//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

#define MSGBUF_SIZE 2048

char* decodeType( int type );

void Ax25Hdr::dump( MBuf& mb, Window& win )
// --------------------------------------------------------------------------
// Dump an AX.25 packet header
// --------------------------------------------------------------------------
{
   char  tmp[Ax25::AXBUF];
   char  frmr[3];
   int   control, pid;
   int   type;
   char* hp;
   int   cnt;
   char* data;
   char* msgBuf = new char[MSGBUF_SIZE];         // message buffer
   char* mp = msgBuf;                            // msssage buffer pointer

   data = mb.data;                               // save for restoral at end
   cnt  = mb.cnt;


//   sprintf( mp, "[%s", Ax25::pAx25( tmp, hrd.source) );
char* cp = Ax25::pAx25( tmp, source);
sprintf( mp, "[%s", cp );
   mp = msgBuf + strlen( msgBuf );               // point to null char
   sprintf( mp, ">%s", Ax25::pAx25( (char *)tmp, (char *)dest ) );
   mp = msgBuf + strlen( msgBuf );               // point to null char
   if (ndigis > 0)
   {
      sprintf( mp, " v" );
      mp += 2;
      for (hp = digis[0]; hp < &digis[ndigis][0];
                               hp += Ax25::AXALEN)
      {
         // print digi string
         sprintf( mp, " %s%s", Ax25::pAx25( (char *)tmp, hp),
                               (hp[Ax25::ALEN] & Ax25::REPEATED) ? "*":"");
         mp = msgBuf + strlen( msgBuf );
      }
   }
   if ((control = mb.pullChar()) == -1)
   {
      delete( msgBuf );
      return;
   }

   sprintf(mp, " :  : ");
   mp += 6;
   type = Ax25::ftype( control );
   sprintf( mp, "%s", decodeType( type ) );
   mp = msgBuf + strlen( msgBuf );

   if(control & LAPB::PF)                        // dump poll/final bit
   {
      switch (cmdrsp)
      {
         case LAPB::COMMAND:
            sprintf( mp, " P" );
            mp += 2;
            break;
         case LAPB::RESPONSE:
            sprintf( mp, " F" );
            mp += 2;
            break;
         default:
            sprintf( mp, " P/F" );
            mp += 4;
            break;
      }
   }
                                                 // dump sequence numbers
   if ((type & 0x3) != LAPB::U)                  // I or S frame?
   {
      sprintf( mp, " R%d", (control >> 5) & 7 );
      mp = msgBuf + strlen( msgBuf );
   }
   if (type == LAPB::I || type == LAPB::UI)
   {
      if (type == LAPB::I)                       // decode I field
      {
         sprintf( mp, " S%d", (control >> 1) & 7 );
         mp = msgBuf + strlen( msgBuf );
      }
      if ((pid = mb.pullChar()) != -1)           // get pid
      {
//       int unsegmented, seg;
//       if (pid == PID_SEGMENT)
//       {
//          unsegmented = 0;
//          seg = mb.pullChar();
//          sprintf( mp, "%s remain %u",
//                   seg & SEG_FIRST ? " First seg;" : "", seg & SEG_REM );
//          mp = msgBuf + strlen( msgBuf );
//          if (seg & SEG_FIRST)
//             pid = mb.pullChar();
//       }
//       else
//          unsegmented = 1;

         switch (pid)
         {
            case Ax25::PID_SEGMENT:
               sprintf( mp, "h]" );
               mp += 2;
               break;	                         // already displayed
            case Ax25::PID_ARP:
               sprintf( mp, " pid=ARP]" );
               mp += 9;
//             arp_dump( bp );
               break;
            case Ax25::PID_NETROM:
               sprintf( mp, " pid=NET/ROM]" );
               mp += 13;
               // Don't verify checksums unless unsegmented
//             netrom_dump( bp, unsegmented );
               break;
            case Ax25::PID_IP:
               sprintf( mp, " pid=IP]" );
               mp += 8;
               // Don't verify checksums unless unsegmented
//             ip_dump( bp, unsegmented );
               break;
            case Ax25::PID_X25:
               sprintf( mp, " pid=X.25]" );
               mp += 10;
               break;
            case Ax25::PID_TEXNET:
               sprintf( mp, " pid=TEXNET]" );
               mp += 12;
               break;
            case Ax25::PID_NO_L3:
               sprintf( mp, " pid=Text]" );
               mp += 10;
               break;
            default:
               sprintf( mp, " pid=0x%02x]", pid );
               mp += 10;
         }
      }
   }
   else
      if (type == LAPB::FRMR && mb.pullUp( (char *)frmr, 3 ) == 3)
      {
         sprintf( mp, ": %s", decodeType( Ax25::ftype( frmr[0] ) ) );
         mp = msgBuf + strlen( msgBuf );
         sprintf( mp, " Vr = %d Vs = %d", (frmr[1] >> 5) & LAPB::MMASK,
                  (frmr[1] >> 1) & LAPB::MMASK );
         mp = msgBuf + strlen( msgBuf );
         if (frmr[2] & LAPB::W)
         {
            sprintf( mp, " Invalid control field" );
            mp = msgBuf + strlen( msgBuf );
         }
         if (frmr[2] & LAPB::X)
         {
            sprintf( mp, " Illegal I-field" );
            mp = msgBuf + strlen( msgBuf );
         }
         if (frmr[2] & LAPB::Y)
         {
            sprintf( mp, " Too-long I-field" );
            mp = msgBuf + strlen( msgBuf );
         }
         if (frmr[2] & LAPB::Z)
         {
            sprintf( mp, " Invalid seq number" );
            mp = msgBuf + strlen( msgBuf );
         }
         sprintf( mp, "]" );
         mp++;
      }
      else
      {
         sprintf( mp, "]" );
         mp++;
      }
   mb.data = data;                              // restore the buffer state
   mb.cnt = cnt;
   if (mp > msgBuf + MSGBUF_SIZE)
      win.printFatal( "ax25_dump : print buffer overflow" );
   win.print( msgBuf );
   delete msgBuf;
}

char* decodeType( int type )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   switch (type)
   {
      case LAPB::I:
         return "I";
      case LAPB::SABM:
         return "SABM";
      case LAPB::DISC:
         return "DISC";
      case LAPB::DM:
         return "DM";
      case LAPB::UA:
         return "UA";
      case LAPB::RR:
         return "RR";
      case LAPB::RNR:
         return "RNR";
      case LAPB::REJ:
         return "REJ";
      case LAPB::FRMR:
         return "FRMR";
      case LAPB::UI:
         return "UI";
      default:
         return "[invalid]";
   }
}

/*
int ax_forus( struct iface* iface, MBuf* bp)
// --------------------------------------------------------------------------
// Return 1 if this packet is directed to us, 0 otherwise. Note that
// this checks only the ultimate destination, not the digipeater field
// --------------------------------------------------------------------------
{
	struct MBuf* bpp;
	char dest[Ax25::AXALEN];

	// Duplicate the destination address
	if(dup_p(&bpp,bp,0,Ax25::AXALEN) != Ax25::AXALEN){
		free_p(bpp);
		return 0;
	}
	if(pullup(&bpp,dest,Ax25::AXALEN) < Ax25::AXALEN)
		return 0;
	if(addreq(dest,iface->hwaddr))
		return 1;
	else
		return 0;
}
*/

