//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef __ACTLIST_H
#define __ACTLIST_H

// Forward References

class ActFile;
class Directory;
class FileFrInfo;
class StatusList;
class Window;

class ActList
{
public:
                           ActList( Window&     fiWin,
                                    Window&     iWin,
                                    Window&     frWin,
                                    char*       dlDir,
                                    Directory*  dir,
                                    StatusList* sList,
                                    unsigned    makeBat,
                                    char*       bats1,
                                    char*       bats2,
                                    unsigned    silent,
                                    unsigned    maxPfhSize );
                           ~ActList();
           void            display();
           ActFile*        onList( const unsigned long fileNumber,
                                   const unsigned      errMsg  );
           void            purgeFiles( const char* dir );
           void            purgeOldFiles( const char*       dlDir,
                                          const unsigned    actDays,
                                          const StatusList* sList   );
           void            save( const FileFrInfo& fr );

private:
           unsigned long   accessesCounter;
           char*           bats1;
           char*           bats2;
           Directory*      dir;
           char*           dlDir;
           Window&         fiWin;
           Window&         frWin;
           Window&         iWin;
           unsigned        makeBat;
           unsigned        maxPfhSize;
           unsigned        silent;
           StatusList*     sList;
           ActFile**       theList;

           ActFile*        addFile( const unsigned long fileNumber );
           void            addToBatchFile( const unsigned long fileNumber );
           void            completionCheck( ActFile* file );
           int             nextSpace();
           int             removeFile( const unsigned index );
};

#endif __ACTLIST_H
