//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef __ACTFILE_H
#define __ACTFILE_H

// Forward references

class Directory;
class HolFile;
class PFileHeader;
class StatusList;
class Window;

class ActFile
{
public:
            enum          { SAVE, PURGE, COMPLETE };
            unsigned long   accessCount;
            unsigned long   fileNumber;
            HolFile*        holFile;
            unsigned        position;

                            ActFile( const char*         path,
                                     const unsigned long fileNumber,
                                     const unsigned      position,
                                           Directory*    dir,
                                           unsigned      silent,
                                     const unsigned      maxPfhSize,
                                           Window&       fiWin,
                                           Window&       iWin,
                                           Window&       frWin );
                            ~ActFile();
            void            close( const int closeAction );
   inline   int             complete();
            void            display();
            void            display( const unsigned long offset );
            int             needData( const unsigned long offset,
                                      const unsigned dLen,
                                      const char     flag );
            void            open();
            void            purgeOldFiles( const char*       dlDir,
                                           const unsigned    actDays,
                                           const StatusList* sList   );
            void            purgeFiles( const char* dir,
                                        const unsigned long fileNumber );
            void            update( const unsigned long offset,
                                    const char*         data,
                                    const unsigned      len );

private:
            Directory*      dir;
            char*           dlDir;
            int             fileHandle;
            int             fileType;
            Window&         fiWin;
            Window&         frWin;
            Window&         iWin;
            unsigned        maxPfhSize;
            unsigned        silent;

            unsigned        readPfh( PFileHeader& pfh, char* bp );
            void            savePfhInfo( PFileHeader& pfh );
};

#endif   __ACTFILE_H
