#define FALSE 0
#define TRUE (!FALSE)



/* Stats structure for keeping statistics. Cleared daily */
struct STAT_STRUCT {
	/* n are simple counters */
	long nHolefills;
	long nStartFile;
	long nEndFile;
	long nNoFile;
	long nNoRoom;
	long nNotOK;
	/* nb are byte counters */
	long nbRequested;
	long nbOverwrite;
	long nbUnfresh;
	long nbPfhErr;
	long nbFopenErr;
	long nbEnd;
	long nbTransmitted;
	/* nh are hole counters */
	long nhRequested;
	long nDirReqs;
	long nbDirTxd;
	/* Ticks count time */
	long TicksDir;						/* Version 2 and up */
	long TicksData; 					/* Version 2 and up */
	int  nNewStns;						/* New stations heard */
	/* Version 3 and up */
	long nbEof;
	int nLongFile;
};

void sum(struct STAT_STRUCT *, struct STAT_STRUCT *, int);
int process(time_t *, struct STAT_STRUCT *, int);
int IsNewLog(time_t tim);
int GetVer(FILE *);
