#include "stdio.h"
#include "bios.h"
#include "dos.h"

/* This software commands the Computer Aided Transceiver (CAT) port on  */
/* The Yaesu FT-736R and FT-847 transceivers.  This library contains    */
/* functions needed by satellite tracking software.  Future upgrades    */
/* will have a complete command set for these transceivers.             */

/* Copyright 1998 by Kenneth J. Ernandes, N2WWD  email: n2wwd@amsat.org */
/* Web page: <http://www.mindpsring.com/~n2wwd                          */

/* This code may be freely incorporated into any software distributed   */
/* by AMSAT, including AMSAT-NA and all international affiliates.  This */
/* code may also be freely incorporated into any personal or public     */
/* domain software.  Commercial software not distributed by AMSAT may   */
/* also use this code for a $10 donation to AMSAT-NA, 850 Sligo Avenue, */
/* Suite 600, Silver Spring, MD 20910-4703, USA or any international    */
/* affiliate.                                                           */

int catYaesuCommand( unsigned catPortID, char * );
int cat736CtcssEnc( unsigned catPortID );
int cat736CtcssEncDec( unsigned catPortID );
int cat847CtcssEnc( unsigned catPortID, char vfoID );
int cat847CtcssEncDec( unsigned catPortID, char vfoID );
int cat736CtcssFreqInput( unsigned catPortID, double ctcssFreq );
int cat847CtcssFreqInput( unsigned catPortID, double ctcssFreq, char vfoID );
int cat736CtcssOff( unsigned catPortID );
int cat847CtcssOff( unsigned catPortID, char vfoID );
int cat736CtcssPlInput( unsigned catPortID, char * );
int cat847CtcssPlInput( unsigned catPortID, char *, char vfoID );
int cat736CtcssToneCode( unsigned catPortID, char codeIndex );
int cat847CtcssToneCode( unsigned catPortID, char codeIndex, char vfoID );
int catYaesuDisable( unsigned catPortID );
int catYaesuEnable( unsigned catPortID, char catPortNumber );
int catYaesuFreqEncode( double freq, char * );
int catYaesuFreqSet( unsigned catPortID, double freq );
int catYaesuModeSet( unsigned catPortID, char mode );
int catYaesuModeString( char mode, char * );
int catYaesuSatModeEnable( unsigned catPortID, char satModeEnable,
                           char transceiverType );
int catYaesuSatRxFreq( unsigned catPortID, double freq, char transceiverType );
int catYaesuSatRxMode( unsigned catPortID, char mode );
int catYaesuSatTxFreq( unsigned catPortID, double freq, char transceiverType );
int catYaesuSatTxMode( unsigned catPortID, char mode );
int catYaesuSplit( unsigned catPortID, double rcvFreq, double xmtFreq,
                   char transceiverType );
int catYaesuSplitDir( unsigned catPortID, char dir, char TransceiverType );
int catYaesuSplitOffset( unsigned catPortID, double freqOffset );
