/*

SERVINFO.C

Ce programme est un serveur pour TPK. Il repond aux messages dont le
titre contient la commande /INFO ou /INFO nnn

Il retourne en reponse le fichier INFO.000 dans le premier cas et le
fichier INFO.nnn dans le second cas.

La reponse est ecrite dans le fichier d'import de messages de TPK dont
le nom implicite est MAIL.IN. Ce nom peut etre change dans le fichier de
configuration SERVINFO.CFG et dans TPK par la commande FORward IMport

Commandes du fichier SERVINFO.CFG:

PATH
Chemin des fichiers INFO.xxx
Ex: PATH C:\TPK\INFO
SERVINFO ira lire les fichiers C:\TPK\INFO\INFO.xxx (xxx=000 a 999)

TPK
Repertoire de TPK (facultatif car arrive en parametre)
Ex: TPK C:\TPK

MYCALL
Indicatif utilise (facultatif car arrive en parametre)
Ex: MYCALL F1EBN

MAIL
Nom du fichier d'import de messages (MAIL.IN implicite)
Ex: MAIL IMPORT.MSG

FILE
Nom des fichiers (INFO implicite)
Ex: FILE TEXT_INF
Dans ce cas SERVINFO ira chercher des fichiers TEXT_INF.000 a 999

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void ReadCfg(void);
void ReadWriteInfo(void);
int ReadDest (char *cmd);
int ReadFromBbs (char *cmd);

char str[255];
char line[256];
char N_Mycall[7]="\0";
char Path_Tpk[129];
char Path_Info[129];
char FiMail[13]="MAIL.IN";
char FiInfo[9]="INFO";
char FiMsg[129];
char Typ[2],To[7],From[7],Abbs[41],Bid[13],BidOrg[13];
char Fbbs[41],FbbsCall[7];
char Subject[81];

void main(int argc, char *argv[])
{
FILE *fichin,*fichout;
char *s;
int WaitFrom,Nbcar;

char *ptr;

if (argc) strncpy(FiMsg, argv[1], 128);
if (argc>1) strncpy(Path_Tpk, argv[2], 128);
if (argc=3) strncpy(N_Mycall, strupr(argv[3]), 6);

ReadCfg();

if ((fichin=fopen(FiMsg, "r")) != NULL)
	{
	if (fgets(line, 255, fichin) != NULL)
		{
        /* Lecture du destinataire */
        ReadDest (line);
        /* Message pour moi ? */
        if (strcmp(To, N_Mycall) == 0)
			{
			if (fgets(Subject, 80, fichin) != NULL)
				{
                /* Est-ce que le sujet est /INFO ? */
                if ((strstr(strupr(Subject), "/INFO")) == Subject)
					{
                    /* Sujet = /INFO donc c'est ok */
                    WaitFrom=1;
					Nbcar=0;
                    /* Recherche de la BBS d'origine */
                    while (fgets(line, 255, fichin) != NULL)
						{
						if (WaitFrom)
							{
							if ((s=strstr(line, "R:")) != NULL)
								{
								ReadFromBbs (s);
								}
							else
								{
								WaitFrom--;
								break;
								}
							}
						}
                    /* Lecture du fichier et creation du message de
                    reponse */
                    ReadWriteInfo();
					}
				}
			}
		}
	fclose(fichin);
	}
}

/* Lecture de la configuration */

void ReadCfg(void)
{
int i;
char cmd[81];
char par1[81];
char par2[81];
char *s;
FILE *fichin;

if (s=strcpy(str, Path_Tpk),s=strcat(str, "SERVINFO.CFG"),
	(fichin=fopen(str, "r")) != NULL)
	{
	while (fgets(str, 80, fichin) !=NULL)
		{
		i=sscanf(str, "%s", cmd);
		if (i){
			i=sscanf(str, "%s %s %s", cmd,par1,par2);
			strcpy(cmd,strupr(cmd));
            /* Chemin des fichiers INFO.xxx */
            if (strcmp("PATH",cmd)==0)
				{
				strncpy(Path_Info, strupr(par1), 128);
				if ((*(Path_Info+strlen(Path_Info))) != '\\')
					strcat(Path_Info, "\\");
				}
            /* Repertoire de TPK (facultatif car arrive en parametre) */
            if (strcmp("TPK",cmd)==0)
				{
				strncpy(Path_Tpk, strupr(par1), 128);
				if ((*(Path_Tpk+strlen(Path_Tpk))) != '\\')
					strcat(Path_Tpk, "\\");
				}

            /* Indicatif utilise (facultatif car arrive en parametre) */
            if (strcmp("MYCALL",cmd)==0) strncpy(N_Mycall, strupr(par1), 6);
            /* Nom du fichier d'import de messages (MAIL.IN implicite)*/
            if (strcmp("MAIL",cmd)==0) strncpy(FiMail, strupr(par1), 12);
            /* Nom des fichiers (INFO implicite) */
            if (strcmp("FILE",cmd)==0) strncpy(FiInfo, strupr(par1), 8);
			}
		}
	fclose(fichin);
	}
}

/* Lecture des informations dans une ligne de commande SP ou SB */

int ReadDest (char *cmd)
{
char *s;
char *ptr;
int i;

if (strlen(cmd)>2)
	{
	if (toupper(*cmd)==83)
		{
		s=cmd;
		s=strupr(s);
		*Typ=*++s;
        ptr=To;                 /* TO */
        i=6;
        for (++s;*s ;s++)
            {
            if (*s==64){        /* @BBS*/
                ptr=Abbs;
                *ptr=0;
                i=40;}
            else if (*s==60){   /* <FROM */
                ptr=From;
                *ptr=0;
                i=6;}
            else if (*s==36){   /* $BID */
				ptr=Bid;
				*ptr=0;
				i=12;}
			else if (*s<33)
				continue;
			else if (i)
				{
				if (*s>32)
					{
					*ptr++=*s;
					*ptr=0;
					i--;
					}
				}
			}
			return strlen(To);
		}
	}
}

/* Recherche de la BBS d'origine du message dans une ligne R: */

int ReadFromBbs (char *cmd)
{
char *s;
char *ptr;
int i=0;
for (s=cmd; *s; s++)
	{
	if (*s==64){
		ptr=Fbbs;
		*ptr=0;
		i=40;
		}
	else if (*s==36){
		ptr=BidOrg;
		*ptr=0;
		i=12;
		}
	else if (*s==58)
		continue;
	else if (*s==32)
		i=0;
	else if (i)
		{
		if (*s>32)
			{
			*ptr++=*s;
			*ptr=0;
			i--;
			}
		}
	}
return strlen(Fbbs);
}

/* Lecture du fichier INFO et ecriture du message dans le fichier */
/* d'import de TPK (MAIL.IN)                                      */

void ReadWriteInfo(void)
{
char str1[129];
char str2[4];
char *s,*st;
int i;
FILE *fichin,*fichout;

i=sscanf(Subject, "%s %s", str1, str1);
if (i==1)
	{
	*(Subject+5)=' ';
	strcat(Subject,"0\n");
	}
for (s=Subject+5; *s; s++)
	{
	for (st=str1, *st='\0'; *s ; s++)
		{
		if ( *s<':',*s>'/')
			{
			*st++=*s;
			*st='\0';
			}
		else if (*s==32 | *s=='\n' )
			{

			if (i=strlen(str1))
				{
				sprintf(str2, "%03d", atoi(str1));
				sprintf(str1, "%s%s.%s", Path_Info, FiInfo, str2);
				if (st=strcpy(str, Path_Tpk),st=strcat(str, FiMail),
					(fichout=fopen(str, "a")) != NULL)
					{
					if (strlen(Fbbs))
						fprintf(fichout, "SP %s @%s <%s\n", From, Fbbs, N_Mycall);
					else
						fprintf(fichout, "SP %s <%s\n", From, N_Mycall);
					fprintf(fichout, "Re:/INFO %s\n", str2);
					if ((fichin=fopen(str1, "r")) != NULL)
						{
						while (fgets(str, 80, fichin) !=NULL)
							{
							fputs(str, fichout);
							}
						fclose (fichin);
						}
					else
						{
						fprintf(fichout, "Pas d'info %s\n", str2);
						}
					fputs("/EX\n", fichout);
					fclose (fichout);
					}
				}
			st=str1;
			}
		}
	}
}
