(******************************************************************)
(****************************** INFO ******************************)
(******************************************************************)
(* Example program [PAS] for New Packet Generation v1.03          *)
(*                                                                *)
(* Author : Robin van Nooy (NL1CGS)                               *)
(* Date   : Monday, 9 March 1998                                  *)
(* E-mail : cygnes@cygnes.demon.nl                                *)
(*                                                                *)
(******************************************************************)

(******************************************************************)
(***************************** Includes ***************************)
(******************************************************************)


(******************************************************************)
(***************************** Constants **************************)
(******************************************************************)
Const Description : Array[0..7] of String[10] =
                     ('Exe-file',
                      'Mycall',
                      'Usercall',
                      'Level',
                      'Executed',
                      'Channel',
                      'Info',
                      'Parameters');

      HexTab      : Array[0..15] of char =
                     ('0','1','2','3','4','5','6','7','8','9',
                      'A','B','C','D','E','F');



(******************************************************************)
(*************************** Records ******************************)
(******************************************************************)
Type

 (************************** FrameBlock **************************)
 (* Parameter 7 is the address of this structure. You can check  *)
 (* out what the user submitted as parameters to the program     *)
 (****************************************************************)

     FrameBlock = Record
                    framelength : word;
                    Buffer      : Array[0..256] of byte;
                  End;

 (***************************** TncRec ***************************)
 (* Structure that is used to give commands to NPG               *)
 (****************************************************************)
      TncRec    = Record
                    Channel     : Byte;
                    TncCommand  : String[80];
                  End;

 (**************************** UserRec ***************************)
 (* Structure that is used to send feedback to the user          *)
 (****************************************************************)
      UserRec   = Record
                    Channel     : Byte;
                    Mode        : Byte; (*  0 = Do Nothing with File    *)
                                        (*  1 = Kill File after execute *)
                                        (*  2 = Send 'FileName' as text *)
                                        (*  3 = Send Frame block        *)
		                        (*  4 = Show Frame block        *)
                    FileName    : String[80];
                  End;

(******************************************************************)
(************************** Functions *****************************)
(******************************************************************)
function hexword(w:word):string;
var s : string;
    i : byte;
begin
  s := '';
  for i := 3 downto 0 do s := s  + HexTab[(w shr (i*4)) and $F];
  hexword := s;
end;

var fb       : ^FrameBlock;(* record with frame data               *)
    Users    : UserRec;    (* record with data for user            *)
    i        : integer;    (* counter                              *)
    f_handle : file;       (* file handle, for output to USERS.NPU *)
    f_text   : text;       (* file handle, for output to user      *)
    segmnt,                (* temporary segment                    *)
    ofst     : String[7];  (* temporary offset                     *)
    s,                     (* segment                              *)
    o        : longint;    (* offset                               *)
    code     : integer;    (* temp for str -> numeric conversions  *)


Function Makepointertoframe(T:String):Pointer;
Var Sgm,Offs : Word;
Begin
  Val(Copy(T,1,Pos(':',T)-1),Sgm,Code);
  Delete(T,1,Pos(':',T));
  Val(T,Offs,Code);
  Makepointertoframe := Ptr(Sgm,Offs);
End;

Function Makestringfromframe:String;
Var S : String; I : Word;
Begin
 if FB <> NIL then
 begin
  S[0] := Chr(Fb^.Framelength);
  For I := 1 To Fb^.Framelength Do S[i] := Chr(Fb^.Buffer[I-1]);
 end else s := '';
 Makestringfromframe := S;
End;

Begin
  assign(f_handle,'users.npu');
  {$i-} rewrite(f_handle,1); {$i+}
  if ioresult <> 0 then
  begin
    writeln('Could not create users.npu');
    halt(0);
  end;

  assign(f_text,'temp.txt');
  {$i-} rewrite(f_text); {$i+}
  if ioresult <> 0 then
  begin
    writeln('Could not create temp.txt');
    halt(0);
  end;

  (* Show program info *)
  writeln(f_text,'PASCAL example program for NPG v1.03'#13#10);

  (* Make a bar *)
  for i := 1 to 80 do write(f_text,'-');

  (* Skip a line *)
  writeln(f_text);

  (* Display parameters with their descriptions *)
  for i :=0 to paramcount do
  begin
    if (i < 8) then write(f_text,'  '+description[i],' ':11-length(description[i]),' = ')
	       else write(f_text,'  '+description[7],' ':11-length(description[7]),' = ');
    writeln(f_text,paramstr(i),' ':15-length(paramstr(i)),'[param. ',i:2,']');
  end;

 If Paramcount >= 7 then Fb := Makepointertoframe(ParamStr(7))
                    else Fb := NIL;

  (* show frame length *)
  writeln(f_text,'  Frame len.  = ',fb^.framelength);
  (* show frame data   *)
  writeln(f_text,'  Frame Data  = ',{fb^.buffer}'''',makestringfromframe,'''');

  (* Make a bar *)
  for i := 1 to 80 do write(f_text,'-');

  (* Skip a line *)
  writeln(f_text);

  (* init userrec *)
  val(paramstr(5),users.channel,code); (* channel to send the data to      *)
  users.mode     := 1;           (* send file and erase file after sending *)
  users.filename := 'temp.txt';  (* set file to send *)
  {$i-} blockwrite(f_handle,users,sizeof(users)); {$i+} (* write data to file  *)

  (* close both files *)
  {$i-} close(f_handle);
        close(f_text);
  {$i+}
  (* return value 2 -> send output to user, and quit program *)
  halt(2);
End.
(* End of program *)