VAR HelpFileName, HelpFileString, IndexFileName: String;
    HelpFile: Text;
    IndexFile: File;
    FileCheckSize: File;
    Description: Array[1..4] of String;
    LengthBuf, Z: Byte;
    HeaderOffset, HelpFilePos, HelpFileSize, LineCountPos, PosSave: Longint;
    TopicCount, TopicLinesCount: Word;

Function Exists(FileName: String): Boolean;
VAR F: File;
BEGIN
{$I-}
Assign(F, FileName);
Reset(F);
Close(F);
{$I+}
Exists:=(IOResult=0);
END;

Function Chain(Count: Byte; Text: Char): String;
VAR ChainBuf: String;
BEGIN
ChainBuf:='';
FOR Count:=1 TO Count DO
  ChainBuf:=ChainBuf+Text;
Chain:=ChainBuf;
END;



BEGIN
IF ParamCount<>1 THEN
  BEGIN
  WriteLn('Syntax: MAKEIDX <HelpFileName>[.HLP]');
  Halt;
  END;
IF Copy(ParamStr(1), Length(ParamStr(1))-3, 4)<>'.HLP' THEN
  BEGIN
  HelpFileName:=ParamStr(1)+'.HLP';
  IndexFileName:=ParamStr(1)+'.IDX';
  END
 ELSE
  BEGIN
  HelpFileName:=ParamStr(1);
  IndexFileName:=Copy(ParamStr(1), 1, Length(ParamStr(1))-4)+'.IDX';
  END;
IF NOT Exists(HelpFileName) THEN
  BEGIN
  WriteLn('Can''t find '+HelpFileName);
  Halt;
  END;
Z:=1;
WriteLn('Please enter helpfile-description, enter * to jump back to line 1');
Repeat
  Write('Description line ', Z:0, ' (max. 30 chars): ');
  ReadLn(Description[Z]);
  IF Description[Z]<>'*' THEN Description[Z]:=Description[Z]+
                              Chain(30-Length(Description[Z]), ' ');
  IF Description[Z]='*' THEN Z:=1 ELSE Inc(Z);
  until Z=5;
{$I-}
Assign(IndexFile, IndexFileName);
Rewrite(IndexFile, 1);
{$I+}
IF IOResult<>0 THEN
  BEGIN
  WriteLn('Can''t write '+IndexFileName);
  Halt;
  END;
FOR Z:=1 TO 4 DO
  BlockWrite(IndexFile, Ptr(Seg(Description[Z]), Ofs(Description[Z])+1)^, 30);
Assign(FileCheckSize, HelpFileName);
Reset(FileCheckSize, 1);
HelpFileSize:=FileSize(FileCheckSize);
Close(FileCheckSize);
BlockWrite(IndexFile, HelpFileSize, 4);
BlockWrite(IndexFile, TopicCount, 2);
Assign(HelpFile, HelpFileName);
Reset(HelpFile);
HelpFilePos:=0;
TopicCount:=0;
Repeat
  ReadLn(HelpFile, HelpFileString);
  IF Copy(HelpFileString, 1, 2)='@@' THEN
    BEGIN
    IF Pos('@@', Copy(HelpFileString, 3, 255))>0 THEN
      BEGIN
      IF TopicCount>0 THEN
        BEGIN
        PosSave:=FilePos(IndexFile);
        Seek(IndexFile, LineCountPos);
        BlockWrite(IndexFile, TopicLinesCount, 2);
        Seek(IndexFile, PosSave);
        END;
      TopicLinesCount:=0;
      Inc(TopicCount);
      BlockWrite(IndexFile, HelpFilePos, 4);
      LineCountPos:=FilePos(IndexFile);
      BlockWrite(IndexFile, TopicLinesCount, 2);
      END;
    END
   ELSE
    BEGIN
    Inc(TopicLinesCount);
    BlockWrite(IndexFile, HelpFilePos, 4);
    LengthBuf:=Length(HelpFileString);
    BlockWrite(IndexFile, LengthBuf, 1);
    END;
  HelpFilePos:=HelpFilePos+Length(HelpFileString)+2;
  until EOF(HelpFile);
Close(HelpFile);
Seek(IndexFile, LineCountPos);
BlockWrite(IndexFile, TopicLinesCount, 2);
Seek(IndexFile, 124);
BlockWrite(IndexFile, TopicCount, 2);
WriteLn('Number of topics in this help-file: ', TopicCount);
Close(IndexFile);
END.