 /* Main network program - provides both client and server functions */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "global.h"
#if (defined(__TURBOC__) || defined (__CPLUSPLUS)) && defined(MSDOS)
#include <fcntl.h>
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <sys\stat.h>
#endif
#include "config.h"
#ifdef	ANSIPROTO
#include <stdarg.h>
#endif
#include "files.h"
#include "mbuf.h"
#include "socket.h"
#include "iface.h"
#include "ftpcli.h"
#include "telnet.h"
#include "remote.h"
#include "session.h"
#include "cmdparse.h"
#include "ax25.h"
#include "arp.h"
#include "kiss.h"
#include "enet.h"
#include "timer.h"
#include "proc.h"
#include "tty.h"
#include "daemon.h"
#include "domain.h"
#include "usock.h"
#include "netrom.h"
#include "ip.h"
#include "tcp.h"
#include "udp.h"
#include "hardware.h"
#include "commands.h"
#include "asy.h"
#include "trace.h"
#ifdef DRSI
#include "drsi.h"
#endif
#ifdef SCC
#include "scc.h"
#endif
#ifdef VANESSA
#include "vanessa.h"
#endif
#include "8250.h";

// unsigned int _stklen = 8192;

extern struct cmds Cmds[];

static char Escape = 0x1b;			/* default escape character is ESC */

char Badhost[] = "Unknown host %s\n";
char Nospace[] = "No space\n";		/* Generic malloc fail message */
char *Hostname = NULLCHAR;
static FILE *Logfp;
static struct proc *Cmdpp;
struct proc *Display;
struct session *Command, *Trace;
static time_t StartTime;			/* Time that NOS was started */
static int32 core ;
int32 currtime = 0;
char uploadstatus = 1;
static int16 LWrap = 70;
int Niface = 0;						/* Number of Ifaces */
#ifdef LZW
int16 Lzwbits = 16;
int Lzwmode = LZWCOMPACT;
#endif

static void near loadfile __ARGS((void));
static void savefile __ARGS((void));
static struct timer Savetimer;

static void near doversion __ARGS((void));

#ifdef MSDOS
#define	NORMALL	48
#define NORMALH	23
#define NORMALS 113
#define INVERS	30
#define	RED		71
#define COMMON	7
#define PANIC   206

static int normal = NORMALL;		/* used for statusline */
static int normalh = NORMALH;
static int normals = NORMALS;
static int invers = INVERS;
static int red = RED;
static int common = COMMON;
static int panic = PANIC;
void statusline __ARGS((int i,void *v1,void *v2));
static void dostatustimer __ARGS((void));
struct timer Statustimer;
static struct proc *statp;
static unsigned char Currmode;
#endif

#ifdef RESETTIMER
/* Timer card - developed by DL3YDN.9203xx
 * code is compiled in when defining RESETTIMER
 *
 * Register des Timers 8253
 */
#define TIMCTRL	0x213
#define TIMER0	0x210
#define TIMER1	0x211
#define TIMER2	0x212

/* Register des I/O Bausteins 8255 */
#define IOCTRL	0x217
#define PORTA	0x214
#define PORTB	0x215
#define PORTC	0x216

static void inittim __ARGS((void));
#endif

unsigned char Nrows = NROWS;	/* extra defined for 43/50 line mode - DB3FL */

static char Prompt[30];

int
main(argc,argv)
int argc;
char *argv[];
{
	struct daemon *tp;
	struct mbuf *bp;
	int c, i;
	char *startfile[3];
#ifdef MSDOS
	extern int Isat;
	struct text_info r;

	gettextinfo(&r);
	Currmode = r.currmode;
#endif

	do {
		c = getopt(argc,argv,"s:d:be");
		switch(c){
		case 's':	/* Number of sockets */
			Nusock = atoi(optarg);
			break;
		case 'd':	/* Root directory for various files */
			initroot(optarg);
			break;
#ifdef	__TURBOC__
		case 'b':	/* Use BIOS for screen output */
			directvideo = 0;
			break;
#endif
#ifdef __CPLUSPLUS
#ifdef MSDOS
		case 'e':
			textmode(C4350);
			gettextinfo(&r);
			break;
#endif
#endif
		case '?':
			puts("aborted...\007\r\n");
			exit(1);
		}
	} while (c != EOF);

#ifdef MSDOS
	Nrows = r.screenheight;
#endif

#ifdef RESETTIMER
	inittim();
#endif

	if(getenv("TZ") == NULL)
        putenv("TZ=GMT00");
	tzset();

	StartTime = time(&StartTime);
	currtime = time(NULL);

	kinit();
	ipinit();
	ioinit();
	sockinit();
	Cmdpp = mainproc("cmdintrp");

	window(1,3,80,Nrows);

	/*-------------------------------------------------------------------*
	* initialize name cache DK5DC                                        *
	*--------------------------------------------------------------------*/
    cache = cxallocw(sizeof(Cache),(Dcache_size + 2));

    Sessions = (struct session *)cxallocw(Nsessions,sizeof(struct session));
	Trace = newsession("Trace",TRACESESSION,1,0);
	Lastcurr = Command = newsession("cmd interpreter",COMMAND,0,1);
	Command->flowmode = Cooked;		/* set 'more' paging on command screen */
	Trace->input = Command->input;
	Display = newproc("display",512,display,0,NULLCHAR,NULL,0);

	/* allocates buffer for the trace screen */
	swapscreen(Trace,NULLSESSION);

	/* This is a try to handle different machine speeds on startup.
	 * On various tests we learn that we need greater values on slow
	 * machines. The value of Isat reflects the type of the cpu. So
	 * its just easy to delay a longer time on a 8088 instead of a 386
	 * DC0HK/DB3FL.920416
	 */
#ifdef MSDOS
	c = Isat ? 200 : 1000;
#else
	c = 200;
#endif

	/* Start background Daemons */
	for(tp = Daemons; tp->name != NULLCHAR; tp++) {
		newproc(tp->name,tp->stksize,tp->fp,0,NULLCHAR,NULL,0);
		for(i = 0; i < c; i++) ;	/* machine dependend delay */
	}

	dostatustimer();
	doversion();
	delay(0);

	startfile[1] = strxdup(optind < argc ? argv[optind] : Startup);
	dosource(1,startfile,NULL);
	xfree(startfile[1]);

	if(Niface)
		loadfile();

	sprintf(Prompt,"%.27s> ",(Hostname != NULLCHAR) ? Hostname : "net");
	tputs(Prompt);
	usflush(Command->output);

	pwait(NULL);

	uploadstatus = 0;
    core = availmem();

	/* Now loop forever, processing commands */
	for(;;){
		if(Current == Command && Command->flag) {	/* DK5DC */
			usflush(Command->output);
			tputs(Prompt);
			Command->flag = 0;
		}
		if(recv_mbuf(Command->input,&bp,0,NULLCHAR,0) != -1){
			(void)cmdparse(Cmds,bp->data,Lastcurr);
			free_p(bp);
		}
	}
}

/* Keyboard input process */
void
keyboard(i,v1,v2)
int i;
void *v1;
void *v2;
{
	int c, j, k;
	struct mbuf *bp;
	struct session *sp;

	/* Keyboard process loop */
	for(;;){
		if((c = kbread()) == Escape && Escape != 0)
			c = -2;
		if(c == -2 && Current != Command){
			/* Save current tty mode and set cooked */
			swapscreen(Current,Command);
			Lastcurr = Current;
			Current = Command;
			if(Command->flag) {
				tputs(Prompt);
				Command->flag = 0;
			}
			/* set 'more' paging on command screen */
			Command->flowmode = Cooked;
		}

		if(c < -2) 				/* F1 to F10 pressed */
			if(c == -13) {      /* ALT-F10 handled here */
				if (Current != Trace){
					swapscreen(Current,Trace);
					Lastcurr = Current;
					Current = Trace;
					Trace->flowmode = Raw;
				} else {
					swapscreen(Trace,Lastcurr);
					Current = Lastcurr;
					Lastcurr = Trace;
				}
			} else {
				for(sp = Sessions, j = 1, k = abs(c); sp < &Sessions[Nsessions]; sp++) {
					if(sp->type == COMMAND)
						continue;
					j++;
					if(sp->type != FREE && j == k) {
						swapscreen(Current,sp);
						Lastcurr = Current;
						Current = sp;
						break;
					}
				}
			}

		Current->row = (Current->split) ? Nrows - 5 : Nrows - 3;
		psignal(&Current->row,1);
		if(c >= 0){
			/* If the screen driver was in morewait state, this char
			 * has woken him up. Toss it so it doesn't also get taken
			 * as normal input. If the char was a command escape,
			 * however, it will be accepted; this gives the user
			 * a way out of lengthy output.
			 */
			if(!Current->morewait) {
				if((bp = ttydriv(Current,(char)c)) == NULLBUF){
					if(LWrap > 0 && Command != Current && c == 32
					  && len_p(Current->ttystate.line) > LWrap) {
						bp = ttydriv(Current,13);
						send_mbuf(Current->input,bp,0,NULLCHAR,0);
					}
				} else {
					send_mbuf(Current->input,bp,0,NULLCHAR,0);
				}
			}
		}
	}
}

int
dowrap(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setintrc(&LWrap,"Wrap",argc,argv,0,132);
}

/* Standard commands called from main */
int
doexit(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int i;

#ifdef RESETTIMER
	outport(PORTC,0x00);  /* Disable Watchdog */
#endif

	if(argc > 250) {
		i = dirps();
		iostop();
		exit(argc);
	}
	reset_all();

	for(i = 0; i < 300; i++)
		pwait(NULL);
	shuttrace();
	log(-1,"Shutdown %s", ctime(&currtime));
	iostop();
	fcloseall();
#ifdef MSDOS
	textmode((int)Currmode);		/* restore video mode */
#endif
	exit(0);
	return 0;						/* To satisfy lint */
}

int
dohostname(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	if(argc < 2 && Hostname != NULLCHAR)
		tprintf("%s\n",Hostname);
	else {
		xfree(Hostname);
		Hostname = strxdup(argv[1]);
	}
	return 0;
}

int
dolog(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	static char *logname;

	if(argc < 2) {
		if(Logfp != NULLFILE)
			tprintf("Logging to %s\n",logname);
		else
			tputs("Logging off\n");
	} else {
		if(Logfp != NULLFILE) {
			fclose(Logfp);
			Logfp = NULLFILE;
			if(logname != NULLCHAR)
				xfree(logname);
			logname = NULLCHAR;
		}
		if(strcmp(argv[1],"off") != 0){
			logname = strxdup(argv[1]);
			if((Logfp = open_file(logname,APPEND_TEXT,0,1)) == NULLFILE)
				return -1;
			log(-1,"Startup %s", ctime(&StartTime));
		}
	}
	return 0;
}

int
dohelp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int i;
	struct cmds *cmdp;

	tputs("Main commands:\n");
	for(i = 0, cmdp = Cmds; cmdp->name != NULLCHAR; cmdp++)
		if(strlen(cmdp->name) > 0) {
			tprintf("%-15.15s%s",cmdp->name,(i == 4) ? "\n" : "");
			i = (i + 1) % 5;
		}
	if(i)
		tputc('\n');
	return 0;

}

/* Manipulate I/O device parameters */
int
doparam(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp;

	if((ifp = if_lookup(argv[1])) == NULLIF){
		tprintf(Badif,argv[1]);
		return 1;
	}
	if(ifp->ioctl == NULLFP){
		tputs("Not supported\n");
		return 1;
	}
	/* Pass rest of args to device-specific code */
	return (*ifp->ioctl)(ifp,argc-2,argv+2);
}

#ifdef AX25
/* Display or set IP interface control flags */
int
domode(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct arp_tab *arp, *ap;
	char usage[] = "Usage: mode <host> [<datagram|vc|ipcam>]\n";
	char buf1[AXBUF];
	int32 addr;
	int i;

	if(if_lookup(argv[1]) != NULLIF){
		tputs(usage);
		return -1;
	}
	if((addr = resolve(argv[1])) == 0 || (arp = arp_lookup(ARP_AX25,addr)) == NULLARP) {
		tprintf(Badhost,argv[1]);
		return -1;
	}
	if(argc < 3){
		tprintf("%s (%s): Mode ",strupr(argv[1]),pax25(buf1,arp->hw_addr));
		switch(arp->flags) {
			case DATAGRAM_MODE:
				tputs("Datagram\n");
				break;
			case CONNECT_MODE:
				tputs("VC\n");
				break;
			case IPCAM_MODE:
				tputs("IPCAM\n");
				break;
			default:
				tputs("unknown\n");
				break;
		}
		return 0;
	}
	switch(tolower(argv[2][0])){
	case 'd':
		arp->flags = DATAGRAM_MODE;
		break;
	case 'v':
	case 'c':
		arp->flags = CONNECT_MODE;
		break;
	case 'i':
		arp->flags = IPCAM_MODE;
		break;
	default:
		tputs(usage);
		return -1;
	}
	for(i = 0; i < HASHMOD; i++){
		for(ap = Arp_tab[i]; ap != (struct arp_tab *)NULL; ap = ap->next){
			if(strcmp(arp->hw_addr,ap->hw_addr) == 0)
				ap->flags = arp->flags;
		}
	}
	return 0;
}
#endif

int
doescape(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	if(argc < 2) {
		tputs("Escape char: ");
		if(Escape < 32)
			tprintf("CTRL-%c\n",Escape + 'A' - 1);
		else
			tprintf("%c\n",Escape);
	} else
		Escape = *argv[1];
	return 0;
}

/* Generate system command packet. Synopsis:
 * remote [-p port#] [-k key] [-a hostname] <hostname> reset|exit|kickme
 */
int
doremote(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in fsock;
	int s, c, klen;
	char *data, *cmd, *host, x, *key = NULLCHAR;
	int16 port, len = 1;
	int32 addr = 0;

	port = IPPORT_REMOTE;	/* Set default */
	optind = 1;		/* reinit getopt() */
	while((c = getopt(argc,argv,"a:p:k:s:")) != EOF){
		switch(c){
		case 'a':
			if((addr = resolve(optarg)) == 0){
				tprintf(Badhost,optarg);
				return -1;
			}
			break;
		case 'p':
			port = atoi(optarg);
			break;
		case 'k':
			key = strxdup(optarg);
			klen = strlen(key);
			break;
		case 's':
			Rempass = strxdup(optarg);
			return 0;	/* Only set local password */
		}
	}
	if(optind > argc - 2){
		tputs("Insufficient args\n");
		return -1;
	}
	host = argv[optind++];
	cmd = argv[optind];
	if((s = socket(AF_INET,SOCK_DGRAM,0)) == -1){
		tputs(Nosocket);
		return 1;
	}
	/* Did the user include a password or kickme target? */
	if(addr != 0 && cmd[0] == 'k')
		len += sizeof(int32);

	if(key != NULLCHAR && (cmd[0] == 'r' || cmd[0] == 'e'))
		len += klen;

	if(len == 1)
		data = &x;
	else
		data = mxallocw(len);

	fsock.sin_family = AF_INET;
	if((fsock.sin_addr.s_addr = resolve(host)) == 0){
		tprintf(Badhost,host);
		goto cleanup;
	}
	fsock.sin_port = port;

	switch(cmd[0]){
	case 'r':
		data[0] = SYS_RESET;
		if(key != NULLCHAR) {
			strncpy(&data[1],key,klen);
			data[data[1]+klen] = '\0';
		}
		break;
	case 'e':
		data[0] = SYS_EXIT;
		if(key != NULLCHAR) {
			strncpy(&data[1],key,klen);
			data[data[1]+klen] = '\0';
		}
		break;
	case 'k':
		data[0] = KICK_ME;
		if(addr != 0)
			put32(&data[1],addr);
		break;
	default:
		tprintf("Unknown command %s\n",cmd);
		goto cleanup;
	}
	/* Form the command packet and send it */
	if(sendto(s,data,len,0,(char *)&fsock,sizeof(fsock)) == -1) {
		tprintf("sendto failed: %s\n",sys_errlist[errno]);
		goto cleanup;
	}
cleanup:
	if(data != &x)
		xfree(data);
	if(key != NULLCHAR)
		xfree(key);
	close_s(s);
	return 0;
}

int
domore(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	FILE *fp;
	char buf[81];
	int row = Nrows - 3;

	if((fp = open_file(argv[1],READ_TEXT,0,1)) == NULLFILE)
		return -1;

	if((sp = newsession(argv[1],MORE,0,1)) == NULLSESSION) {
		fclose(fp);
		tputs(Nosess);
		return -1;
	}
	/* Put tty into raw mode so single-char responses will work */
	sp->ttystate.echo = sp->ttystate.edit = 0;

	while(fgets(buf,sizeof(buf),fp),!feof(fp)){
		tputs(buf);
		if(--row == 0){
			row = keywait("--More--",0);
			switch(row){
			case -1:
			case 'q':
			case 'Q':
				goto done;
			case '\n':
			case '\r':
				row = 2;
				break;
			case ' ':
			default:
				row = Nrows - 3;
			}
		}
	}
done:
	fclose(fp);
	keywait(NULLCHAR,1);
	freesession(sp);
	return 0;
}

int
dotail(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int handle, i;
	unsigned line = 0, rdsize = 2000;
	long length;
	char buffer[2000], Noread[] = "Can't read %s: %s\n";

	if ((handle = open(argv[1],O_BINARY | O_RDONLY)) == -1) {
		tprintf(Noread,argv[1],sys_errlist[errno]);
		return -1;
	}
	length = filelength(handle);

	if (length > 2000) {
		length -= 2000;
	} else {
		rdsize = (int)length;
		length = 0;
	}

	lseek (handle, length, SEEK_SET);
	if (read (handle, buffer, rdsize) == -1) {
		tprintf(Noread,argv[1],sys_errlist[errno]);
		close(handle);
		return -1;
	}

	for (i = rdsize - 1; i > 0; i--) {
		if (buffer[i] == '\n')
			line++;
		if (line == 18)
			break;
	}
	for (; i < rdsize; i++)
		tputc(buffer[i]);

	tputs("\n");
	close(handle);
	return 0;
}

/* Log messages of the form
 * Tue Jan 31 00:00:00 1987 44.64.0.7:1003 open FTP
 */
#if	defined(ANSIPROTO)
void
log(int s,char *fmt, ...)
{
	va_list ap;
	char *cp;
	long t;
	int i;
#ifdef MSDOS
	int fd;
#endif
	struct sockaddr fsocket;

	if(Logfp == NULLFILE)
		return;

	time(&t);
	cp = ctime(&t);
	rip(cp);
	i = SOCKSIZE;
	fprintf(Logfp,"%s",cp);
	if(getpeername(s,(char *)&fsocket,&i) != -1)
		fprintf(Logfp," %s",psocket(&fsocket));

	fprintf(Logfp," - ");
	va_start(ap,fmt);
	vfprintf(Logfp,fmt,ap);
	va_end(ap);
	fprintf(Logfp,"\n");
	fflush(Logfp);
#ifdef	MSDOS
	/* MS-DOS doesn't really flush files until they're closed */
	fd = fileno(Logfp);
	if((fd = dup(fd)) != -1)
		close(fd);
#endif
}
#else
/*VARARGS2*/
void
log(s,fmt,arg1,arg2,arg3,arg4,arg5)
int s;
char *fmt;
int arg1,arg2,arg3,arg4,arg5;
{
	char *cp;
	long t;
	int i;
#ifdef MSDOS
	int fd;
#endif
	struct sockaddr fsocket;

	if(Logfp == NULLFILE)
		return;

	time(&t);
	cp = ctime(&t);
	rip(cp);
	i = SOCKSIZE;
	fprintf(Logfp,"%s",cp);
	if(getpeername(s,(char *)&fsocket,&i) != -1)
		fprintf(Logfp," %s",psocket(&fsocket));

	fprintf(Logfp," - ");
	fprintf(Logfp,fmt,arg1,arg2,arg3,arg4,arg5);
	fprintf(Logfp,"\n");
	fflush(Logfp);
#ifdef	MSDOS
	/* MS-DOS doesn't really flush files until they're closed */
	fd = fileno(Logfp);
	if((fd = dup(fd)) != -1)
		close(fd);
#endif
}
#endif

int
dosource(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int linenum = 0;
	char inbuf[BUFSIZ], intmp[BUFSIZ];
	FILE *fp;

	/* Read command source file */
	if((fp = open_file(argv[1],READ_TEXT,0,1)) == NULLFILE)
		return -1;

	while(fgets(inbuf,BUFSIZ,fp) != NULLCHAR){
		strcpy(intmp,inbuf);
		linenum++;
		if(cmdparse(Cmds,inbuf,NULL) != 0) {
			tprintf("ERROR - line %d:\n%s\n",linenum,intmp);
		}
	}
	fclose(fp);
	return 0;
}

#ifdef	__TURBOC__
static int near dofstat __ARGS((void));
#endif

int
dostatus(argc,argv,p)
int argc;
char *argv[];
void *p;

{
extern unsigned char _osmajor;
extern unsigned char _osminor;

	doversion();
    tprintf("System time     : %s", ctime(&currtime));
    tprintf("Start time      : %s", ctime(&StartTime));
    tprintf("Elapsed time    : %s\n",tformat(secclock()));
    tprintf("Startup coreleft: %lu\n",core);
    tprintf("Coreleft now    : %lu\n",availmem());
    if (_osmajor == 20){
    tprintf("System          : OS/2 2.%d\n\n",_osminor);
}else{
    tprintf("DOS Vers.       : %d.%d\n\n",_osmajor,_osminor);
}
    if(argc < 9) {
#ifdef	MSDOS
        tprintf("Load info   : CodeSeg=%04x, DataSeg=%04x\n\n", _CS, _DS);
#endif
#ifdef	__TURBOC__
		dofstat();		/* print status of open files */
#endif
	}
	return 0;
}

#ifdef	__TURBOC__
/*
 * Fstat utility code.
 * Converted to go into NOS by Kelvin Hill - G1EMM  April 9, 1990
 */

// extern unsigned char _osmajor;
// extern unsigned char _osminor;
static char * near localcopy(char far *);
static char * near progname(unsigned int);

static int near
dofstat()
{
	union REGS regs;
	struct SREGS segregs;
	char far *pfiletab, far * pnext;
	char far *name, file[13], far * plist, far * entry;
	char ownername[9], ownerext[5];
	int nfiles, i, numhandles, entrylen;
	unsigned int access, devinfo, progpsp;
	long length, offset;
	int heading = 0;

	regs.h.ah = 0x52;	/* DOS list of lists */
	intdosx(&regs, &regs, &segregs);

	/* make a pointer to start of master list */
	plist = (char far *) MK_FP(segregs.es, regs.x.bx);

	/* pointer to start of file table */
	pfiletab = (char far *) MK_FP(*(int far *) (plist + 6), *(int far *) (plist + 4));

	switch (_osmajor) {
	case 2:
		entrylen = 40;	/* DOS 2.x */
		break;
    case 3:   /* DRDOS 6.0, too */
		entrylen = 53;	/* DOS 3.x */
		break;
    case 4:
    case 5:  /* DOS 5.0 */
    case 6:  /* DOS 6.0 */
        entrylen = 59;  /* DOS 4.x - I do not know what is in the
						 * extra 6 bytes */
		break;
    case 20: /* OS/2 */
        entrylen = 59;
        break;
    default:
		return 1;
	}

	for (;;) {
		/* pointer to next file table */
		pnext = (char far *) MK_FP(*(int far *) (pfiletab + 2), *(int far *) (pfiletab + 0));
		nfiles = *(int far *) (pfiletab + 4);
 #ifdef MDEBUG
		tprintf("\nFile table at %Fp entries for %d files\n", pfiletab, nfiles);
 #endif
		for (i = 0; i < nfiles; i++) {
			/* cycle through all files, quit when we reach an
			 * unused entry
			 */
			entry = pfiletab + 6 + (i * entrylen);
			if (_osmajor >= 3) {
				name = entry + 32;
				sprintf(file,"%.11s",localcopy(name));
				numhandles = *(int far *) (entry + 0);
				access = (int) *(char far *) (entry + 2);
				length = *(long far *) (entry + 17);
				offset = *(long far *) (entry + 21);
				devinfo = *(int far *) (entry + 5);
				progpsp = *(int far *) (entry + 49);
			} else {
				name = entry + 4;
				sprintf(file,"%.11s",localcopy(name));
				numhandles = (int) *(char far *) (entry + 0);
				access = (int) *(char far *) (entry + 1);
				length = *(long far *) (entry + 19);
				offset = *(long far *) (entry + 36);
				devinfo = (int) *(char far *) (entry + 27);
			}
			if ((strlen(file) > 0) && (numhandles > 0) && !(devinfo & 0x80)) {
				if(!heading) {
                    tputs("open files     length   offset hnd acc  PSP device       type/owner\n");
					heading++;		/* header now printed */
				}
				tprintf("%8.8s.%3.3s %8ld %8ld  %2d ",
				       file, &file[8], length, offset, numhandles);
				switch (access) {
				case 0:
					tputs("r ");
					break;
				case 1:
					tputs("w ");
					break;
				case 2:
					tputs("rw");
					break;
				default:
					tputs("  ");
				}
				tputs("  ");
				if (_osmajor >= 3)
					tprintf("%04X", progpsp);
				else
					tputs("----");
				tprintf(" drive %c: ", 'A' + (devinfo & 0x1F));
				if (devinfo & 0x8000)
					tputs("(network) ");
				if (_osmajor >= 3) {
					/*
					 * only DOS 3+ can find out
					 * the name of the program
					 */
					fnsplit(progname(progpsp), NULL, NULL, ownername, ownerext);
					tprintf("   [%s%s]", strlwr(ownername), strlwr(ownerext));
				}
				tputs("\n");
			}
			if (strlen(file) == 0)
				return 0;
		}
		pfiletab = pnext;
	}
}

/* Make a copy of a string pointed to by a far pointer */
static char * near
localcopy(s)
char far *s;
{
	static char localstring[255];
	char far *p = s;
	char *l = localstring;
	int i = 0;

	while (*p != NULL && i++ < 255) {
		*l++ = *p++;
	}

	*l = '\0';
	return (localstring);
}

/*
 * Return a near pointer to a character string with the full path name of the
 * program whose PSP is given in the argument.  If the argument is invalid,
 * this may return gibberish but I don't know how to tell Offset 0x2C in the
 * PSP in the segment address of the environment of a program.  Beyond the
 * last environment string is a null marker, a word count (usually 1), then
 * the full pathname of the owner of the environment This only works for DOS
 * 3+
 */
static char * near
progname(pid)
unsigned int pid;
{
	unsigned far *envsegptr;	/* Pointer to seg address of environment */
	char far *envptr;			/* Pointer to pid's environment	 */
	unsigned far *envsizeptr;	/* Pointer to environment size */
	unsigned envsize;			/* Size of pid's environment */
	unsigned ppid;				/* Parent psp address */

	/* find the parent process psp at offset 0x16 of the psp */
	ppid = *(unsigned far *) MK_FP(pid, 0x16);

	/* find the environment at offset 2Ch of the psp */
	envsegptr = (unsigned far *) MK_FP(pid, 0x2C);
	envptr = (char far *) MK_FP(*envsegptr, 0);

	/*
	 * Make a pointer that contains the size of the environment block.
	 * Must point back one paragraph (to the environments MCB plus three
	 * bytes forward (to the MCB block size field).
	 */
	envsizeptr = (unsigned far *) MK_FP(*envsegptr - 1, 0x3);
	envsize = *envsizeptr * 16;	/* x 16 turns it into bytes */

	while (envsize > 0) {
		/* search for end of environment block, or NULL */
		while (--envsize && *envptr++);

		/*
		 * Now check for another NULL immediately following the first
		 * one located and a word count of 0001 following that.
		 */
		if (!*envptr && *(unsigned far *) (envptr + 1) == 0x1) {
			envptr += 3;
			break;
		}
	}
	return (envsize > 0) ? localcopy(envptr) : (pid == ppid) ? "-shell-" : "unknown";
}
#endif

static void near
loadfile(void)
{
	FILE *fp;
	struct iface *ifp;

#ifdef NETROM
	extern int donrload __ARGS((void));
    extern int Nr_save;
#endif

/* loading of ip-routes */
	if ((fp = open_file(Iproutefile,READ_BINARY,0,1)) != NULLFILE) {
		struct ip_saverecord ipbuf;

		while(fread((char *)&ipbuf, sizeof(ipbuf), 1, fp)) {
			for(ifp = Ifaces; ifp; ifp = ifp->next) {
				if(ifp->niface == ipbuf.niface)
					break;
			}
			if(ifp != NULLIF) {
				if (ipbuf.gateway == 0xffffffffL)
					ipbuf.gateway = 0;
				rt_add(ipbuf.target,ipbuf.bits,ipbuf.gateway,ifp,
					ipbuf.metric,0,ipbuf.flags);
			}
		}
		fclose(fp);
	}

/* loading of arp-entries */
	if ((fp = open_file(Arproutefile,READ_BINARY,0,1)) != NULLFILE) {
		struct arp_tab *p;
		struct arp_saverecord arpbuf;
		char  hw_addr[MAXHWALEN];

		if(getc(fp) == ARP_FILE_VERSION) {		/* Version 3 required !!!! */
			while(fread((char *)&arpbuf, sizeof(arpbuf), 1, fp)) {
				if (fread(hw_addr, arpbuf.hwalen, 1, fp)) {
					if (arpbuf.hardware < NHWTYPES) {
						if ((p = arp_add(arpbuf.ip_addr,arpbuf.hardware,
						  hw_addr,arpbuf.pub,arpbuf.flags)) != NULLARP) {
							stop_timer(&p->timer);
							set_timer(&p->timer,0L);
						}
					}
				}
			}
		}
		fclose(fp);
	}

/* loading of ax25-routes */
#ifdef AX25
	if ((fp = open_file(Axroutefile,READ_BINARY,0,1)) != NULLFILE) {
		struct axroute_tab *rp;
		struct iface *ifptable[ASY_MAX
#ifdef SCC
		   + MAXSCC
#endif
#ifdef VANESSA
			+ VAN_MAX
#endif
#ifdef AXIP
   			  + NAX25
#endif
#ifdef DRSI
                            + DRMAX
#endif
					 ];

		struct ax_saverecord axbuf;

		memset((char *) ifptable, 0, sizeof(ifptable));

		for (ifp = Ifaces; ifp; ifp = ifp->next) {
			if (ifp->output == ax_output)
				ifptable[ifp->niface] = ifp;
		}
		while (fread((char *)&axbuf, sizeof(axbuf), 1, fp)) {
			if (axbuf.time + Axholdtime < currtime)
				continue;
			rp = axroute_tabptr(&axbuf.call, 1);
			if (axbuf.digi.call[0])
				rp->digi = axroute_tabptr(&axbuf.digi, 1);
			if (axbuf.dev >= 0 && axbuf.dev < Niface)
				rp->ifp = ifptable[axbuf.dev];
			rp->time = axbuf.time;
		}
		fclose(fp);
	}
#endif
#ifdef NETROM
    if(Nr_save) donrload();
#endif
}

static void
savefile(void)
{
  FILE * fp;
  int  i;

#ifdef NETROM
	extern int donrsave __ARGS((void));
    extern int Nr_save;
#endif

  stop_timer(&Savetimer);
  if ((fp = open_file(Iproutetmp,WRITE_BINARY,0,1)) != NULLFILE) {
	  struct route *rp;
	  struct ip_saverecord buf;
	  int bits;

	  for(bits = 31; bits >= 0; bits--) {
		for(i=0;i<HASHMOD;i++){
		  for(rp = Routes[bits][i];rp != NULLROUTE;rp = rp->next){
			if(rp->target == 0 || rp->flags >= 0x01) continue;
			buf.target = rp->target;
			buf.bits = rp->bits;
			buf.gateway = (rp->gateway != 0) ? rp->gateway : 0xffffffffL;
			buf.niface = rp->iface->niface;
			buf.metric = rp->metric;
			buf.flags = rp->flags;
			fwrite((char *)&buf,sizeof(buf),1,fp);
		  }
		}
	  }
	  fflush(fp);
	  fclose(fp);
	  unlink(Iproutefile);
	  rename(Iproutetmp,Iproutefile);
  }

  pwait(NULL);
  if ((fp = open_file(Arproutetmp,WRITE_BINARY,0,1)) != NULLFILE) {
	  struct arp_saverecord buf;
	  struct arp_tab *p;

	  putc(ARP_FILE_VERSION, fp);
	  for (i = 0; i < HASHMOD; i++) {
		for (p = Arp_tab[i]; p; p = p->next) {
		  if (p->hw_addr && p->state == ARP_VALID) {
			buf.ip_addr = p->ip_addr;
			buf.hardware = p->hardware;
			buf.flags = p->flags;
			buf.hwalen = p->hwalen;
			buf.pub = p->pub;
			fwrite((char *) & buf, sizeof(buf), 1, fp);
			fwrite(p->hw_addr, p->hwalen, 1, fp);
		  }
		}
	  }
	  fflush(fp);
	  fclose(fp);
	  unlink(Arproutefile);
	  rename(Arproutetmp,Arproutefile);
  }

  pwait(NULL);

#ifdef AX25
  if ((fp = open_file(Axroutetmp,WRITE_BINARY,0,1)) != NULLFILE) {
	  struct ax_saverecord buf;
	  struct axroute_tab *rp, *lp;

	  for (i = 0; i < AXROUTESIZE; i++) {
		for (lp = 0, rp = axroute_tab[i]; rp; ) {
		  if (rp->time + Axholdtime >= currtime) {
			buf.call = rp->call;
			if (rp->digi)
			  buf.digi = rp->digi->call;
			else
			  buf.digi.call[0] = '\0';
			buf.dev = rp->ifp ? rp->ifp->niface : -1;
			buf.time = rp->time;
			fwrite((char *) &buf, sizeof(buf), 1, fp);
			lp = rp;
			rp = rp->next;
		  } else if (lp) {
			lp->next = rp->next;
			xfree((char *) rp);
			rp = lp->next;
		  } else {
			axroute_tab[i] = rp->next;
			xfree((char *) rp);
			rp = axroute_tab[i];
		  }
		}
	  }
	  fflush(fp);
	  fclose(fp);
	  unlink(Axroutefile);
	  rename(Axroutetmp,Axroutefile);
  }

  pwait(NULL);

#endif
#ifdef NETROM
  if(Nr_save) donrsave();
#endif

  start_timer(&Savetimer);
}

int
dosavefile(int argc,char *argv[],void *p)
{
	if(argc < 2) {
		tprintf("Save timer %lu/%lu s\n",
			read_timer(&Savetimer)/1000L,
			dur_timer(&Savetimer)/1000L);
	} else {
		stop_timer(&Savetimer) ;			/* in case it's already running */
		/* what to call on timeout */
		Savetimer.func = (void (*) __ARGS((void *))) savefile;
		Savetimer.arg = NULLCHAR;			/* dummy value */
		/* set timer duration */
		set_timer(&Savetimer,atol(argv[1]) * 1000L);
		start_timer(&Savetimer);			/* and fire it up */
	}
	return 0;
}

static void near
doversion(void)
{
	tprintf("\nKA9Q NOS based %s (%s)\n"
			"Copyright 1991/2 by Phil Karn (KA9Q), "
			"WAMPES parts by DK5SG, and others.\n\n",
            Version,__DATE__);

}

int
doattribute(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	if(tolower(*argv[1] == 'm')) {
		normal = 112;
		normalh = 15;
		normals = 112;
		invers = 240;
		red = 127;
		common = 7;
		panic = 143;
	} else {
		normal = NORMALL;
		normalh = NORMALH;
		normals = NORMALS;
		invers = INVERS;
		red = RED;
		common = COMMON;
		panic = PANIC;
	}
	return 0;
}

#ifdef RESETTIMER
static void
inittim()
{
    outport(TIMCTRL,0x36); /*Init Timer0 for sqarewavegeneration*/
    outport(TIMER0,0x50);
    outport(TIMER0,0x50); /*Teilerfaktor fr Timer0 0xffff*/

    outport(TIMCTRL,0x78); /*Init Timer1 for squarewavegeneration*/
    outport(TIMER1,0xff);
    outport(TIMER1,0x0d);

    outport(TIMCTRL,0xb4); /*Init Timer2 for sqarewavegeneration*/
    outport(TIMER2,0xff);
    outport(TIMER2,0x20);


    outport(IOCTRL,0x80); /*Set all I/O-Ports to output im Mode0*/
	outport(IOCTRL,0x80);
    outport(PORTC,0xff); /*activate Reset*/

    return;
}
#endif

static void
dostatustimer(void)
{
   if (!istate())   {                   /* return if in critical section*/
	  start_timer(&Statustimer);
      return;
   }
   alert(statp,(void *)1);                /* wake process                 */
}

void
statusline(i,v1,v2)
int i;
void *v1;
void *v2;
{
	struct text_info str;
	struct time sttime;
	struct session *sp;
	struct usock *up;
	int s;
	char size;
	extern int Attended;

	statp = Curproc;                /* preserve process descriptor  */
	Statustimer.func = (void (*)())dostatustimer; /* what to call on timeout*/
	Statustimer.arg = NULLCHAR;     /* dummy value                  */
	set_timer(&Statustimer,990);	/* set timer duration, appr. 1 sec*/

#ifdef MDEBUG
	strcpy(Statustimer.tname,"Status");
#endif
	start_timer(&Statustimer);

	for(;;) {
		pwait(&sttime);
		stop_timer(&Statustimer);
		time(&currtime);
		gettime(&sttime);

#ifdef RESETTIMER
		outport(TIMER1,0xff);   /* Reset Timer */
		outport(TIMER1,0x0d);
#endif

		gettextinfo(&str);
		window(1,1,80,2);
		gotoxy(1,1);

		if((size = (availmem() < Memthresh * 2)) != 0) {
			textattr(panic);
			cputs(" PANIC ");
		} else {
			textattr(red);
			cputs(" WNOS4 ");
			textattr(normal);
		}

		if(Current->type == COMMAND || Current->type == TRACESESSION || size) {
			cprintf(" Coreleft%7lu",availmem());
		} else {
			cprintf(" %-15.15s",Current->name);
		}
		s = -1;
		cprintf("%-8s",(Current->type == FTP
		  && (s = Current->cb.ftp->data) != -1)
		  ? "FTP-DATA" : Sestypes[Current->type]);

		if((up = itop((s == -1) ? Current->s : s)) != NULLUSOCK) {
			switch(up->type) {
			case TYPE_NETROML4:
				if(up->cb.nr4 != NULLNR4CB) {
					cprintf("Retries%3dUnack%5dSRTT%7ld%s",
						up->cb.nr4->blevel,up->cb.nr4->nbuffered,
						up->cb.nr4->srtt,up->cb.nr4->choked ? "CHK" : "   ");
				} else
					goto line;
				break;
            case TYPE_RAW:      /* fix to bad status line */
                goto line;      /* in ping session */
            case TYPE_AX25I:
				if(up->cb.ax25 != NULLAX25) {
					cprintf("Retries%3dUnack%5dT1  ",
						up->cb.ax25->retries,up->cb.ax25->unack);
					switch(up->cb.ax25->t1.state) {
					case TIMER_RUN:
						cprintf("%3lu",read_timer(&up->cb.ax25->t1)/1000);
						break;
					case TIMER_STOP:
						cputs("  -");
						break;
					case TIMER_EXPIRE:
						cputs("  E");
						break;
					}
					cprintf("/%3lu%s",
						dur_timer(&up->cb.ax25->t1)/1000,
						up->cb.ax25->remotebusy ? "RNR" : "   ");
				} else
					goto line;
				break;
			case TYPE_TCP:
				if(up->cb.tcb != NULLTCB) {
					if(s == -1) {
						cprintf("Backoff%3uTxQ%7uRTT ",
							up->cb.tcb->backoff,up->cb.tcb->sndcnt);
					} else {
						cprintf("Rx%8luTx%8luRTT ",
							up->cb.tcb->rcv.nxt - up->cb.tcb->irs,
							up->cb.tcb->snd.una - up->cb.tcb->iss);
					}
					switch(up->cb.tcb->timer.state) {
					case TIMER_RUN:
						cprintf("%3lu",read_timer(&up->cb.tcb->timer)/1000);
						break;
					case TIMER_STOP:
						cputs("  -");
						break;
					case TIMER_EXPIRE:
						cputs("  E");
						break;
					}
					cprintf("/%3lu   ",
						dur_timer(&up->cb.tcb->timer)/1000);
				} else
					goto line;
				break;
			}
		} else {
line:
/*
			cprintf("%-10s%26s",Attended ? "Attended" : "Unattended"," ");
*/
			cprintf("%31sttended",Attended ? "  A" : "Una");
		}

		if(Current->rfile != NULLCHAR && sttime.ti_sec & 1)
			cputs("R");
		else if(Current->ufile != NULLCHAR && !(sttime.ti_sec & 1))
			cputs("U");
		else
			cputs(" ");

		cprintf(" %02d%c%02d ",
			sttime.ti_hour,(sttime.ti_sec & 1) ? ' ' : ':',sttime.ti_min);

/* 2nd line starts here */
		textattr(normals);
		for(sp = Sessions, s = 0; sp < &Sessions[Nsessions]; sp++){
			if(sp->type == COMMAND || sp->type == TRACESESSION)
				continue;
			s++;
			if(sp->type != FREE) {
				if(socklen(sp->output,1))
					textattr(invers);

				cprintf(" %d:%s%s%s ",
					s,
					(sp->rfile == NULLCHAR) ? "" : "R:",
					(sp->ufile == NULLCHAR) ? "" : "U:",
					sp->name);

				textattr(normals);
			}
		}
		clreol();
		window(str.winleft,str.wintop,str.winright,str.winbottom);
		textattr(common);
		gotoxy(str.curx,str.cury);
		start_timer(&Statustimer);
	}
}
