/*      vanessa.h
 *
 * Definitions for vanessa.c driver code by hb9rwm
 *
 */


#define VAN_MAX 8       /* one board = two AX.25 ports ! 8-> 4 Boards */
#define MAXLFRAME       1024    /* version depending */
#define DP_BLOCK        4096    /* size of DP-RAM for one port */

#define PARAM_COUNT 5

#define TXDELAY 	1       /* Transmit Delay 10 ms/cnt */
#define PERSIST		2       /* Persistence (0-255) as a % */
#define SLOTTIME        3       /* Delay to wait on persistence hit */
#define TXTAIL          4       /* Delay after XMTR OFF */
#define FULLDUP		5       /* Full Duplex mode 0=CSMA 1=DUP 2=ALWAYS KEYED */

#define LED_ON          0       /* LED's on the rear of the vanessa board */
#define LED_OFF 1

#define BASE_SEGMENT    0xd000  /* segment of first board */
#define BASE_IO         0x300   /* io address of first board */

#define cPNr    2                               /* offset in DP-RAM */
#define cRev    4
#define cRst    8

#define cRx     10
#define cTx     13
#define cTxKu   16
#define cRxBf   19
#define cTxBf   21
#define cRxBe   23
#define cTxBe   25
#define cRFlI   27
#define cTFlC   29
#define cTFlI   31
#define cRCRC   33
#define cRxOv   35
#define cTxTo   37
#define cSyTx   39
#define cSyRx   41
#define cRxAb   43
#define cTxUdr 45
#define cPort1 cTxUdr+2-cRx     /* start counters for port 1 */

#define CMD_UPLOAD      0x0100
#define CMD_CRC         0x0200
#define CMD_EXEC        0x0300
#define CMD_DOWNLOAD    0x0400
#define CMD_POINTER     0x0500
#define CMD_ID_LOAD     0x0600

#define CMD_TIMEOUT     1000            /* wait counter */

#define CDATA_SIZE      1873            /* size of dp_cDATA */

/* Data type definitions --------------------------------------- */


struct dp_record{

        int16   dp_iFProd;                      /* 0x0: DATA TRUE   */
        int16   dp_iLFrm;                       /* length of data   */
        int16   dp_iOCtl;                       /* currently unused */
        unsigned char
                dp_iBuffer[MAXLFRAME+70];       /* Data and res.    */
        int16   dp_iMagic;                      /* Bufferend Mark   */

        int16   dp_oFProd;                      /* 0x0: DATA TRUE   */
        int16   dp_oLFrm;                       /* length of data   */
        int16   dp_oOCtl;                       /* currently unused */
        unsigned char
                dp_oBuffer[MAXLFRAME+70];       /* Data and res.    */
        int16   dp_oMagic;                      /* Bufferend Mark   */

        int16   dp_reReadPar;                   /* 0x0: Param. TRUE */
        int16   dp_pSlottime;                   /* Slottime x 10ms  */
        int16   dp_pTXDelay;                    /* Tx Delay x 10ms  */
        int16   dp_pTXTail;                     /* Tx Tail  x 10ms  */
        int16   dp_pPersist;                    /* Persistanse      */
        int16   dp_pDuplex;                     /* 0=half, ff=full  */

        int16   dp_cCMD;                                                 /* 0x0:
CMD TRUE    */
        int16   dp_cCNT;                                                 /*
Length of Data   */
        int16   dp_cADR;                                                 /*
Address          */
        unsigned char   dp_cData[CDATA_SIZE];   /* Data             */
};


struct vandrvr{
        struct  dp_record far *dpram_base;
        int16   ioled;
        int16   iores;
        struct  iface *iface;
        int16   portnr;
        int16   nTXwait;
        int16   nTXmaxlen;
        int16   nRXmaxlen;
};

typedef union {
  struct dp_record dprec;
  unsigned char dpflat[DP_BLOCK];
} dpram_type;


/* function prototypes */

int van_ioctl __ARGS((struct iface *iface,int, char **));
int van_raw __ARGS((struct iface *iface,struct mbuf *data));
int pk_send __ARGS((struct mbuf *bp,struct iface *iface,int32 gateway,
        int prec,int del,int tput,int rel));
void van_rx __ARGS((int dev,void *p1,void *p2));
int van_status __ARGS((struct iface *iface));
void van_reset __ARGS((struct vandrvr *vp));
int32 cova __ARGS((char *p,int16 n));

