/* Miscellaneous servers */

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "socket.h"
#include "remote.h"
#include "hardware.h"
#include "commands.h"
#include "smtp.h"
#include "tcp.h"

char *Rempass = "";	/* Remote access password */

static int Sdisc = -1;
static int Secho = -1;
static int SRem  = -1;

static int near chkrpass __ARGS((struct mbuf *bp));

static void
discserv(s,unused,p)
int s;
void *unused;
void *p;
{
	struct mbuf *bp;

	sockowner(s,Curproc);
	log(s,"DISC open");
	while(recv_mbuf(s,&bp,0,NULLCHAR,NULL) > 0)
		free_p(bp);
	log(s,"DISC close");
	close_s(s);
}

static void
echoserv(s,unused,p)
int s;
void *unused;
void *p;
{
	struct mbuf *bp;

	sockowner(s,Curproc);
	log(s,"ECHO open");
	while(recv_mbuf(s,&bp,0,NULLCHAR,NULL) > 0)
		send_mbuf(s,bp,0,NULLCHAR,0);

	log(s,"ECHO close");
	close_s(s);
}

/* Start up TCP discard server */
int
dis1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in lsocket;
	int s;

	if(Sdisc != -1)
		return 0;

	psignal(Curproc,0); 	/* Don't keep the parser waiting */
	chname(Curproc,"Discard listener");

	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	lsocket.sin_port = (argc < 2) ? IPPORT_DISCARD : atoi(argv[1]);

	Sdisc = socket(AF_INET,SOCK_STREAM,0);
	bind(Sdisc,(char *)&lsocket,sizeof(lsocket));
	listen(Sdisc,1);
	for(;;){
		if((s = accept(Sdisc,NULLCHAR,(int *)NULL)) == -1)
			break;	/* Service is shutting down */

		if(availmem() < Memthresh){
			shutdown(s,1);
		} else
			/* Spawn a server */
			newproc("Discard server",576,discserv,s,NULL,NULL,0);
	}
	return 0;
}

/* Stop discard server */
int
dis0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	close_s(Sdisc);
	Sdisc = -1;
	return 0;
}

/* Start up TCP echo server */
int
echo1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in lsocket;
	int s;

	if(Secho != -1){
		return 0;
	}
	psignal(Curproc,0); 	/* Don't keep the parser waiting */
	chname(Curproc,"Echo listener");

	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	lsocket.sin_port = (argc < 2) ? IPPORT_ECHO : atoi(argv[1]);

	Secho = socket(AF_INET,SOCK_STREAM,0);
	bind(Secho,(char *)&lsocket,sizeof(lsocket));
	listen(Secho,1);
	for(;;){
		if((s = accept(Secho,NULLCHAR,(int *)NULL)) == -1)
			break;	/* Service is shutting down */

		if(availmem() < Memthresh){
			shutdown(s,1);
		} else
			/* Spawn a server */
			newproc("Echo server",576,echoserv,s,NULL,NULL,0);
	}
	return 0;
}

/* stop echo server */
int
echo0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	close_s(Secho);
	Secho = -1;
	return 0;
}

/* Check remote password */
static int near
chkrpass(struct mbuf *bp)
{
	char lbuf[80];

	int16 len = len_p(bp);

	if(strlen(Rempass) != len)
		return 0;
	pullup(&bp,lbuf,(int16)min(len,80));
	return (strncmp(Rempass,lbuf,len) == 0);
}

/* Start remote exit/reboot server */
int
rem1(int argc,char *argv[],void *p)
{
	struct sockaddr_in lsocket,fsock;
	int i, command;
	struct mbuf *bp;
	int32 addr;

	if(SRem != -1)
		return 0;
	psignal(Curproc,0);
	chname(Curproc,"Remote listener");
	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	lsocket.sin_port = (argc < 2) ? IPPORT_REMOTE : atoi(argv[1]);

	SRem = socket(AF_INET,SOCK_DGRAM,0);
	bind(SRem,(char *)&lsocket,sizeof(lsocket));
	for(;;){
		i = sizeof(fsock);
		if(recv_mbuf(SRem,&bp,0,(char *)&fsock,&i) == -1)
			break;
		command = PULLCHAR(&bp);
		i = chkrpass(bp);
		switch(command){
#ifdef	MSDOS	/* Only present on PCs running MSDOS */
		case SYS_RESET:
			log(SRem,"REM  reset %s %s",
			  psocket((struct sockaddr *)&fsock),i ? "" : "PASSWORD FAIL");
			if(i){
				iostop();
				sysreset();	/* No return */
			}
			break;
#endif
		case SYS_EXIT:
			log(SRem,"REM  exit %s %s",
			  psocket((struct sockaddr *)&fsock),i ? "" : "PASSWORD FAIL");
			if(i){
				iostop();
				doexit(0,0,0);
			}
			break;
		case KICK_ME:
			if(len_p(bp) >= sizeof(int32))
				addr = pull32(&bp);
			else
				addr = fsock.sin_addr.s_addr;
			kick(addr);
			smtptick((void *)addr);
			break;
		}
		free_p(bp);
	}
	return 0;
}

int
rem0(int argc,char *argv[],void *p)
{
	close_s(SRem);
	SRem = -1;
	return 0;
}


