/************************************************************************/
/* 941028 FLEXNET routing packet tracing routines for wampes Tom Sailer */
/*        HB9JNX, ported to WNOS by DG1ZX 				*/
/* 	  Trace of compressed rmnc headers by DG1ZX			*/
/************************************************************************/

#include <stdio.h>
#include "global.h"
#include "config.h"
#ifdef FLEXNET
#include "flexnet.h"
#include "mbuf.h"
#include "ax25.h"
#include "trace.h"

/* some prototypes */
static int near decode_line(FILE *fp,struct mbuf **bpp);
static int near fd_getnum(struct mbuf **bpp, int *val);


/* Display FLEXNET network and transport headers */
void
flexnet_dump(FILE *fp,struct mbuf **bpp) {

  if(bpp == NULLBUFP || *bpp == NULLBUF)
    return;

  trprintf(fp,"FLEXNET: len %d\n",len_p(*bpp));

  for (;;)
    if(decode_line(fp,bpp) == -1)
      break;
}


/* Convert encoded RMNC address to printable string */
char *
prmnc(char *destcall,char *addr) {

  destcall[0] = 0x20 + ((addr[0] >> 2) & 0x3F);
  destcall[1] = 0x20 + (((addr[0] << 4) & 0x30) | ((addr[1] >> 4) & 0x0F));
  destcall[2] = 0x20 + (((addr[1] << 2) & 0x30) | ((addr[2] >> 6) & 0x03));
  destcall[3] = 0x20 + (addr[2] & 0x3F);
  destcall[4] = 0x20 + ((addr[3] >> 2) & 0x3F);
  destcall[5] = 0x20 + (((addr[3] << 4) & 0x30) | ((addr[4] >> 4) & 0x0F));

  if ((addr[4] & 0x0F) != 0)
    sprintf(&destcall[6],"-%d",(addr[4] & 0x0F));   /* ssid */
  else
    destcall[6] = '\0';

  return destcall;
}


static int near fd_getnum(struct mbuf **bpp, int *val) {
  int chr;

  *val = 0;
  do {
    chr=PULLCHAR(bpp);
    if ((chr == -1) || (chr < '0') || (chr > '9'))
      return (chr);
    *val = *val * 10 + chr - '0';
  } while (1);
}


static int near decode_line(FILE *fp,struct mbuf **bpp) {
  int func, chr, i;

  switch(func=PULLCHAR(bpp)) {
    case -1:
      return (-1);

    case '0':		/* link setup packet */
      trprintf(fp,"Link setup: ");
      do {
	chr=PULLCHAR(bpp);
	if((chr == 13) || (chr == -1))
	  break;
	trprintf(fp,"%c",chr);
      } while(1);
      trprintf(fp,"\n");
      break;

    case '1':		/* measured RTT */
      chr = fd_getnum(bpp,&i);
      trprintf(fp,"Measured RTT: %i\n",i);
      break;

    case '2':
      /* data isn't important, it's all spaces */
      trprintf(fp,"Polling Packet\n");
      chr=0;
      break;

    case '3':		/* now the interesting part, the routing packet */
      do {
	chr=PULLCHAR(bpp);
	if((chr == -1) || (chr == 13))
	  break;
	if(((chr >= '0') && (chr <= '9')) || ((chr >= 'A') && (chr <= 'Z'))) {
	  /* this is a routing entry */
	  trprintf(fp,"Routing: ");
	  for(i=0;i<6;i++) {
	    trprintf(fp,"%c",chr);
	    chr=PULLCHAR(bpp);
	    if ((chr == 13) || (chr == -1))
	      return chr;
	  }
	  trprintf(fp,"  %2u-",chr-'0');
	  chr=PULLCHAR(bpp);
	  if ((chr == 13) || (chr == -1))
	    return chr;
	  trprintf(fp,"%2u  ",chr-'0');
	  chr = fd_getnum(bpp,&i);
	  if (i == 0)
	    trprintf(fp,"Link down\n");
	  else
	    trprintf(fp,"Time %u\n",i);
	} else if (chr == '-') {
	    trprintf(fp,"Routing: - (??)\n");
	} else if (chr == '+') {
	    trprintf(fp,"Routing: + (??)\n");
	} else {
	    trprintf(fp,"Routing: Unknown: %c\n",chr);
	}
	if ((chr == 13) || (chr == -1))
	  break;
      } while (1);
      break;

    case '6':
      trprintf(fp,"Route query: ");
      do {
	chr=PULLCHAR(bpp);
	if((chr == 13) || (chr == -1))
	  break;
	trprintf(fp,"%c",chr);
      } while(1);
      trprintf(fp,"\n");
      break;

    case '7':
      trprintf(fp,"Route query response: ");
      do {
	chr=PULLCHAR(bpp);
	if((chr == 13) || (chr == -1))
	  break;
	trprintf(fp,"%c",chr);
      } while(1);
      trprintf(fp,"\n");
      break;

    default:
      trprintf(fp,"Unknown type: %u: ",func);
      do {
	chr=PULLCHAR(bpp);
	if((chr == 13) || (chr == -1))
	  break;
	trprintf(fp,"%c",chr);
      } while(1);
      trprintf(fp,"\n");
      break;
    }

  do {
    if((chr == 13) || (chr == -1))
      return (chr);
    chr=PULLCHAR(bpp);
  } while(1);
}

#endif /* FLEXNET */
