#ifndef	_CONFIG_H
#define _CONFIG_H

/* Software options */
#define	MAILBOX		1		/* Include SM0RGV mailbox server */
#define	SERVERS		1		/* Include TCP servers */
#define	TRACE		1		/* Include packet tracing code */
#define	POP2_SERVER	1		/* POP2 Server  - can't undef - ve3mrm */
#define	POP2_CLIENT	1		/* POP2 Client  - can't undef - ve3mrm */
#define	POP3_SERVER	1		/* POP3 Server  */
#define	POP3_CLIENT	1		/* POP3 Client  */
#define	NNTP		1		/* Include NNTP Network News Protocol */
#define CONVERS		1		/* conversd implementation - DB3FL */
#undef 	AXIP		1		/* AX25/IP encapsulation */
#define	LZW		1		/* LZW compression */
#define	ENH		1		/* enables enhanced DOMAIN options */
#undef  RLOGINCLI       1               /* rlogin for unix clients */
#define IPACCESS	1		/* IP access control */
#undef TCPACCESS	1		/* TCP access control */
#undef	FLEXNET		1		/* FLEXNET-TRACE - DG1ZX */

/* Hardware config */
#define NSESSIONS	8		/* Number of interactive clients */
#define DEFNSOCK	60		/* Default number of sockets */
#define	MTHRESH		16384		/* Default memory threshold */
#define	NROWS		25		/* Number of rows on screen */
#define NCOLS		80		/* Number of cols on screen */
#define	NIBUFS		20		/* Number of interrupt buffers */
#define	IBUFSIZE	512	 	/* Size of interrupt buffers */
#define ESCAPE		1		/* Allow Unix style escape on PC */

/* Hardware configuration */
#undef	ARCNET		1		/* ARCnet via PACKET driver */
#undef	PC_EC		1		/* 3-Com 3C501 Ethernet controller */
#define	SLIP		1		/* Serial line IP */
#define	KISS		1		/* KISS TNC code */
#undef  CRCSET		1		/* KISS CRC (SMACK)	*/
#undef	HS		1		/* High speed (56kbps) modem driver */
#undef	HAPN		1		/* Hamilton Area Packet Network driver code */
#undef	EAGLE		1		/* Eagle card driver */
#define	PACKET		1		/* FTP Software's Packet Driver interface */
#undef	PC100		1		/* PAC-COM PC-100 driver code */
#undef	APPLETALK	1		/* Appletalk interface (Macintosh) */
#undef	NRS		1		/* NET/ROM async interface */
#define	NETROM 		1		/* NET/ROM network support */
#undef 	DRSI		1		/* DRSI PCPA slow-speed driver */
#undef  SCC            	1		/* PE1CHL generic scc driver */
#define	ASY		1		/* Asynch driver code */
#undef	SLFP		1		/* SLFP packet driver class supported */
#undef	VANESSA		1		/* Vanessa Board (HB9RWM) */

#if defined(NRS)
#undef	NETROM
#define	NETROM		1		/* NRS implies NETROM */
#endif

#if (defined(HS)||defined(NETROM)||defined(KISS)||defined(HAPN)||defined(EAGLE)||defined(PC100)||defined(AXIP))
#undef AX25
#define	AX25		1		/* AX.25 subnet code */
#endif

#if (defined(ARCNET) || defined(SLFP))
#undef	PACKET
#define	PACKET		1		/* FTP Software's Packet Driver interface */
#endif

#if (defined(PC_EC) || defined(PACKET))
#undef 	ETHER
#define	ETHER		1		/* Generic Ethernet code */
#endif

#endif	/* _CONFIG_H */

