#ifndef _STATS_H
#define _STATS_H

#ifndef _FILES_H
#include "files.h"
#endif

#ifndef _COMMANDS_H
#include "commands.h"
#endif

#ifndef _SOCKET_H
#include "socket.h"
#endif

#ifndef _SESSION_H
#include "session.h"
#endif


#define MSPHOUR (1000L*60L*60L)
#define MSPDAY (1000L*60L*60L*24L)

#ifdef STATS_AREA
int doSTATclear_area (int argc,char *argv[],void *p);
void loadstats_area (void);
void savestats_area (void);
void updatestats_area (void);
int doSTATarea (int argc,char *argv[],void *p);
void newhour_area (int hour);
void newday_area (int hour);
void endmonthclear_area (int hour,int month);
void endday_area (int hour);
void eachcycle_area (time_t now);
void init_area (time_t now);
#endif

extern int BbsUsers, FtpUsers, Tutored;
#ifdef STATS_USE
extern long MiscUsers;
extern long localConfUsers;
int doSTATclear_use (int argc,char *argv[],void *p);
void loadstats_use (void);
void savestats_use (void);
void updatestats_use (void);
int doSTATusage (int argc,char *argv[],void *p);
void newhour_use (int hour);
void newday_use (int hour);
void endmonthclear_use (int hour,int month);
void endday_use (int hour);
void eachcycle_use (time_t now);
void init_use (time_t now);
#endif

#ifdef STATS_FWD
int doSTATclear_fwd (int argc,char *argv[],void *p);
void loadstats_fwd (void);
void savestats_fwd (void);
void updatestats_fwd (void);
int doSTATforward (int argc,char *argv[],void *p);
void newhour_fwd (int hour);
void newday_fwd (int hour);
void endmonthclear_fwd (int hour,int month);
void endday_fwd (int hour);
void eachcycle_fwd (time_t now);
void init_fwd (time_t now);
#endif

#ifdef STATS_MSG
int doSTATclear_msg (int argc,char *argv[],void *p);
void loadstats_msg (void);
void savestats_msg (void);
void updatestats_msg (void);
int doSTATmessage (int argc,char *argv[],void *p);
void newhour_msg (int hour);
void newday_msg (int hour);
void endmonthclear_msg (int hour,int month);
void endday_msg (int hour);
void eachcycle_msg (time_t now);
void init_msg (time_t now);
#endif

#ifdef STATS_TFC
int doSTATclear_tfc (int argc,char *argv[],void *p);
void loadstats_tfc (void);
void savestats_tfc (void);
void updatestats_tfc (void);
int doSTATtraffic (int argc,char *argv[],void *p);
void newhour_tfc (int hour);
void newday_tfc (int hour);
void endmonthclear_tfc (int hour,int month);
void endday_tfc (int hour);
void eachcycle_tfc (time_t now);
void init_tfc (time_t now);
#endif

#ifdef STATS_HTTP
int doSTATclear_http (int argc,char *argv[],void *p);
void loadstats_http (void);
void savestats_http (void);
int doSTAThttp (int argc,char *argv[],void *p);
void newhour_http (int hour);
void newday_http (int hour);
void endmonthclear_http (int hour,int month);
void endday_http (int hour);
void eachcycle_http (time_t now);
void init_http (time_t now);
#endif

#if defined(STATS_USE) || defined(STATS_MSG) || defined(STATS_AREA) || defined(STATS_FWD) || defined(STATS_TFC) || defined(STATS_HTTP)
void doGraph (int num,long array[][2]);
#endif


extern const char dailyhdr[];
extern const char weeklyhdr[];
extern const char monthlyhdr[];
extern const char yearlyhdr[];
extern const char STAT_emptystr[];
extern const char STAT_dailytrailer[];
extern const char STAT_weeklytrailer[];
extern const char STAT_monthlytrailer[];
extern const char STAT_yearlytrailer[];
extern const char STAT_cannotclear[];

extern const char *Months[12];

#endif /* _STATS_H */
