#include "global.h"
#ifdef NODECALL
#include "commands.h"
#include "mailbox.h"
#include "netrom.h"
#include "files.h"


static int donodebanner (int argc, char *argv[], void *p);
static int donodenetrom (int argc, char *argv[], void *p);
static int donodenralias (int argc, char *argv[], void *p);
static int donodecall (int argc, char *argv[], void *p);
static int donodebbscall (int argc, char *argv[], void *p);
static int donodebbsifc (int argc, char *argv[], void *p);
static char *return_id (void);
static int donodeports (int argc, char *argv[], void *p);
static int donodeheard (int argc, char *argv[], void *p);
static int dolistnodes (int argc, char *argv[], void *p);
static int dolistusers (int argc, char *argv[], void *p);
static int donodechat (int argc, char *argv[], void *p);
static int donodealias (int argc, char *argv[], void *p);
static int dolistroutes (int argc, char *argv[], void *p);
static int donodeinfo (int argc, char *argv[], void *p);
static int donodebye (int argc, char *argv[], void *p);
static int donodeconnect (int argc, char *argv[], void *p);
static int donodehelp (int argc, char *argv[], void *p);
static int donodebbs (int argc, char *argv[], void *p);
static int donodetelnet (int argc, char *argv[], void *p);
#ifdef CONVERS
static int donodeconf (int argc, char *argv[], void *p);
#endif
static int donodeshowid (int argc, char *argv[], void *p);
static int donodegwexit (int argc, char *argv[], void *p);

extern int dombconvers (int argc, char *argv[], void *p);
extern int dombjheard (int argc, char *argv[], void *p);
extern int dombusers (int argc, char *argv[], void *p);
extern int dochat (int argc, char *argv[], void *p);
#ifdef NETROM
extern int donrneighbour (int argc, char *argv[], void *p);
#endif
extern int dombconnect (int argc, char *argv[], void *p);

extern char Nodecall[AXALEN];	/* the node call in 'call' form */
extern char Nodealias[AXALEN];	/* the node alias call in 'call' form */
extern short SecureTelnet;

static char *BBScall = NULLCHAR, *BBSinterface = NULLCHAR;
static char *NODEbanner = NULLCHAR;
int NodeNetrom = 0, NodeAlias = 0;
static int NodeExitMode = 0;


static struct cmds NodeTab[] =
{
	{ "alias",		donodealias,	0, 0, NULLCHAR },
	{ "banner",		donodebanner,	0, 0, NULLCHAR },
	{ "bbscall",		donodebbscall,	0, 0, NULLCHAR },
	{ "bbsinterface",	donodebbsifc,	0, 0, NULLCHAR },
	{ "call",		donodecall,	0, 0, NULLCHAR },
	{ "gatewayexit",	donodegwexit,	0, 0, NULLCHAR },
#ifdef NETROM
	{ "netrom2node",	donodenetrom,	0, 0, NULLCHAR },
	{ "nralias2node",	donodenralias,	0, 0, NULLCHAR },
#endif
	{ "showid",		donodeshowid,	0, 0, NULLCHAR },
	{ NULLCHAR,		NULL,		0, 0, NULLCHAR }
};



int
donode (int argc, char *argv[], void *p)
{
	return subcmd (NodeTab, argc, argv, p);
}





static int
donodegwexit (int argc, char *argv[], void *p OPTIONAL)
{
	return setbool (&NodeExitMode, "Exit node upon return from gateway functions", argc, argv);
}




static int
donodenetrom (int argc, char *argv[], void *p OPTIONAL)
{
	return setbool (&NodeNetrom, "Intercept netrom call and send to node instead", argc, argv);
}




static int
donodenralias (int argc, char *argv[], void *p OPTIONAL)
{
	return setbool (&NodeAlias, "Intercept netrom alias and send to node instead", argc, argv);
}




/* Display or change node AX.25 address */
static int
donodecall (int argc, char *argv[], void *p OPTIONAL)
{
char tmp[AXBUF];

	if (argc < 2) {
		tprintf ("%s\n", pax25 (tmp, Nodecall));
		return 0;
	}
	if (setcall (Nodecall, argv[1]) == -1)
		return -1;
	return 0;
}




/* Display or change node AX.25 alias address */
static int
donodealias (int argc, char *argv[], void *p OPTIONAL)
{
char tmp[AXBUF];

	if (argc < 2) {
		tprintf ("%s\n", pax25 (tmp, Nodealias));
		return 0;
	}
	if (setcall (Nodealias, argv[1]) == -1)
		return -1;
	return 0;
}




/* Display or change node BBS callsign */
static int
donodebbscall (int argc, char *argv[], void *p OPTIONAL)
{
	if (argc < 2)	{
		if (BBScall != NULLCHAR)
			tprintf ("%s\n", BBScall);
		return 0;
	}
	free (BBScall);
	BBScall = NULLCHAR;
	if (argv[1][0])
		BBScall = strdup (argv[1]);
	return 0;
}




/* Display or change node banner string */
static int
donodebanner (int argc, char *argv[], void *p OPTIONAL)
{
	if (argc < 2)	{
		if (NODEbanner != NULLCHAR)
			tprintf ("%s\n", NODEbanner);
		return 0;
	}
	free (NODEbanner);
	NODEbanner = NULLCHAR;
	if (argv[1][0])
		NODEbanner = strdup (argv[1]);
	return 0;
}




/* Display or change node BBS interface */
static int
donodebbsifc (int argc, char *argv[], void *p OPTIONAL)
{
	if (argc < 2)	{
		if (BBSinterface != NULLCHAR)
			tprintf ("%s\n", BBSinterface);
		return 0;
	}
	free (BBSinterface);
	BBSinterface = NULLCHAR;
	if (argv[1][0])
		BBSinterface = strdup (argv[1]);
	return 0;
}



/* Display the current node ID string */
static int
donodeshowid (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tprintf ("%s\n", return_id());
	return 0;
}




static char *
return_id (void)
{
static char buffer[40];
char tmp[AXBUF];
char tmp2[AXBUF];

	if (!Nodealias[0] && !Nodecall[0])
		strcpy (buffer, "NODE} ");
	else if (Nodealias[0] && Nodecall[0])
		sprintf (buffer, "%s:%s} ", pax25 (tmp, Nodealias), pax25 (tmp2, Nodecall));
	else if (Nodealias[0])
		sprintf (buffer, "%s} ", pax25 (tmp, Nodealias));
	else
		sprintf (buffer, "%s} ", pax25 (tmp, Nodecall));
	return buffer;
}



static struct cmds Ndcmds[] =
{
	{ "?",		donodehelp,		0, 0, NULLCHAR },
	{ "Bye",	donodebye,		0, 0, NULLCHAR },
#ifdef GATECMDS
	{ "Connect",	donodeconnect,		0, 0, NULLCHAR },
#endif
#ifdef CONVERS
	{ "CONFerence",	donodeconf,		0, 0, NULLCHAR },
#endif
	{ "Help",	donodehelp,		0, 0, NULLCHAR },
	{ "Info",	donodeinfo,		0, 0, NULLCHAR },
#ifdef	AX25
	{ "Jheard",	donodeheard,		0, 0, NULLCHAR },
#endif
#if defined(NETROM) && defined(GATECMDS)
	{ "Nodes",	dolistnodes,		0, 0, NULLCHAR },
#endif
#if defined(NETROM) && defined(GATECMDS)
	{ "NRoutes",	dolistroutes,		0, 0, NULLCHAR },
#endif
	{ "Pbbs",	donodebbs,		0, 0, NULLCHAR },
	{ "POrts",	donodeports,		0, 0, NULLCHAR },
#ifdef FOQ_CMDS
	{ "Talk",	donodechat,		0, 0, NULLCHAR },
#endif
#ifdef GATECMDS
	{ "Telnet",	donodetelnet,		0, 0, NULLCHAR },
#endif
	{ "Quit",	donodebye,		0, 0, NULLCHAR },
	{ "Users",	dolistusers,		0, 0, NULLCHAR },
	{ NULLCHAR,	NULLFP ((int, char **, void *)),
						0, 0, "Huh?" },
};




static int
donodeports (int argc, char *argv[], void *p)
{
	tputs ("Ports:\n");
	return dombports (argc, argv, p);
}




static int
donodeheard (int argc, char *argv[], void *p)
{
	tputs ("Jheard:\n");
	return dombjheard (argc, argv, p);
}




static int
donodebbs (int argc OPTIONAL, char *argv[] OPTIONAL, void *p)
{
char buf[8], *newargv[4], buf2[2];
struct mbx *m;
int retval = 0;
int ind = 1;
char tmp[AXBUF], tmp2[6];

	m = (struct mbx *) p;
	m->state = MBX_GATEWAY;

	if (BBScall)	{
		strcpy (buf2, "C");
		newargv[0] = buf2;
		if (BBSinterface)	{
			newargv[1] = BBSinterface;
			ind++;
		}
		newargv[ind] = BBScall;
		newargv[ind + 1] = NULLCHAR;
		retval = donodeconnect (ind + 1, newargv, p);
	} else	{
		SecureTelnet = 0;
		m->stype = '+';
		m->authenticated |= 0x10;
		if (if_lookup ("axlp") != NULLIF) {
			strcpy (buf2, "C");
			newargv[0] = buf2;
			(void) pax25 (tmp, Mycall);
			sprintf (tmp2, "axlp");
			newargv[1] = tmp2;
			newargv[2] = tmp;
			retval = donodeconnect (3, newargv, p);
		} else {
			strcpy (buf2, "T");
			newargv[0] = buf2;
			newargv[1] = Hostname;
			sprintf (buf, "%d", IPPORT_TELNET);
			newargv[2] = buf;
			retval = dombtelnet (3, newargv, p);
			tprintf ("\n%sWelcome back.\n", return_id());
		}
		m->authenticated &= ~0x10;
	}
	return ((NodeExitMode) ? -2 : retval);
}




static int
dolistnodes (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tputs ("Nodes:\n");
	return doroutedump ();
}




static int
dolistusers (int argc, char *argv[], void *p)
{
	tputs ("Users:\n");
	return dombusers (argc, argv, p);
}




static int
donodechat (int argc, char *argv[], void *p)
{
	tputs ("Talk:\n");
	return dochat (argc, argv, p);
}




static int
dolistroutes (int argc, char *argv[], void *p)
{
	tputs ("Routes:\n");
	return donrneighbour (argc, argv, p);
}




static int
donodeinfo (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tputs ("Info:\n");
	(void) DisplayFile (NODEInfo, Curproc->output);
	return 0;
}



static int
donodebye (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tputs ("Goodbye\n");
	kpause (500L);
	return -2;
}



static int
donodetelnet (int argc, char *argv[], void *p)
{
int retval;
struct mbx *m = (struct mbx *) p;

	m->authenticated |= 0x10;
	retval = dombtelnet (argc, argv, p);
	m->authenticated &= ~0x10;
	tprintf ("\n%sWelcome back.\n", return_id());
	return ((NodeExitMode) ? -2 : retval);
}



#ifdef CONVERS
static int
donodeconf (int argc, char *argv[], void *p)
{
int retval;

	retval = dombconvers (argc, argv, p);
	tprintf ("\n%sWelcome back.\n", return_id());
	return retval;
}
#endif



static int
donodeconnect (int argc, char *argv[], void *p)
{
int retval;
struct mbx *m = (struct mbx *) p;

	m->authenticated |= 0x10;
	retval = dombconnect (argc, argv, p);
	m->authenticated &= ~0x10;
	tprintf ("\n%sWelcome back.\n", return_id());
	return ((NodeExitMode) ? -2 : retval);
}



static int
donodehelp (int argc, char *argv[], void *p OPTIONAL)
{
char buf[255];

	sprintf (buf, "Node Commands for %s at %s\n\n", Version, Hostname);
	dohelper (buf, &Ndcmds[1], "[", (argv[0][0] == '?' && argc == 1) ? NULLCHAR : NODEHelp, (argc == 2) ? argv[1] : NULLCHAR);
	return 0;
}



int
node_incom (int argc OPTIONAL, char *argv[] OPTIONAL, void *p)
{
struct mbx *m = (struct mbx *) p;

	if (NODEbanner != NULLCHAR)
		tprintf ("%s%s\n", return_id(), NODEbanner);

	while (mbxrecvline (m) != -1) {
		tputs (return_id ());
		if (m->privs & EXCLUDED_CMD)
			break;

		if (cmdparse (Ndcmds, m->line, (void *) m) == -2)
			break;

		tputc ('\n');
		m->state = MBX_NODE;
	}
	return 0;
}


#endif	/* NODECALL */
