#ifdef FORTH
#ifndef FORTH_WORD

struct vocentry {
	char type;
#define FORTH_WORD	0
#define FORTH_VARIABLE	1
#define FORTH_CONSTANT	2
	char length;
	char name[9];
};

/* variable and constant types */
#define FORTH_NORMAL		1
#define FORTH_SYSTEM		2
#define FORTH_READONLY		4
#define FORTH_INDIRECT		8

/* word types */
#define FORTH_END		0
#define FORTH_LOCALENTRY	1
#define FORTH_FIXEDENTRY	2
#define FORTH_INT32		3
#define FORTH_RETSTACK		4
#define FORTH_ARGUMENT		5

struct fvars {
	char const *name;
	char type;
	char options;
	int32 value;
};

struct fcompiler {		/* compiler scratch space */
	char buf[512];
	char base;
	char arg;
	char first;
	char *p;
	struct vocentry v;
};

struct forth {
	struct mbuf *vocabulary;
	struct mbuf *stack;
	struct mbuf *retstack;
	struct mbuf *pad;
	char *word;
	char args;
	char final;
	char delimiter;		/* used by the parser, default is a space */
	int32 base;
	int (*nextfkn) (struct forth * task);
	struct fcompiler *fc;
	int goaddr;		/* goto pointer, changes the flow of a compiled word */
	FILE *fp;
	int s;
};

struct wordlist {
	const char *name;
	int (*fkn) (struct forth * task);
	char args;		/* number of arguments, if negative. Otherwise
			   delimiting character for the next argument. */
};

int doforth (int argc, char *argv[], void *p);

#endif /* FORTH_WORD */
#endif /* FORTH */
