/* UDP-related user commands
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "commands.h"
#ifdef MSDOS
#include "socket.h"
#else
#include "mbuf.h"
#endif
#include "netuser.h"
#include "udp.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: udpcmd.c,v 1.16 1997/09/07 00:31:16 root Exp $";
#endif

#ifdef  UDPACCESS
static int douaccess (int argc, char *argv[], void *p);
extern int do_tcpudp_access (int argc, char *argv[], void *p);

struct rtaccess *UDPaccess = NULLACCESS;       /* access list */
#endif

static int doudpstat (int argc,char *argv[],void *p);

static struct cmds Udpcmds[] = {
#ifdef UDPACCESS
	{ "access",	douaccess,	0, 0,	NULLCHAR },
#endif
	{ "status",	doudpstat,	0, 0,	NULLCHAR },
	{ NULLCHAR,	NULL,		0, 0,	NULLCHAR }
};


int
doudp (argc, argv, p)
int argc;
char *argv[];
void *p;
{
	return (subcmd (Udpcmds, argc, argv, p));
}


int
st_udp (udp, n)
struct udp_cb *udp;
int n;
{
	if (n == 0)
		tputs ("&UCB Rcv-Q  Local socket\n");
#ifdef UNIX
	return tprintf ("%8.8lx%6u  %s\n",
#else
	return tprintf ("%4.4x%6u  %s\n",
#endif
		(unsigned long) udp, udp->rcvcnt, pinet (&udp->socket));
}


/* Dump UDP statistics and control blocks */
static int
doudpstat (argc, argv, p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
register struct udp_cb *udp;
register int i;

	for (i = 1; i <= NUMUDPMIB; i++)	{
		tprintf ("(%2u)%-20s%10lu", i, Udp_mib[i].name, Udp_mib[i].value.integer);
		if (i % 2)
			tputs("     ");
		else
			tputc('\n');
	}
	if ((i % 2) == 0)
		tputc('\n');

	tputs ("&UCB Rcv-Q  Local socket\n");
	for (udp = Udps; udp != NULLUDP; udp = udp->next)	{
		if (st_udp (udp, 1) == EOF)
			return 0;
	}
	return 0;
}


#ifdef  UDPACCESS

static int
douaccess (argc, argv, p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return (do_tcpudp_access (argc, argv, &UDPaccess));
}

#endif



