/* Low level socket routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "usock.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: sockutil.c,v 1.15 1997/08/19 01:19:22 root Exp $";
#endif

/* Convert a socket (address + port) to an ascii string of the form
 * aaa.aaa.aaa.aaa:ppppp
 */
char *
psocket(p)
void *p;	/* Pointer to structure to decode */
{
#if	defined(AX25) || defined(NETROM)
	char tmp[11];
#endif
	static char buf[30];
	union sp sp;
	struct socket thesocket;

	sp.p = p;
	switch(sp.sa->sa_family){
	case AF_LOCAL:
		buf[0] = '\0';
		break;
	case AF_INET:
		thesocket.address = sp.in->sin_addr.s_addr;
		thesocket.port = sp.in->sin_port;
		strncpy (buf, pinet(&thesocket), 30);
		break;
#ifdef	AX25
	case AF_AX25:
		(void) pax25(tmp,sp.ax->ax25_addr);
		if(strlen(sp.ax->iface) != 0)
			sprintf(buf,"%s on port %s",tmp,sp.ax->iface);
		else
			strncpy (buf, tmp, 30);
		break;
#endif
#ifdef	NETROM
	case AF_NETROM:
		(void) pax25(tmp,sp.nr->nr_addr.user);
		sprintf(buf,"%s @ ",tmp);
		(void) pax25(tmp,sp.nr->nr_addr.node);
		strcat(buf,tmp);
		break;
#endif
	default:
		break;
	}
	return buf;
}

/* Return ASCII string giving reason for connection closing */
const char *
sockerr(s)
int s;	/* Socket index */
{
	register struct usock *up;

	if((up = itop(s)) == NULLUSOCK){
		errno = EBADF;
		return Badsocket;
	}
	switch(up->type){
#ifdef	AX25
	case TYPE_AX25I:
		if(up->cb.ax25 != NULLAX25)
			return NULLCHAR;	/* nothing wrong */
		return Axreasons[(int)up->errcodes[0]];
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		if(up->cb.nr4 != NULLNR4CB)
			return NULLCHAR;	/* nothing wrong */
		return Nr4reasons[(int)up->errcodes[0]];
#endif
	case TYPE_TCP:
		if(up->cb.tcb != NULLTCB)
			return NULLCHAR;	/* nothing wrong */		
		return Tcpreasons[(int)up->errcodes[0]];
	default:
		errno = EOPNOTSUPP;	/* not yet, anyway */
		return NULLCHAR;
	}
}
/* Get state of protocol. Valid only for connection-oriented sockets. */
const char *
sockstate(s)
int s;		/* Socket index */
{
	register struct usock *up;

	if((up = itop(s)) == NULLUSOCK){
		errno = EBADF;
		return NULLCHAR;
	}
	if(up->cb.p == NULLCHAR){
		errno = ENOTCONN;
		return NULLCHAR;
	}
	switch(up->type){
	case TYPE_TCP:
		return Tcpstates[(int)up->cb.tcb->state];
#ifdef	AX25
	case TYPE_AX25I:
		return Ax25states[up->cb.ax25->state];
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		return Nr4states[up->cb.nr4->state];
#endif
	default:
		/* Datagram sockets don't have state */
		errno = EOPNOTSUPP;
		return NULLCHAR;
	}
	/*NOTREACHED*/
}
/* Convert a socket index to an internal user socket structure pointer */
struct usock *
itop(s)
register int s;	/* Socket index */
{
	register struct usock *up;

	s -= SOCKBASE;
	if(s < 0 || s >= Nusock)
		return NULLUSOCK;

	up = &Usock[s];

	if(up->type == NOTUSED)
		return NULLUSOCK;
	return up;
}

#ifdef MSDOS
void
st_garbage(red)
int red;
{
	int i;
	struct usock *up;

	for(i=SOCKBASE;i<SOCKBASE+Nusock;i++){
		/* FIXED!!! up = &Usock[i]; */
		up = itop(i);
		if(up->type == TYPE_LOCAL_STREAM)
			mbuf_crunch(&up->cb.local->q);
	}
}
#endif


