#ifndef _MAILUTIL_H
#define _MAILUTIL_H

#if !defined(_STDIO_H) && !defined(__dj_include_stdio_h_)
#include <stdio.h>
#endif

/* Header types */
#define	NOHEADER 	-1
#define APPROVED	0
#define	FROM		1
#define	TO		2
#define	DATE		3
#define	MSGID		4
#define	SUBJECT		5
#define	RECEIVED	6
#define	SENDER		7
#define	REPLYTO		8
#define STATUS		9
#define BBSTYPE		10
#define XFORWARD	11
#define CC		12
#define RRECEIPT	13
#define APPARTO		14
#define ERRORSTO	15
#define ORGANIZATION    16
#define NEWSGROUPS	17
#define PATH		18
#define XBBSHOLD	19
#define XMAILGROUP	20
#define MSGTYPE		21
#define XBID		22
#define DISTRIBUTION    23
#define POSTHOST        24
#define LINECNT         25
#define REFERENCES      26
#define DATERXD         27
#define XMSGID          28
#define XNNTPGATE	    29
#define XBBSTO          30
#define XNNTPNEWSGROUPS 31
#define UNKNOWN         32

extern const char *Hdrs[];

#define MAXREWRITERECURSION	10

int recvmail (int s, char *buf, unsigned len, FILE *fp, int trace);
int copymail (char *buf, unsigned len, FILE *fp, char* mail_to);

#ifndef _SMTP_H
int mlock (const char *thedir,char *id);
void rmlock (const char *thedir,char *id);
char *getname (char *cp);
#endif

char *getaddress (char *string,int cont);
int htype (char *s);
#ifndef _MAILBOX_H
char *rewrite_address (const char *addr, int recursionlevel);
#endif

#if (defined (NNTPSERV)) || (defined (UKIP))
int look_for_t_line (char *buf, int bufsize, FILE *data, const char *type);
#endif

#endif  /* _MAILUTIL_H */
