#if !defined(_DELEGATE_H) && defined(DELEGATE)
#define _DELEGATE_H

#ifndef _HARDWARE_H
#include "hardware.h"
#endif

struct delegate {
	int 	hold;		/* are we holding a copy */
	int	notify;		/* are we to notify the sender */
	char	*forward;	/* user we are to forward a copy to */
	time_t	start;		/* date the delegation starts */
	time_t	date;		/* date the delegation ends */
	long	index;		/* position in file that the message data starts */
};


int delegate (FILE *fp, const char *from, const char *to);
void setup_delegate (struct mbx *m);
void clear_delegate (struct mbx *m);
void display_delegation (char *to);
void purge_delegate (void);

#endif /* _DELEGATE_H */
