head	1.8;
access;
symbols;
locks;
comment	@ * @;


1.8
date	92.09.14.09.02.17;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.06.21.08.41.49;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.29.23.19.24;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.28.12.32.48;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.05.14.09.51.22;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.05.04.08.51.22;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	92.04.20.13.20.06;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.33.30;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.8
log
@Redo ttydriv to work with a statically allocated buffer, and to
work correctly even when null characters are typed (it was
annoying to not be able to set a mark in gnumacs). Also clean
up some variables.
@
text
@/* TTY input line editing
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include <conio.h>
#include "global.h"
#include "mbuf.h"
#include "session.h"
#include "tty.h"
#include "socket.h"

#define	OFF	0
#define	ON	1

#define	LINESIZE	256

/* Accept characters from the incoming tty buffer and process them
 * (if in cooked mode) or just pass them directly (if in raw mode).
 *
 * Echoing (if enabled) is direct to the raw terminal. This requires
 * recording (if enabled) of locally typed info to be done by the session
 * itself so that edited output instead of raw input is recorded.
 *
 * Returns the number of cooked characters ready to be read from the buffer.
 */
int
ttydriv(sp,c)
struct session *sp;
char c;
{
	int rval;
	register struct ttystate *ttyp = &sp->ttystate;

	if(ttyp->line == NULLCHAR){
		/* First-time initialization */
		ttyp->lp = ttyp->line = calloc(1,LINESIZE);
	}
	switch(ttyp->edit){
	case OFF:
		/* Editing is off; add character to buffer
		 * and return the number of characters in it (probably 1)
		 */
		*ttyp->lp++ = c;
		if(ttyp->echo)
			fputc(c,Current->output);
		rval = ttyp->lp - ttyp->line;
		ttyp->lp = ttyp->line;
		return rval;
	case ON:
		/* Perform cooked-mode line editing */
		switch(uchar(c)){
		case '\r':	/* CR and LF both terminate the line */
		case '\n':
			if(ttyp->crnl)
				*ttyp->lp++ = '\n';
			else
				*ttyp->lp++ = c;
			if(ttyp->echo)
				putc('\n',Current->output);
			rval = ttyp->lp - ttyp->line;
			ttyp->lp = ttyp->line;
			return rval;
		case DEL:
		case '\b':	/* Character delete */
			if(ttyp->lp != ttyp->line){
				ttyp->lp--;
				if(ttyp->echo)
					fputs("\b \b",Current->output);
			}
			break;
		case CTLR:	/* print line buffer */
			if(ttyp->echo){
				fprintf(Current->output,"^R\n");
				fwrite(ttyp->line,1,ttyp->lp-ttyp->line,
				 Current->output);
			}
			break;
		case CTLU:	/* Line kill */
			while(ttyp->echo && ttyp->lp-- != ttyp->line){
				fputs("\b \b",Current->output);
			}
			ttyp->lp = ttyp->line;
			break;
		default:	/* Ordinary character */
			*ttyp->lp++ = c;

			/* ^Z apparently hangs the terminal emulators under
			 * DoubleDos and Desqview. I REALLY HATE having to patch
			 * around other people's bugs like this!!!
			 */
			if(ttyp->echo &&
#ifndef	AMIGA
			 c != CTLZ &&
#endif
			 ttyp->lp - ttyp->line < LINESIZE-1){
				putc(c,Current->output);

			} else if(ttyp->lp - ttyp->line >= LINESIZE-1){
				putc('\007',Current->output);	/* Beep */
				ttyp->lp--;
			}
			break;
		}
		break;
	}
	return 0;
}
@


1.7
log
@Remove control char defs, parity stripping
@
text
@d23 2
d26 1
a26 1
char *
d31 2
a32 1
	char *cp,*rp;
d34 5
a38 1
	switch(sp->ttystate.edit){
d40 5
a44 4
		rp = cp = mallocw(2);
		*cp++ = c;
		*cp = '\0';
		if(sp->ttystate.echo)
d46 3
a48 1
		return rp;
a49 5
		if(sp->ttystate.line == NULLCHAR)
			sp->ttystate.lp = sp->ttystate.line = calloc(1,LINESIZE);

		cp = sp->ttystate.lp;
		rp = sp->ttystate.line;
d54 2
a55 2
			if(sp->ttystate.crnl)
				*cp++ = '\n';
d57 2
a58 3
				*cp++ = c;
			*cp++ = '\0';
			if(sp->ttystate.echo)
d60 3
a62 3

			sp->ttystate.line = NULLCHAR;
			return rp;
d65 3
a67 3
			if(sp->ttystate.lp != rp){
				sp->ttystate.lp--;
				if(sp->ttystate.echo)
d72 1
a72 1
			if(sp->ttystate.echo){
d74 2
a75 1
				fwrite(rp,1,cp-rp,Current->output);
d79 2
a80 5
			while(sp->ttystate.lp != rp){
				sp->ttystate.lp--;
				if(sp->ttystate.echo){
					fputs("\b \b",Current->output);
				}
d82 1
d85 1
a85 1
			*cp++ = c;
d91 1
a91 1
			if(sp->ttystate.echo &&
d95 1
a95 1
			 cp - rp < LINESIZE-1){
d98 1
a98 1
			} else if(cp - rp >= LINESIZE-1){
d100 1
a100 1
				cp--;
a101 1
			sp->ttystate.lp = cp;
d106 1
a106 1
	return NULLCHAR;
@


1.6
log
@s920529
@
text
@a16 5
#define	CTLU	21
#define CTLR	18
#define	CTLZ	26
#define	DEL	0x7f

d46 1
a46 1
		switch(c & 0x7f){
@


1.5
log
@s920528
@
text
@d45 1
a45 1
		if(sp->ttystate.line == NULLCHAR){
d47 1
a47 1
		}
d58 1
d60 1
a60 1
				fputs(Eol,Current->output);
d74 2
a75 3
				fprintf(Current->output,"^R%s",Eol) ;
				while (rp < cp)
					putc(*rp++,Current->output);
@


1.4
log
@src0514
@
text
@d73 1
a73 1
				fprintf(stdout,"^R%s",Eol) ;
@


1.3
log
@src0505
@
text
@d29 1
a29 1
struct mbuf *
a33 1
	struct mbuf *bp;
d38 3
a40 3
		bp = ambufw(1);
		*bp->data = c;
		bp->cnt = 1;
d43 1
a43 1
		return bp;
d45 5
a49 5
		if(sp->ttystate.line == NULLBUF)
			sp->ttystate.line = ambufw(LINESIZE);

		bp = sp->ttystate.line;
		cp = bp->data + bp->cnt;
d55 1
a55 1
				*cp = '\n';
d57 1
a57 1
				*cp = c;
d61 2
a62 3
			bp->cnt += 1;
			sp->ttystate.line = NULLBUF;
			return bp;
d65 2
a66 2
			if(bp->cnt != 0){
				bp->cnt--;
a73 1
				rp = bp->data;
d77 1
a77 1
			break ;
d79 2
a80 2
			while(bp->cnt != 0){
				bp->cnt--;
d87 1
a87 2
			*cp = c;
			bp->cnt++;
d97 1
a97 1
			 bp->cnt < LINESIZE-1){
d100 1
a100 1
			} else if(bp->cnt >= LINESIZE-1){
d102 1
a102 1
				bp->cnt--;
d104 1
d109 1
a109 1
	return NULLBUF;
@


1.2
log
@s920423
@
text
@a11 4
#ifndef	directio
extern FILE *Rawterm;
#endif

d43 1
a43 6
#ifndef	directio
			putc(c,Rawterm);
#else
			putch(c);
#endif

d60 1
a60 5
#ifndef	directio
				fputs(Eol,Rawterm);
#else
				cputs(Eol);
#endif
d70 1
a70 5
#ifndef	directio
					fputs("\b \b",Rawterm);
#else
					cputs("\b \b");
#endif
d75 1
a75 6
#ifndef	directio
				fprintf(Rawterm,"^R%s",Eol) ;
#else
				cputs("^R");
				cputs(Eol);
#endif
d78 1
a78 5
#ifndef	directio
					putc(*rp++,Rawterm) ;
#else
					putch(*rp++);
#endif
d85 1
a85 5
#ifndef	directio
					fputs("\b \b",Rawterm);
#else
					cputs("\b \b");
#endif
d102 1
a102 5
#ifndef	directio
				putc(c,Rawterm);
#else
				putch(c);
#endif
d105 1
a105 5
#ifndef	directio
				putc('\007',Rawterm);	/* Beep */
#else
				putch('\007');
#endif
@


1.1
log
@Initial revision
@
text
@d5 1
d12 1
d14 1
d47 1
d49 3
d69 1
d71 3
d83 1
d85 3
d92 1
d94 4
d100 1
d102 3
d111 1
d113 3
d132 1
d134 3
d139 1
d141 3
@
