head	1.15;
access;
symbols;
locks;
comment	@ * @;


1.15
date	93.05.06.10.11.31;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	93.03.15.05.08.28;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	93.01.02.08.23.00;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.06.21.08.43.12;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.06.13.05.17.46;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.15.10.03.02;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.13.02.28.28;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.03.12.45.48;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.01.11.16.32;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.10.10.31.10;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.01.15.34.24;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.03.29.03.32.42;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.06.01.05.03.14;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.32.18;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.15
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* "Dumb terminal" session command for serial lines
 * Copyright 1991 Phil Karn, KA9Q
 *
 *	Feb '91	Bill Simpson
 *		rlsd control and improved dialer
 */
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "iface.h"
#ifndef	UNIX
#include "n8250.h"
#endif
#include "asy.h"
#include "tty.h"
#include "session.h"
#include "socket.h"
#include "commands.h"
#include "devparam.h"


static void tip_out(int i,void *n1,void *n2);


/* Execute user telnet command */
int
dotip(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	char *ifn;
	int c;
	FILE *asy;

	if((asy = asyopen(argv[1],"r+b")) == NULLFILE){
		printf("Can't open %s\n",argv[1]);
		return 1;
	}
	setvbuf(asy,NULLBUF,_IONBF,0);
	/* Allocate a session descriptor */
	if((sp = newsession(Cmdline,TIP,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return 1;
	}
	/* Put tty into raw mode */
	sp->ttystate.echo = 0;
	sp->ttystate.edit = 0;
	fmode(stdin,STREAM_BINARY);
	fmode(stdout,STREAM_BINARY);

	/* Now fork into two paths, one rx, one tx */
	ifn = malloc(strlen(argv[1]) + 10);
	sprintf(ifn,"%s tip out",argv[1]);
	sp->proc1 = newproc(ifn,256,tip_out,0,asy,NULL,0);
	free( ifn );

	ifn = malloc(strlen(argv[1]) + 10);
	sprintf(ifn,"%s tip in",argv[1]);
	chname( Curproc, ifn );
	free( ifn );

	while((c = fgetc(asy)) != EOF){
		putchar(c);
		if(sp->record != NULLFILE)
			putc(c,sp->record);
	}
	fflush(stdout);

	killproc(sp->proc1);
	sp->proc1 = NULLPROC;
	fclose(asy);
	keywait(NULLCHAR,1);
	freesession(sp);
	return 0;
}


/* Output process, DTE version */
static void
tip_out(i,n1,n2)
int i;
void *n1,*n2;
{
	int c;
	FILE *asy = (FILE *)n1;

	while((c = getchar()) != EOF){
		fputc(c,asy);
	}
}


@


1.14
log
@Change tip command to use new stdio asynch facilities
@
text
@d22 1
a22 1
static void tip_out __ARGS((int i,void *n1,void *n2));
@


1.13
log
@Call newsession with Cmdline
@
text
@d22 1
a22 1
static void tip_out __ARGS((int dev,void *n1,void *n2));
a32 1
	register struct iface *ifp;
a33 1
	int (*rawsave) __ARGS((struct iface *,struct mbuf *));
d35 1
d37 2
a38 2
	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
d41 1
a41 9
	if( ifp->dev >= ASY_MAX || Asy[ifp->dev].iface != ifp ){
		printf("Interface %s not asy port\n",argv[1]);
		return 1;
	}
	if(ifp->raw == bitbucket){
		printf("tip or dialer session already active on %s\n",argv[1]);
		return 1;
	}

a46 9
	/* Save output handler and temporarily redirect output to null */
	rawsave = ifp->raw;
	ifp->raw = bitbucket;

	/* Suspend the packet input driver. Note that the transmit driver
	 * is left running since we use it to send buffers to the line.
	 */
	suspend(ifp->rxproc);

d54 3
a56 2
	ifn = if_name( ifp, " tip out" );
	sp->proc1 = newproc(ifn,256,tip_out,ifp->dev,NULL,NULL,0);
d59 2
a60 1
	ifn = if_name( ifp, " tip in" );
d64 1
a64 5
	/* bring the line up (just in case) */
	if ( ifp->ioctl != NULL )
		(*ifp->ioctl)( ifp, PARAM_UP, TRUE, 0L );

	while((c = get_asy(ifp->dev)) != -1){
d73 1
a73 2
	ifp->raw = rawsave;
	resume(ifp->rxproc);
d82 2
a83 2
tip_out(dev,n1,n2)
int dev;
d87 1
a87 1
	char c1;
d90 1
a90 3
		c1 = c;
		asy_write(dev,&c1,1);
		Asy[dev].iface->lastsent = secclock();
@


1.12
log
@Remove parity stripping
@
text
@d52 1
a52 1
	if((sp = newsession(argv[1],TIP,1)) == NULLSESSION){
@


1.11
log
@s920612
@
text
@d85 1
a85 1
		putchar(c & 0x7f);
@


1.10
log
@src0515
@
text
@d84 1
a84 1
	while((c = get_asy(ifp->dev)) != -1)
d86 3
@


1.9
log
@src0514
@
text
@d12 1
a12 1
#include "8250.h"
@


1.8
log
@src0503
@
text
@a55 1
	Current->flowmode = 0;
@


1.7
log
@src0501
@
text
@d69 1
d108 1
a108 3
	while((c = getc(Curproc->input)) != EOF){
		if(c == '\n')
			c = '\r';		/* NL => CR */
@


1.6
log
@src0410
@
text
@d39 1
a39 1
		tprintf("Interface %s unknown\n",argv[1]);
d43 1
a43 1
		tprintf("Interface %s not asy port\n",argv[1]);
d47 1
a47 1
		tprintf("tip or dialer session already active on %s\n",argv[1]);
d53 1
a53 1
		tprintf("Too many sessions\n");
d69 1
a69 1
	sockmode(sp->output,SOCK_BINARY);
d85 2
a86 2
		tputc(c & 0x7f);
	tflush();
d107 1
a107 1
	while((c = recvchar(Curproc->input)) != EOF){
@


1.5
log
@src0401
@
text
@d56 1
a56 1

@


1.4
log
@src0331
@
text
@a103 1
	struct mbuf *bp;
d105 1
d110 2
a111 3
		bp = pushdown(NULLBUF,1);
		bp->data[0] = c;
		asy_send(dev,bp);
@


1.3
log
@src0609
@
text
@d52 1
a52 1
	if((sp = newsession(argv[1],TIP)) == NULLSESSION){
@


1.2
log
@src0318
@
text
@a6 1
#include <stdlib.h>
a7 1
#include "config.h"
a17 1
#include "usock.h"
a20 18
#ifdef	MAILBOX
#include "telnet.h"
#include "timer.h"
#include "mailbox.h"
static struct tipcb {
	struct tipcb *next;
	struct proc *proc;
	struct proc *in;
	struct iface *iface;
	int (*rawsave) __ARGS((struct iface *,struct mbuf *));
	int s;
	int echo;
	struct timer timer;
} *Tiplist;
#define	NULLTIP	(struct tipcb *)0
static void tip_in __ARGS((int dev,void *n1,void *n2));
static void tipidle __ARGS((void *t));
#endif
a117 233
#ifdef	MAILBOX
/* Input process */
static void
tip_in(dev,n1,n2)
int dev;
void *n1,*n2;
{
	struct tipcb *tip;
	struct mbuf *bp;
	char *buf[2], line[MBXLINE];
	int c, ret, pos = 0;

	tip = (struct tipcb *) n1;
	while((c = get_asy(dev)) != -1){
		Asy[dev].iface->lastrecv = secclock();
		c &= 0x7f;
		ret = 0;
		if(tip->echo == WONT){
			switch(c){
			case 18:	/* CTRL-R */
				bp = pushdown(qdata(line,pos),4);
				memcpy(bp->data,"^R\r\n",4);
				ret = 1;
				break;
			case 0x7f:	/* DEL */
			case '\b':
				bp = NULLBUF;
				if(pos){
					--pos;
					bp = qdata("\b \b",3);
				}
				ret = 1;
				break;
			case '\r':
				c = '\n';	/* CR => NL */
			case '\n':
				bp = qdata("\r\n",2);
				break;
			default:
				bp = pushdown(NULLBUF,1);
				*bp->data = c;
				break;
			}
			asy_send(dev,bp);
			tip->iface->lastsent = secclock();
			if(ret)
				continue;
		}
		line[pos++] = c;
		if(pos == MBXLINE - 1 || tip->echo == WILL
		  || c == '\n'){
			line[pos] = '\0';
			pos = 0;
			usputs(tip->s,line);
			usflush(tip->s);
		}
	}
	/* get_asy() failed, terminate */
	close_s(tip->s);
	tip->in = tip->proc;
	tip->proc = Curproc;
	buf[1] = Asy[dev].iface->name;
	tip0(2,buf,NULL);
}
/* Start mailbox on serial line */
int
tipstart(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp;
	register struct asy *ap;
	struct tipcb *tip;
	struct mbuf *bp;
	char *buf[2];
	int dev, c, cmd, s[2], type = TIP;

	if((ifp = if_lookup(argv[1])) == NULLIF){
		tprintf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	for(dev=0,ap = Asy;dev < ASY_MAX;dev++,ap++)
		if(ap->iface == ifp)
			break;
	if(dev == ASY_MAX){
		tprintf("Interface %s not asy port\n",argv[1]);
		return 1;
	}
	if(ifp->raw == bitbucket){
		tprintf("Tip session already active on %s\n",argv[1]);
		return 1;
	}
	psignal(Curproc,0);	/* Don't keep the parser waiting */
	chname(Curproc,"Mbox tip");
	tip = (struct tipcb *) callocw(1,sizeof(struct tipcb));
	/* Save output handler and temporarily redirect output to null */
	tip->rawsave = ifp->raw;
	ifp->raw = bitbucket;
	tip->iface = ifp;
	tip->proc = Curproc;
	tip->timer.func = tipidle;
	tip->timer.arg = (void *) tip;
	tip->next = Tiplist;
	Tiplist = tip;
	buf[1] = ifp->name;

	/* Suspend packet input drivers */
	suspend(ifp->rxproc);

	for(;;) {
		if(ap->rlsd_line_control)
			/* Wait for DCD to be asserted */
			get_rlsd_asy(dev,RLSD_UP);

		if(socketpair(AF_LOCAL,SOCK_STREAM,0,s) == -1){
			tprintf("Could not create socket pair, errno %d\n",errno);
			tip0(2,buf,p);
			return 1;
		}
		seteol(s[0],"\n");
		seteol(s[1],"\n");
		tip->echo = WONT;
		tip->s = s[0];
		newproc("mbx_incom",2048,mbx_incom,s[1],(void *)type,NULL,0);
		set_timer(&tip->timer,Tiptimeout*1000);
		start_timer(&tip->timer);
		setflush(tip->s,-1);
		sockmode(tip->s,SOCK_ASCII);

		/* Now fork into two paths, one rx, one tx */
		tip->in = newproc("Mbox tip in",
				256,tip_in,dev,(void *)tip,NULL,0);
		while((c = recvchar(tip->s)) != -1) {
			if(c == IAC){	/* ignore most telnet options */
				if((cmd = recvchar(tip->s)) == -1)
					break;
				if(cmd > 250 && cmd < 255) {
					if((c = recvchar(tip->s)) == -1)
						break;
					switch(cmd){
					case WILL:
						if(c == TN_ECHO) {
							tip->echo = cmd;
							cmd = DO;
						}
						else
							cmd = DONT;
						break;
					case WONT:
						if(c == TN_ECHO)
							tip->echo = cmd;
						cmd = DONT;
						break;
					case DO:
					case DONT:
						cmd = WONT;
						break;
					}
					usprintf(tip->s,"%c%c%c",IAC,cmd,c);
					usflush(tip->s);
				}
				continue;
			}
			if(c == '\n')
				bp = qdata("\r\n",2);
			else {
				bp = pushdown(NULLBUF,1);
				*bp->data = c;
			}
			asy_send(dev,bp);
			ifp->lastsent = secclock();
		}
		close_s(tip->s);
		killproc(tip->in);
		tip->in = NULLPROC;
		pwait(itop(s[1])); /* let mailbox terminate, if necessary */
		stop_timer(&tip->timer);
		if(ap->rlsd_line_control)
			/* Wait for DCD to be dropped */
			get_rlsd_asy(dev,RLSD_DOWN);
	}
}
int
tip0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp;
	struct tipcb *tip, *prev = NULLTIP;
	struct proc *proc;

	if((ifp = if_lookup(argv[1])) == NULLIF){
		tprintf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	for(tip = Tiplist; tip != NULLTIP; prev = tip, tip = tip->next)
		if(tip->iface == ifp) {
			if(prev != NULLTIP)
				prev->next = tip->next;
			else
				Tiplist = tip->next;
			proc = tip->proc;
			close_s(tip->s);
			ifp->raw = tip->rawsave;
			resume(ifp->rxproc);
			stop_timer(&tip->timer);
			killproc(tip->in);
			free((char *)tip);
			killproc(proc);
			return 0;
		}
	return 0;
}
static void
tipidle(t)
void *t;
{
	struct tipcb *tip;
	static char *msg = "You have been idle too long. Please hang up.\r\n";
	tip = (struct tipcb *) t;
	if(secclock() - tip->iface->lastrecv < Tiptimeout){
		set_timer(&tip->timer,(Tiptimeout-secclock() *
		 tip->iface->lastrecv)*1000);
		start_timer(&tip->timer);
		return;
	}
	asy_send(tip->iface->dev,qdata(msg,strlen(msg)));
	tip->iface->lastsent = secclock();
	close_s(tip->s);
}
#endif
@


1.1
log
@Initial revision
@
text
@d3 3
d7 1
a7 1
#include <stdio.h>
d9 1
d11 1
d17 1
a18 2
#include "proc.h"
#include "tty.h"
d20 1
d22 1
a22 1
#include "config.h"
d42 1
d55 1
a55 1
	register struct asy *ap;
a56 1
	int dev;
d58 1
a58 1
	
d63 1
a63 4
	for(dev=0,ap = Asy;dev < ASY_MAX;dev++,ap++)
		if(ap->iface == ifp)
			break;
	if(dev == ASY_MAX){
d67 1
a67 1
	if(ifp->raw == dumppkt){
d71 1
d77 1
d80 1
a80 1
	ifp->raw = dumppkt;
d82 3
a84 1
	/* Suspend packet input drivers */
d93 12
a104 1
	sp->proc1 = newproc("tip_out",256,tip_out,dev,NULL,NULL,0);
d107 1
d115 1
a115 1
	return 1;
d117 2
d138 1
d216 1
a216 1
	
d228 1
a228 1
	if(ifp->raw == dumppkt){
d237 1
a237 1
	ifp->raw = dumppkt;
d251 3
a253 1
			get_rlsd_asy(dev,100);/* Wait for DCD to be asserted */
d270 2
a271 2
		tip->in = newproc("Mbox tip in",256,tip_in,dev,(void *)tip,
				    NULL,0);
d319 1
a319 1
			get_rlsd_asy(dev,1);
d331 1
a331 1
	
@
