head	1.10;
access;
symbols;
locks;
comment	@ * @;


1.10
date	93.05.06.10.11.22;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	93.04.27.23.21.32;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	93.03.15.22.10.13;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	93.01.26.20.21.08;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.09.14.09.05.51;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.21.11.42.36;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.05.11.04.19.24;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.05.03.01.46.18;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	92.04.11.08.54.24;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	92.04.09.09.15.26;	author karn;	state Exp;
branches;
next	;


desc
@src0410
@


1.10
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@#include "global.h"
#include "tcp.h"
#include "socket.h"
#include "usock.h"

static void s_trcall(struct tcb *tcb,int32 cnt);
static void s_tscall(struct tcb *tcb,int old,int new);
static void s_ttcall(struct tcb *tcb,int32 cnt);
static void trdiscard(struct tcb *tcb,int32 cnt);
static void autobind(struct usock *up);

uint16 Lport = 1024;

int
so_tcp(up,protocol)
struct usock *up;
int protocol;
{
	up->type = TYPE_TCP;
	return 0;
}
int
so_tcp_listen(up,backlog)
struct usock *up;
int backlog;
{
	struct sockaddr_in *local;
	struct socket lsock;

	if(up->name == NULLCHAR)
		autobind(up);

	local = (struct sockaddr_in *)up->name;
	lsock.address = local->sin_addr.s_addr;
	lsock.port = local->sin_port;
	up->cb.tcb = open_tcp(&lsock,NULLSOCK,
	 backlog ? TCP_SERVER:TCP_PASSIVE,0,
	s_trcall,s_ttcall,s_tscall,up->tos,up->index);
	return 0;
}
int
so_tcp_conn(up)
struct usock *up;
{
	int s;
	struct tcb *tcb;
	struct socket lsock,fsock;
	struct sockaddr_in *local,*remote;

	if(up->name == NULLCHAR){
		autobind(up);
	}
	
	if(checkipaddr(up->peername,up->peernamelen) == -1){
		errno = EAFNOSUPPORT;
		return -1;
	}
	s = up->index;
	/* Construct the TCP-style ports from the sockaddr structs */
	local = (struct sockaddr_in *)up->name;
	remote = (struct sockaddr_in *)up->peername;

	if(local->sin_addr.s_addr == INADDR_ANY)
		/* Choose a local address */
		local->sin_addr.s_addr = locaddr(remote->sin_addr.s_addr);

	lsock.address = local->sin_addr.s_addr;
	lsock.port = local->sin_port;
	fsock.address = remote->sin_addr.s_addr;
	fsock.port = remote->sin_port;

	/* Open the TCB in active mode */
	up->cb.tcb = open_tcp(&lsock,&fsock,TCP_ACTIVE,0,
	 s_trcall,s_ttcall,s_tscall,up->tos,s);

	/* Wait for the connection to complete */
	while((tcb = up->cb.tcb) != NULLTCB && tcb->state != TCP_ESTABLISHED){
		if(up->noblock){
			errno = EWOULDBLOCK;
			return -1;
		} else if((errno = pwait(up)) != 0){
			return -1;
		}
	}
	if(tcb == NULLTCB){
		/* Probably got refused */
		free(up->peername);
		up->peername = NULLCHAR;
		errno = ECONNREFUSED;
		return -1;
	}
	return 0;
}
int
so_tcp_recv(up,bpp,from,fromlen)
struct usock *up;
struct mbuf **bpp;
char *from;
int *fromlen;
{
	long cnt;
	struct tcb *tcb;

	while((tcb = up->cb.tcb) != NULLTCB && tcb->r_upcall != trdiscard
	 && (cnt = recv_tcp(tcb,bpp,0)) == -1){
		if(up->noblock){
			errno = EWOULDBLOCK;
			return -1;
		} else if((errno = pwait(up)) != 0){
			return -1;
		}
	}
	if(tcb == NULLTCB){
		/* Connection went away */
		errno = ENOTCONN;
		return -1;
	} else if(tcb->r_upcall == trdiscard){
		/* Receive shutdown has been done */
		errno = ENOTCONN;	/* CHANGE */
		return -1;
	}
	return cnt;
}
int
so_tcp_send(up,bp,to)
struct usock *up;
struct mbuf *bp;
char *to;
{
	struct tcb *tcb;
	long cnt;

	if((tcb = up->cb.tcb) == NULLTCB){
		free_p(bp);
		errno = ENOTCONN;
		return -1;
	}		
	cnt = send_tcp(tcb,bp);

	while((tcb = up->cb.tcb) != NULLTCB &&
	 tcb->sndcnt > tcb->window){
		/* Send queue is full */
		if(up->noblock){
			errno = EWOULDBLOCK;
			return -1;
		} else if((errno = pwait(up)) != 0){
			return -1;
		}
	}
	if(tcb == NULLTCB){
		errno = ENOTCONN;
		return -1;
	}
	return cnt;
}
int
so_tcp_qlen(up,rtx)
struct usock *up;
int rtx;
{
	int len;

	switch(rtx){
	case 0:
		len = up->cb.tcb->rcvcnt;
		break;
	case 1:
		len = up->cb.tcb->sndcnt;
		break;
	}
	return len;
}
int
so_tcp_kick(up)
struct usock *up;
{
	kick_tcp(up->cb.tcb);
	return 0;
}
int
so_tcp_shut(up,how)
struct usock *up;
int how;
{
	switch(how){
	case 0:	/* No more receives -- replace upcall */
		up->cb.tcb->r_upcall = trdiscard;
		break;
	case 1:	/* Send EOF */
		close_tcp(up->cb.tcb);
		break;
	case 2:	/* Blow away TCB */
		reset_tcp(up->cb.tcb);
		up->cb.tcb = NULLTCB;
		break;
	}
	return 0;
}
int
so_tcp_close(up)
struct usock *up;
{
	if(up->cb.tcb != NULLTCB){	/* In case it's been reset */
		up->cb.tcb->r_upcall = trdiscard;
		/* Tell the TCP_CLOSED upcall there's no more socket */
		up->cb.tcb->user = -1;
		close_tcp(up->cb.tcb);
	}
	return 0;
}
/* TCP receive upcall routine */
static void
s_trcall(tcb,cnt)
struct tcb *tcb;
int32 cnt;
{
	/* Wake up anybody waiting for data, and let them run */
	psignal(itop(tcb->user),1);
	pwait(NULL);
}
/* TCP transmit upcall routine */
static void
s_ttcall(tcb,cnt)
struct tcb *tcb;
int32 cnt;
{
	/* Wake up anybody waiting to send data, and let them run */
	psignal(itop(tcb->user),1);
	pwait(NULL);
}
/* TCP state change upcall routine */
static void
s_tscall(tcb,old,new)
struct tcb *tcb;
int old,new;
{
	int s,ns;
	struct usock *up,*nup,*oup;
	union sp sp;

	s = tcb->user;
	oup = up = itop(s);

	switch(new){
	case TCP_CLOSED:
		/* Clean up. If the user has already closed the socket,
		 * then up will be null (s was set to -1 by the close routine).
		 * If not, then this is an abnormal close (e.g., a reset)
		 * and clearing out the pointer in the socket structure will
		 * prevent any further operations on what will be a freed
		 * control block. Also wake up anybody waiting on events
		 * related to this tcb so they will notice it disappearing.
		 */
		if(up != NULLUSOCK){
			up->cb.tcb = NULLTCB;
			up->errcodes[0] = tcb->reason;
			up->errcodes[1] = tcb->type;
			up->errcodes[2] = tcb->code;
			psignal(up,0); /* Wake up anybody waiting */
		}
		del_tcp(tcb);
		break;
	case TCP_SYN_RECEIVED:
		/* Handle an incoming connection. If this is a server TCB,
		 * then we're being handed a "clone" TCB and we need to
		 * create a new socket structure for it. In either case,
		 * find out who we're talking to and wake up the guy waiting
		 * for the connection.
		 */
		if(tcb->flags.clone){
			/* Clone the socket */
			ns = socket(AF_INET,SOCK_STREAM,0);
			nup = itop(ns);
			ASSIGN(*nup,*up);
			tcb->user = ns;
			nup->cb.tcb = tcb;
			/* Allocate new memory for the name areas */
			nup->name = mallocw(SOCKSIZE);
			nup->peername = mallocw(SOCKSIZE);
			nup->index = ns;
			/* Store the new socket # in the old one */
			up->rdysock = ns;
			up = nup;
			s = ns;
		} else {
			/* Allocate space for the peer's name */
			up->peername = mallocw(SOCKSIZE);
			/* Store the old socket # in the old socket */
			up->rdysock = s;
		}
		/* Load the addresses. Memory for the name has already
		 * been allocated, either above or in the original bind.
		 */
		sp.p = up->name;
		sp.in->sin_family = AF_INET;
		sp.in->sin_addr.s_addr = up->cb.tcb->conn.local.address;
		sp.in->sin_port = up->cb.tcb->conn.local.port;
		up->namelen = SOCKSIZE;

		sp.p = up->peername;
		sp.in->sin_family = AF_INET;
		sp.in->sin_addr.s_addr = up->cb.tcb->conn.remote.address;
		sp.in->sin_port = up->cb.tcb->conn.remote.port;
		up->peernamelen = SOCKSIZE;

		/* Wake up the guy accepting it, and let him run */
		psignal(oup,1);
		pwait(NULL);
		break;
	default:	/* Ignore all other state transitions */
		break;
	}
	psignal(up,0);	/* In case anybody's waiting */
}
/* Discard data received on a TCP connection. Used after a receive shutdown or
 * close_s until the TCB disappears.
 */
static void
trdiscard(tcb,cnt)
struct tcb *tcb;
int32 cnt;
{
	struct mbuf *bp;

	recv_tcp(tcb,&bp,cnt);
	free_p(bp);
}

/* Issue an automatic bind of a local address */
static void
autobind(up)
struct usock *up;
{
	struct sockaddr_in local;

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = INADDR_ANY;
	local.sin_port = Lport++;
	bind(up->index,(char *)&local,sizeof(struct sockaddr_in));
}
char *
tcpstate(up)
struct usock *up;
{
	if(up->cb.tcb == NULLTCB)
		return NULLCHAR;
	return Tcpstates[up->cb.tcb->state];
}
int
so_tcp_stat(up)
struct usock *up;
{
	st_tcp(up->cb.tcb);
	return 0;
}

struct inet {
	struct inet *next;
	struct tcb *tcb;
	char *name;
	int stack;
	void (*task)(int,void *,void *);
};
#define	NULLINET	(struct inet *)0
struct inet *Inet_list;

static void i_upcall(struct tcb *tcb,int oldstate,int newstate);


/* Start a TCP server. Create TCB in listen state and post upcall for
 * when a connection comes in
 */ 
int
start_tcp(port,name,task,stack)
uint16 port;
char *name;
void (*task)(int,void *,void *);
int stack;
{
	struct inet *in;
	struct socket lsocket;

	in = (struct inet *)calloc(1,sizeof(struct inet));
	lsocket.address = INADDR_ANY;
	lsocket.port = port;
	in->tcb = open_tcp(&lsocket,NULLSOCK,TCP_SERVER,0,NULLVFP,NULLVFP,i_upcall,0,-1);
	if(in->tcb == NULLTCB){
		free(in);
		return -1;
	}
	in->stack = stack;
	in->task = task;
	in->name = strdup(name);
	in->next = Inet_list;
	Inet_list = in;
	return 0;
}

/* State change upcall that takes incoming TCP connections */
static void
i_upcall(tcb,oldstate,newstate)
struct tcb *tcb;
int oldstate;
int newstate;
{
	struct inet *in;
	struct sockaddr_in sock;
	struct usock *up;
	int s;

	if(oldstate != TCP_LISTEN)
		return;	/* "can't happen" */
	if(newstate == TCP_CLOSED){
		/* Called when server is shut down */
		del_tcp(tcb);
		return;
	}
	for(in = Inet_list;in != NULLINET;in = in->next)
		if(in->tcb->conn.local.port == tcb->conn.local.port)
			break;
	if(in == NULLINET)
		return;	/* not in table - "can't happen" */

	/* Create a socket, hook it up with the TCB */
	s = socket(AF_INET,SOCK_STREAM,0);
	up = itop(s);
	sock.sin_family = AF_INET;
	sock.sin_addr.s_addr = tcb->conn.local.address;
	sock.sin_port = tcb->conn.local.port;
	bind(s,(char *)&sock,SOCKSIZE);

	sock.sin_addr.s_addr = tcb->conn.remote.address;
	sock.sin_port = tcb->conn.remote.port;
	up->peernamelen = SOCKSIZE;
	up->peername = mallocw(up->peernamelen);
	memcpy(up->peername,(char *)&sock,SOCKSIZE);
	up->cb.tcb = tcb;
	tcb->user = s;

	/* Set the normal upcalls */
	tcb->r_upcall = s_trcall;
	tcb->t_upcall = s_ttcall;
	tcb->s_upcall = s_tscall;

	/* And spawn the server task */
	newproc(in->name,in->stack,in->task,s,NULL,NULL,0);
}
/* Close down a TCP server created earlier by inet_start */
int
stop_tcp(port)
uint16 port;
{
	struct inet *in,*inprev;

	inprev = NULLINET;
	for(in = Inet_list;in != NULLINET;inprev=in,in = in->next)
		if(in->tcb->conn.local.port == port)
			break;
	if(in == NULLINET)
		return -1;
	close_tcp(in->tcb);
	free(in->name);
	if(inprev != NULLINET)
		inprev->next = in->next;
	else
		Inet_list = in->next;
	free(in);
	return 0;
}

@


1.9
log
@Signal waiting tasks when control block closes
@
text
@d6 5
a10 5
static void s_trcall __ARGS((struct tcb *tcb,int32 cnt));
static void s_tscall __ARGS((struct tcb *tcb,int old,int new));
static void s_ttcall __ARGS((struct tcb *tcb,int32 cnt));
static void trdiscard __ARGS((struct tcb *tcb,int32 cnt));
static void autobind __ARGS((struct usock *up));
d12 1
a12 1
int16 Lport = 1024;
d362 1
a362 1
	void (*task) __ARGS((int,void *,void *));
d367 1
a367 1
static void i_upcall __ARGS((struct tcb *tcb,int oldstate,int newstate));
d375 1
a375 1
int16 port;
d377 1
a377 1
void (*task) __ARGS((int,void *,void *));
d451 1
a451 1
int16 port;
@


1.8
log
@Fix bug in args to checkipaddr, tighten
@
text
@d259 1
@


1.7
log
@Add new start_tcp/stop_tcp code
@
text
@a26 1
	int s;
a29 1
	s = up->index;
d38 1
a38 1
	s_trcall,s_ttcall,s_tscall,up->tos,s);
d53 2
a54 1
	if(checkipaddr(up->peername,up->namelen) == -1){
a333 1
	int s;
a334 1
	s = up->index;
d338 1
a338 1
	bind(s,(char *)&local,sizeof(struct sockaddr_in));
@


1.6
log
@Use 32-bit count args to tcp send and receive calls
@
text
@d359 113
@


1.5
log
@src0521
@
text
@d6 1
a6 1
static void s_trcall __ARGS((struct tcb *tcb,int cnt));
d8 2
a9 2
static void s_ttcall __ARGS((struct tcb *tcb,int cnt));
static void trdiscard __ARGS((struct tcb *tcb,int cnt));
d102 1
a102 1
	int cnt;
d106 1
a106 1
	 && (cnt = recv_tcp(tcb,bpp,(int16)0)) == -1){
d132 1
a132 1
	int cnt;
d216 1
a216 1
int cnt;
d226 1
a226 1
int cnt;
d321 1
a321 1
int cnt;
d325 1
a325 1
	recv_tcp(tcb,&bp,(int16)cnt);
@


1.4
log
@src0514
@
text
@d280 1
@


1.3
log
@src0503
@
text
@d31 1
a31 1
	s = up - Usock + SOCKBASE;
d59 1
a59 1
	s = up - Usock + SOCKBASE;
d336 1
a336 1
	s = up - Usock + SOCKBASE;
@


1.2
log
@src0411
@
text
@a19 1
	strcpy(up->eol,INET_EOL);
d52 1
a52 1
	if(up->name == NULLCHAR) {
d166 1
a166 1
		len = up->cb.tcb->rcvcnt + len_p(up->ibuf);
d169 1
a169 1
		len = up->cb.tcb->sndcnt + len_p(up->obuf);
a256 4
			free_p(up->obuf);
			up->obuf = NULLBUF;
			free_p(up->ibuf);
			up->ibuf = NULLBUF;
@


1.1
log
@Initial revision
@
text
@d136 1
d258 4
@
