head	1.10;
access;
symbols;
locks;
comment	@ * @;


1.10
date	93.05.06.10.11.14;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	93.01.02.08.26.45;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.11.24.10.10.25;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.09.16.17.42.46;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.09.14.09.05.14;	author karn;	state Exp;
branches
	1.6.1.1;
next	1.5;

1.5
date	92.09.09.01.24.39;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.05.01.08.24.08;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.12.16.15.30.36;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.18.08.04.28;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.25.18;	author karn;	state Exp;
branches;
next	;

1.6.1.1
date	92.09.16.07.28.16;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.10
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* TCP control and status routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "timer.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "tcp.h"
#include "cmdparse.h"
#include "commands.h"
#include "socket.h"
#include "session.h"

static int doirtt(int argc,char *argv[],void *p);
static int domss(int argc,char *argv[],void *p);
static int dortt(int argc,char *argv[],void *p);
static int dotcpkick(int argc,char *argv[],void *p);
static int dotcpreset(int argc,char *argv[],void *p);
static int dotcpstat(int argc,char *argv[],void *p);
static int dotcptr(int argc,char *argv[],void *p);
static int dowindow(int argc,char *argv[],void *p);
static int dosyndata(int argc,char *argv[],void *p);
static int tstat(void);
static int keychar(int c);
static void tcprepstat(int interval,void *p1,void *p2);

/* TCP subcommand table */
static struct cmds Tcpcmds[] = {
	"irtt",		doirtt,		0, 0,	NULLCHAR,
	"kick",		dotcpkick,	0, 2,	"tcp kick <tcb>",
	"mss",		domss,		0, 0,	NULLCHAR,
	"reset",	dotcpreset,	0, 2,	"tcp reset <tcb>",
	"rtt",		dortt,		0, 3,	"tcp rtt <tcb> <val>",
	"status",	dotcpstat,	0, 0,	"tcp stat <tcb> [<interval>]",
	"syndata",	dosyndata,	0, 0,	NULLCHAR,
	"trace",	dotcptr,	0, 0,	NULLCHAR,
	"window",	dowindow,	0, 0,	NULLCHAR,
	NULLCHAR,
};
int
dotcp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Tcpcmds,argc,argv,p);
}
static int
dotcptr(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Tcp_trace,"TCP state tracing",argc,argv);
}

/* Eliminate a TCP connection */
static int
dotcpreset(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct tcb *tcb;

	tcb = (struct tcb *)ltop(htol(argv[1]));
	if(!tcpval(tcb)){
		printf(Notval);
		return 1;
	}
	reset_tcp(tcb);
	return 0;
}

/* Set initial round trip time for new connections */
static int
doirtt(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct tcp_rtt *tp;

	setlong(&Tcp_irtt,"TCP default irtt",argc,argv);
	if(argc < 2){
		for(tp = &Tcp_rtt[0];tp < &Tcp_rtt[RTTCACHE];tp++){
			if(tp->addr != 0){
				if(printf("%s: srtt %lu mdev %lu\n",
				 inet_ntoa(tp->addr),
				 tp->srtt,tp->mdev) == EOF)
					break;
			}
		}
	}
	return 0;
}

/* Set smoothed round trip time for specified TCB */
static int
dortt(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct tcb *tcb;

	tcb = (struct tcb *)ltop(htol(argv[1]));
	if(!tcpval(tcb)){
		printf(Notval);
		return 1;
	}
	tcb->srtt = atol(argv[2]);
	return 0;
}

/* Force a retransmission */
static int
dotcpkick(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct tcb *tcb;

	tcb = (struct tcb *)ltop(htol(argv[1]));
	if(kick_tcp(tcb) == -1){
		printf(Notval);
		return 1;
	}
	return 0;
}

/* Set default maximum segment size */
static int
domss(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Tcp_mss,"TCP MSS",argc,argv);
}

/* Set default window size */
static int
dowindow(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Tcp_window,"TCP window",argc,argv);	
}

static int
dosyndata(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Tcp_syndata,"TCP syn+data piggybacking",argc,argv);
}


/* Display status of TCBs */
static int
dotcpstat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct tcb *tcb;
	int32 interval = 0;

	if(argc < 2){
		tstat();
		return 0;
	}
	if(argc > 2)
		interval = atol(argv[2]);

	tcb = (struct tcb *)ltop(htol(argv[1]));
	if(!tcpval(tcb)){
		printf(Notval);
		return 1;
	}
	if(interval == 0){
		st_tcp(tcb);
		return 0;
	}
	newproc("rep tcp stat",512,tcprepstat,interval,(void *)tcb,NULL,0);
	return 0;
}

static void
tcprepstat(interval,p1,p2)
int interval;
void *p1;
void *p2;
{
	struct tcb *tcb = (struct tcb *)p1;
	struct session *sp;
	
	if((sp = newsession(Cmdline,REPEAT,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return;
	}
	sp->inproc = keychar;	/* Intercept ^C */
	while(sp->inproc == keychar){	/* ^C will clear sp->inproc */
		printf("%c[2J",ESC);	/* Clear screen */
		st_tcp(tcb);
		if(tcb->state == TCP_CLOSED || pause(interval) == -1)
			break;
	}
	keywait(NULLCHAR,1);
	freesession(sp);
}

/* Dump TCP stats and summary of all TCBs
/*     &TCB Rcv-Q Snd-Q  Local socket           Remote socket          State
 *     1234     0     0  xxx.xxx.xxx.xxx:xxxxx  xxx.xxx.xxx.xxx:xxxxx  Established
 */
static int
tstat()
{
	register int i;
	register struct tcb *tcb;
	int j;

	for(j=i=1;i<=NUMTCPMIB;i++){
		if(Tcp_mib[i].name == NULLCHAR)
			continue;
		printf("(%2u)%-20s%10lu",i,Tcp_mib[i].name,
		 Tcp_mib[i].value.integer);
		if(j++ % 2)
			printf("     ");
		else
			printf("\n");
	}
	if((j % 2) == 0)
		printf("\n");

	printf("    &TCB Rcv-Q Snd-Q  Local socket           Remote socket          State\n");
	for(tcb=Tcbs;tcb != NULLTCB;tcb = tcb->next){
		printf("%8lx%6u%6u  ",ptol(tcb),tcb->rcvcnt,tcb->sndcnt);
		printf("%-23s",pinet(&tcb->conn.local));
		printf("%-23s",pinet(&tcb->conn.remote));
		printf("%-s",Tcpstates[tcb->state]);
		if(tcb->state == TCP_LISTEN && tcb->flags.clone)
			printf(" (S)");
		if(printf("\n") == EOF)
			return 0;
	}
	return 0;
}
/* Dump a TCP control block in detail */
void
st_tcp(tcb)
struct tcb *tcb;
{
	int32 sent,recvd;

	if(tcb == NULLTCB)
		return;
	/* Compute total data sent and received; take out SYN and FIN */
	sent = tcb->snd.una - tcb->iss;	/* Acknowledged data only */
	recvd = tcb->rcv.nxt - tcb->irs;
	switch(tcb->state){
	case TCP_LISTEN:
	case TCP_SYN_SENT:	/* Nothing received or acked yet */
		sent = recvd = 0;	
		break;
	case TCP_SYN_RECEIVED:
		recvd--;	/* Got SYN, no data acked yet */
		sent = 0;
		break;
	case TCP_ESTABLISHED:	/* Got and sent SYN */
	case TCP_FINWAIT1:	/* FIN not acked yet */
		sent--;
		recvd--;
		break;
	case TCP_FINWAIT2:	/* Our SYN and FIN both acked */
		sent -= 2;
		recvd--;
		break;
	case TCP_CLOSE_WAIT:	/* Got SYN and FIN, our FIN not yet acked */
	case TCP_CLOSING:
	case TCP_LAST_ACK:
		sent--;
		recvd -= 2;
		break;
	case TCP_TIME_WAIT:	/* Sent and received SYN/FIN, all acked */
		sent -= 2;
		recvd -= 2;
		break;
	}
	printf("Local: %s",pinet(&tcb->conn.local));
	printf(" Remote: %s",pinet(&tcb->conn.remote));
	printf(" State: %s\n",Tcpstates[tcb->state]);
	printf("         Unack     Next Resent CWind Thrsh  Wind  MSS Queue  Thruput      Total\n");
	printf("Send: %08lx %08lx%7lu%6lu%6lu%6lu%5lu%6lu%9lu%11lu\n",
	 tcb->snd.una,tcb->snd.nxt,tcb->resent,tcb->cwind,tcb->ssthresh,
	 tcb->snd.wnd,tcb->mss,tcb->sndcnt,tcb->txbw,sent);

	printf("Recv:          %08lx%7lu            %6lu     %6lu%9lu%11lu\n",
	 tcb->rcv.nxt,tcb->rerecv,tcb->rcv.wnd,tcb->rcvcnt,tcb->rxbw,recvd);

	printf("Dup acks   Backoff   Timeouts   Source Quench   Unreachables   Power\n");
	printf("%8u%10u%11lu%16lu%15lu",tcb->dupacks,tcb->backoff,tcb->timeouts,
	 tcb->quench,tcb->unreach);
	if(tcb->srtt != 0)
		printf("%8lu",1000*tcb->txbw/tcb->srtt);
	else
		printf("     INF");
	if(tcb->flags.retran)
		printf(" Retry");
	printf("\n");

	printf("Timer        Count  Duration  Last RTT      SRTT      mdev\n");
	switch(tcb->timer.state){
	case TIMER_STOP:
		printf("stopped");
		break;
	case TIMER_RUN:
		printf("running");
		break;
	case TIMER_EXPIRE:
		printf("expired");
		break;
	}
	printf(" %10lu%10lu%10lu%10lu%10lu\n",(long)read_timer(&tcb->timer),
	 (long)dur_timer(&tcb->timer),tcb->rtt,tcb->srtt,tcb->mdev);

	if(tcb->reseq != (struct reseq *)NULL){
		register struct reseq *rp;

		printf("Reassembly queue:\n");
		for(rp = tcb->reseq;rp != (struct reseq *)NULL; rp = rp->next){
			if(printf("  seq x%lx %u bytes\n",
			 rp->seg.seq,rp->length) == EOF)
				return;
		}
	}
}
static int
keychar(c)
int c;
{
	if(c != CTLC)
		return 1;	/* Ignore all but ^C */

	fprintf(Current->output,"^C\n");
	alert(Current->proc,EABORT);
	Current->inproc = NULL;
	return 0;
}

@


1.9
log
@Call newsession with Cmdline
@
text
@d16 12
a27 12
static int doirtt __ARGS((int argc,char *argv[],void *p));
static int domss __ARGS((int argc,char *argv[],void *p));
static int dortt __ARGS((int argc,char *argv[],void *p));
static int dotcpkick __ARGS((int argc,char *argv[],void *p));
static int dotcpreset __ARGS((int argc,char *argv[],void *p));
static int dotcpstat __ARGS((int argc,char *argv[],void *p));
static int dotcptr __ARGS((int argc,char *argv[],void *p));
static int dowindow __ARGS((int argc,char *argv[],void *p));
static int dosyndata __ARGS((int argc,char *argv[],void *p));
static int tstat __ARGS((void));
static int keychar __ARGS((int c));
static void tcprepstat __ARGS((int interval,void *p1,void *p2));
@


1.8
log
@TCP status command now forks off separate task only when interval
is non-zero (requesting a repeating display)
@
text
@d204 1
a204 1
	if((sp = newsession("tcp stat",REPEAT,1)) == NULLSESSION){
@


1.7
log
@More reformatting of tcp status display
Show last received RTT
Add repeat option to tcp status command
@
text
@d27 1
d36 1
a36 1
	"status",	dotcpstat,	512, 0,	"tcp stat <tcb> [<interval>]",
a173 1
	struct session *sp;
d191 14
a204 1
	if((sp = newsession(argv[1],REPEAT,1)) == NULLSESSION){
d206 1
a206 1
		return 1;
a216 1
	return 0;
@


1.6
log
@Use long format for variables that are now 32 bits. Also print
leading zeros on sequence numbers.
@
text
@d13 2
d26 1
d35 1
a35 1
	"status",	dotcpstat,	0, 0,	NULLCHAR,
d172 2
d179 3
d187 17
a203 1
	st_tcp(tcb);
d289 17
a305 23
	printf("Send:");
	printf(" %08lx",tcb->snd.una);
	printf(" %08lx",tcb->snd.nxt);
	printf("%7lu",tcb->resent);
	printf("%6lu",tcb->cwind);
	printf("%6lu",tcb->ssthresh);
	printf("%6lu",tcb->snd.wnd);
	printf("%5lu",tcb->mss);
	printf("%6lu",tcb->sndcnt);
	printf("%9lu",tcb->txbw);
	printf("%11lu\n",sent);

	printf("Recv:");
	printf("         ");
	printf(" %08lx",tcb->rcv.nxt);
	printf("%7lu",tcb->rerecv);
	printf("      ");
	printf("      ");
	printf("%6lu",tcb->rcv.wnd);
	printf("     ");
	printf("%6lu",tcb->rcvcnt);
	printf("%9lu",tcb->rxbw);
	printf("%11lu\n",recvd);
d307 1
a307 1
	printf("Timer        Count  Duration      SRTT      mdev da bo   TO quench unrch\n");
d319 3
a321 12
	printf(" %10ld%10ld",(long)read_timer(&tcb->timer),
	 (long)dur_timer(&tcb->timer));
	printf("%10ld%10ld",tcb->srtt,tcb->mdev);

	printf("%3d",tcb->dupacks);
	printf("%3u",tcb->backoff);
	printf("%5ld",tcb->timeouts);
	printf("%7lu",tcb->quench);
	printf("%6lu",tcb->unreach);
	if(tcb->flags.retran)
		printf(" Retry");
	printf("\n");
d333 13
@


1.6.1.1
log
@Break up some long lines, add display of power history stuff
(experimental, retracted)
@
text
@a225 1
	int i;
d289 1
a289 16

	printf(" da bo   TO quench unrch power\n");
	printf("%3d",tcb->dupacks);
	printf("%3u",tcb->backoff);
	printf("%5ld",tcb->timeouts);
	printf("%7lu",tcb->quench);
	printf("%6lu",tcb->unreach);
	if(tcb->srtt != 0)
		printf("%6lu",1000*tcb->txbw/tcb->srtt);
	else
		printf("   INF");
	if(tcb->flags.retran)
		printf(" Retry");
	printf("\n");

	printf("Timer        Count  Duration      SRTT      mdev\n");
d303 1
a303 1
	printf("%10ld%10ld\n",tcb->srtt,tcb->mdev);
d305 8
a312 3
	printf("Power history:\n");
	for(i=0;i<PHIST;i++)
		printf("%lu\t%lu\n",tcb->chist[i],tcb->phist[i]);
@


1.5
log
@Major changes to TCP status display - show lots of interesting
performance stuff. Also fix return code from tcp stat command to
exit properly when repeated
@
text
@d266 2
a267 2
	printf("%9lx",tcb->snd.una);
	printf("%9lx",tcb->snd.nxt);
d269 5
a273 5
	printf("%6u",tcb->cwind);
	printf("%6u",tcb->ssthresh);
	printf("%6u",tcb->snd.wnd);
	printf("%5u",tcb->mss);
	printf("%6u",tcb->sndcnt);
d279 1
a279 1
	printf("%9lx",tcb->rcv.nxt);
d283 1
a283 1
	printf("%6u",tcb->rcv.wnd);
d285 1
a285 1
	printf("%6u",tcb->rcvcnt);
@


1.4
log
@src0501
@
text
@d172 6
a177 6
	} else {
		tcb = (struct tcb *)ltop(htol(argv[1]));
		if(tcpval(tcb))
			st_tcp(tcb);
		else
			printf(Notval);
d179 1
d264 1
a264 1
	printf("      Init seq    Unack     Next Resent CWind Thrsh  Wind  MSS Queue      Total\n");
a265 1
	printf("%9lx",tcb->iss);
d274 1
a277 1
	printf("%9lx",tcb->irs);
d286 1
d289 24
a322 17
	if(tcb->backoff > 0)
		printf("Backoff %u ",tcb->backoff);
	if(tcb->flags.retran)
		printf("Retrying ");
	switch(tcb->timer.state){
	case TIMER_STOP:
		printf("Timer stopped ");
		break;
	case TIMER_RUN:
		printf("Timer running (%ld/%ld ms) ",
		 (long)read_timer(&tcb->timer),
		 (long)dur_timer(&tcb->timer));
		break;
	case TIMER_EXPIRE:
		printf("Timer expired ");
	}
	printf("SRTT %ld ms Mean dev %ld ms\n",tcb->srtt,tcb->mdev);
@


1.3
log
@src1216
@
text
@d66 1
a66 1
		tprintf(Notval);
d86 1
a86 1
				if(tprintf("%s: srtt %lu mdev %lu\n",
d107 1
a107 1
		tprintf(Notval);
d125 1
a125 1
		tprintf(Notval);
d177 1
a177 1
			tprintf(Notval);
d196 1
a196 1
		tprintf("(%2u)%-20s%10lu",i,Tcp_mib[i].name,
d199 1
a199 1
			tprintf("     ");
d201 1
a201 1
			tprintf("\n");
d204 1
a204 1
		tprintf("\n");
d206 1
a206 1
	tprintf("    &TCB Rcv-Q Snd-Q  Local socket           Remote socket          State\n");
d208 4
a211 4
		tprintf("%8lx%6u%6u  ",ptol(tcb),tcb->rcvcnt,tcb->sndcnt);
		tprintf("%-23s",pinet(&tcb->conn.local));
		tprintf("%-23s",pinet(&tcb->conn.remote));
		tprintf("%-s",Tcpstates[tcb->state]);
d213 2
a214 2
			tprintf(" (S)");
		if(tprintf("\n") == EOF)
d260 27
a286 27
	tprintf("Local: %s",pinet(&tcb->conn.local));
	tprintf(" Remote: %s",pinet(&tcb->conn.remote));
	tprintf(" State: %s\n",Tcpstates[tcb->state]);
	tprintf("      Init seq    Unack     Next Resent CWind Thrsh  Wind  MSS Queue      Total\n");
	tprintf("Send:");
	tprintf("%9lx",tcb->iss);
	tprintf("%9lx",tcb->snd.una);
	tprintf("%9lx",tcb->snd.nxt);
	tprintf("%7lu",tcb->resent);
	tprintf("%6u",tcb->cwind);
	tprintf("%6u",tcb->ssthresh);
	tprintf("%6u",tcb->snd.wnd);
	tprintf("%5u",tcb->mss);
	tprintf("%6u",tcb->sndcnt);
	tprintf("%11lu\n",sent);

	tprintf("Recv:");
	tprintf("%9lx",tcb->irs);
	tprintf("         ");
	tprintf("%9lx",tcb->rcv.nxt);
	tprintf("%7lu",tcb->rerecv);
	tprintf("      ");
	tprintf("      ");
	tprintf("%6u",tcb->rcv.wnd);
	tprintf("     ");
	tprintf("%6u",tcb->rcvcnt);
	tprintf("%11lu\n",recvd);
d291 1
a291 1
		tprintf("Reassembly queue:\n");
d293 1
a293 1
			if(tprintf("  seq x%lx %u bytes\n",
d299 1
a299 1
		tprintf("Backoff %u ",tcb->backoff);
d301 1
a301 1
		tprintf("Retrying ");
d304 1
a304 1
		tprintf("Timer stopped ");
d307 1
a307 1
		tprintf("Timer running (%ld/%ld ms) ",
d312 1
a312 1
		tprintf("Timer expired ");
d314 1
a314 1
	tprintf("SRTT %ld ms Mean dev %ld ms\n",tcb->srtt,tcb->mdev);
@


1.2
log
@src0318
@
text
@d69 1
a69 1
	close_self(tcb,RESET);
@


1.1
log
@Initial revision
@
text
@d207 9
a215 11
	for(i=0;i<NTCB;i++){
		for(tcb=Tcbs[i];tcb != NULLTCB;tcb = tcb->next){
			tprintf("%8lx%6u%6u  ",ptol(tcb),tcb->rcvcnt,tcb->sndcnt);
			tprintf("%-23s",pinet(&tcb->conn.local));
			tprintf("%-23s",pinet(&tcb->conn.remote));
			tprintf("%-s",Tcpstates[tcb->state]);
			if(tcb->state == TCP_LISTEN && tcb->flags.clone)
				tprintf(" (S)");
			if(tprintf("\n") == EOF)
				return 0;
		}
@
