head	1.9;
access;
symbols;
locks;
comment	@ * @;


1.9
date	93.05.06.10.10.19;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.01.08.23.04;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	91.09.18.14.32.24;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	91.06.07.07.07.36;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.04.23.09.54.24;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.04.20.09.54.26;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.08.11.19.32;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	90.12.10.07.14.58;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.9
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 *  PPPIPCP.C	-- negotiate IP parameters
 *
 *	This implementation of PPP is declared to be in the public domain.
 *
 *	Jan 91	Bill_Simpson@@um.cc.umich.edu
 *		Computer Systems Consulting Services
 *
 *	Acknowledgements and correction history may be found in PPP.C
 */

#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "slhc.h"
#include "ppp.h"
#include "pppfsm.h"
#include "pppipcp.h"
#include "cmdparse.h"
#include "files.h"
#include "trace.h"


/* These defaults are defined in the PPP RFCs, and must not be changed */
static struct ipcp_value_s ipcp_default = {
	FALSE,			/* no need to negotiate defaults */

	0L,			/* no source address */
	0L,			/* no destination address */

	0,			/* no compression protocol */
	0,			/* no slots */
	0			/* no slot compression */
};

/* for test purposes, accept anything we understand */
static uint16 ipcp_negotiate = IPCP_N_ADDRESS | IPCP_N_COMPRESS;

static byte_t option_length[] = {
	 0,		/* unused */
	10,		/* address */
	 6		/* compression */
};


static int doipcp_local(int argc, char *argv[], void *p);
static int doipcp_open(int argc, char *argv[], void *p);
static int doipcp_pool(int argc, char *argv[], void *p);
static int doipcp_remote(int argc, char *argv[], void *p);

static int doipcp_address(int argc, char *argv[], void *p);
static int doipcp_compress(int argc, char *argv[], void *p);
static int doipcp_default(int argc, char *argv[], void *p);

static void ipcp_option(struct mbuf **bpp,
			struct ipcp_value_s *value_p,
			byte_t o_type,
			byte_t o_length,
			struct mbuf **copy_bpp);
static void ipcp_makeoptions(struct mbuf **bpp,
			struct ipcp_value_s *value_p,
			uint16 negotiating);
static struct mbuf *ipcp_makereq(struct fsm_s *fsm_p);

static int ipcp_check(struct mbuf **bpp,
			struct ipcp_s *ipcp_p,
			struct ipcp_side_s *side_p,
			struct option_hdr *option_p,
			int request);

static int ipcp_request(struct fsm_s *fsm_p,
			struct config_hdr *config,
			struct mbuf *data);
static int ipcp_ack(struct fsm_s *fsm_p,
			struct config_hdr *config,
			struct mbuf *data);
static int ipcp_nak(struct fsm_s *fsm_p,
			struct config_hdr *config,
			struct mbuf *data);
static int ipcp_reject(struct fsm_s *fsm_p,
			struct config_hdr *config,
			struct mbuf *data);

static void ipcp_reset(struct fsm_s *fsm_p);

static int32 ipcp_addr_idle(int32 addr);
static int32 ipcp_lookuppeer(char *peerid);
static int32 ipcp_poolnext(struct ipcp_s *ipcp_p);

static void ipcp_starting(struct fsm_s *fsm_p);
static void ipcp_stopping(struct fsm_s *fsm_p);

static void ipcp_closing(struct fsm_s *fsm_p);
static void ipcp_opening(struct fsm_s *fsm_p);

static void ipcp_free(struct fsm_s *fsm_p);


static struct fsm_constant_s ipcp_constants = {
	"IPcp",
	PPP_IPCP_PROTOCOL,
	0x00FE,				/* codes 1-7 recognized */

	IPcp,
	IPCP_REQ_TRY,
	IPCP_NAK_TRY,
	IPCP_TERM_TRY,
	IPCP_TIMEOUT * 1000L,

	ipcp_free,

	ipcp_reset,
	ipcp_starting,
	ipcp_opening,
	ipcp_closing,
	ipcp_stopping,

	ipcp_makereq,
	ipcp_request,
	ipcp_ack,
	ipcp_nak,
	ipcp_reject,
};


/************************************************************************/

/* "ppp <iface> ipcp" subcommands */
static struct cmds IPcpcmds[] = {
	"close",	doppp_close,	0,	0,	NULLCHAR,
	"listen",	doppp_passive,	0,	0,	NULLCHAR,
	"local",	doipcp_local,	0,	0,	NULLCHAR,
	"open",		doipcp_open,	0,	0,	NULLCHAR,
	"pool",		doipcp_pool,	0,	0,	NULLCHAR,
	"remote",	doipcp_remote,	0,	0,	NULLCHAR,
	"timeout",	doppp_timeout,	0,	0,	NULLCHAR,
	"try",		doppp_try,	0,	0,	NULLCHAR,
	NULLCHAR,
};

/* "ppp <iface> ipcp {local | remote}" subcommands */
static struct cmds IPcpside_cmds[] = {
	"address",	doipcp_address,	0,	0,	NULLCHAR,
	"compress",	doipcp_compress,0,	0,	NULLCHAR,
	"default",	doipcp_default,	0,	0,	NULLCHAR,
	NULLCHAR,
};


int
doppp_ipcp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp = p;
	register struct ppp_s *ppp_p = ifp->edv;

	return subcmd(IPcpcmds, argc, argv, &(ppp_p->fsm[IPcp]));
}


static int
doipcp_local(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	return subcmd(IPcpside_cmds, argc, argv, &(ipcp_p->local));
}


static int
doipcp_open(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;

	doppp_active( argc, argv, p );

	if ( fsm_p->ppp_p->phase == pppREADY ) {
		fsm_start( fsm_p );
	}
	return 0;
}


/* Set a pool of peer addresses for PPP interface */
static int
doipcp_pool(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	int32 pool_addr;
	int pool_cnt;

	if (argc < 2) {
		if ( ipcp_p->peer_min == 0L ) {
			printf("None");
		} else {
			printf("%s thru ", inet_ntoa(ipcp_p->peer_min));
			printf("%s\n", inet_ntoa(ipcp_p->peer_max));
		}
		return 0;
	}

	if ((pool_addr = resolve(argv[1])) == 0L) {
		printf(Badhost,argv[1]);
	}

	/* May specify a consecutive range of addresses; otherwise assume 1 */
	if (argc < 3)
		pool_cnt = 1;
	else
		pool_cnt = (int)strtol( argv[2], NULLCHARP, 0 );

	if (pool_cnt <= 0) {
		printf("Pool count %s (%d) must be > 0\n");
		return -1;
	}

	ipcp_p->peer_min = pool_addr;
	ipcp_p->peer_max = pool_addr + pool_cnt - 1;
	return 0;
}


static int
doipcp_remote(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	return subcmd(IPcpside_cmds, argc, argv, &(ipcp_p->remote));
}


/************************************************************************/
/* Set addresses for PPP interface */
static int
doipcp_address(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct ipcp_side_s *side_p = p;
	int32 x32;

	if (argc < 2) {
		printf("%s\n", inet_ntoa(side_p->want.address));
		return 0;
	} else if ( stricmp(argv[1],"allow") == 0 ) {
		return bit16cmd( &(side_p->will_negotiate), IPCP_N_ADDRESS,
			"Allow Address", --argc, &argv[1] );
	}
	if ((x32 = resolve(argv[1])) == 0L) {
		printf(Badhost,argv[1]);
	}
	side_p->want.address = x32;
	side_p->want.negotiate |= IPCP_N_ADDRESS;
	return 0;
}


/* Set IP compression type for PPP interface */
static int
doipcp_compress(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct ipcp_side_s *side_p = p;

	if (argc < 2) {
		if ( side_p->want.negotiate & IPCP_N_COMPRESS ) {
			switch ( side_p->want.compression ) {
			case PPP_COMPR_PROTOCOL:
				printf("TCP header compression enabled; "
					"Slots = %d, slot compress = %x\n",
					side_p->want.slots,
					side_p->want.slot_compress);
				break;
			default:
				printf("0x%04x\n", side_p->want.compression);
				break;
			};
		} else {
			printf("None\n");
		}
	} else if ( stricmp(argv[1],"allow") == 0 ) {
		return bit16cmd( &(side_p->will_negotiate), IPCP_N_COMPRESS,
			"Allow Compression", --argc, &argv[1] );
	} else if ( stricmp(argv[1],"tcp") == 0
		 || stricmp(argv[1],"vj") == 0 ) {
		side_p->want.compression = PPP_COMPR_PROTOCOL;
		if ( argc >= 3 ) {
			side_p->want.slots = strtol(argv[2],NULLCHARP,0);
			if ( side_p->want.slots < 1 || side_p->want.slots > 255 ) {
				printf( "slots must be in range 1 to 255" );
				return 1;
			}
		} else {
			side_p->want.slots = IPCP_SLOT_DEFAULT;
		}
		if ( argc >= 4 ) {
			side_p->want.slot_compress = strtol(argv[3],NULLCHARP,0);
		} else {
			side_p->want.slot_compress = IPCP_SLOT_COMPRESS;
		}
		side_p->want.negotiate |= IPCP_N_COMPRESS;
	} else if (stricmp(argv[1],"none") == 0) {
		side_p->want.negotiate &= ~IPCP_N_COMPRESS;
	} else {
		printf("allow tcp none\n");
		return 1;
	}
	return 0;
}


static int
doipcp_default(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct ipcp_side_s *side_p = p;

	ASSIGN( side_p->want, ipcp_default );
	return 0;
}


/************************************************************************/
/*			E V E N T   P R O C E S S I N G			*/
/************************************************************************/

static void
ipcp_option( bpp, value_p, o_type, o_length, copy_bpp )
struct mbuf **bpp;
struct ipcp_value_s *value_p;
byte_t o_type;
byte_t o_length;
struct mbuf **copy_bpp;
{
	struct mbuf *bp;
	register char *cp;
	register int toss = o_length - OPTION_HDR_LEN;

	if ((bp = alloc_mbuf(o_length)) == NULLBUF) {
		return;
	}
	cp = bp->data;
	*cp++ = o_type;
	*cp++ = o_length;

	switch ( o_type ) {
	case IPCP_ADDRESS:
		cp = put32(cp, value_p->address);
		cp = put32(cp, value_p->other);
		toss -= 8;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS) {
	trace_log(PPPiface, "    making IP source address: %s",
		inet_ntoa(value_p->address));
	trace_log(PPPiface, "    making IP destination address %s",
		inet_ntoa(value_p->other));
}
#endif
		break;

	case IPCP_COMPRESS:
		cp = put16(cp, value_p->compression);
		toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making IP compression 0x%04x",
		value_p->compression);
#endif
		if ( value_p->compression == PPP_COMPR_PROTOCOL ) {
			*cp++ = value_p->slots - 1;
			*cp++ = value_p->slot_compress;
			toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    with IP compression slots %d, flag %x",
		value_p->slots,
		value_p->slot_compress);
#endif
		}
		break;

	default:
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    making unimplemented type %d", o_type);
#endif
		break;
	};

	while ( toss-- > 0 ) {
		*cp++ = pullchar(copy_bpp);
	}
	bp->cnt += o_length;
	append(bpp, bp);
}


/************************************************************************/
/* Build a list of options */
static void
ipcp_makeoptions(bpp, value_p, negotiating)
struct mbuf **bpp;
struct ipcp_value_s *value_p;
uint16 negotiating;
{
	register int o_type;

	PPP_DEBUG_ROUTINES("ipcp_makeoptions()");

	for ( o_type = 1; o_type <= IPCP_OPTION_LIMIT; o_type++ ) {
		if (negotiating & (1 << o_type)) {
			ipcp_option( bpp, value_p,
				o_type, option_length[ o_type ], NULLBUFP);
		}
	}
}


/************************************************************************/
/* Build a request to send to remote host */
static struct mbuf *
ipcp_makereq(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	struct mbuf *req_bp = NULLBUF;

	PPP_DEBUG_ROUTINES("ipcp_makereq()");

	ipcp_makeoptions( &req_bp, &(ipcp_p->local.work),
				ipcp_p->local.work.negotiate );
	return(req_bp);
}


/************************************************************************/
/* Check the options, updating the working values.
 * Returns -1 if ran out of data, ACK/NAK/REJ as appropriate.
 */
static int
ipcp_check( bpp, ipcp_p, side_p, option_p, request )
struct mbuf **bpp;
struct ipcp_s *ipcp_p;
struct ipcp_side_s *side_p;
struct option_hdr *option_p;
int request;
{
	int toss = option_p->len - OPTION_HDR_LEN;
	int option_result = CONFIG_ACK;		/* Assume good values */
	int test;

	switch(option_p->type) {
	case IPCP_ADDRESS:
		side_p->work.address = pull32(bpp);
		side_p->work.other = pull32(bpp);
		toss -= 8;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS) {
	trace_log(PPPiface, "    checking IP source address: %s",
		inet_ntoa(side_p->work.address));
	trace_log(PPPiface, "    checking IP destination address %s",
		inet_ntoa(side_p->work.other));
}
#endif
		if ( !request ) {
			/* override any undesirable changes */
			if (ipcp_p->remote.want.address != 0L) {
				ipcp_p->local.work.other
					= ipcp_p->remote.want.address;
			}
			if (ipcp_p->local.want.address != 0L) {
				ipcp_p->local.work.address
					= ipcp_p->local.want.address;
			}
			break;
		}

		/* Ensure that addresses match */
		if (ipcp_p->remote.work.address == ipcp_p->remote.want.address) {
			if (ipcp_p->remote.want.address == 0L) {
				/* don't know address either */
				option_result = CONFIG_REJ;
			}
		} else if (ipcp_p->remote.want.address == 0L) {
			ipcp_p->local.work.other = ipcp_p->remote.work.address;
		} else {
			ipcp_p->remote.work.address = ipcp_p->remote.want.address;
			option_result = CONFIG_NAK;
		}

		if (ipcp_p->remote.work.other == ipcp_p->local.want.address) {
			if (ipcp_p->local.want.address == 0L) {
				/* don't know address either */
				option_result = CONFIG_REJ;
			}
		} else if (ipcp_p->local.want.address == 0L) {
			ipcp_p->local.work.address = ipcp_p->remote.work.other;
		} else {
			option_result = CONFIG_NAK;
			ipcp_p->remote.work.other = ipcp_p->local.want.address;
		}
		break;

	case IPCP_COMPRESS:
		side_p->work.compression = pull16(bpp);
		toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    checking IP compression 0x%04x",
		side_p->work.compression);
#endif
		/* Check if requested type is acceptable */
		switch ( side_p->work.compression ) {
		case PPP_COMPR_PROTOCOL:
			if ( (test = pullchar(bpp)) == -1 ) {
				return -1;
			}
			if ( (side_p->work.slots = test + 1) < IPCP_SLOT_LO) {
				side_p->work.slots = IPCP_SLOT_LO;
				option_result = CONFIG_NAK;
			} else if (side_p->work.slots > IPCP_SLOT_HI) {
				side_p->work.slots = IPCP_SLOT_HI;
				option_result = CONFIG_NAK;
			}

			if ( (test = pullchar(bpp)) == -1 ) {
				return -1;
			}
			if ( (side_p->work.slot_compress = test) > 1 ) {
				side_p->work.slot_compress = 1;
				option_result = CONFIG_NAK;
			}
			toss -= 2;
#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS)
	trace_log(PPPiface, "    with IP compression slots %d, flag %x",
		side_p->work.slots,
		side_p->work.slot_compress);
#endif
			break;

		default:
			if ( side_p->want.negotiate & IPCP_N_COMPRESS ) {
				side_p->work.compression = side_p->want.compression;
				side_p->work.slots = side_p->want.slots;
				side_p->work.slot_compress = side_p->want.slot_compress;
			} else {
				side_p->work.compression = PPP_COMPR_PROTOCOL;
				side_p->work.slots = IPCP_SLOT_DEFAULT;
				side_p->work.slot_compress = IPCP_SLOT_COMPRESS;
			}
			option_result = CONFIG_NAK;
			break;
		};
		break;

	default:
		option_result = CONFIG_REJ;
		break;
	};

	if (option_p->type > IPCP_OPTION_LIMIT
	 || !(side_p->will_negotiate & (1 << option_p->type))) {
		option_result = CONFIG_REJ;
	}

	if ( toss < 0 )
		return -1;

	if ( !request  &&  toss > 0 ) {
		/* toss extra bytes in option */
		while( toss-- > 0 ) {
			if ( pullchar(bpp) == -1 )
				return -1;
		}
	}

	return (option_result);
}


/************************************************************************/
/* Check options requested by the remote host */
static int
ipcp_request(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	int32 signed_length = config->len;
	struct mbuf *reply_bp = NULLBUF;	/* reply packet */
	int reply_result = CONFIG_ACK;		/* reply to request */
	uint16 desired;				/* desired to negotiate */
	struct option_hdr option;		/* option header storage */
	int option_result;			/* option reply */

	PPP_DEBUG_ROUTINES("ipcp_request()");
	ipcp_p->remote.work.negotiate = FALSE;	/* clear flags */

	/* Process options requested by remote host */
	while (signed_length > 0  &&  ntohopt(&option, &data) != -1) {
		if ((signed_length -= option.len) < 0) {
			PPP_DEBUG_CHECKS("IPCP REQ: bad header length");
			free_p(data);
			free_p(reply_bp);
			return -1;
		}

		if ( ( option_result = ipcp_check( &data, ipcp_p,
				&(ipcp_p->remote), &option, TRUE ) ) == -1 ) {
			PPP_DEBUG_CHECKS("IPCP REQ: ran out of data");
			free_p(data);
			free_p(reply_bp);
			return -1;
		}

#ifdef PPP_DEBUG_OPTIONS
if (PPPtrace & PPP_DEBUG_OPTIONS) {
	trace_log(PPPiface, "IPCP REQ: result %s, option %d, length %d",
		fsmCodes[option_result],
		option.type,
		option.len);
}
#endif
		if ( option_result < reply_result ) {
			continue;
		} else if ( option_result > reply_result ) {
			/* Discard current list of replies */
			free_p(reply_bp);
			reply_bp = NULLBUF;
			reply_result = option_result;
		}

		/* remember that we processed option */
		if ( option_result != CONFIG_REJ
		 && option.type <= IPCP_OPTION_LIMIT ) {
			ipcp_p->remote.work.negotiate |= (1 << option.type);
		}

		/* Add option response to the return list */
		ipcp_option( &reply_bp, &(ipcp_p->remote.work),
			option.type, option.len, &data );
	}

	/* Now check for any missing options which are desired */
	if ( fsm_p->retry_nak > 0
	 &&  (desired = ipcp_p->remote.want.negotiate
		       & ~ipcp_p->remote.work.negotiate) != 0 ) {
		switch ( reply_result ) {
		case CONFIG_ACK:
			free_p(reply_bp);
			reply_bp = NULLBUF;
			reply_result = CONFIG_NAK;
			/* fallthru */
		case CONFIG_NAK:
			ipcp_makeoptions( &reply_bp, &(ipcp_p->remote.want),
				desired );
			fsm_p->retry_nak--;
			break;
		case CONFIG_REJ:
			/* do nothing */
			break;
		};
	} else if ( reply_result == CONFIG_NAK ) {
		/* if too many NAKs, reject instead */
		if ( fsm_p->retry_nak > 0 )
			fsm_p->retry_nak--;
		else
			reply_result = CONFIG_REJ;
	}

	/* Send ACK/NAK/REJ to remote host */
	fsm_send(fsm_p, reply_result, config->id, reply_bp);
	free_p(data);
	return (reply_result != CONFIG_ACK);
}


/************************************************************************/
/* Process configuration ACK sent by remote host */
static int
ipcp_ack(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct mbuf *req_bp;
	int error = FALSE;

	PPP_DEBUG_ROUTINES("ipcp_ack()");

	/* ID field must match last request we sent */
	if (config->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("IPCP ACK: wrong ID");
		free_p(data);
		return -1;
	}

	/* Get a copy of last request we sent */
	req_bp = ipcp_makereq(fsm_p);

	/* Overall buffer length should match */
	if (config->len != len_p(req_bp)) {
		PPP_DEBUG_CHECKS("IPCP ACK: buffer length mismatch");
		error = TRUE;
	} else {
		register int req_char;
		register int ack_char;

		/* Each byte should match */
		while ((req_char = pullchar(&req_bp)) != -1) {
			if ((ack_char = pullchar(&data)) == -1
			 || ack_char != req_char ) {
				PPP_DEBUG_CHECKS("IPCP ACK: data mismatch");
				error = TRUE;
				break;
			}
		}
	}
	free_p(req_bp);
	free_p(data);

	if (error) {
		return -1;
	}

	PPP_DEBUG_CHECKS("IPCP ACK: valid");
	return 0;
}


/************************************************************************/
/* Process configuration NAK sent by remote host */
static int
ipcp_nak(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	struct ipcp_side_s *local_p = &(ipcp_p->local);
	int32 signed_length = config->len;
	struct option_hdr option;
	int last_option = 0;
	int result;

	PPP_DEBUG_ROUTINES("ipcp_nak()");

	/* ID field must match last request we sent */
	if (config->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("IPCP NAK: wrong ID");
		free_p(data);
		return -1;
	}

	/* First, process in order.  Then, process extra "important" options */
	while (signed_length > 0  &&  ntohopt(&option, &data) != -1) {
		if ((signed_length -= option.len) < 0) {
			PPP_DEBUG_CHECKS("IPCP NAK: bad header length");
			free_p(data);
			return -1;
		}
		if ( option.type > IPCP_OPTION_LIMIT ) {
			PPP_DEBUG_CHECKS("IPCP NAK: option out of range");
		} else if ( option.type < last_option
		 || !(local_p->work.negotiate & (1 << option.type)) ) {
			if (local_p->work.negotiate & (1 << option.type)) {
				PPP_DEBUG_CHECKS("IPCP NAK: option out of order");
				free_p(data);
				return -1;		/* was requested */
			}
			local_p->work.negotiate |= (1 << option.type);
			last_option = IPCP_OPTION_LIMIT + 1;
		} else {
			last_option = option.type;
		}
		if ( ( result = ipcp_check( &data, ipcp_p,
				local_p, &option, FALSE ) ) == -1 ) {
			PPP_DEBUG_CHECKS("IPCP NAK: ran out of data");
			free_p(data);
			return -1;
		}
		/* update the negotiation status */
		if ( result == CONFIG_REJ
		  && option.type <= IPCP_OPTION_LIMIT ) {
			local_p->work.negotiate &= ~(1 << option.type);
		}
	}
	PPP_DEBUG_CHECKS("IPCP NAK: valid");
	free_p(data);
	return 0;
}


/************************************************************************/
/* Process configuration reject sent by remote host */
static int
ipcp_reject(fsm_p, config, data)
struct fsm_s *fsm_p;
struct config_hdr *config;
struct mbuf *data;
{
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	struct ipcp_side_s *local_p = &(ipcp_p->local);
	int32 signed_length = config->len;
	struct option_hdr option;
	int last_option = 0;

	PPP_DEBUG_ROUTINES("ipcp_reject()");

	/* ID field must match last request we sent */
	if (config->id != fsm_p->lastid) {
		PPP_DEBUG_CHECKS("IPCP REJ: wrong ID");
		free_p(data);
		return -1;
	}

	/* Process in order, checking for errors */
	while (signed_length > 0  &&  ntohopt(&option, &data) != -1) {
		register int k;

		if ((signed_length -= option.len) < 0) {
			PPP_DEBUG_CHECKS("IPCP REJ: bad header length");
			free_p(data);
			return -1;
		}
		if ( option.type > IPCP_OPTION_LIMIT ) {
			PPP_DEBUG_CHECKS("IPCP REJ: option out of range");
		} else if (option.type < last_option
		 || !(local_p->work.negotiate & (1 << option.type))) {
			PPP_DEBUG_CHECKS("IPCP REJ: option out of order");
			free_p(data);
			return -1;
		}
		for ( k = option.len - OPTION_HDR_LEN; k-- > 0; ) {
			if ( pullchar(&data) == -1 ) {
				PPP_DEBUG_CHECKS("IPCP REJ: ran out of data");
				free_p(data);
				return -1;
			}
		}
		last_option = option.type;

		if ( option.type <= IPCP_OPTION_LIMIT ) {
			local_p->work.negotiate &= ~(1 << option.type);
		}
	}
	PPP_DEBUG_CHECKS("IPCP REJ: valid");
	free_p(data);
	return 0;
}


/************************************************************************/
/*			I N I T I A L I Z A T I O N			*/
/************************************************************************/

/* Reset configuration options before request */
static void
ipcp_reset(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p =	fsm_p->pdv;

	PPP_DEBUG_ROUTINES("ipcp_reset()");

	ASSIGN( ipcp_p->local.work, ipcp_p->local.want );
	ipcp_p->local.work.other = ipcp_p->remote.want.address;
	ipcp_p->local.will_negotiate |= ipcp_p->local.want.negotiate;

	ipcp_p->remote.work.negotiate = FALSE;
	ipcp_p->remote.will_negotiate |= ipcp_p->remote.want.negotiate;
}


/************************************************************************/
/* After termination */
static void
ipcp_stopping(fsm_p)
struct fsm_s *fsm_p;
{
	PPP_DEBUG_ROUTINES("ipcp_stopping()");
}


/************************************************************************/
/* Close IPCP */
static void
ipcp_closing(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p = 	fsm_p->pdv;

	/* free old slhc configuration, if any */
	slhc_free( ipcp_p->slhcp );
	ipcp_p->slhcp = NULL;

#ifdef notdef
	if (PPPtrace > 1)
		trace_log(PPPiface,"%s PPP/IPCP Drop route to peer (%s)",
			ifp->name,
			inet_ntoa(ipcp_p->local.work.other);

	rt_drop(ipcp_p->local.work.other, (unsigned int)32);
#endif
}


/************************************************************************/
/* configuration negotiation complete */
static void
ipcp_opening(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p = 	fsm_p->pdv;
	struct iface *ifp = 		fsm_p->ppp_p->iface;
	int32 address = ipcp_p->local.work.address;
	int rslots = 0;
	int tslots = 0;

	/* Set our IP address to reflect negotiated option */
	if (address != ifp->addr) {
		/* address not the same as last time */
		if (Ip_addr == 0L) {
			/* no global address */
			Ip_addr = address;
		} else if ( Ip_addr == ifp->addr ) {
			/* global was same as local; must be replaced */
			/* !!! TO DO: reset tcp connections */
			Ip_addr = address;
		}
		ifp->addr = address;

		if (PPPtrace > 1)
			trace_log(PPPiface,"%s PPP/IPCP Setting new IP address: %s",
				ifp->name,
				inet_ntoa(address));
	}

#ifdef notdef
	rt_add(ipcp_p->local.work.other, (unsigned int)32, (int32)0,
		ifp, (int32)1, (int32)0, (char)1);

	if (PPPtrace > 1)
		trace_log(PPPiface,"%s PPP/IPCP Add route to peer (%s)",
			ifp->name,
			inet_ntoa(ipcp_p->local.work.other);
#endif

	/* free old slhc configuration, if any */
	slhc_free( ipcp_p->slhcp );
	ipcp_p->slhcp = NULL;

	if (ipcp_p->local.work.negotiate & IPCP_N_COMPRESS) {
		rslots = ipcp_p->local.work.slots;
	}
	if (ipcp_p->remote.work.negotiate & IPCP_N_COMPRESS) {
		tslots = ipcp_p->remote.work.slots;
	}

	if ( rslots != 0 || tslots != 0 ) {
		ipcp_p->slhcp = slhc_init( rslots, tslots );

		if (PPPtrace > 1)
			trace_log(PPPiface,"%s PPP/IPCP Compression enabled;"
				" Recv slots = %d, flag = %x;"
				" Xmit slots = %d, flag = %x",
				ifp->name,
				rslots,
				ipcp_p->local.work.slot_compress,
				tslots,
				ipcp_p->remote.work.slot_compress);
	}
}


/************************************************************************/
/* Check the address against all other assigned addresses */
static int32
ipcp_addr_idle(addr)
int32 addr;
{
	struct iface *ifp;

	/* Check if peer IP address is already in use on another interface */
	/* !!! need to look at *remote* address, not local! */
	for (ifp=Ifaces; ifp != NULLIF; ifp = ifp->next) {
		if (ifp->addr == addr)
			return 0L;
	}
	return addr;
}


/************************************************************************/
/* Assign the next unused address from a pool */
static int32
ipcp_poolnext(ipcp_p)
struct ipcp_s *ipcp_p;
{
	int32 i = 1L + ipcp_p->peer_max - ipcp_p->peer_min;
	int32 nextaddr = 0L;

	while ( i-- > 0  &&  nextaddr == 0L ) {
		if (++ipcp_p->local.want.other < ipcp_p->peer_min
		 || ipcp_p->local.want.other > ipcp_p->peer_max)
			ipcp_p->local.want.other = ipcp_p->peer_min;

		nextaddr = ipcp_addr_idle(ipcp_p->local.want.other);
	}
	return(nextaddr);
}


/************************************************************************/
/* Check if we have a specific IP address to assign to remote peer host */
/* !!! TO DO: subnet mask, and routing */
static int32
ipcp_lookuppeer(peerid)
char *peerid;
{
	char *buf;
	int32 peer_addr = 0L;

	if (peerid == NULLCHAR)
		return 0L;

	if ( (buf = userlookup( peerid, NULLCHARP, NULLCHARP,
			NULL, &peer_addr )) != NULLCHAR ) {
		free(buf);
	}
	return(peer_addr);
}


/************************************************************************/
/* Prepare to begin configuration exchange */
static void
ipcp_starting(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p =		fsm_p->pdv;

	PPP_DEBUG_ROUTINES("ipcp_starting()");

	/* If not already set, and we know the name of the peer,
	 * look in login file for an address
	 */
	if ( ipcp_p->remote.want.address == 0L ){
		ipcp_p->remote.want.address
		= ipcp_lookuppeer(fsm_p->ppp_p->peername);
	}

	/* If available, get next address from PPP pool */
	if ((ipcp_p->remote.want.address == 0L)
	 && (ipcp_p->peer_min != 0L)) {
		ipcp_p->remote.want.address = ipcp_poolnext(ipcp_p);
	}

	ipcp_p->local.want.address = fsm_p->ppp_p->iface->addr;
}


/************************************************************************/
static void
ipcp_free(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p = fsm_p->pdv;

	slhc_free( ipcp_p->slhcp );
}


/* Initialize configuration structure */
void
ipcp_init(ppp_p)
struct ppp_s *ppp_p;
{
	struct fsm_s *fsm_p = &(ppp_p->fsm[IPcp]);
	struct ipcp_s *ipcp_p;

	PPPtrace = ppp_p->trace;
	PPPiface = ppp_p->iface;

	PPP_DEBUG_ROUTINES("ipcp_init()");

	fsm_p->ppp_p = ppp_p;
	fsm_p->pdc = &ipcp_constants;
	fsm_p->pdv =
	ipcp_p = callocw(1,sizeof(struct ipcp_s));

	/* Set option parameters to first request defaults */
	ASSIGN( ipcp_p->local.want, ipcp_default );
	ipcp_p->local.will_negotiate = ipcp_negotiate;

	ASSIGN( ipcp_p->remote.want, ipcp_default );
	ASSIGN( ipcp_p->remote.work, ipcp_default);
	ipcp_p->remote.will_negotiate = ipcp_negotiate;

	fsm_init(fsm_p);
}


@


1.8
log
@src0501
@
text
@d40 1
a40 1
static int16 ipcp_negotiate = IPCP_N_ADDRESS | IPCP_N_COMPRESS;
d49 8
a56 8
static int doipcp_local		__ARGS((int argc, char *argv[], void *p));
static int doipcp_open		__ARGS((int argc, char *argv[], void *p));
static int doipcp_pool		__ARGS((int argc, char *argv[], void *p));
static int doipcp_remote	__ARGS((int argc, char *argv[], void *p));

static int doipcp_address	__ARGS((int argc, char *argv[], void *p));
static int doipcp_compress	__ARGS((int argc, char *argv[], void *p));
static int doipcp_default	__ARGS((int argc, char *argv[], void *p));
d58 1
a58 1
static void ipcp_option __ARGS((struct mbuf **bpp,
d62 2
a63 2
			struct mbuf **copy_bpp));
static void ipcp_makeoptions __ARGS((struct mbuf **bpp,
d65 2
a66 2
			int16 negotiating));
static struct mbuf *ipcp_makereq __ARGS((struct fsm_s *fsm_p));
d68 1
a68 1
static int ipcp_check __ARGS((struct mbuf **bpp,
d72 1
a72 1
			int request));
d74 1
a74 1
static int ipcp_request	__ARGS((struct fsm_s *fsm_p,
d76 2
a77 2
			struct mbuf *data));
static int ipcp_ack	__ARGS((struct fsm_s *fsm_p,
d79 2
a80 2
			struct mbuf *data));
static int ipcp_nak	__ARGS((struct fsm_s *fsm_p,
d82 2
a83 2
			struct mbuf *data));
static int ipcp_reject	__ARGS((struct fsm_s *fsm_p,
d85 1
a85 1
			struct mbuf *data));
d87 1
a87 1
static void ipcp_reset	__ARGS((struct fsm_s *fsm_p));
d89 3
a91 3
static int32 ipcp_addr_idle __ARGS((int32 addr));
static int32 ipcp_lookuppeer __ARGS((char *peerid));
static int32 ipcp_poolnext __ARGS((struct ipcp_s *ipcp_p));
d93 2
a94 2
static void ipcp_starting __ARGS((struct fsm_s *fsm_p));
static void ipcp_stopping __ARGS((struct fsm_s *fsm_p));
d96 2
a97 2
static void ipcp_closing __ARGS((struct fsm_s *fsm_p));
static void ipcp_opening __ARGS((struct fsm_s *fsm_p));
d99 1
a99 1
static void ipcp_free	__ARGS((struct fsm_s *fsm_p));
d427 1
a427 1
int16 negotiating;
d617 1
a617 1
	int16 desired;				/* desired to negotiate */
d926 1
a926 1
			inet_ntoa(ipcp_p->local.work.other));
d971 1
a971 1
			inet_ntoa(ipcp_p->local.work.other));
@


1.7
log
@src0922
@
text
@d209 1
a209 1
			tprintf("None");
d211 2
a212 2
			tprintf("%s thru ", inet_ntoa(ipcp_p->peer_min));
			tprintf("%s\n", inet_ntoa(ipcp_p->peer_max));
d218 1
a218 1
		tprintf(Badhost,argv[1]);
d228 1
a228 1
		tprintf("Pool count %s (%d) must be > 0\n");
d262 1
a262 1
		tprintf("%s\n", inet_ntoa(side_p->want.address));
d269 1
a269 1
		tprintf(Badhost,argv[1]);
d290 1
a290 1
				tprintf("TCP header compression enabled; "
d296 1
a296 1
				tprintf("0x%04x\n", side_p->want.compression);
d300 1
a300 1
			tprintf("None\n");
d311 1
a311 1
				tprintf( "slots must be in range 1 to 255" );
d326 1
a326 1
		tprintf("allow tcp none\n");
@


1.6
log
@src0609
@
text
@a21 2
#include "ppplcp.h"
#include "ppppap.h"
d24 1
a99 1
static void ipcp_init	__ARGS((struct ppp_s *ppp_p));
d160 1
a160 1
	register struct ppp_s *ppp_p = ifp->extension;
a161 1
	ipcp_init(ppp_p);
d376 1
a376 1
	log(-1, "    making IP source address: %s",
d378 1
a378 1
	log(-1, "    making IP destination address %s",
d389 1
a389 1
	log(-1, "    making IP compression 0x%04x",
d398 1
a398 1
	log(-1, "    with IP compression slots %d, flag %x",
d408 1
a408 1
	log(-1, "    making unimplemented type %d", o_type);
d482 1
a482 1
	log(-1, "    checking IP source address: %s",
d484 1
a484 1
	log(-1, "    checking IP destination address %s",
d532 1
a532 1
	log(-1, "    checking IP compression 0x%04x",
d559 1
a559 1
	log(-1, "    with IP compression slots %d, flag %x",
d643 1
a643 1
	log(-1, "IPCP REQ: result %s, option %d, length %d",
a900 83
static int32
ipcp_addr_idle(addr)
int32 addr;
{
	struct iface *ifp;

	/* Check if peer IP address is already in use on another interface */
	for (ifp=Ifaces; ifp != NULLIF; ifp = ifp->next) {
		if (ifp->addr == addr)
			return 0L;
	}
	return addr;
}


/************************************************************************/
static int32
ipcp_poolnext(ipcp_p)
struct ipcp_s *ipcp_p;
{
	int32 i = 1L + ipcp_p->peer_max - ipcp_p->peer_min;
	int32 nextaddr = 0L;

	while ( i-- > 0  &&  nextaddr == 0L ) {
		if (++ipcp_p->local.want.other < ipcp_p->peer_min
		 || ipcp_p->local.want.other > ipcp_p->peer_max)
			ipcp_p->local.want.other = ipcp_p->peer_min;

		nextaddr = ipcp_addr_idle(ipcp_p->local.want.other);
	}
	return(nextaddr);
}


/************************************************************************/
/* Check if we have a specific IP address to assign to remote peer host */
static int32
ipcp_lookuppeer(peerid)
char *peerid;
{
	char *buf;
	int32 peer_addr = 0L;

	if (peerid == NULLCHAR)
		return 0L;

	if ( (buf = userlookup( peerid, NULLCHARP, NULLCHARP,
			NULL, &peer_addr )) != NULLCHAR ) {
		free(buf);
	}
	return(peer_addr);
}


/************************************************************************/
/* Prepare to begin configuration exchange */
static void
ipcp_starting(fsm_p)
struct fsm_s *fsm_p;
{
	struct lcp_s *lcp_p = 		fsm_p->ppp_p->fsm[Lcp].pdv;
	struct pap_s *pap_p = 		fsm_p->ppp_p->fsm[Pap].pdv;
	struct ipcp_s *ipcp_p =		fsm_p->pdv;

	PPP_DEBUG_ROUTINES("ipcp_starting()");

	/* If not already set, and we required authentication,
	 * look in FTPUSER file
	 */
	if ((ipcp_p->remote.want.address == 0L)
	 && (lcp_p->local.want.negotiate & LCP_N_AUTHENT)) {
		ipcp_p->remote.want.address = ipcp_lookuppeer(pap_p->peername);
	}

	/* If used, get next address from PPP pool */
	if ((ipcp_p->remote.want.address == 0L)
	 && (ipcp_p->peer_min != 0L)) {
		ipcp_p->remote.want.address = ipcp_poolnext(ipcp_p);
	}
}


/************************************************************************/
d917 4
a920 1
	struct iface *ifp = 		fsm_p->ppp_p->iface;
d922 1
d924 1
a924 1
		log(-1,"%s: PPP/IPCP Drop route to peer (%s)",
d929 1
d941 1
d946 2
a947 1
	if (ipcp_p->local.work.address != ifp->addr) {
d949 2
a950 1
			Ip_addr = ipcp_p->local.work.address;
d952 3
a954 4
			/* We just are not what we used to be (sigh) */
			/* Quash anyone who thinks otherwise */
			ipcp_closing(fsm_p);
			Ip_addr = ipcp_p->local.work.address;
d956 1
a956 1
		ifp->addr = ipcp_p->local.work.address;
d959 1
a959 1
			log(-1,"%s: PPP/IPCP Saving new IP addr: %s",
d961 1
a961 1
				inet_ntoa(ipcp_p->local.work.address));
d964 1
d969 1
a969 1
		log(-1,"%s: PPP/IPCP Add route to peer (%s)",
d972 1
d976 1
d989 1
a989 1
			log(-1,"%s: PPP/IPCP Compression enabled;"
d1002 87
d1100 1
a1100 1
static void
d1104 1
a1104 1
	struct fsm_s *fsm_p;
d1108 1
a1111 4
	if (ppp_p->fsm[IPcp].pdv != NULL)
		return;		/* already initialized */

	fsm_p = &(ppp_p->fsm[IPcp]);
@


1.5
log
@src0423
@
text
@d52 1
d55 1
a57 2
static int doipcp_address	__ARGS((int argc, char *argv[], void *p));
static int doipcp_pool		__ARGS((int argc, char *argv[], void *p));
a92 1
static void ipcp_start	__ARGS((struct fsm_s *fsm_p));
d94 3
d118 2
a119 1
	ipcp_start,
d121 1
a121 1
	ipcp_opening,
d131 1
a131 1
/****************************************************************************/
d136 1
d169 1
a169 1
int
d181 1
a181 1
int
d189 1
a189 1
	doppp_open( argc, argv, p );
d198 44
a241 1
int
d253 1
a349 44
/* Set a pool of peer addresses for PPP interface */
static int
doipcp_pool(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	int32 pool_addr;
	int pool_cnt;

	if (argc < 2) {
		if ( ipcp_p->peer_min == 0L ) {
			tprintf("None");
		} else {
			tprintf("%s thru ", inet_ntoa(ipcp_p->peer_min));
			tprintf("%s\n", inet_ntoa(ipcp_p->peer_max));
		}
		return 0;
	}

	if ((pool_addr = resolve(argv[1])) == 0L) {
		tprintf(Badhost,argv[1]);
	}

	/* May specify a consecutive range of addresses; otherwise assume 1 */
	if (argc < 3)
		pool_cnt = 1;
	else
		pool_cnt = (int)strtol( argv[2], NULLCHARP, 0 );

	if (pool_cnt <= 0) {
		tprintf("Pool count %s (%d) must be > 0\n");
		return -1;
	}

	ipcp_p->peer_min = pool_addr;
	ipcp_p->peer_max = pool_addr + pool_cnt - 1;
	return 0;
}


/************************************************************************/
d961 1
a961 1
ipcp_start(fsm_p)
d968 1
a968 1
	PPP_DEBUG_ROUTINES("ipcp_start()");
d979 2
a980 1
	if (ipcp_p->peer_min != 0L) {
d983 10
@


1.4
log
@src0420
@
text
@d1029 1
a1029 1
		ifp, (int32)1, (int32)0, (char)1,0);
@


1.3
log
@src0318
@
text
@d1029 1
a1029 1
		ifp, (int32)1, (int32)0, (char)1);
@


1.2
log
@src0308
@
text
@d4 6
a9 18
 *	12-89	-- Katie Stevens (dkstevens@@ucdavis.edu)
 *		   UC Davis, Computing Services
 *	PPP.04	02-90	[ks] make automatic route entry a private route
 *	PPP.07	04-90	[ks] make IP addr negotiation independent of
 *			     whether host is active or passive open
 *			     thanks to Brad Clements, bkc@@omnigate.clarkson.edu
 *			     dont bring up IP unless both addrs are known
 *	PPP.08	05-90	[ks] IP compr: we request means we want to rcv compr;
 *			     remote requests means we should xmt compr TCP.
 *			     improve PPP trace reporting
 *	PPP.09	05-90	[ks] add UPAP auth protocol
 *	PPP.10	07-90	[ks] make ppp open/close/reset work properly
 *			     add peerID-to-IPaddr lookup table
 *			     add peer IP lookup pool
 *	PPP.13	08-90	[ks] add timestamp on PPP link open
 *	PPP.14	08-90	[ks] change UPAP to PAP for consistency with RFC1172
 *			     make IPCP timeout configurable
 *	PPP.15	09-90	[ks] update to KA9Q NOS v900828
a15 2
#include "files.h"
#include "netuser.h"
a16 1
/*#include "proc.h"*/
d18 1
a18 4
#include "pktdrvr.h"
#include "ip.h"
#include "tcp.h"
#include "slcomp.h"
d20 6
a25 7
#include "slip.h"
#include "proc.h"

extern int32 Ip_addr;

/* Counter for PPP id field */
extern unsigned char Pppid;
a26 2
/* PPP tracing */
extern int Ppptrace;
d28 46
a73 8
static void ipcp_open __ARGS((struct slip *sp));
static int ipcp_addr_idle __ARGS((int32 addr));
static int32 ipcp_lookuppeer __ARGS((char *peerid));
static int32 ipcp_poolnext __ARGS((struct ipcppool *poolp));
static void ipcp_reset_tcp __ARGS((struct slip *sp));

static int ipcp_sendreq __ARGS((struct slip *sp));
static struct mbuf *ipcp_makereq __ARGS((struct ipcpctl *ipcpiop));
d75 2
a76 1
static void ipcp_rcvack __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d78 2
a79 1
static void ipcp_rcvnak __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d81 2
a82 1
static void ipcp_rcvrej __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d84 2
a85 1
static void ipcp_rcvreq __ARGS((struct slip *sp, struct cnfhdr *rcnf,
d87 2
a88 3
static void ipcp_rcvtermack __ARGS((struct slip *sp));
static void ipcp_rcvtermreq __ARGS((struct slip *sp, struct cnfhdr *rcnf));
static void ipcp_shutdown __ARGS((struct slip *sp));
d90 10
a99 8
static int ipcp_chkack __ARGS((struct slip *sp, struct cnfhdr *ackcnf,
			struct mbuf *data));
static int ipcp_chknak __ARGS((struct slip *sp, struct cnfhdr *nakcnf,
			struct mbuf *data));
static int ipcp_chkrej __ARGS((struct slip *sp, struct cnfhdr *rejcnf,
			struct mbuf *data));
static void ipcp_chkreq __ARGS((struct slip *sp, struct cnfhdr *reqcnf,
			struct mbuf *data));
a100 2
static void ipcp_timeout __ARGS((void *vp));
static void ipcp_timer __ARGS((struct slip *sp));
d102 24
a125 2
static int ipcp_sendreply __ARGS((struct slip *sp, char code,
			unsigned char id, struct mbuf *data));
a126 4
/* In PPPLCP.C */
/* Possible IPCP states same as possible LCP states */
extern char *LCPStates[];
extern char *LCPCodes[];
d130 21
a150 1
/* Initialize IP Control Protocol state machine for config exchange */
d152 4
a155 2
ipcp_start(sp)
struct slip *sp;
d157 7
a163 34
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1, "ipcp_start()");

	pppiop = sp->pppio;
	lcpiop = &(pppiop->lcpio);
	ipcpiop = &(pppiop->ipcpio);

	/* Just finished LCP negotiation; prepare for IPCP negotiation */
	pppiop->state = PPP_IPCP;
	ipcp_reset(sp);
	/* Can set peer_addr with 'ppp peer' command */
	ipcpiop->attempt_dest = ipcpiop->peer_addr;
	/* If not already set, can lookup PAP peer ID in PPPHOSTS file */
	if ((ipcpiop->peer_addr == 0L) &&
	    (lcpiop->lclparm.auth_type == PAP_AUTH_TYPE)) {
		ipcpiop->attempt_dest = ipcp_lookuppeer(lcpiop->pap_user);
	}
	/* If still not set, can get next address from PPP pool */
	if ((ipcpiop->peer_addr == 0L) &&
	    (ipcpiop->peer_pool != NULLPOOL)) {
		ipcpiop->attempt_dest = ipcp_poolnext(ipcpiop->peer_pool);
	}
	if (ipcpiop->attempt_dest == 0L)
		ipcpiop->accept_addrs = 1;

	if (!ipcpiop->active) {
		/* Passive open; wait until remote host attempts connection */
		ipcpiop->ipcp_state = IPCP_LISTEN;
		return 0;
	}
d165 9
a173 3
	/* Active open; begin IPCP configuration negotiation */
	ipcpiop->ipcp_state = IPCP_CLOSED;	
	return(ipcp_sendreq(sp));
a175 1
/*******************************************/
a176 1
/* Close the IP connection from local side */
d178 4
a181 2
ipcp_close(sp)
struct slip *sp;
d183 1
a183 2
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d185 1
a185 2
	if (Ppptrace > 5)
		log(-1,"ipcp_close()");
d187 2
a188 6
	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	if ((ipcpiop->ipcp_state == IPCP_CLOSED) ||
	    (ipcpiop->ipcp_state == IPCP_LISTEN))   {
		/* Already closed */
		return 0;
a189 16

	if (Ppptrace > 1)
		log(-1,"%s: PPP/IPCP IP Closing",sp->iface->name);

	/* Reset IP connections on this interface */
	ipcp_reset_tcp(sp);
	/* Remove routing entry from route table */
	rt_drop(ipcpiop->attempt_dest, (unsigned int)32);

	/* Set a timer against our request to shutdown */
	ipcp_timer(sp);
	/* Ask remote host to shutdown */
	ipcpiop->ipcp_state = IPCP_TERMINATE;
	ipcpiop->ack_retry = 0;
	if (ipcp_sendreply(sp, TERMINATE_REQ, 0, NULLBUF) == 0)
		pwait(ipcpiop);
a192 16
/* Initialize our IPCP configuration options to compiled default options */
void
ipcp_init(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
	struct timer *t;

	if (Ppptrace > 5)
		log(-1, "ipcp_init()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	t = &(ipcpiop->ipcp_tm);
	ipcpiop->ipcp_state = IPCP_CLOSED;
d194 10
a203 8
	/* Set option parameters to first request defaults */
	ipcpiop->peer_addr = 0L;
	ipcpiop->neg_ip_compr = 0;
	ipcpiop->ip_compr_type = DEF_IP_COMPR;
	/* Initialize timer */
	set_timer(t,IPCP_TIMEOUT*1000L);
	ipcp_timer(sp);
	stop_timer(&(ipcpiop->ipcp_tm));
a204 2
	ipcp_reset(sp);
}
d206 6
a211 4
/* IP Control configuration negotiation complete */
static void
ipcp_open(sp)
struct slip *sp;
d213 2
a214 2
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d216 6
a221 16
	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* Mark IPCP layer as open */
	if (Ppptrace)
		log(-1,"%s: PPP/IPCP IP Open",sp->iface->name);
	ipcpiop->ipcp_state = IPCP_OPEN;

	/* Make sure we found out IP address at each end */
	if ((ipcpiop->attempt_src != ipcpiop->accept_dest)
		|| (ipcpiop->attempt_src == 0L)) {
		if (Ppptrace)
			log(-1,"Couldnt negotiate local IP addr for interface %s",
				sp->iface->name);
		ipcp_shutdown(sp);
		return;
d223 2
a224 7
	if ((ipcpiop->attempt_dest != ipcpiop->accept_src)
		|| (ipcpiop->attempt_dest == 0L)) {
		if (Ppptrace)
			log(-1,"Couldnt negotiate remote peer IP addr for interface %s",
				sp->iface->name);
		ipcp_shutdown(sp);
		return;
d226 3
a228 43

	/* Set IP compression to reflect negotiated option */
	if (ipcpiop->lcl_ip_compr == IPCP_VJCOMPR) {
		sp->escaped |= PPP_RCV_VJCOMPR;
		if (Ppptrace > 1)
			log(-1,"    Begin Van Jacobson TCP/IP header compression on incoming packets");
	} else {
		sp->escaped &= ~PPP_RCV_VJCOMPR;
	}
	if (ipcpiop->rem_ip_compr == IPCP_VJCOMPR) {
		sp->escaped |= PPP_XMT_VJCOMPR;
		if (Ppptrace > 1)
			log(-1,"    Begin Van Jacobson TCP/IP header compression on outgoing packets");
	} else {
		sp->escaped &= ~PPP_XMT_VJCOMPR;
	}
	if ((sp->escaped & (PPP_RCV_VJCOMPR | PPP_XMT_VJCOMPR)) != 0) {
		/* Initialize compression control structure */
		sp->slcomp = (struct slcompress *)mallocw(sizeof(struct slcompress));
		sl_compress_init(sp->slcomp);
	}

	/* Set our IP address to reflect negotiated option */
	if (ipcpiop->attempt_src != sp->iface->addr) {
		if (Ip_addr == 0L)
			Ip_addr = ipcpiop->attempt_src;
		sp->iface->addr = ipcpiop->attempt_src;
		if (Ppptrace > 1)
			log(-1,"    Saving new IP addr for interface %s: %s",
				sp->iface->name,inet_ntoa(sp->iface->addr));
	}

	/* Add point-to-point route to remote PPP host */
	rt_add(ipcpiop->attempt_dest, (unsigned int)32, (int32)0,
		sp->iface, (int32)1, (int32)0, (char)1);
	if (Ppptrace > 1)
		log(-1,"    Add route to peer (%s) on interface %s",
			inet_ntoa(ipcpiop->attempt_dest),
			sp->iface->name);

/* Allow any queued IP traffic */
	pppiop->state = PPP_OPEN;
	pppiop->upsince = time(0L);
a230 7
/* Reset IPCP configuration options for initial request */
int
ipcp_reset(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d232 48
a279 16
	if (Ppptrace > 5)
		log(-1, "ipcp_reset()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	ipcpiop->ipcp_state = IPCP_CLOSED;
	ipcpiop->ack_retry = 0;
	ipcpiop->active = pppiop->lcpio.active;

	/* Set up for IP addr exchange; attempt values set in ipcp_start() */
	ipcpiop->attempt_addrs = 1;
	ipcpiop->attempt_src = Ip_addr;
	/* If we dont know our IP address, or if we dont know IP addr */
	/* of the remote host, accept address assignment from remote  */
	if ((ipcpiop->attempt_src == 0L)||(ipcpiop->attempt_dest == 0L)) {
		ipcpiop->accept_addrs = 1;
d281 2
a282 1
		ipcpiop->accept_addrs = 0;
a283 11
	ipcpiop->accept_src = ipcpiop->attempt_dest;
	ipcpiop->accept_dest = ipcpiop->attempt_src;

	/* Reset IP header compression options to first request defaults */
	ipcpiop->attempt_ip_compr = ipcpiop->neg_ip_compr;
	ipcpiop->lcl_ip_compr = ipcpiop->ip_compr_type;
	ipcpiop->accept_ip_compr = 1;
	ipcpiop->rem_ip_compr = DEF_IP_COMPR;
	sp->escaped &= ~PPP_RCV_VJCOMPR;
	sp->escaped &= ~PPP_XMT_VJCOMPR;

a286 1
/*******************************************/
d289 4
a292 2
ipcp_addr_idle(addr)
int32 addr;
d294 1
a294 2
	struct iface *ifp;
	struct pppctl *pppiop;
d296 2
a297 12
	/* Check if peer IP address is already in use on another interface */
	for (ifp=Ifaces; ifp != NULLIF; ifp = ifp->next) {
		if ((Slip[ifp->xdev].iface == ifp) &&
		    (Slip[ifp->xdev].type == CL_PPP)) {
			pppiop = Slip[ifp->xdev].pppio;
			if ((pppiop->ipcpio.ipcp_state != IPCP_CLOSED) &&
			    (pppiop->ipcpio.attempt_dest == addr))        {
				return 0;
			}
		}
	}
	return 1;
a299 9
/* Check if we have a specific IP address to assign to remote peer host */
static int32
ipcp_lookuppeer(peerid)
char *peerid;
{
	FILE *peerfp;
	char buf[128];
	char *cp;
	int32 peer_addr = 0L;
d301 19
a319 17
	if ((peerfp = fopen(Userfile, READ_TEXT)) == NULLFILE)
		return 0L;
	while (fgets(buf,128,peerfp) != NULLCHAR) {
		if(buf[0] == '#')
			continue;	/* Comment */
		if((cp = strchr(buf,' ')) == NULLCHAR)
			/* Bogus entry */
			continue;
		*cp++ = '\0';		/* Now points to password */
		if(stricmp(peerid,buf) == 0) {
			++cp;
			if ((cp = strrchr(cp,' ')) == NULLCHAR)
				/* No IP address given */
				break;
			++cp;
			peer_addr = resolve(cp);
			break;		/* Found user name */
d321 1
a322 3
	fclose(peerfp);
	return(peer_addr);
}
d324 3
a326 6
static int32
ipcp_poolnext(poolp)
struct ipcppool *poolp;
{
	int i;
	int32 nextaddr = 0L;
d328 5
a332 3
	for (i=0; i<=(poolp->peer_max - poolp->peer_min); ++i) {
		if (ipcp_addr_idle(poolp->peer_next))
			nextaddr = poolp->peer_next;
d334 4
a337 4
		if (poolp->peer_next == poolp->peer_max)
			poolp->peer_next = poolp->peer_min;
		else
			++poolp->peer_next;
d339 3
a341 4
		if (nextaddr != 0L)
			break;
	}
	return(nextaddr);
d344 5
a348 1
/* Close all TCP connections in preparation for PPP link shutdown */
d350 6
a355 2
ipcp_reset_tcp(sp)
struct slip *sp;
d357 44
a400 19
	register struct iface *ifp;
	register int i;
	register struct tcb *tcb;
	register struct route *rp;

	ifp = sp->iface;

	for(i=0;i<NTCB;i++){
		for(tcb=Tcbs[i];tcb != NULLTCB;tcb = tcb->next) {
			if ((tcb->state == TCP_LISTEN) &&
			    (tcb->flags.clone == 1))      {
				/* Leave servers alone */
				continue;
			}
			rp = rt_lookup(tcb->conn.remote.address);
			if (rp->iface == ifp) {
				/* Reset active connections */
				reset_tcp(tcb);
			}
d402 12
d415 2
a416 2
	/* Wait 1sec for any replys or static */
	pause(1000L);
a418 1
/****************************************************************************/
d420 7
a426 4
/* Send our IPCP configuration request */
static int
ipcp_sendreq(sp)
struct slip *sp;
d428 1
a428 3
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
	struct mbuf *bp;
d430 1
a430 2
	if (Ppptrace > 5)
		log(-1,"ipcp_sendreq()");
d432 6
a437 14
	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* Get a packet with our configuration request */
	bp = ipcp_makereq(ipcpiop);

	/* Start timer against wait for reply to our config request */
	ipcp_timer(sp);

	/* Send IPCP configuration request to remote host */
	pppiop->state = PPP_IPCP;
	if (ipcpiop->ipcp_state != IPCP_ACK_SENT)
		ipcpiop->ipcp_state = IPCP_REQ_SENT;
	return(ipcp_sendreply(sp, CONFIG_REQ, 0, bp));
a439 1
/*******************************************/
d441 2
d444 2
a445 2
ipcp_makereq(ipcpiop)
struct ipcpctl *ipcpiop;
d447 1
a447 2
	register char *cp;
	struct mbuf *bp;
d450 1
a450 40
	if (Ppptrace > 5)
		log(-1,"    ipcp_makereq()");

	/* Request our preferred IP control options */
	if (ipcpiop->attempt_addrs) {
		/* Attempt to negotiate IP addrs */
		if (Ppptrace > 5) {
			log(-1,"    asking for src addr: %s",
				inet_ntoa(ipcpiop->attempt_src));
			log(-1,"    asking for dest addr: %s",
				inet_ntoa(ipcpiop->attempt_dest));
		}
		if ((bp = alloc_mbuf(10)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = IP_ADDRS;
		*cp++ = 10;
		cp = put32(cp, ipcpiop->attempt_src);
		cp = put32(cp, ipcpiop->attempt_dest);
		bp->cnt += 10;
		append(&req_bp, bp);
	}

	/* IP header compression */
	if (ipcpiop->attempt_ip_compr) {
		if (Ppptrace > 5) {
			log(-1,"    asking for IP compression: %x",
				ipcpiop->lcl_ip_compr);
		}

		/* Attempt to negotiate IP compression */
		if ((bp = alloc_mbuf(4)) == NULLBUF)
			return NULLBUF;
		cp = bp->data;
		*cp++ = IP_COMPR_TYPE;
		*cp++ = 4;
		put16(cp, ipcpiop->lcl_ip_compr);
		bp->cnt += 4;
		append(&req_bp, bp);
	}
d452 2
a453 1
	/* Return our config request */
a456 1
/****************************************************************************/
d458 40
a497 23
/* Remote host ACKed our configuration request */
static void
ipcp_rcvack(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1, "ipcp_rcvack()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	stop_timer(&ipcpiop->ipcp_tm);

	switch(ipcpiop->ipcp_state) {
	case IPCP_REQ_SENT:
		/* Make sure ACK is proper */
		if (ipcp_chkack(sp, rcnf, data) != -1) {
			/* Remote host accepted our request */
			ipcpiop->ipcp_state = IPCP_ACK_RCVD;
d500 8
a507 10
		/* Still need to settle request from remote host */
		ipcp_timer(sp);
		break;

	case IPCP_ACK_SENT:
		/* Make sure ACK is proper */
		if (ipcp_chkack(sp, rcnf, data) == -1) {
			/* Error in ACK from remote host */
			/* Wait for another ACK, then send another request */
			ipcp_timer(sp);
d509 2
a510 2
			/* IPCP negotiation complete */
			ipcp_open(sp);
a511 1
		break;
d513 7
a519 47
	case IPCP_ACK_RCVD:
	case IPCP_OPEN:
		/* Something went wrong; restart negotiations */
		free_p(data);	
		ipcp_reset(sp);
		ipcp_sendreq(sp);
		break;
	case IPCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request */
		free_p(data);
		break;
	case IPCP_CLOSED:
	case IPCP_LISTEN:
	default:
		/* Confusion; shutdown the connection */
		free_p(data);
		ipcp_shutdown(sp);
		break;
	}
}

/* Remote host NAKed our configuration request */
static void
ipcp_rcvnak(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1, "ipcp_rcvnak()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	stop_timer(&ipcpiop->ipcp_tm);

	switch(ipcpiop->ipcp_state) {
	case IPCP_REQ_SENT:
	case IPCP_ACK_SENT:
		/* Update our config request to reflect NAKed options */
		if (ipcp_chknak(sp, rcnf, data) == -1) {
			/* Bad NAK packet */
			/* Wait for another; resend request on timeout */
			ipcp_timer(sp);
d521 2
a522 2
			/* Send updated config request */
			ipcp_sendreq(sp);
d526 51
a576 6
	case IPCP_ACK_RCVD:
	case IPCP_OPEN:
		/* Something went wrong; restart negotiations */
		free_p(data);	
		ipcp_reset(sp);
		ipcp_sendreq(sp);
d578 1
a578 7
	case IPCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request */
		free_p(data);
		break;
	case IPCP_CLOSED:
	case IPCP_LISTEN:
d580 1
a580 3
		/* Confusion; shutdown the connection */
		free_p(data);
		ipcp_shutdown(sp);
d582 5
a587 1
}
d589 2
a590 12
/* Remote host rejected our configuration request */
static void
ipcp_rcvrej(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
struct mbuf *data;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1, "ipcp_rcvrej()");
d592 5
a596 15
	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	stop_timer(&ipcpiop->ipcp_tm);

	switch(ipcpiop->ipcp_state) {
	case IPCP_REQ_SENT:
	case IPCP_ACK_SENT:
		/* Update our config request to reflect rejected options */
		if (ipcp_chkrej(sp, rcnf, data) == -1) {
			/* Bad reject packet */
			/* Wait for another; resend request on timeout */
			ipcp_timer(sp);
		} else {
			/* Send updated config request */
			ipcp_sendreq(sp);
d598 1
a598 1
		break;
d600 1
a600 20
	case IPCP_ACK_RCVD:
	case IPCP_OPEN:
		/* Something went wrong; restart negotiations */
		free_p(data);	
		ipcp_reset(sp);
		ipcp_sendreq(sp);
		break;
	case IPCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request */
		free_p(data);
		break;
	case IPCP_CLOSED:
	case IPCP_LISTEN:
	default:
		/* Confusion; shutdown the connection */
		free_p(data);
		ipcp_shutdown(sp);
		break;
	}
d603 7
a609 5
/* Process configuration request sent by remote host */
static void
ipcp_rcvreq(sp, rcnf, data)
struct slip *sp;
struct cnfhdr *rcnf;
d612 7
a618 2
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d620 2
a621 2
	if (Ppptrace > 5)
		log(-1, "ipcp_rcvreq()");
d623 33
a655 2
	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
d657 5
a661 11
	switch(ipcpiop->ipcp_state) {
	case IPCP_LISTEN:	/* Normal event */
	case IPCP_ACK_SENT:	/* Unexpected event */
	case IPCP_OPEN:		/* Unexpected event */
		/* Reset IPCP state machine for configuration negotiation */
		ipcp_reset(sp);
		/* Send our configuration request */	
		ipcp_sendreq(sp);
		/* Evaluate configuration request from remote host */
		ipcp_chkreq(sp, rcnf, data);
		break;
d663 3
a665 20
	case IPCP_ACK_RCVD:
		/* Stop timer against wait for config request */
		stop_timer(&(ipcpiop->ipcp_tm));
	case IPCP_REQ_SENT:
		/* Evaluate configuration request from remote host */
		ipcp_chkreq(sp, rcnf, data);
		break;

	case IPCP_TERMINATE:
		/* We are attempting to close connection; wait */
		/* for timeout to resend a Terminate Request   */
		free_p(data);
		break;

	case IPCP_CLOSED:
	default:
		/* We are closed; dont accept any connections */
		free_p(data);
		ipcp_shutdown(sp);
		break;
a666 9
}

/* Remote host closed connection */
static void
ipcp_rcvtermack(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d668 23
a690 21
	if (Ppptrace > 5)
		log(-1,"ipcp_rcvtermack()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	stop_timer(&(ipcpiop->ipcp_tm));

	switch(ipcpiop->ipcp_state) {
	case IPCP_OPEN:
		/* Remote host has abruptly closed connection */
		/* Reset IP connections on this interface */
		ipcp_reset_tcp(sp);
		/* Remove routing entry from route table */
		rt_drop(ipcpiop->attempt_dest, (unsigned int)32);
		/* Fall through */
	case IPCP_TERMINATE:
		/* Remote host has responded to our terminate request */
		if (Ppptrace)
			log(-1,"%s: PPP/IPCP IP Closed",sp->iface->name);
		if (ipcpiop->active)
			ipcpiop->ipcp_state = IPCP_CLOSED;
d692 1
a692 20
			ipcpiop->ipcp_state = IPCP_LISTEN;
		/* Prepare for next open */
		ipcp_reset(sp);
		/* We are done; signal anyone waiting for us to close */
		psignal(ipcpiop,0);
		break;
	case IPCP_REQ_SENT:
		/* Wait for timeout to restart attempt */
		break;
	case IPCP_ACK_SENT:
	case IPCP_ACK_RCVD:
		/* Something went wrong; restart negotiations */
		ipcp_reset(sp);
		ipcp_sendreq(sp);
		break;
	case IPCP_CLOSED:
	case IPCP_LISTEN:
	default:
		/* Unexpected, but no action needed */
		break;
a693 1
}
d695 4
a698 57
/* Remote peer requested that we close the IP layer */
static void
ipcp_rcvtermreq(sp, rcnf)
struct slip *sp;
struct cnfhdr *rcnf;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1, "ipcp_shutdown()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* Reset IP connections on this interface */
	ipcp_reset_tcp(sp);
	/* Remove routing entry from route table */
	rt_drop(ipcpiop->attempt_dest, (unsigned int)32);

	if (Ppptrace)
		log(-1,"%s: PPP/IPCP Peer requested close",sp->iface->name);
	ipcpiop->active = 0;
	ipcpiop->ipcp_state = IPCP_LISTEN;

	ipcp_sendreply(sp, TERMINATE_ACK, rcnf->id, NULLBUF);
	ipcp_reset(sp);
}

/* Shutdown the IPCP connection */
static void
ipcp_shutdown(sp)
struct slip *sp;
{
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 5)
		log(-1, "ipcp_shutdown()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* Reset IP connections on this interface */
	ipcp_reset_tcp(sp);
	/* Remove routing entry from route table */
	rt_drop(ipcpiop->attempt_dest, (unsigned int)32);

	if (Ppptrace)
		log(-1,"%s: PPP/IPCP IP Shutdown",sp->iface->name);
	if (ipcpiop->active)
		ipcpiop->ipcp_state = IPCP_CLOSED;
	else
		ipcpiop->ipcp_state = IPCP_LISTEN;

	ipcp_sendreply(sp,TERMINATE_ACK,0,NULLBUF);
	ipcp_reset(sp);
a700 1
/*******************************************/
d702 2
a703 1
/* Process configuration ACK send by remote host */
d705 3
a707 3
ipcp_chkack(sp, ackcnf, data)
struct slip *sp;
struct cnfhdr *ackcnf;
a709 3
	int ackerr = 0;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d711 7
a717 15
	struct opthdr reqopt;
	struct opthdr ackopt;
	int16 reqi16, acki16;
	int32 reqsrc_ip, reqdest_ip, acksrc_ip, ackdest_ip;

	if (Ppptrace > 5)
		log(-1,"ipcp_chkack()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* IPCP ID field must match last request we sent */
	if (ackcnf->id != ipcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper IPCP ACK; bad ID");
d723 1
a723 1
	req_bp = ipcp_makereq(ipcpiop);
d726 6
a731 43
	if (ackcnf->len != len_p(req_bp)) {
		ackerr = 1;
	}

	/* ACK must echo all options we requested in the order requested */
	while ((ntohopt(&reqopt, &req_bp) != -1) && (!ackerr)) {
		/* Get config option from ACK packet */
		if (ntohopt(&ackopt, &data) == -1) {
			/* Must have as many acked options as requested */
			ackerr = 1;
			break;
		}

		/* Config option headers must match */
		if ((ackopt.type != reqopt.type)
		   ||(ackopt.len != reqopt.len)) {
			ackerr = 1;
			break;
		}

		/* Config option values must match */
		switch(reqopt.type) {
		case IP_ADDRS:		/* IP address */
			/* Echoed values must match our request */
			reqsrc_ip = pull32(&req_bp);
			reqdest_ip = pull32(&req_bp);
			acksrc_ip = pull32(&data);
			ackdest_ip = pull32(&data);

			if (acksrc_ip != reqsrc_ip) {
				ackerr = 1;
				break;
			}
			if (ackdest_ip != reqdest_ip) {
				ackerr = 1;
				break;
			}
			break;

		case IP_COMPR_TYPE:	/* IP header compr */
			/* Echoed values must match our request */
			reqi16 = pull16(&req_bp);
			acki16 = pull16(&data);
d733 6
a738 2
			if (reqi16 != acki16) {
				ackerr = 1;
a740 4
			break;
		default:		/* Shouldnt happen */
			ackerr = 1;
			break;
a742 1

d746 1
a746 4
	if (ackerr) {
		/* Error in configuration ACK */
		if (Ppptrace > 5)
			log(-1,"improper IPCP ACK echo");
d750 1
a750 3
	/* ACK matches last request we made */
	if (Ppptrace > 5)
		log(-1,"valid IPCP ACK echo");
d754 3
a756 1
/* Process configuration NAK send by remote host */
d758 3
a760 3
ipcp_chknak(sp, nakcnf, data)
struct slip *sp;
struct cnfhdr *nakcnf;
d763 12
a774 19
	int nakerr = 0;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
	struct mbuf *req_bp;
	struct opthdr reqopt;
	struct opthdr nakopt;
	int16 naki16;
	int32 naksrc_ip, nakdest_ip;

	if (Ppptrace > 5)
		log(-1,"ipcp_chknak()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* IPCP ID field must match last request we sent */
	if (nakcnf->id != ipcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper IPCP NAK; bad ID");
d779 15
a793 33
	/* Get a copy of last request we sent */
	req_bp = ipcp_makereq(ipcpiop);

	/* Check overall buffer length */
	if (nakcnf->len > len_p(req_bp)) {
		/* Remote cant NAK more options than we requested */
		nakerr = 1;
	}

	/* NAKed options must be same order as our original request */
	while ((ntohopt(&nakopt, &data) != -1) && (!nakerr)) {
		/* Get config option from our request */
		if (ntohopt(&reqopt, &req_bp) == -1) {
			/* Must find match to each NAKed option */
			nakerr = 1;
			break;
		}

		/* Maybe not all options were NAKed; look */
		/* for matching option in our request     */
		while (reqopt.type != nakopt.type) {
			/* This option not NAKed; eat rest   */
			/* of option from the request packet */
			reqopt.len -= 2;
			while (reqopt.len--)
				pullchar(&req_bp);

			/* Get next config option from our request */
			if (ntohopt(&reqopt, &req_bp) == -1) {
				/* Must find match to each NAKed option */
				reqopt.type = 0;
				nakerr = 1;
				break;
d795 4
d800 5
a804 6

		/* Config option headers must match */
		if ((nakopt.type != reqopt.type)
		   ||(nakopt.len != reqopt.len)) {
			nakerr = 1;
			break;
d806 4
a809 38

		/* Remote host replaced our request with new suggestion */
		switch(reqopt.type) {
		case IP_ADDRS:		/* IP address */
			/* Get replacement value from NAK packet */
			naksrc_ip = pull32(&data);
			nakdest_ip = pull32(&data);
			/* Eat option value from our request packet */
			pull32(&req_bp);
			pull32(&req_bp);

			/* Ignore remote if we want to control addrs */
			if (ipcpiop->accept_addrs != 0) {
				/* We asked remote for our addresses */
				if (ipcpiop->attempt_src == 0L)
					ipcpiop->attempt_src = naksrc_ip;
				if (ipcpiop->attempt_dest == 0L)
					ipcpiop->attempt_dest = nakdest_ip;
			}
			break;
		case IP_COMPR_TYPE:	/* IP header compr */
			/* Get replacement value from NAK packet */
			naki16 = pull16(&data);
			/* Eat option value from our request packet */
			pull16(&req_bp);

			/* See if we can do this type of IP compression */
			if (naki16 == IPCP_VJCOMPR) {
				/* Ask for Van Jacobson TCP compression */
				ipcpiop->lcl_ip_compr = IPCP_VJCOMPR;
			} else {
				/* Cant do that type of compr, ask for none */
				ipcpiop->lcl_ip_compr = DEF_IP_COMPR;
			}
			break;
		default:		/* Shouldnt happen */
			nakerr = 1;
			break;
d812 1
a812 2

	free_p(req_bp);
a813 11

	if (nakerr) {
		/* Error in configuration NAK */
		if (Ppptrace > 5)
			log(-1,"improper IPCP NAK echo");
		return -1;
	}

	/* NAK matches last request we made */
	if (Ppptrace > 5)
		log(-1,"valid IPCP NAK echo");
d817 3
a819 1
/* Process configuration reject send by remote host */
d821 3
a823 3
ipcp_chkrej(sp, rejcnf, data)
struct slip *sp;
struct cnfhdr *rejcnf;
d826 11
a836 17
	int rejerr = 0;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
	struct mbuf *req_bp;
	struct opthdr reqopt;
	struct opthdr rejopt;

	if (Ppptrace > 5)
		log(-1,"ipcp_chkrej()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* IPCP ID field must match last request we sent */
	if (rejcnf->id != ipcpiop->lastid) {
		if (Ppptrace > 1)
			log(-1,"improper IPCP REJ; bad ID");
d841 3
a843 8
	/* Get a copy of last request we sent */
	req_bp = ipcp_makereq(ipcpiop);

	/* Check overall buffer length */
	if (rejcnf->len > len_p(req_bp)) {
		/* Remote cant NAK more options than we requested */
		rejerr = 1;
	}
d845 12
a856 7
	/* Rejected options must be same order as our original request */
	while ((ntohopt(&rejopt, &data) != -1) && (!rejerr)) {
		/* Get config option from our request */
		if (ntohopt(&reqopt, &req_bp) == -1) {
			/* Must find match to each NAKed option */
			rejerr = 1;
			break;
d858 5
a862 16

		/* Maybe not all options were NAKed; look */
		/* for matching option in our request     */
		while (reqopt.type != rejopt.type) {
			/* This option not NAKed; eat rest   */
			/* of option from the request packet */
			reqopt.len -= 2;
			while (reqopt.len--)
				pullchar(&req_bp);

			/* Get next config option from our request */
			if (ntohopt(&reqopt, &req_bp) == -1) {
				/* Must find match to each NAKed option */
				reqopt.type = 0;
				rejerr = 1;
				break;
d865 1
a865 16

		/* Config option headers must match */
		if ((rejopt.type != reqopt.type)
		   ||(rejopt.len != reqopt.len)) {
			rejerr = 1;
			break;
		}

		/* Remote host wont negotiate this option */
		switch(reqopt.type) {
		case IP_ADDRS:		/* IP address */
			/* Eat option values from each packet */
			pull32(&req_bp);
			pull32(&req_bp);
			pull32(&data);
			pull32(&data);
d867 2
a868 15
			/* Abandon attempt to negotiate IP addrs */
			ipcpiop->attempt_addrs = 0;
			break;
		case IP_COMPR_TYPE:	/* IP header compression */
			/* Eat option values from each packet */
			pull16(&req_bp);
			pull16(&data);

			/* Abandon attempt to negotiate IP compression */
			ipcpiop->attempt_ip_compr = 0;
			ipcpiop->lcl_ip_compr = DEF_IP_COMPR;
			break;
		default:		/* Shouldnt happen */
			rejerr = 1;
			break;
d871 1
a871 2

	free_p(req_bp);
d873 2
a875 6
	if (rejerr) {
		/* Error in configuration reject */
		if (Ppptrace > 5)
			log(-1,"improper IPCP REJ echo");
		return -1;
	}
d877 3
a879 5
	/* Reject matches last request we made */
	if (Ppptrace > 5)
		log(-1,"valid IPCP REJ echo");
	return 0;
}
d881 1
a881 1
/* Check IP Control options requested by the remote host */
d883 2
a884 4
ipcp_chkreq(sp, reqcnf, data)
struct slip *sp;
struct cnfhdr *reqcnf;
struct mbuf *data;
d886 7
a892 23
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
	int ilen;
	int16 i16;
	int32 reqsrc_ip, reqdest_ip;
	register char *cp;
	char cnf_accept = CONFIG_ACK;		/* Overall reply to request */
	char opt_accept;			/* Per option reply */
	struct opthdr reqopt;			/* Per option header storage */
	struct opthdr replyopt;			/* For building reply */
	struct mbuf *bp;			/* Ptr for building reply */
	struct mbuf *reply_bp = NULLBUF;	/* Actual reply packet */

	if (Ppptrace > 5)
		log(-1, "ipcp_chkreq()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* Make sure length in IPCP config header is realistic */
	ilen = len_p(data);
	if (ilen < reqcnf->len)
		reqcnf->len = ilen;
d894 3
a896 5
	/* Process options requested by remote host */
	while (reqcnf->len > 0) {
		/* Get header for next option */
		if (ntohopt(&reqopt, &data) == -1)
			break;
a897 16
		reqcnf->len -= reqopt.len;	/* Count bytes this option */
		reqopt.len -= 2;		/* Get data len this option */
		opt_accept = CONFIG_ACK;	/* Assume will accept option */

		switch(reqopt.type) {
		case IP_ADDRS:		/* IP address */
			if (Ppptrace > 5)
				log(-1, "remote asking to negotiate IP addrs");

			/* IP Addr is 2 32bit fields */
			ilen = 8;
			if (reqopt.len < ilen) {
				/* Short option data; reject packet */
				opt_accept = CONFIG_REJ;
				break;
			}
d899 6
a904 8
			/* Get proposed value from packet */
			reqsrc_ip = pull32(&data);
			reqdest_ip = pull32(&data);
			if (Ppptrace > 5) {
				log(-1,	"src IP addr: %s",
					inet_ntoa(reqsrc_ip));
				log(-1,	"dest IP addr: %s",
					inet_ntoa(reqdest_ip));
d906 7
a912 1
			}
a913 28
			/* Check requested IP addresses */
			if (ipcpiop->accept_addrs == 0) {
				/* Request okay if it matches what we want */
				if ((reqsrc_ip == ipcpiop->attempt_dest)
				    && (reqdest_ip == ipcpiop->attempt_src)) {
					opt_accept = CONFIG_ACK;	
					/* Save these values for later */
					ipcpiop->accept_src = reqsrc_ip;
					ipcpiop->accept_dest = reqdest_ip;
					break;
				}
				if ((reqsrc_ip == ipcpiop->accept_src)
				    && (reqdest_ip == ipcpiop->accept_dest)) {
					/* We already NAKed these once */
					opt_accept = CONFIG_REJ;
					break;
				}

				/* Cant accept suggestion of remote host */
				opt_accept = CONFIG_NAK;
				/* Save these values in case remote insists */
				ipcpiop->accept_src = reqsrc_ip;
				ipcpiop->accept_dest = reqdest_ip;
				/* Tell remote what to request instead */
				reqsrc_ip = ipcpiop->attempt_dest;
				reqdest_ip = ipcpiop->attempt_src;
				break;
			}
d915 7
a921 7
			/* Make sure remote is not repeating itself */
			if ((reqsrc_ip == ipcpiop->accept_src)
			    && (reqdest_ip == ipcpiop->accept_dest)) {
				/* We already NAKed these once */
				opt_accept = CONFIG_REJ;
				break;
			}
d923 4
a926 53
			/* Save these values for later */
			ipcpiop->accept_src = reqsrc_ip;
			ipcpiop->accept_dest = reqdest_ip;
			/* Remote host may request IP addrs */
			if(reqsrc_ip == 0L) {
				/* Remote host request its IP addr */
				if (ipcpiop->attempt_dest == 0L) {
					/* We dont have an addr for remote */
					opt_accept = CONFIG_REJ;
					break;
				} else {
					/* Give IP addr to remote peer */
					opt_accept = CONFIG_NAK;
					reqsrc_ip = ipcpiop->attempt_dest;
				}
			} else {
				/* Remote host gave us its IP addr */
				if (ipcpiop->attempt_dest == 0L) {
					/* We need to know peer IP addr */
					ipcpiop->attempt_dest = reqsrc_ip;
				} else {
					/* We already know peer IP addr */
					if (reqsrc_ip != ipcpiop->attempt_dest) {
						opt_accept = CONFIG_NAK;
						reqsrc_ip = ipcpiop->attempt_dest;
					}
				}
			}
			if (reqdest_ip == 0L) {
				/* Remote host requested our IP addr */
				if (ipcpiop->attempt_src == 0L) {
					/* We dont know our IP addr */
					opt_accept = CONFIG_REJ;
					break;
				} else {
					/* Tell remote what our IP addr is */
					opt_accept = CONFIG_NAK;
					reqdest_ip = ipcpiop->attempt_src;
				}
			} else {
				/* Remote host gave us our IP addr */
				if (ipcpiop->attempt_src == 0L) {
					/* We need to know our IP addr */
					ipcpiop->attempt_src = reqdest_ip;
				} else {
					/* We already know our IP addr */
					if (reqdest_ip != ipcpiop->attempt_src) {
						opt_accept = CONFIG_NAK;
						reqdest_ip = ipcpiop->attempt_src;
					}
				}
			}
			break;
d928 4
a931 4
		case IP_COMPR_TYPE:	/* IP header compression */
			if (Ppptrace > 5) {
				log(-1, "remote asking to negotiate IP compression");
			}
a932 7
			/* IP compression type is a 16 bit field */
			ilen = 2;
			if (reqopt.len < ilen) {
				/* Short option; reject packet */
				opt_accept = CONFIG_REJ;
				break;
			}
d934 8
a941 8
			/* Get proposed value from packet */
			i16 = pull16(&data);
			if ((ipcpiop->accept_ip_compr == 0)
				&& (i16 != DEF_IP_COMPR)) {
				/* Not open for negotiation */
				opt_accept = CONFIG_REJ;
				break;
			}
d943 2
a944 13
			/* Check if requested compr type is acceptable */
			if (i16 == IPCP_VJCOMPR) {
				/* We can do Van Jacobson TCP header compr */
				opt_accept = CONFIG_ACK;
			} else {
				/* Dont know this compr type;
				 * suggest Van Jacobson TCP header compr
				 */
				opt_accept = CONFIG_NAK;
				i16 = IPCP_VJCOMPR;
			}
			ipcpiop->rem_ip_compr = i16;
			break;
d946 6
a951 9
		default:		/* Unknown option */
			if (Ppptrace > 5)
				log(-1,	"remote asking for unimplemented option: %x   len: %d",
					reqopt.type, reqopt.len);
			opt_accept = CONFIG_REJ;
			ilen = reqopt.len;
			if (len_p(data) < ilen)
				ilen = len_p(data);
			/* Data dequeued at echo time */
a952 8
			break;
		}
		if ((opt_accept == CONFIG_ACK) &&
		    (cnf_accept != CONFIG_ACK))
			/* This option was good, but a previous      */
			/* option was not. Return only those options */
			/* which are being nacked/rejected.          */
			continue;
d954 9
a962 13
		if (opt_accept == CONFIG_NAK) {
			if (cnf_accept == CONFIG_REJ)
				/* Return only those options */
				/* which are being rejected. */
				continue;
			if (cnf_accept == CONFIG_ACK) {
				/* Discard current list of good options */
				free_p(reply_bp);
				reply_bp = NULLBUF;
				/* Send a list of nacked options */
				cnf_accept = CONFIG_NAK;
			}
		}
d964 1
a964 9
		if (opt_accept == CONFIG_REJ) {
			if (cnf_accept != CONFIG_REJ) {
				/* Discard current list of good options */
				free_p(reply_bp);
				reply_bp = NULLBUF;
				/* Send a list of rejected options */
				cnf_accept = CONFIG_REJ;
			}
		}
d966 6
a971 26
		/* Add option response to the return list */
		replyopt.type = reqopt.type;
		replyopt.len = ilen + OPT_HDRLEN;
		if ((bp = htonopt(&replyopt)) == NULLBUF)
			break;
		append(&reply_bp,bp);
		if (ilen) {
			if ((bp = alloc_mbuf(ilen)) == NULLBUF)
				break;
			cp = bp->data;
			switch(ilen) {
			case 2:
				put16(cp,i16);
				bp->cnt += 2;
				break;
			case 8:
				cp = put32(cp, reqsrc_ip);
				cp = put32(cp, reqdest_ip);
				bp->cnt += 8;
				break;
			default:
				while (ilen--)
					bp->data[bp->cnt++] = pullchar(&data);
			}
			append(&reply_bp,bp);
		}
d974 3
a976 24
	/* Send ACK/NAK/REJ to remote host */
	if (cnf_accept == CONFIG_ACK) {
		if (Ppptrace > 1)
			log(-1, "accept all options requested by remote peer");

		/* Accept configuration requested by remote host */
		ipcp_sendreply(sp, CONFIG_ACK, reqcnf->id, reply_bp);
		if (ipcpiop->ipcp_state == IPCP_REQ_SENT) {
			ipcpiop->ipcp_state = IPCP_ACK_SENT;
		} else {
			/* PPP data link now ready for IP traffic */
			ipcp_open(sp);
		}
	} else {
		if (Ppptrace > 1)
			log(-1,"options requested by remote peer not accepted: %s",
				((cnf_accept==CONFIG_NAK) ? "NAK" : "REJ"));

		/* NAK/REJ config request made by remote host */
		ipcp_sendreply(sp, cnf_accept, reqcnf->id, reply_bp);

		/* Start timer against wait for amended config request */
		if (ipcpiop->ipcp_state == IPCP_ACK_RCVD)
			ipcp_timer(sp);
d978 18
a995 1
	free_p(data);
a997 1
/****************************************************************************/
d999 2
a1000 1
/* Timeout while waiting for reply from remote host */
d1002 2
a1003 2
ipcp_timeout(vp)
void *vp;
d1005 14
a1018 27
	struct slip *sp;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;

	if (Ppptrace > 1)
		log(-1, "ipcp_timeout()");

	/* Load pointers to interface that timed-out */
	sp = (struct slip *)vp;
	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);

	/* Attempt to get things going again */
	switch(ipcpiop->ipcp_state) {
	case IPCP_ACK_SENT:
		/* Remote host isnt listening to our request */
		ipcp_reset(sp);
	case IPCP_REQ_SENT:
	case IPCP_ACK_RCVD:
		if (!ipcpiop->active) {
			/* If passive open, we got a CONFIG_REQ from remote */
			/* host but no ACK in response to our CONFIG_REQ    */
			if (++ipcpiop->ack_retry > IPCP_RETRY_MAX) {
				/* Remote host doesnt seem to be listening */
				ipcp_shutdown(sp);
				break;
			}
d1020 25
a1044 4
		/* Timeout waiting for ACK to our request,         */
		/* or timeout waiting for request from remote host */
		ipcp_sendreq(sp);
		break;
d1046 2
a1047 22
	case IPCP_TERMINATE:
		/* Timeout waiting for terminate ACK; send another request */
		if (++ipcpiop->ack_retry > IPCP_TERM_RETRY) {
			/* No response to our polite request; give it up */
			if (Ppptrace)
				log(-1,"%s: PPP/IPCP IP Closed without reply from remote peer",sp->iface->name);
			if (ipcpiop->active)
				ipcpiop->ipcp_state = IPCP_CLOSED;
			else
				ipcpiop->ipcp_state = IPCP_LISTEN;

			ipcp_sendreply(sp,TERMINATE_ACK,0,NULLBUF);
			ipcp_reset(sp);
			tprintf("Still no response; marking IPCP layer as closed\n");
			psignal(ipcpiop,0);
		} else {
			/* Request remote host to close IP */
			tprintf("Timeout waiting for response to our IPCP terminate request\n");
			ipcp_timer(sp);
			ipcp_sendreply(sp, TERMINATE_REQ, 0, NULLBUF);
		}
		break;
d1049 9
a1057 7
	case IPCP_CLOSED:
	case IPCP_LISTEN:
	case IPCP_OPEN:
	default:
		/* Confusion; shutdown the connection */
		ipcp_shutdown(sp);
		break;
d1061 2
a1062 1
/* Set a timer in case an expected event does not occur */
d1064 2
a1065 2
ipcp_timer(sp)
struct slip *sp;
d1067 3
a1069 13
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
	struct timer *t;

	if (Ppptrace > 5)
		log(-1,"ipcp_timer()");

	pppiop = sp->pppio;
	ipcpiop = &(pppiop->ipcpio);
	t = &(ipcpiop->ipcp_tm);
	t->func = (void (*)())ipcp_timeout;
	t->arg = (void *)sp;
	start_timer(t);
a1071 1
/****************************************************************************/
d1073 4
a1076 7
/* Send an IPCP packet to the remote host */
static int
ipcp_sendreply(sp,code,id,data)
struct slip *sp;
char code;
unsigned char id;
struct mbuf *data;
d1078 4
a1081 2
	struct iface *iface;
	struct cnfhdr hdr;
d1083 1
a1083 10
	/* Load IPCP header values */
	hdr.code = code;
	switch(code) {
	case CONFIG_REQ:
	case TERMINATE_REQ:
		/* Save ID field for match aginst replies from remote host */
		sp->pppio->ipcpio.lastid = Pppid;
		/* Use a unique ID field value */
		hdr.id = Pppid++;
		break;
d1085 2
a1086 8
	case CONFIG_ACK:
	case CONFIG_NAK:
	case CONFIG_REJ:
	case TERMINATE_ACK:
	case CODE_REJ:
		/* Use ID sent by remote host */
		hdr.id = id;
		break;
d1088 5
a1092 7
	default:
		/* Shouldnt happen */
		if (Ppptrace)
			log(-1, "bogus code: %x\n", code);
		return -1;
	}
	hdr.len = len_p(data) + CNF_HDRLEN;
d1094 3
a1096 3
	/* Prepend IPCP header to packet data */
	if ((data = htoncnf(&hdr,data)) == NULLBUF)
		return -1;
d1098 3
a1100 55
	if (Ppptrace > 1)
		log(-1, "%s: PPP/IPCP Send: current state: %s   IPCP option: %s  id: %d  len: %d",
			sp->iface->name,
			LCPStates[sp->pppio->ipcpio.ipcp_state],
			LCPCodes[code],hdr.id,hdr.len);

	/* Send IPCP packet to remote host */
	sp->pppio->sndipcp++;
	iface = sp->iface;
	return( (*iface->output)
		(iface, NULLCHAR, NULLCHAR, PPP_IPCP_TYPE, data) );
}

/* Process incoming IPCP packet */
void
ipcpproc(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	struct slip *sp;
	struct cnfhdr hdr;

	sp = &Slip[iface->xdev];

	/* Extract IPCP header */
	ntohcnf(&hdr, &bp);
	hdr.len -= CNF_HDRLEN;			/* Length includes envelope */
	trim_mbuf(&bp, hdr.len);		/* Trim off FCS bytes */

	if (Ppptrace > 1)
		log(-1,	"%s: PPP/IPCP Recv: current state: %s   IPCP option: %s    id: %d   len: %d",
			iface->name,
			LCPStates[sp->pppio->ipcpio.ipcp_state],
			LCPCodes[hdr.code], hdr.id, hdr.len);

	/* Process IPCP packet data */
	switch(hdr.code) {
	case CONFIG_REQ:			/* Request of remote host */
		ipcp_rcvreq(sp, &hdr, bp);
		break;
	case CONFIG_ACK:			/* Remote accepted our req */
		ipcp_rcvack(sp, &hdr, bp);
		break;
	case CONFIG_NAK:			/* Remote adjusted our req */
		ipcp_rcvnak(sp, &hdr, bp);
		break;
	case CONFIG_REJ:			/* Remote rejected our req */
		ipcp_rcvrej(sp, &hdr, bp);
		break;
	case TERMINATE_REQ:			/* Remote request to close */
		ipcp_rcvtermreq(sp, &hdr);
		break;
	case TERMINATE_ACK:			/* Remote closed on request */
		ipcp_rcvtermack(sp);
		break;
d1102 1
a1102 11
	case CODE_REJ:
		if (Ppptrace)
			log(-1,"Unimplemented IPCP packet type: %x; dropping packet",hdr.code);
		free_p(bp);
		break;
	default:
		if (Ppptrace)
			log(-1,"Unknown IPCP packet type: %x; dropping packet",hdr.code);
		free_p(bp);
		break;
	}
d1104 2
@


1.1
log
@Initial revision
@
text
@d36 1
a36 1
#include "slcompre.h"
@
