head	1.19;
access;
symbols;
locks;
comment	@ * @;


1.19
date	93.05.06.10.09.59;	author karn;	state Exp;
branches;
next	1.18;

1.18
date	93.01.10.23.17.42;	author karn;	state Exp;
branches;
next	1.17;

1.17
date	92.10.16.16.15.32;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	92.10.07.19.28.11;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.06.07.08.52.14;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.05.15.10.01.02;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.05.01.08.22.42;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.04.29.11.50.46;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.04.19.07.00.34;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.04.03.23.58.12;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.04.01.13.37.34;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.03.29.03.10.32;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.03.27.12.59.22;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	91.06.01.05.03.14;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.05.24.19.58.16;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.04.18.09.21.54;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.02.11.20.14.22;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.02.22.38.40;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.30.22.41.42;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.19
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 * Interface driver for the VE3IFB 8530 card (PI card)
 * Copyright 1990 by Dave Perry, VE3IFB
 * Minor delinting - KA9Q 2/2/91
 *
 * Portions of this driver were derived from the Eagle card
 * driver by Art Goldman, WA3CVG. It has been very extensively
 * modified from his work, due to the addition of DMA support
 * and due to differences in the hardware.  The PI card is NOT
 * an Eagle card clone. It is an original design by Dave Perry,
 * VE3IFB.  Art's copyright notice follows:
 *
 *  Written by Art Goldman, WA3CVG - (c) Copyright 1987 All Rights Reserved
 *  Permission for non-commercial use is hereby granted provided this notice
 *  is retained.  For info call: (301) 997-3838.
 *
 */

#include <time.h>
#include <stdio.h>
#include <dos.h>
#include <bios.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "pktdrvr.h"
#include "netuser.h"
#include "pi.h"
#include "z8530.h"
#include "ax25.h"
#include "trace.h"
#include "pc.h"

#include "session.h"
#include "lapb.h"
#include "proc.h"
#include "ip.h"
#include "devparam.h"

#ifndef FP_OFF
#define FP_OFF(fp)	((unsigned)(fp))
#endif
#ifndef FP_SEG
#define FP_SEG(fp)	((unsigned)((unsigned long)(fp) >> 16))
#endif

static void xwrite_scc(struct pichan *hp,uint16 ctl,uint16 reg,
	uint16 val );
static char xread_scc(struct pichan *hp, uint16 ctl, char reg);
static int32 pi_ctl(struct iface *iface,int cmd,int set,int32 val);
static int pi_raw(struct iface *iface,struct mbuf *bp);
static int pi_stop(struct iface *iface);
static void rts(struct pichan *hp, uint16 x);
void setup_rx_dma(struct pichan *hp);
void setup_tx_dma(struct pichan *hp);
static void set_acc_delay(void);
static void tdelay(register struct pichan *hp,unsigned int time);

static struct PITAB Pi[PIMAX];	/* Device table - one entry per card */
static INTERRUPT (*pihandle[])() = {	/* handler interrupt vector table */
	pi0vec,
	pi1vec,
	pi2vec
};
static uint16 Page_regs[] = {
	0x87,0x83,0x81,0x82,0,0x8b,0x89,0x8a
};
static struct pichan Pichan[2*PIMAX];	/* channel table - 2 entries per card */
static uint16 pinbr;

extern uint16 acc_delay;	/* Delay for the 8530 chip access recovery time */


/* This calculates the constant to be used in the delay loops
 *  which satify the SCC's access recovery time.  It needs to be timed and
 *  calculated because a fixed value would not work in a 4.77mhz XT
 *  to a 40mhz 486 (and beyond).
 */
static void
set_acc_delay()
{	
	long starttime, endtime;
	int n;
	int ticks;

	starttime = bioscnt();
	for(n = 0; n < 10; n++)
		mloop();
	endtime = bioscnt();
	ticks = (int) (endtime - starttime);
	if(ticks == 0)
		ticks = 1;
	acc_delay = 61/ticks;
	if(acc_delay == 0)
		acc_delay = 1;
	fflush(stdout);
}

/* Write 8530 register */
static void
xwrite_scc(hp,ctl,reg,val)
register struct pichan *hp;
register uint16 ctl;
uint16 reg,val;
{
	wrtscc(hp->cardbase,ctl,reg,val);
}

/* Read 8530 register */
static char
xread_scc(hp,ctl,reg)
register struct pichan *hp;
register uint16 ctl;
char reg;
{
	return(rdscc(hp->cardbase,ctl,reg));
}

/* Setup 8253 chip for time delay */
static void
tdelay(hp,time)
register struct pichan *hp;
unsigned int time;		 /* Time to delay in milliseconds */
{
	int n,port;
	unsigned int t1;
	unsigned char sc;

	if(hp->base & 2){ /* If A channel */
		sc = SC1;
		t1 = time;
		port = hp->cardbase+TMR1;
	} else {
		sc = SC2;
		t1 = 10 * time; /* 10s of milliseconds for the B channel */
		port = hp->cardbase+TMR2;
	}

	/* Setup timer sc */
	outportb(hp->cardbase+TMRCMD, sc|LSB_MSB|MODE0);
	
	/* satisfy access time restriction */
	for(n=0; n<5;n++)
		;
	/* times 2 to make millisecs */
	outportb(port, (t1 << 1) & 0xFF);

	/* satisfy access time restriction */
	for(n=0; n<5;n++)
		;
	outportb(port, (t1 >> 7) & 0xFF);

	/* Enable correct int for timeout */
	xwrite_scc(hp,hp->base+CTL,R15,CTSIE);
	xwrite_scc(hp,hp->base+CTL,R1,EXT_INT_ENAB);
	xwrite_scc(hp,hp->base+CTL,R0,RES_EXT_INT);
}

/* Master interrupt handler.  One interrupt at a time is handled.
 * here. Service routines are called from here.
 */
INTERRUPT (far *(piint)(dev))()
int dev;
{
	register char st;
	register uint16 pcbase;
	struct pichan *hp;
	struct PITAB *pip;
	void b_rxint(),b_txint(),b_exint();
	void a_rxint(),a_txint(),a_exint();

	pip = &Pi[dev];
	pip->ints++;
	pcbase = pip->addr;

	/* Read interrupt status register (only valid from channel A)
	 * Process all pending interrupts in while loop
	 */
	hp = &Pichan[2 * dev];	/* Assume channel A */
	while((st = xread_scc(hp,pcbase+CHANA+CTL,R3)) != 0){
		if(st & CHARxIP){
			/* Channel A Rcv Interrupt Pending */
			hp = &Pichan[2 * dev];
			a_rxint(hp);
		} else if(st & CHATxIP){
			/* Channel A Transmit Int Pending */
			hp = &Pichan[2 * dev];
			a_txint(hp);
		} else if(st & CHAEXT){
			/* Channel A External Status Int */
			hp = &Pichan[2 * dev];
			a_exint(hp);
		} else if(st & CHBRxIP){
			/* Channel B Rcv Interrupt Pending */
			hp = &Pichan[(2 * dev)+1];
			b_rxint(hp);
		} else if(st & CHBTxIP){
			/* Channel B Transmit Int Pending */
			hp = &Pichan[(2 * dev)+1];
			b_txint(hp);
		} else if(st & CHBEXT){
			/* Channel B External Status Int */
			hp = &Pichan[(2 * dev)+1];
			b_exint(hp);
		}
		/* Reset highest interrupt under service */
		xwrite_scc(hp,hp->base+CTL,R0,RES_H_IUS);
	} /* End of while loop on int processing */
	return pip->chain ? pip->oldvec : NULL;
}

static void
a_exint(hp)
register struct pichan *hp;
{
	register uint16 cmd;
	char st;
	int32 t,ca;
	struct mbuf *bp;
	int i_state;

	i_state = dirps();

	st = xread_scc(hp,hp->base+CTL,R0);     /* Fetch status */

	/* reset external status latch */
	xwrite_scc(hp,CTL+hp->base,R0,RES_EXT_INT);
	cmd = hp->base+CTL;
	hp->exints++;

	if((hp->rstate >= ACTIVE) && (st & BRK_ABRT)){	
		setup_rx_dma(hp);
		hp->rstate = ACTIVE;
	}
	switch(hp->tstate){
	case ACTIVE:
		hp->tstate = FLAGOUT;
		tdelay(hp,hp->squeldelay);
		break;
	case FLAGOUT:
		if((bp = dequeue(&hp->sndq)) == NULLBUF){
			/* Nothing to send - return to receive mode */
			hp->tstate = IDLE;
			rts(hp,OFF);
			restore(i_state);
			return;
		}
		/* Get all chars */
		hp->txcnt = pullup(&bp,hp->sndbuf,hp->bufsiz);
		free_p(bp);	/* Truncate overly long packets */

		/* NOTE - fall through if more to send */
	case ST_TXDELAY:
		/* Disable DMA chan */
		outportb(DMA_MASK, DMA_DISABLE|hp->dmachan);

		/* Set up for TX dma */
		xwrite_scc(hp,cmd,R1,WT_FN_RDYFN|EXT_INT_ENAB);

		/* Setup DMA controller for tx */
		setup_tx_dma(hp);

		/* select transmit interrupts to enable */
		/* Allow DMA on chan */
		outportb(DMA_MASK,DMA_ENABLE|hp->dmachan);

		/* reset CRC, Txint pend*/
		xwrite_scc(hp,cmd,R0,RES_Tx_CRC|RES_Tx_P);

		/* allow Underrun int only */
		xwrite_scc(hp,cmd,R15,TxUIE);

		/* Enable TX DMA */
		xwrite_scc(hp,cmd,R1,WT_RDY_ENAB|WT_FN_RDYFN|EXT_INT_ENAB);

		/* Send CRC on underrun */
		xwrite_scc(hp,cmd,R0,RES_EOM_L);

		/* packet going out now */
		hp->tstate = ACTIVE;
		break;
	case DEFER:
		/* we have deferred prev xmit attempt
		 * See Intel Microcommunications Handbook, p2-308
		 */
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		if((xread_scc(hp,cmd,R0) & DCD) != 0){
			hp->tstate = DEFER;
			tdelay(hp,100);
			/* Defer until dcd transition or 100mS timeout */
			xwrite_scc(hp,CTL+hp->base,R15,CTSIE|DCDIE);
			restore(i_state);
			return;
		}
		/* Defer logic. Wait until deftime is in the past (so we
		 * defer to any overheard CTS messages) AND the p-persistence
		 * dice roll succeeds. The computation of ca allows for clock
		 * rollover (which happens every 49+ days).
		 */
		t = msclock();
		ca = hp->deftime - t;
		if(ca > 0){
			hp->tstate = DEFER;
			tdelay(hp,ca);
			restore(i_state);
			return;
		}
		hp->deftime = t;	/* Keep from getting too old */
		if((rand() & 0xff) > uchar(hp->persist)){
			hp->tstate = DEFER;
			tdelay(hp,hp->slotime);
			restore(i_state);
			return;
		}
		/* Assert RTS early minimize collision window */
		xwrite_scc(hp,cmd,R5,TxCRC_ENAB|RTS|Tx8);
		rts(hp,ON);	/* Transmitter on */
		hp->tstate = ST_TXDELAY;
		tdelay(hp,hp->txdelay);
		restore(i_state);
		return;
	} /* switch(hp->tstate) */

	restore(i_state);
} /* a_exint() */

/* Receive interrupt handler for the A channel 
 */
static void
a_rxint(hp)
register struct pichan *hp;
{
	register uint16 cmd;
	register uint16 bytecount;
	char rse;
	struct mbuf *bp;
	int i_state;
	
	hp->rxints++;
	cmd = hp->base+CTL;

	i_state = dirps();
	rse = xread_scc(hp,cmd,R1); /* Get special condition bits from R1 */
	if(rse & Rx_OVR){
		/* If receiver overrun */
		hp->rovers++;
		hp->rstate = RXERROR;
	}

	if(rse & END_FR){
		/* If end of frame */
		/* figure length of frame from 8237 */
		outportb(DMA_RESETFF,0); /* reset firstlast ff */
		bytecount = inportb(DMABASE+2*hp->dmachan+1);
		bytecount += inportb(DMABASE+2*hp->dmachan+1) << 8;
		bytecount = hp->bufsiz - 1 - bytecount;

		if((rse & CRC_ERR)||(hp->rstate > ACTIVE)||(bytecount < 10)){
			if((bytecount >= 10) && (rse & CRC_ERR))
				hp->crcerr++; /* Ignore noise */

			/* Reset buffer pointers */
			hp->rstate = ACTIVE;
			setup_rx_dma(hp);
		} else {
			/* Here we have a valid frame. Copy to buffer,
			 * minus 2 CRC bytes
			 */
			bytecount -= 2;
			if((bp = alloc_mbuf(bytecount+sizeof(struct iface *)))
			 != NULLBUF){
				bp->data += sizeof(struct iface *);
				bp->cnt = bytecount;
				memcpy(bp->data,hp->rcvbuf,bytecount);
				net_route(hp->iface,bp);
				hp->rxcnt = 0;
				hp->rxframes++;
			}
			/* packet queued - get buffer for next frame */
			setup_rx_dma(hp);
		} /* end good frame queued */
	} /* end EOF check */

	xwrite_scc(hp,hp->base+CTL,R0,ERR_RES);	/* error reset */
	restore(i_state);
}

void
a_txint(hp)
register struct pichan *hp;
{
	register uint16 cmd;
	int32 t,ca;
	struct mbuf *bp;
	int i_state;

	cmd = CTL+hp->base;

	i_state = dirps();
	switch(hp->tstate){
	case IDLE:
		/* Transmitter idle. Find a frame for transmission */
		if((bp = dequeue(&hp->sndq)) == NULLBUF){
			rts(hp,OFF);
			restore(i_state);
			return;
		}
		/* If a buffer to send, we drop thru here */
		hp->txcnt = pullup(&bp,hp->sndbuf,hp->bufsiz);
		free_p(bp);	/* Truncate overly long packet */
		hp->tcp = hp->sndbuf;
	case DEFER:
		/* we may have deferred prev xmit attempt */
		/* Check DCD - debounce it
		 * See Intel Microcommunications Handbook, p2-308
		 */
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		if((xread_scc(hp,cmd,R0) & DCD) != 0){
			hp->tstate = DEFER;
			tdelay(hp,100);
			/* defer until DCD transition or timeout */
			xwrite_scc(hp,cmd,R15,CTSIE|DCDIE);
			restore(i_state);
			return;
		}
		/* Defer logic. Wait until deftime is in the past (so we
		 * defer to any overheard CTS messages) AND the p-persistence
		 * dice roll succeeds. The computation of ca allows for clock
		 * rollover (which happens every 49+ days).
		 */
		t = msclock();
		ca = hp->deftime - t;
		if(ca > 0){
			hp->tstate = DEFER;
			tdelay(hp,ca);
			restore(i_state);
			return;
		}
		hp->deftime = t;	/* Keep from getting too old */
		if((rand() & 0xff) > uchar(hp->persist)){
			hp->tstate = DEFER;
			tdelay(hp,hp->slotime);
			restore(i_state);
			return;
		}

		/* Assert RTS early minimize collision window */
		xwrite_scc(hp,cmd,R5,TxCRC_ENAB|RTS|Tx8);
		rts(hp,ON);	/* Transmitter on */
		hp->tstate = ST_TXDELAY;
		tdelay(hp,hp->txdelay);
		restore(i_state);
		return;
	default:
		break;
	} /* end switch(hp->state) */

	restore(i_state);
} /*a_txint */

static void
b_rxint(hp)
register struct pichan *hp;
{
	register uint16 cmd;
	char rse;
	struct mbuf *bp;
	int i_state;

	hp->rxints++;
	cmd = CTL+hp->base;

	i_state = dirps();
	if((xread_scc(hp,cmd,R0)) & Rx_CH_AV){
		/* there is a char to be stored
		 * read special condition bits before reading the data char
		 */
		rse = xread_scc(hp,cmd,R1); /* get status byte from R1 */
		if(rse & Rx_OVR){
			/* Rx overrun - toss buffer */
			/* reset buffer pointers */
			hp->rcp = hp->rcvbuf;
			hp->rxcnt = 0;
			hp->rstate = RXERROR;	/* set error flag */
			hp->rovers++;
		} else if(hp->rxcnt >= hp->bufsiz){
			/* Too large -- toss entire frame */
			/* reset buffer pointers */
			hp->rcp = hp->rcvbuf;
			hp->rxcnt = 0;
			hp->rstate = TOOBIG;	/* when set, chars are not stored */
		}
		/* ok, we can store the received character now */
		if(hp->rstate == ACTIVE){	/* If no errors... */
			*hp->rcp++ = xread_scc(hp,cmd,R8); /* char to rcv buff */
			hp->rxcnt++;		   /* bump count */
		} else {
			/* got to empty FIFO */
			(void) xread_scc(hp,cmd,R8);
			xwrite_scc(hp,cmd,R0,ERR_RES);	/* reset err latch */
			hp->rstate = ACTIVE;
		}
	}

	if(rse & END_FR){
		/* END OF FRAME -- Make sure Rx was active */
		if(hp->rxcnt > 0){
			if((rse & CRC_ERR)||(hp->rstate > ACTIVE)||(hp->rxcnt < 10)){
				if((hp->rxcnt >= 10) && (rse & CRC_ERR))
					hp->crcerr++; /* Ignore noise */

				hp->rcp = hp->rcvbuf;
				hp->rxcnt = 0;
			} else {
				/* Here we have a valid frame */
				hp->rxcnt -= 2;  /* Toss 2 crc bytes */
				if((bp = alloc_mbuf(hp->rxcnt+sizeof(struct iface *)))
				 != NULLBUF){
					bp->data += sizeof(struct iface *);
					bp->cnt = hp->rxcnt;
					memcpy(bp->data,hp->rcvbuf,hp->rxcnt);
					net_route(hp->iface,bp);
					hp->rxframes++;
				}
				/* packet queued - get ready for next frame */
				hp->rcp = hp->rcvbuf;
				hp->rxcnt = 0;
			} /* end good frame queued */
		}  /* end check for active receive upon EOF */
		hp->rstate = ACTIVE;	/* and clear error status */
	} /* end EOF check */

	restore(i_state);
}

static void
b_txint(hp)
register struct pichan *hp;
{
	register uint16 cmd;
	char c;
	struct mbuf *bp;
	int i_state;

	cmd = CTL+hp->base;

	i_state = dirps();
	if(hp->tstate != DEFER && hp->tstate)
		hp->txints++;

	switch(hp->tstate){
	case CRCOUT:
		hp->tstate = FLAGOUT;
		tdelay(hp,hp->squeldelay);
		restore(i_state);
		return;
	case IDLE:
		/* Transmitter idle. Find a frame for transmission */
		if((bp = dequeue(&hp->sndq)) == NULLBUF){
			/* Nothing to send - return to receive mode
			 * Tx OFF now - flag should have gone
			 */
			rts(hp,OFF);
			restore(i_state);
			return;
		}
		hp->txcnt = pullup(&bp,hp->sndbuf,hp->bufsiz);	
		free_p(bp);	/* Truncate overly long packets */
		/* If a buffer to send, we drop thru here */
	case DEFER:	    /* we may have deferred prev xmit attempt */
		/* Check DCD - debounce it */
		/* See Intel Microcommunications Handbook, p2-308 */
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		if((xread_scc(hp,cmd,R0) & DCD) != 0){
			hp->tstate = DEFER;
			tdelay(hp,100);
			/* defer until DCD transition or timeout */
			xwrite_scc(hp,cmd,R15,CTSIE|DCDIE);
			restore(i_state);
			return;
		}
		/* p - persist calculation */
		if(inportb(hp->cardbase+TMR0) > hp->persist){
			inportb(hp->cardbase+TMR0); /* Discard MSB */
			hp->tstate = DEFER;
			tdelay(hp,hp->slotime);
			restore(i_state);
			return;
		}
		inportb(hp->cardbase+TMR0); /* Discard MSB */

		rts(hp,ON);   /* Transmitter on */
		hp->tstate = ST_TXDELAY;
		tdelay(hp,hp->txdelay);
		restore(i_state);
		return;

	case ACTIVE:
		/* Here we are actively sending a frame */
		if(hp->txcnt-- != 0){
			c = *hp->tcp++;
			/* next char is gone */
			xwrite_scc(hp,cmd,R8,c);
			/* stuffing a char satisfies Interrupt condition */
		} else {
			/* No more to send */
			if((xread_scc(hp,cmd,R0) & 0x40)){
				/* Did we underrun? */
				/* unexpected underrun */
				hp->tunders++;
				xwrite_scc(hp,cmd,R0,SEND_ABORT);
				hp->tstate = FLAGOUT;
				tdelay(hp,hp->squeldelay);
				restore(i_state);
				return;
			}
			hp->tstate = UNDERRUN; /* Now we expect to underrun */
			/* Send flags on underrun */
			if(hp->speed){ /* If externally clocked */
				xwrite_scc(hp,cmd,R10,CRCPS|NRZI);
			} else {
				xwrite_scc(hp,cmd,R10,CRCPS);
			}
			xwrite_scc(hp,cmd,R0,RES_Tx_P); /* reset Tx Int Pend */
		}
		restore(i_state);
		return;     /* back to wait for interrupt */
	} /* end switch */
	restore(i_state);
}

/* Pi SIO External/Status interrupts (for the B channel)
 * This can be caused by a receiver abort, or a Tx UNDERRUN/EOM.
 * Receiver automatically goes to Hunt on an abort.
 *
 * If the Tx Underrun interrupt hits, change state and
 * issue a reset command for it, and return.
 */
static void
b_exint(hp)
register struct pichan *hp;
{
	char st;
	register uint16 cmd;
	char c;
	struct mbuf *bp;
	int i_state;

	cmd = CTL+hp->base;
	hp->exints++;
	i_state = dirps();
	st = xread_scc(hp,cmd,R0);     /* Fetch status */
	/* reset external status latch */
	xwrite_scc(hp,cmd,R0,RES_EXT_INT);

	switch(hp->tstate){
	case ACTIVE:	/* Unexpected underrun */
		xwrite_scc(hp,cmd,R0,SEND_ABORT);
		hp->tstate = FLAGOUT;
		hp->tunders++;
		tdelay(hp,hp->squeldelay);
		restore(i_state);
		return;
	case UNDERRUN:
		hp->tstate = CRCOUT;
		restore(i_state);
		return;
	case FLAGOUT: 
		/* Find a frame for transmission */
		if((bp = dequeue(&hp->sndq)) == NULLBUF){
			/* Nothing to send - return to receive mode
			 * Tx OFF now - flag should have gone
			 */
			rts(hp,OFF);
			hp->tstate = IDLE;
			restore(i_state);
			return;
		}
		hp->txcnt = pullup(&bp,hp->sndbuf,hp->bufsiz);
                free_p(bp); /* Truncate overly long packets */
		hp->tcp = hp->sndbuf;

		/* Get next char to send */
		c = *hp->tcp++;
		hp->txcnt--;
		xwrite_scc(hp,cmd,R0,RES_Tx_CRC);/* reset for next frame */

		/* Send abort on underrun */
		if(hp->speed){ /* If externally clocked */
			xwrite_scc(hp,cmd,R10,CRCPS|NRZI|ABUNDER);
		} else {
			xwrite_scc(hp,cmd,R10,CRCPS|ABUNDER);
		}

		xwrite_scc(hp,cmd,R8,c);	/* First char out now */
		xwrite_scc(hp,cmd,R0,RES_EOM_L);/* Reset end of message latch */

		/* select transmit interrupts to enable */

		xwrite_scc(hp,cmd,R15,TxUIE);	/* allow Underrun int only */
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		xwrite_scc(hp,cmd,R1,TxINT_ENAB|EXT_INT_ENAB);  /* Tx/Extern ints on */

		hp->tstate = ACTIVE;	/* char going out now */
		restore(i_state);
		return;

	case DEFER:
		/* Check DCD - debounce it
		 * See Intel Microcommunications Handbook, p2-308
		 */
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		if((xread_scc(hp,cmd,R0) & DCD) != 0){
			hp->tstate = DEFER;
			tdelay(hp,100);
			/* defer until DCD transition or timeout */
			xwrite_scc(hp,cmd,R15,CTSIE|DCDIE);
			restore(i_state);
			return;
		}
		/* p - persist calculation */
		if(inportb(hp->cardbase+TMR0) > hp->persist){
			inportb(hp->cardbase+TMR0); /* Discard MSB */
			hp->tstate = DEFER;
			tdelay(hp,hp->slotime);
			restore(i_state);
			return;
		}
		inportb(hp->cardbase+TMR0); /* Discard MSB */

		rts(hp,ON);   /* Transmitter on */
		hp->tstate = ST_TXDELAY;
		tdelay(hp,hp->txdelay);
		restore(i_state);
		return;

	case ST_TXDELAY:

		/* Get next char to send */
		c = *hp->tcp++;
		hp->txcnt--;
		xwrite_scc(hp,cmd,R0,RES_Tx_CRC);/* reset for next frame */

		/* Send abort on underrun */
		if(hp->speed){ /* If externally clocked */
			xwrite_scc(hp,cmd,R10,CRCPS|NRZI|ABUNDER);
		} else {
			xwrite_scc(hp,cmd,R10,CRCPS|ABUNDER);
		}

		xwrite_scc(hp,cmd,R8,c);	/* First char out now */
		xwrite_scc(hp,cmd,R0,RES_EOM_L);/* Reset end of message latch */

		/* select transmit interrupts to enable */

		xwrite_scc(hp,cmd,R15,TxUIE);	/* allow Underrun int only */
		xwrite_scc(hp,cmd,R0,RES_EXT_INT);
		/* Tx/Extern ints on */
		xwrite_scc(hp,cmd,R1,TxINT_ENAB|EXT_INT_ENAB);

		hp->tstate = ACTIVE;	/* char going out now */
		restore(i_state);
		return;
	}

	/* Receive Mode only
	 * This triggers when hunt mode is entered, & since an ABORT
	 * automatically enters hunt mode, we use that to clean up
	 * any waiting garbage
	 */
	if((hp->rstate == ACTIVE) && (st & BRK_ABRT)){
		(void) xread_scc(hp,cmd,R8);
		(void) xread_scc(hp,cmd,R8);
		(void) xread_scc(hp,cmd,R8);
		hp->rcp = hp->rcvbuf;
		hp->rxcnt = 0;	      /* rewind on DCD transition */
	}
	restore(i_state);
}

/* SET Transmit or Receive Mode
 * Set RTS (request-to-send) to modem on Transmit
 */
static void
rts(hp,x)
register struct pichan *hp;
uint16 x;
{
	uint16 tc;
	long br;
	uint16 cmd;

	cmd = CTL+hp->base;

	/* Reprogram BRG and turn on transmitter to send flags */
	if(x == ON){	/* Turn Tx ON and Receive OFF */
		/* Exints off first to avoid abort int */
		xwrite_scc(hp,cmd,R15,0);
		xwrite_scc(hp,cmd,R3,Rx8);	/* Rx off */
		hp->rstate = IDLE;
		if(cmd & 2){ /* if channel a */
			/* Set up for TX dma */
			xwrite_scc(hp,cmd,R1,WT_FN_RDYFN|EXT_INT_ENAB);
		} else {
			xwrite_scc(hp,cmd,R1,0);	/* No interrupts */
		}
		if(hp->speed){			/* if internally clocked */
			br = hp->speed;		/* get desired speed */
			tc = (XTAL/br)-2;	/* calc 1X BRG divisor */
			xwrite_scc(hp,cmd,R12,tc&0xFF);     /* lower byte */
			xwrite_scc(hp,cmd,R13,(tc>>8)&0xFF);/* upper byte */
		}
		xwrite_scc(hp,cmd,R5,TxCRC_ENAB|RTS|TxENAB|Tx8|DTR);
		/* Transmitter now on */
	} else {	/* Tx OFF and Rx ON */
		hp->tstate = IDLE;
		xwrite_scc(hp,cmd,R5,Tx8|DTR); 	/*  TX off */

		if(hp->speed){		/* if internally clocked */
			/* Reprogram BRG for 32x clock for receive DPLL */
			/* BRG off, keep Pclk source */
			xwrite_scc(hp,cmd,R14,BRSRC);
			br = hp->speed;			/* get desired speed */
			/* calc 32X BRG divisor */
			tc = ((XTAL/32)/br)-2;
			xwrite_scc(hp,cmd,R12,tc&0xFF);	/* lower byte */
			xwrite_scc(hp,cmd,R13,(tc>>8)&0xFF);/* upper byte */
			/* SEARCH mode, BRG source */
			xwrite_scc(hp,cmd,R14,BRSRC|SEARCH);
			/* Enable the BRG */
			xwrite_scc(hp,cmd,R14,BRSRC|BRENABL);
		}
		/* Now, turn on the receiver and hunt for a flag */
		xwrite_scc(hp,cmd,R3,RxENABLE|RxCRC_ENAB|Rx8);
		hp->rstate = ACTIVE;		/* Normal state */

		if(cmd & 2){/* if channel a */
			setup_rx_dma(hp);
		} else {
			/* reset error bits */
		/*	xwrite_scc(hp,cmd,R0,ERR_RES); */
			/* reset buffer pointers */
			hp->rcp = hp->rcvbuf;
			hp->rxcnt = 0;
			xwrite_scc(hp,cmd,R1,(INT_ALL_Rx|EXT_INT_ENAB));
		}
		xwrite_scc(hp,cmd,R15,BRKIE);		/* allow ABORT int */
		/* Hold tx off long enough for other station to reply */
		hp->deftime = msclock() + hp->txdelay + 500;
	}
}

void
setup_rx_dma(hp)
register struct pichan *hp;
{
	int cmd;
	int dmaport;
	int i_state;

	cmd = hp->base+CTL;
	dmaport = DMABASE+2*hp->dmachan;

	i_state = dirps();
	if(!hp->rcvbuf){
		/* No rx buffer available */
		restore(i_state);
		return;
	}

	/* Get ready for RX DMA */
	xwrite_scc(hp,cmd,R1,WT_FN_RDYFN|WT_RDY_RT|INT_ERR_Rx|EXT_INT_ENAB);
	outportb(DMA_MASK, DMA_DISABLE|hp->dmachan); /* Disable DMA chan */
	/* Set DMA mode register to single transfers, incrementing address,
	 *	auto init, writes
	 */
	outportb(DMA_MODE,DMA_RX_MODE|hp->dmachan);

	outportb(Page_regs[hp->dmachan],hp->rcvphys >> 16);/* Store in  64K DMA page */
	outportb(DMA_RESETFF,0);	 /* reset byte pointer flipflop */
	/* Output buffer start (dest) address */
	outportb(dmaport,hp->rcvphys);
	outportb(dmaport,hp->rcvphys >> 8);
	/* output DMA maximum byte count */
	dmaport++;
	outportb(dmaport,hp->bufsiz - 1);
	outportb(dmaport, (hp->bufsiz - 1) >> 8);
	/* Unmask channel 1 (start DMA) */
	outportb(DMA_MASK, DMA_ENABLE|hp->dmachan); /* Enable DMA chan */

	/* If a packet is already coming in, this line is supposed
	 *	to mess up the crc to avoid receiving a partial packet
	 */
	xwrite_scc(hp,cmd,R0,RES_Rx_CRC);

	/* Enable RX dma */
	xwrite_scc(hp,cmd,R1,WT_RDY_ENAB|WT_FN_RDYFN|WT_RDY_RT|INT_ERR_Rx|EXT_INT_ENAB);

	restore(i_state);
}

void
setup_tx_dma(hp)
struct pichan *hp;
{
	int dmaport;
	uint16 length;
	int i_state;

	length = hp->txcnt - 1;
	dmaport = DMABASE + 2*hp->dmachan;
	i_state = dirps();

	outportb(DMA_MASK, DMA_DISABLE|hp->dmachan); /* Disable DMA chan */
	/* Set DMA mode register to single transfers, incrementing address,
	 *	no auto init, reads
 	 */
	outportb(DMA_MODE,DMA_TX_MODE|hp->dmachan);

	outportb(Page_regs[hp->dmachan],hp->sndphys >> 16); /* Store in 64K DMA page */
	outportb(DMA_RESETFF,0);	/* reset byte pointer flipflop */
	outportb(dmaport,hp->sndphys);	/* Output buffer start (source) address */
	outportb(dmaport,hp->sndphys >> 8);
	/* output byte count */
	dmaport++;
	outportb(dmaport,length);
	outportb(dmaport, length >> 8);

	restore(i_state);
}

/* Initialize pi controller parameters */
static int
scc_init(hp)
register struct pichan *hp;
{
	uint16 tc;
	long br;
	register uint16 cmd;
	int i_state;

	/* Initialize 8530 channel for SDLC operation */

	cmd = CTL+hp->base;
#ifdef	notdef
	printf("Pi: Initializing Channel %c - Base = %x\n",cmd&2?'A':'B',cmd&~CTL);
#endif
	i_state = dirps();

	switch(cmd & 2){
	case 2:
		xwrite_scc(hp,cmd,R9,CHRA);	/* Reset channel A */
		xwrite_scc(hp,cmd,R2,0xff); /* Initialize interrupt vector */
		break;
	case 0:
		xwrite_scc(hp,cmd,R9,CHRB);	/* Reset channel B */
		break;
	}

	/* Deselect all Rx and Tx interrupts */
	xwrite_scc(hp,cmd,R1,0);

	/* Turn off external interrupts (like CTS/CD) */
	xwrite_scc(hp,cmd,R15,0);

	/* X1 clock, SDLC mode */
	xwrite_scc(hp,cmd,R4,SDLC|X1CLK);

	/* Now some misc Tx/Rx parameters */
	/* CRC PRESET 1, NRZI Mode */
	if(hp->speed){
		xwrite_scc(hp,cmd,R10,CRCPS|NRZI);
		/* Tx Clk from BRG. Rcv Clk from DPLL, TRxC pin outputs DPLL */
		xwrite_scc(hp,cmd,R11,TCBR|RCDPLL|TRxCDP|TRxCOI);
	} else {
		xwrite_scc(hp,cmd,R10,CRCPS);
		/* Tx Clk from Trxcl. Rcv Clk from Rtxcl, TRxC pin is input */
		xwrite_scc(hp,cmd,R11,TCTRxCP);
	}

	/* Null out SDLC start address */
	xwrite_scc(hp,cmd,R6,0);

	/* SDLC flag */
	xwrite_scc(hp,cmd,R7,FLAG);

	/* Set up the Transmitter but don't enable it
	 *  DTR, 8 bit TX chars only - TX NOT ENABLED
	 */
	xwrite_scc(hp,cmd,R5,Tx8|DTR);

	/* Receiver - intial setup only - more later */
	xwrite_scc(hp,cmd,R3,Rx8); 	       /* 8 bits/char */

	/* Setting up BRG now - turn it off first */
	xwrite_scc(hp,cmd,R14,BRSRC);	     /* BRG off, but keep Pclk source */

	/* set the 32x time constant for the BRG in Receive mode */

	if(hp->speed){
		br = hp->speed; 	/* get desired speed */
		tc = ((XTAL/32)/br)-2;	/* calc 32X BRG divisor */
	} else {
		tc = 14;
	}

	xwrite_scc(hp,cmd,R12,tc&0xFF);      /* lower byte */
	xwrite_scc(hp,cmd,R13,(tc>>8)&0xFF); /* upper byte */

	/* Following subroutine sets up and ENABLES the receiver */
	rts(hp,OFF);		   /* TX OFF and RX ON */

	if(hp->speed){
		/* DPLL frm BRG, BRG src PCLK */
		xwrite_scc(hp,cmd,R14,BRSRC|SSBR);
	} else {
		/* DPLL frm rtxc,BRG src PCLK */
		xwrite_scc(hp,cmd,R14,BRSRC|SSRTxC);
	}
	xwrite_scc(hp,cmd,R14,BRSRC|SEARCH); /* SEARCH mode, keep BRG source */
	xwrite_scc(hp,cmd,R14,BRSRC|BRENABL);/* Enable the BRG */

	if(!(cmd & 2)) /* if channel b */
		xwrite_scc(hp,cmd,R1,(INT_ALL_Rx|EXT_INT_ENAB));

	xwrite_scc(hp,cmd,R15,BRKIE);	    /* ABORT int */

	/* Now, turn on the receiver and hunt for a flag */
	xwrite_scc(hp,cmd,R3,RxENABLE|RxCRC_ENAB|Rx8);

	restore(i_state);
	return 0;
}


/* Attach a PI interface to the system
 * argv[0]: hardware type, must be "pi"
 * argv[1]: I/O address, e.g., "0x300"
 * argv[2]: vector, e.g., "2"
 * argv[3]: dma channel (1..3)
 * argv[4]: mode, must be:
 *	    "ax25" (AX.25 UI frame format)
 * argv[5]: interface label, e.g., "pi0"
 * argv[6]: receiver packet buffer size in bytes
 * argv[7]: maximum transmission unit, bytes
 * argv[8]: channel A interface speed, e.g, "1200", 0 = ext. clock
 * argv[9]: channel B interface speed
 * argv[10]: First IP address, optional (defaults to Ip_addr);
 * argv[11]: Second IP address, optional (defaults to Ip_addr);
 */
int
pi_attach(argc,argv)
int argc;
char *argv[];
{
	register struct iface *if_pca,*if_pcb;
	struct pichan *hp;
	int dev;
	int n;
	char *cp;

	if(acc_delay == 0){	/* Only do this once */
		/* Adapt recovery time delay to processor speed */
		set_acc_delay();
	}
	/* Quick check to make sure args are good and mycall is set */
	if(setencap(NULLIF,argv[4]) == -1){
		printf("PI: Mode %s unknown for interface %s\n",
			argv[4],argv[5]);
		return -1;
	}
	if(if_lookup(argv[5]) != NULLIF){
		printf("PI: Interface %s already exists\n",argv[5]);
		return -1;
	}
	if(Mycall[0] == '\0'){
		printf("PI: Set mycall first\n");
		return -1;
	}
	/* Note: each card must have a unique address, IRQ and DMA */

	if(pinbr >= PIMAX){
		printf("PI: Maximum of %d PI cards supported\n",PIMAX);
		return -1;
	}
	dev = pinbr++;

	/* Initialize hardware-level control structure */
	Pi[dev].addr = htoi(argv[1]);
	Pi[dev].vec = atoi(argv[2]);
	if(strchr(argv[2],'c') != NULLCHAR)
		Pi[dev].chain = 1;
	else
		Pi[dev].chain = 0;

	/* Set up counter chip */
	/* 500 uS square wave */
	outportb(Pi[dev].addr+TMRCMD, SC0|LSB_MSB|MODE3);
	for(n=0; n<5;n++) /* satisfy access time restriction */
		;
	outportb(Pi[dev].addr+TMR0, 922 & 0xFF); 
	for(n=0; n<5;n++) /* satisfy access time restriction */
		;
	outportb(Pi[dev].addr+TMR0, 922 >> 8);
	for(n=0; n<5;n++) /* satisfy access time restriction */
		;

	/* Save original interrupt vector */
	Pi[dev].oldvec = getirq(Pi[dev].vec);

	/* Set new interrupt vector */
	if(setirq(Pi[dev].vec,pihandle[dev]) == -1){
		printf("PI: IRQ %u out of range\n",Pi[dev].vec);
		pinbr--;
		return -1;
	}

	if((atoi(argv[3]) < 1) || (atoi(argv[3]) > 3)){
		printf("PI: DMA %d out of range\n",atoi(argv[3]));
		pinbr--;
		return -1;
	}

	/* set params in pichan table for CHANNEL B */
	hp = &Pichan[2*dev+1];			/* pi1 is offset 1 */
	hp->dmachan = 0; /* Channel B does not have dma */
	hp->cardbase = Pi[dev].addr;
	hp->stata = Pi[dev].addr + CHANA + CTL;	/* permanent status */
	hp->statb = Pi[dev].addr + CHANB + CTL;	/* addrs for CHANA/B*/
	hp->speed = (uint16)atoi(argv[9]);
	hp->base = Pi[dev].addr + CHANB;
	hp->bufsiz = atoi(argv[6]);
	hp->tstate = IDLE;
	/* default channel access Params */
	hp->txdelay = 30;		/* 300 Ms */
	hp->persist = 128;		/* 50% persistence */
	hp->slotime = 30;		/* 300 Ms */
	hp->squeldelay = 3;		/* 30 Ms */

	xwrite_scc(hp,CTL+hp->stata,R9,FHWRES); 	/* Hardware reset */
						/* one time only */
	/* Disable interrupts with Master interrupt ctrl reg */
	xwrite_scc(hp,CTL+hp->stata,R9,0);

	scc_init(hp);

	/* Pre-allocate a receive DMA buffer */
	hp->rcvbuf = dma_malloc(&hp->rcvphys,hp->bufsiz);
	if(hp->rcvbuf == NULLCHAR){
		/* No memory, abort receiver */
		printf("PI: No memory available for receive buffer\n");
		/* Restore original interrupt vector */
		setirq(Pi[dev].vec,Pi[dev].oldvec);
		pinbr--;
		return -1;
	}
	/* Pre-allocate a transmit DMA buffer */
	hp->sndbuf = dma_malloc(&hp->sndphys,hp->bufsiz);
	if(hp->sndbuf == NULLCHAR){
		/* No memory, abort */
		printf("PI: No memory available for transmit buffer\n");
		/* Restore original interrupt vector */
		setirq(Pi[dev].vec,Pi[dev].oldvec);
		pinbr--;
		free(hp->rcvbuf);
		return -1;
	}
	hp->sndq = NULLBUF;

	/* set params in pichan table for CHANNEL A */
	hp = &Pichan[2*dev];	/* pi0a is offset 0 */
	hp->dmachan = (unsigned char)atoi(argv[3]);
	/* Verify dma channel */
	if(hp->dmachan < 0 || hp->dmachan >= 8){
		printf("PI: DMA channel %d out of range\n",hp->dmachan);
		free(hp->rcvbuf);
		free(hp->sndbuf);
		/* Restore original interrupt vector */
		setirq(Pi[dev].vec,Pi[dev].oldvec);
		pinbr--;
		return -1;
	}
	hp->cardbase = Pi[dev].addr;
	hp->speed = (uint16)atoi(argv[8]);
	hp->base = Pi[dev].addr + CHANA;
	hp->bufsiz = atoi(argv[6]);
	hp->tstate = IDLE;
	/* default channel access Params */
	hp->txdelay = 15;		/* 15 mS */
	hp->persist = 128;		/* 50% persistence */
	hp->slotime = 15;		/* 15 mS */
	hp->squeldelay = 1;		/* 1 mS */

	/* Pre-allocate a receive buffer */
	hp->rcvbuf = dma_malloc(&hp->rcvphys,hp->bufsiz);
	if(hp->rcvbuf == NULLCHAR){
		/* No memory, abort receiver */
		printf("PI: No memory available for receive buffers\n");
		/* Restore original interrupt vector */
		setirq(Pi[dev].vec,Pi[dev].oldvec);
		pinbr--;
		return -1;
	}
	hp->sndq = NULLBUF;

	/* Get a buffer for tx which does not cross a dma boundary */
	hp->sndbuf = dma_malloc(&hp->sndphys,hp->bufsiz);
	if(hp->sndbuf == NULLCHAR){
		printf("PI: No memory available for transmit buffer");
		/* Restore original interrupt vector */
		setirq(Pi[dev].vec,Pi[dev].oldvec);
		pinbr--;
		free(hp->rcvbuf);
		return -1;
	}
	/* Create interface structures and fill in details */
	if_pca = (struct iface *)callocw(1,sizeof(struct iface));
	if_pcb = (struct iface *)callocw(1,sizeof(struct iface));

	if_pca->addr = if_pcb->addr = Ip_addr;
	if(argc > 10)
		if_pca->addr = resolve(argv[10]);
	if(argc > 11)
		if_pcb->addr = resolve(argv[11]);

	if(if_pca->addr == 0 || if_pcb->addr == 0)
		printf("PI: No IP address!\n");

	/* Append "a" to interface associated with A channel */
	if_pca->name = malloc((unsigned)strlen(argv[5])+2);
	strcpy(if_pca->name,argv[5]);
	strcat(if_pca->name,"a");
	/* Append "b" to interface associated with B channel */
	if_pcb->name = malloc((unsigned)strlen(argv[5])+2);
	strcpy(if_pcb->name,argv[5]);
	strcat(if_pcb->name,"b");

	if_pcb->mtu = if_pca->mtu = atoi(argv[7]);
	if_pcb->ioctl = if_pca->ioctl = pi_ctl;
	if_pca->dev = 2*dev;			/* pi0a */
	if_pcb->dev = 2*dev + 1;		/* pi0b */
	if_pcb->stop = if_pca->stop = pi_stop;
	if_pcb->raw = if_pca->raw = pi_raw;

	/* Must succeed, was checked at top */
	setencap(if_pca,argv[4]);
	setencap(if_pcb,argv[4]);

	if(if_pcb->hwaddr == NULLCHAR)
		if_pcb->hwaddr = mallocw(AXALEN);
	memcpy(if_pcb->hwaddr,Mycall,AXALEN);
	if(if_pca->hwaddr == NULLCHAR)
		if_pca->hwaddr = mallocw(AXALEN);
	memcpy(if_pca->hwaddr,Mycall,AXALEN);

        Pichan[2*dev].iface = if_pca;
        Pichan[2*dev+1].iface = if_pcb;

	/* Link em in to the interface chain */
	if_pca->next = if_pcb;
	if_pcb->next = Ifaces;
	Ifaces = if_pca;

	scc_init(hp);
	/* master interrupt enable */
	xwrite_scc(hp,CTL+hp->base,R9,MIE|NV);

	/* Enable interrupt */
	maskon(Pi[dev].vec);

	cp = if_name(if_pca," tx");
	if_pca->txproc = newproc(cp,512,if_tx,0,if_pca,NULL,0);
	free(cp);
	cp = if_name(if_pcb," tx");
	if_pcb->txproc = newproc(cp,512,if_tx,0,if_pcb,NULL,0);
	free(cp);
	return 0;
}

/* Shut down interface */
int
pi_stop(iface)
struct iface *iface;
{
	uint16 dev;
	struct pichan *hp;

	dev = iface->dev;
	if(dev & 1) /* Because there are 2 devices per card */
		return 0;
	dev >>= 1;		/* Convert back into pi number */
	hp = &Pichan[2*dev];	/* pi0a is offset 0 */

	outportb(DMA_MASK, DMA_DISABLE|hp->dmachan); /* Disable DMA channel */

	/* Turn off interrupts */
	maskoff(Pi[dev].vec);

	/* Restore original interrupt vector */
	setirq(Pi[dev].vec,Pi[dev].oldvec);

	/* Force hardware reset */
	xwrite_scc(&Pichan[2*dev],CTL+Pi[dev].addr + CHANA,R9,FHWRES);

	return 0;
}

/* Send raw packet on pi card */
int
pi_raw(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	char kickflag;
	struct pichan *hp;
	int i_state;

	dump(iface,IF_TRACE_OUT,bp);
	iface->rawsndcnt++;
	iface->lastsent = secclock();

	hp = &Pichan[iface->dev];
	kickflag = (hp->sndq == NULLBUF) & (hp->sndbuf == NULLCHAR);
	enqueue(&hp->sndq,bp);
	hp->enqueued++;
	if(kickflag){
		/* simulate interrupt to xmit */
		switch(hp->base & 2){
		case 2:
			a_txint(hp);		/* process interrupt */
			break;
		case 0:
			i_state = dirps();
			if(hp->tstate == IDLE)
				b_txint(hp);
			restore(i_state);
			break;
		}
	}
	return 0;
}

/* display PI Channel stats */
int
dopistat()
{
	struct pichan *hp;
	int i;

	printf("PI Board Statistics:\n\n");
	printf("Base Addr  Rxints  Txints  Exints  TxFrms  RxFrms  Crcerr  RxOvrs  TxUndr \n");
	printf("---------  ------  ------  ------  ------  ------  ------  ------  ------ \n");
	for(i=0; i<pinbr*2; i++){
		hp = &Pichan[i];

		printf("0x%03x    % 8lu% 8lu% 8lu% 8u% 8u% 8u% 8u% 8u\nRcv State=%s ",
		 hp->base, hp->rxints, hp->txints, hp->exints, hp->enqueued,
		 hp->rxframes, hp->crcerr, hp->rovers, hp->tunders,
		 hp->rstate==0 ?
		  "IDLE" : hp->rstate==1 ?
		   "ACTIVE" : hp->rstate==2 ?
		    "RXERROR" : hp->rstate==3 ?
		     "RXABORT":"TOOBIG"
		);

		printf("Tstate = %s\n",
		 hp->tstate == 0 ?
		  "IDLE" : hp->tstate == 1 ?
		   "ACTIVE" : hp->tstate == 2 ?
		    "UNDERRUN" : hp->tstate == 3 ?
		     "FLAGOUT" : hp->tstate == 4 ?
		      "DEFER" : hp->tstate == 5 ?
		       "TXDELAY" : "CRCOUT"
		);
	}
	return 0;
}

/* Subroutine to set kiss params in channel tables */
int32
pi_ctl(iface,cmd,set,val)
struct iface *iface;
int cmd;
int set;
int32 val;
{
	struct pichan *hp;
	int32 t,ca;

	hp = &Pichan[iface->dev]; /* point to channel table */
	switch(cmd){
	case PARAM_TXDELAY:
		if(set)
			hp->txdelay = val;
		return hp->txdelay;
	case PARAM_PERSIST:
		if(set)
			hp->persist = val;
		return uchar(hp->persist);
	case PARAM_SLOTTIME:
		if(set)
			hp->slotime = val;
		return hp->slotime;
	case PARAM_TXTAIL:
		if(set)
			hp->squeldelay = val;
		return hp->squeldelay;
	case PARAM_MUTE:
		if(set){
			if(val == -1){
				/* Special case for duration of a CTS */
				val = hp->txdelay + 500;
			}
			hp->deftime = msclock() + val;
		}
		t = msclock();
		ca = hp->deftime - t;
		if(ca < 0){
			hp->deftime = t;
			ca = 0;
		}
		return ca;
	}
	return -1;
}
@


1.18
log
@Go back to dirps/restore, remove pragma inline
@
text
@d47 11
a57 11
static void xwrite_scc __ARGS((struct pichan *hp,int16 ctl,int16 reg,
	int16 val ));
static char xread_scc __ARGS((struct pichan *hp, int16 ctl, char reg));
static int32 pi_ctl __ARGS((struct iface *iface,int cmd,int set,int32 val));
static int pi_raw __ARGS((struct iface *iface,struct mbuf *bp));
static int pi_stop __ARGS((struct iface *iface));
static void rts __ARGS((struct pichan *hp, int16 x));
void setup_rx_dma __ARGS((struct pichan *hp));
void setup_tx_dma __ARGS((struct pichan *hp));
static void set_acc_delay __ARGS((void));
static void tdelay __ARGS((register struct pichan *hp,unsigned int time));
d65 1
a65 1
static int16 Page_regs[] = {
d69 1
a69 1
static int16 pinbr;
d71 1
a71 1
extern int16 acc_delay;	/* Delay for the 8530 chip access recovery time */
d103 2
a104 2
register int16 ctl;
int16 reg,val;
d113 1
a113 1
register int16 ctl;
d166 1
a166 1
	register int16 pcbase;
d216 1
a216 1
	register int16 cmd;
d334 2
a335 2
	register int16 cmd;
	register int16 bytecount;
d393 1
a393 1
	register int16 cmd;
d467 1
a467 1
	register int16 cmd;
d542 1
a542 1
	register int16 cmd;
d647 1
a647 1
	register int16 cmd;
d791 1
a791 1
int16 x;
d793 1
a793 1
	int16 tc;
d795 1
a795 1
	int16 cmd;
d911 1
a911 1
	int16 length;
d941 1
a941 1
	int16 tc;
d943 1
a943 1
	register int16 cmd;
d1134 1
a1134 1
	hp->speed = (int16)atoi(argv[9]);
d1188 1
a1188 1
	hp->speed = (int16)atoi(argv[8]);
d1289 1
a1289 1
	int16 dev;
@


1.17
log
@Revised to use DMA support routines in dma.c. NOT YET TESTED!!
@
text
@a0 1
#pragma inline
d220 1
d222 1
a222 1
	DISABLE();
d245 1
a245 1
			RESTORE();
d293 1
a293 1
			RESTORE();
d306 1
a306 1
			RESTORE();
d313 1
a313 1
			RESTORE();
d321 1
a321 1
		RESTORE();
d325 1
a325 1
	RESTORE();
d338 1
d343 1
a343 1
	DISABLE();
d386 1
a386 1
	RESTORE();
d396 1
d400 1
a400 1
	DISABLE();
d406 1
a406 1
			RESTORE();
d425 1
a425 1
			RESTORE();
d438 1
a438 1
			RESTORE();
d445 1
a445 1
			RESTORE();
d454 1
a454 1
		RESTORE();
d460 1
a460 1
	RESTORE();
d470 1
d475 1
a475 1
	DISABLE();
d535 1
a535 1
	RESTORE();
d545 1
d549 1
a549 1
	DISABLE();
d557 1
a557 1
		RESTORE();
d566 1
a566 1
			RESTORE();
d582 1
a582 1
			RESTORE();
d590 1
a590 1
			RESTORE();
d598 1
a598 1
		RESTORE();
d617 1
a617 1
				RESTORE();
d629 1
a629 1
		RESTORE();
d632 1
a632 1
	RESTORE();
d650 1
d654 1
a654 1
	DISABLE();
d665 1
a665 1
		RESTORE();
d669 1
a669 1
		RESTORE();
d679 1
a679 1
			RESTORE();
d708 1
a708 1
		RESTORE();
d722 1
a722 1
			RESTORE();
d730 1
a730 1
			RESTORE();
d738 1
a738 1
		RESTORE();
d766 1
a766 1
		RESTORE();
d782 1
a782 1
	RESTORE();
d863 1
d868 1
a868 1
	DISABLE();
d871 1
a871 1
		RESTORE();
d903 1
a903 1
	RESTORE();
d912 1
d916 1
a916 1
	DISABLE();
d933 1
a933 1
	RESTORE();
d944 1
d952 1
a952 1
	DISABLE();
d1035 1
a1035 1
	RESTORE();
d1320 1
d1337 1
a1337 1
			DISABLE();
d1340 1
a1340 1
			RESTORE();
@


1.16
log
@Allow any encapsulation by using setencap() function
@
text
@d56 1
a56 1
void setup_tx_dma __ARGS((struct pichan *hp, char *buffer, int length));
a73 38
/* Allocate a buffer which does not cross a dma page boundary */
/* This really belongs in mbuf.c */
struct mbuf *
alloc_dmabuf(size)
register int16 size;
{
	struct mbuf *bp[20],*retbuf;
	unsigned buf_offset, buf_segment;
	long longseg, dma_abs, dma_page;
	int n;

	for(n = 0; n < 20 ;n++){
		if((bp[n] = alloc_mbuf(size)) == NULLBUF){
			/* Free the buffers which failed the test */
			while(--n >= 0)
				free_p(bp[n]);
			return(NULLBUF);
		}
		/* Calculate the DMA page */
		buf_offset = FP_OFF(bp[n]);
		buf_segment= FP_SEG(bp[n]);
		longseg = (long) buf_segment;
		dma_abs = (longseg << 4) + (long) buf_offset;
		dma_page = dma_abs >> 16;
		if(((dma_abs+size) >> 16) == dma_page){
			/* Save the one that passed */
			retbuf = bp[n];
			/* Free the buffers which failed the test */
			while(--n >= 0)
				free_p(bp[n]);
			return(retbuf);
		}
	}
	/* Free the buffers which failed the test */
	while(--n >= 0)
		free_p(bp[n]);
	return(NULLBUF);
}
a218 1
	int length;
d220 1
a236 2
		free_p(hp->sndbuf);
		hp->sndbuf = NULLBUF;
d241 1
a241 1
		if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF){
d248 4
a259 3
		/* Get all chars */
		length = pullup(&hp->sndbuf,hp->txdmabuf,hp->bufsiz);

d261 1
a261 1
		setup_tx_dma(hp,hp->txdmabuf,length);
d337 1
a337 1

d354 3
a356 4
		bytecount = inportb(hp->dma_wcr);
		bytecount += inportb(hp->dma_wcr) << 8;
		/* Allow for the extra space for the header */
		bytecount = (hp->bufsiz - 1 - sizeof(struct iface *)) - bytecount;
d366 13
a378 8
			/* Here we have a valid frame */
			/* Toss 2 crc bytes */
			hp->rcvbuf->cnt = bytecount - 2;
			/* "Can't fail" */
			net_route(hp->iface,hp->rcvbuf);
			hp->rcvbuf = NULLBUF;
			hp->rxframes++;

a379 4
			hp->rcvbuf = alloc_mbuf(hp->bufsiz + sizeof(struct iface *));
			if(hp->rcvbuf != NULLBUF)
				/* Allow room for header */
				hp->rcvbuf->data += sizeof(struct iface *);
d394 1
d402 1
a402 1
		if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF){
d408 3
d467 1
d481 2
a482 2
			hp->rcp = hp->rcvbuf->data;
			hp->rcvbuf->cnt = 0;
d485 2
a486 2
		} else if(hp->rcvbuf->cnt >= hp->bufsiz - sizeof(struct iface *)){
			/* Too large -- toss buffer */
d488 2
a489 2
			hp->rcp = hp->rcvbuf->data;
			hp->rcvbuf->cnt = 0;
d495 1
a495 1
			hp->rcvbuf->cnt++;		   /* bump count */
d506 3
a508 3
		if(hp->rcvbuf->cnt > 0){
			if((rse & CRC_ERR)||(hp->rstate > ACTIVE)||(hp->rcvbuf->cnt < 10)){
				if((hp->rcvbuf->cnt >= 10) && (rse & CRC_ERR))
d511 2
a512 2
				hp->rcp = hp->rcvbuf->data;
				hp->rcvbuf->cnt = 0;
d515 8
a522 12
				hp->rcvbuf->cnt -= 2;  /* Toss 2 crc bytes */
				/* "Can't fail" */
				net_route(hp->iface,hp->rcvbuf);
				hp->rxframes++;

				/* packet queued - get buffer for next frame */
				hp->rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct iface *));
				if(hp->rcvbuf == NULLBUF){
					/* No memory - abort rx */
					xwrite_scc(hp,cmd,R3,Rx8);
					RESTORE();
					return;
d524 3
a526 3
				hp->rcvbuf->data += sizeof(struct iface *);
				hp->rcp = hp->rcvbuf->data;
				hp->rcvbuf->cnt = 0;
d541 1
d557 1
a557 1
		if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF){
d565 2
d599 2
a600 1
		if((c = PULLCHAR(&hp->sndbuf)) != -1){
a605 1
			free_p(hp->sndbuf);
d645 1
a653 1

a655 1
		free_p(hp->sndbuf);
d668 1
a668 1
		if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF){
d677 4
d682 2
a683 1
		pullup(&hp->sndbuf,&c,1);	/* one char at a time */
d739 2
a740 1
		pullup(&hp->sndbuf,&c,1);	 /* one char at a time */
d774 2
a775 2
		hp->rcp = hp->rcvbuf->data;
		hp->rcvbuf->cnt = 0;	      /* rewind on DCD transition */
d842 2
a843 2
			hp->rcp = hp->rcvbuf->data;
			hp->rcvbuf->cnt = 0;
a855 1
	unsigned buf_offset, buf_segment;
d857 1
a857 1
	long longseg, dma_abs, dma_page;
d860 1
a868 12
	/* Calculate high order 4 bits of the buffer area and store
	 *	them in the DMA page register
	 */
	buf_offset = FP_OFF(hp->rcvbuf->data);
	buf_segment= FP_SEG(hp->rcvbuf->data);
	longseg = (long) buf_segment;
	dma_abs = (longseg << 4) + (long) buf_offset;
	dma_page = dma_abs >> 16;

	if(((dma_abs + hp->bufsiz -1) >> 16) != dma_page)
		printf("PI: ERROR - RX DMA page boundary violation\n");

d877 1
a877 1
	outportb(hp->page_addr,dma_page);/* Store in  64K DMA page */
d880 2
a881 2
	outportb(hp->dma_dest,dma_abs);
	outportb(hp->dma_dest,dma_abs >> 8);
d883 3
a885 2
	outportb(hp->dma_wcr,hp->bufsiz - 1 - sizeof(struct iface *));
	outportb(hp->dma_wcr, (hp->bufsiz - 1 - sizeof(struct iface *)) >> 8);
d901 1
a901 1
setup_tx_dma(hp,buffer,length)
a902 2
char *buffer;
int length;
d904 2
a905 2
	unsigned buf_offset, buf_segment;
	long longseg, dma_abs, dma_page;
d907 2
a910 10
	/* Calculate high order 4 bits of the buffer area and store
	 *	them in the DMA page register
	 */

	buf_offset = FP_OFF(buffer);
	buf_segment= FP_SEG(buffer);
	longseg = (long) buf_segment;
	dma_abs = (longseg << 4) + (long) buf_offset;
	dma_page = dma_abs >> 16;

a911 3
	if(((dma_abs + length) >> 16) != dma_page)
		printf("PI: ERROR - TX DMA page boundary violation\n");
	--length;	 /* Adjust length for DMA chip */
d917 1
a917 1
	outportb(hp->page_addr,dma_page); /* Store in 64K DMA page */
d919 2
a920 2
	outportb(hp->dma_dest,dma_abs);	/* Output buffer start (source) address */
	outportb(hp->dma_dest,dma_abs >> 8);
d922 3
a924 2
	outportb(hp->dma_wcr,length);
	outportb(hp->dma_wcr, (length) >> 8);
a1030 42
/* Process to recover from ibuffails.
 * This could be done in the function network() in config.c,
 * to save a context switch.  I put it here so the driver would
 * be more self contained.
*/
void
buf_recover(unused,b,a)
int unused;
void *b;	/* Unused */
void *a;	/* Unused */
{
	struct pichan *hp0, *hp1;
	int i;

	for(;;){
		pwait(NULL);

		for(i=0; i<pinbr; i++){ /* for each card */
			hp0 = &Pichan[i];
			hp1 = &Pichan[i + 1];
			if(!hp0->rcvbuf){ /* No rx buffer allocated */
				DISABLE();
				hp0->rcvbuf = alloc_mbuf(hp0->bufsiz + sizeof(struct iface *));
				if(hp0->rcvbuf != NULLBUF)
					hp0->rcvbuf->data += sizeof(struct iface *);
				RESTORE();
				setup_rx_dma(hp0);
			}
			DISABLE();
			if(!hp1->rcvbuf && (hp1->rstate == ACTIVE)){
				/* No rx buf allocated */
				if((hp1->rcvbuf = alloc_mbuf(hp1->bufsiz+sizeof(struct iface *))) != NULL){
					hp1->rcvbuf->data += sizeof(struct iface *);
					hp1->rcp = hp1->rcvbuf->data;
					hp1->rcvbuf->cnt = 0;
					xwrite_scc(hp1,CTL+hp1->base,R3,RxENABLE|RxCRC_ENAB|Rx8);
				}
			}
			RESTORE();
		}
	}
}
a1051 1
	struct mbuf *bp;
a1119 48
	/* Create interface structures and fill in details */
	if_pca = (struct iface *)callocw(1,sizeof(struct iface));
	if_pcb = (struct iface *)callocw(1,sizeof(struct iface));

	if_pca->addr = if_pcb->addr = Ip_addr;
	if(argc > 10)
		if_pca->addr = resolve(argv[10]);
	if(argc > 11)
		if_pcb->addr = resolve(argv[11]);

	if(if_pca->addr == 0 || if_pcb->addr == 0){
		printf("PI: No IP address");
		free((char *)if_pca);
		free((char *)if_pcb);
		return -1;
	}
	/* Append "a" to interface associated with A channel */
	if_pca->name = malloc((unsigned)strlen(argv[5])+2);
	strcpy(if_pca->name,argv[5]);
	strcat(if_pca->name,"a");
	/* Append "b" to interface associated with B channel */
	if_pcb->name = malloc((unsigned)strlen(argv[5])+2);
	strcpy(if_pcb->name,argv[5]);
	strcat(if_pcb->name,"b");

	if_pcb->mtu = if_pca->mtu = atoi(argv[7]);
	if_pcb->ioctl = if_pca->ioctl = pi_ctl;
	if_pca->dev = 2*dev;			/* pi0a */
	if_pcb->dev = 2*dev + 1;		/* pi0b */
	if_pcb->stop = if_pca->stop = pi_stop;
	if_pcb->raw = if_pca->raw = pi_raw;

	/* Must succeed, was checked at top */
	setencap(if_pca,argv[4]);
	setencap(if_pcb,argv[4]);

	if(if_pcb->hwaddr == NULLCHAR)
		if_pcb->hwaddr = mallocw(AXALEN);
	memcpy(if_pcb->hwaddr,Mycall,AXALEN);
	if(if_pca->hwaddr == NULLCHAR)
		if_pca->hwaddr = mallocw(AXALEN);
	memcpy(if_pca->hwaddr,Mycall,AXALEN);

	/* Link em in to the interface chain */
	if_pca->next = if_pcb;
	if_pcb->next = Ifaces;
	Ifaces = if_pca;

a1123 1
	hp->iface = if_pcb;
d1143 3
a1145 5
	/* Pre-allocate a receive buffer */
	DISABLE();
	hp->rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct iface *));
	RESTORE();
	if(hp->rcvbuf == NULLBUF){
d1147 11
a1157 1
		printf("PI: No memory available for receive buffers\n");
d1161 1
a1163 3
	hp->rcvbuf->data += sizeof(struct iface *);
	hp->rcp = hp->rcvbuf->data;
	hp->rcvbuf->cnt = 0;
d1169 2
a1170 4
	/* Figure out where the dma page register is. */
	if(hp->dmachan < 8 && hp->dmachan >= 0){
		hp->page_addr = Page_regs[hp->dmachan];
	} else {
d1172 2
a1173 1
		free_p(hp->rcvbuf);
a1178 4

	hp->dma_dest = hp->dmachan * 2;
	hp->dma_wcr = hp->dma_dest + 1;

a1179 1
	hp->iface = if_pca;
a1188 1
	newproc("buf_recover",256,buf_recover,0,hp,NULL,0);
d1191 2
a1192 5
	/* buffer is allocated with ints off */
	DISABLE();
	hp->rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct iface *));
	RESTORE();
	if(hp->rcvbuf == NULLBUF){
a1199 2
	hp->rcvbuf->data += sizeof(struct iface *);
	hp->rcvbuf->cnt = 0;
d1203 2
a1204 9
	/* buffer is allocated with ints off */
	DISABLE();
	bp = alloc_mbuf(hp->bufsiz);
	if(bp != NULLBUF)
		hp->txdmabuf = bp->data;
	else
		hp->txdmabuf = NULLCHAR;
	RESTORE();
	if(!hp->txdmabuf)
d1206 53
d1318 1
a1318 1
	kickflag = (hp->sndq == NULLBUF) & (hp->sndbuf == NULLBUF);
@


1.15
log
@s920612
@
text
@a1147 1
	extern void refiq();
a1153 1
	refiq(); /* replenish interrupt buffer pool (in mbuf.c) */
d1159 1
a1159 1
	if(strcmp(argv[4],"ax25") != 0){
d1248 11
a1258 11
	if(strcmp(argv[4],"ax25") == 0){
		/* Must be true, was checked at top */
		setencap(if_pca,"AX25");
		setencap(if_pcb,"AX25");
		if(if_pcb->hwaddr == NULLCHAR)
			if_pcb->hwaddr = mallocw(AXALEN);
		memcpy(if_pcb->hwaddr,Mycall,AXALEN);
		if(if_pca->hwaddr == NULLCHAR)
			if_pca->hwaddr = mallocw(AXALEN);
		memcpy(if_pca->hwaddr,Mycall,AXALEN);
	}
@


1.14
log
@src0515
@
text
@d1 1
@


1.13
log
@src0501
@
text
@d29 1
a29 1
#include "8530.h"
@


1.12
log
@src0429a
@
text
@d908 1
a908 1
		tprintf("PI: ERROR - RX DMA page boundary violation\n");
d963 1
a963 1
		tprintf("PI: ERROR - TX DMA page boundary violation\n");
d994 1
a994 1
	tprintf("Pi: Initializing Channel %c - Base = %x\n",cmd&2?'A':'B',cmd&~CTL);
d1161 1
a1161 1
		tprintf("PI: Mode %s unknown for interface %s\n",
d1166 1
a1166 1
		tprintf("PI: Interface %s already exists\n",argv[5]);
d1170 1
a1170 1
		tprintf("PI: Set mycall first\n");
d1176 1
a1176 1
		tprintf("PI: Maximum of %d PI cards supported\n",PIMAX);
d1206 1
a1206 1
		tprintf("PI: IRQ %u out of range\n",Pi[dev].vec);
d1212 1
a1212 1
		tprintf("PI: DMA %d out of range\n",atoi(argv[3]));
d1228 1
a1228 1
		tprintf("PI: No IP address");
d1295 1
a1295 1
		tprintf("PI: No memory available for receive buffers\n");
d1344 1
a1344 1
		tprintf("PI: No memory available for receive buffers\n");
d1364 1
a1364 1
		tprintf("PI: No memory available for transmit buffer");
d1451 3
a1453 3
	tprintf("PI Board Statistics:\n\n");
	tprintf("Base Addr  Rxints  Txints  Exints  TxFrms  RxFrms  Crcerr  RxOvrs  TxUndr \n");
	tprintf("---------  ------  ------  ------  ------  ------  ------  ------  ------ \n");
d1457 1
a1457 1
		tprintf("0x%03x    % 8lu% 8lu% 8lu% 8u% 8u% 8u% 8u% 8u\nRcv State=%s ",
d1467 1
a1467 1
		tprintf("Tstate = %s\n",
@


1.11
log
@src0419
@
text
@d255 1
a255 1
	char st, i_state;
d259 1
a259 1
	i_state = dirps();	    /* disable interrupts */
d284 1
a284 1
			restore(i_state);
d331 1
a331 1
			restore(i_state);
d344 1
a344 1
			restore(i_state);
d351 1
a351 1
			restore(i_state);
d359 1
a359 1
		restore(i_state);
d363 1
a363 1
	restore(i_state);
d374 1
a374 1
	char rse, i_state;
d376 1
a376 1
	i_state = dirps();	    /* disable interrupts */
d380 1
d394 2
a395 2
		/* Allow for the extra space for phdr */
		bytecount = (hp->bufsiz - 1 - sizeof(struct phdr)) - bytecount;
d409 1
a409 1
			net_route(hp->iface,CL_AX25,hp->rcvbuf);
d414 1
a414 1
			hp->rcvbuf = alloc_mbuf(hp->bufsiz + sizeof(struct phdr));
d416 2
a417 2
				/* Allow room for phdr */
				hp->rcvbuf->data += sizeof(struct phdr);
d423 1
a423 1
	restore(i_state);
a430 1
	char i_state;
a432 1
	i_state = dirps();
d435 1
d441 1
a441 1
			restore(i_state);
d457 1
a457 1
			restore(i_state);
d470 1
a470 1
			restore(i_state);
d477 1
a477 1
			restore(i_state);
d486 1
a486 1
		restore(i_state);
d492 1
a492 1
	restore(i_state);
d500 1
a500 1
	char rse, i_state;
a501 1
	i_state = dirps();	    /* disable interrupts */
d505 1
d518 1
a518 1
		} else if(hp->rcvbuf->cnt >= hp->bufsiz - sizeof(struct phdr)){
d550 1
a550 1
				net_route(hp->iface,CL_AX25,hp->rcvbuf);
d554 1
a554 1
				hp->rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct phdr));
d558 1
a558 1
					restore(i_state);
d561 1
a561 1
				hp->rcvbuf->data += sizeof(struct phdr);
d569 1
a569 1
	restore(i_state);
d577 1
a577 1
	char i_state,c;
a578 1
	i_state = dirps();
d581 1
d589 1
a589 1
		restore(i_state);
d598 1
a598 1
			restore(i_state);
d612 1
a612 1
			restore(i_state);
d620 1
a620 1
			restore(i_state);
d628 1
a628 1
		restore(i_state);
d647 1
a647 1
				restore(i_state);
d659 1
a659 1
		restore(i_state);
d662 1
a662 1
	restore(i_state);
d676 1
a676 1
	char st, i_state;
a680 1
	i_state = dirps();	    /* disable interrupts */
d682 1
d695 1
a695 1
		restore(i_state);
d699 1
a699 1
		restore(i_state);
d709 1
a709 1
			restore(i_state);
d733 1
a733 1
		restore(i_state);
d747 1
a747 1
			restore(i_state);
d755 1
a755 1
			restore(i_state);
d763 1
a763 1
		restore(i_state);
d790 1
a790 1
		restore(i_state);
d806 1
a806 1
	restore(i_state);
a887 3
	char i_state;

	i_state = dirps();	    /* disable interrupts */
d891 1
d894 1
a894 1
		restore(i_state);
d924 2
a925 2
	outportb(hp->dma_wcr,hp->bufsiz - 1 - sizeof(struct phdr));
	outportb(hp->dma_wcr, (hp->bufsiz - 1 - sizeof(struct phdr)) >> 8);
d937 1
a937 1
	restore(i_state);
a947 1
	char i_state;
d949 1
a949 1
	i_state = dirps();	    /* disable interrupts */
d978 1
a978 1
	restore(i_state);
a987 1
	char i_state;
d996 1
a996 1
	i_state = dirps();
d1079 1
a1079 1
	restore(i_state);
a1094 1
	char i_state;
d1104 2
a1105 2
				i_state = dirps();
				hp0->rcvbuf = alloc_mbuf(hp0->bufsiz + sizeof(struct phdr));
d1107 2
a1108 2
					hp0->rcvbuf->data += sizeof(struct phdr);
				restore(i_state);
d1111 1
a1111 1
			i_state = dirps();
d1114 2
a1115 2
				if((hp1->rcvbuf = alloc_mbuf(hp1->bufsiz+sizeof(struct phdr))) != NULL){
					hp1->rcvbuf->data += sizeof(struct phdr);
d1121 1
a1121 1
			restore(i_state);
a1150 1
	char i_state;
a1242 1
	if_pcb->type = if_pca->type = CL_AX25;
a1246 1
	if_pcb->output = if_pca->output = ax_output;
d1251 2
d1290 3
a1292 3
	i_state = dirps();
	hp->rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct phdr));
	restore(i_state);
d1301 1
a1301 1
	hp->rcvbuf->data += sizeof(struct phdr);
d1339 3
a1341 3
	i_state = dirps();
	hp->rcvbuf = alloc_mbuf(hp->bufsiz+sizeof(struct phdr));
	restore(i_state);
d1350 1
a1350 1
	hp->rcvbuf->data += sizeof(struct phdr);
d1356 1
a1356 1
	i_state = dirps();
d1362 1
a1362 1
	restore(i_state);
a1415 1
	char i_state;
d1419 1
a1419 1
	dump(iface,IF_TRACE_OUT,CL_AX25,bp);
d1434 1
a1434 1
			i_state = dirps();
d1437 1
a1437 1
			restore(i_state);
@


1.10
log
@src0403
@
text
@d1158 1
d1379 6
a1384 3
	if_pca->txproc = newproc("pi tx",512,if_tx,0,if_pca,NULL,0);
	if_pcb->txproc = newproc("pi tx",512,if_tx,0,if_pcb,NULL,0);

@


1.9
log
@src0401
@
text
@d200 1
a200 2
void
piint(dev)
d206 1
d210 3
a212 2
	Pi[dev].ints++;
	pcbase = Pi[dev].addr;
d247 1
d1188 5
a1192 1
	Pi[dev].vec = htoi(argv[2]);
@


1.8
log
@src0331
@
text
@a372 2
	struct mbuf *bp;
	struct phdr phdr;
d406 1
a406 4
			bp = pushdown(hp->rcvbuf,sizeof(phdr));
			phdr.type = CL_AX25;
			phdr.iface = hp->iface;
			memcpy(bp->data,(char *)&phdr,sizeof(phdr));
a407 1
			enqueue(&Hopper,bp);	   /* queue it in */
d411 1
a411 1
			hp->rcvbuf = alloc_mbuf(hp->bufsiz + sizeof(phdr));
a498 2
	struct mbuf *bp;
	struct phdr phdr;
d548 1
a548 5
				bp = pushdown(hp->rcvbuf,sizeof(phdr));
				phdr.type = CL_AX25;
				phdr.iface = hp->iface;
				memcpy(bp->data,(char *)&phdr,sizeof(phdr));
				enqueue(&Hopper,bp);	   /* queue it in */
@


1.7
log
@src0327
@
text
@d1384 2
a1385 2
	if_pca->sendproc = newproc("pi tx",512,if_tx,0,if_pca,NULL,0);
	if_pcb->sendproc = newproc("pi tx",512,if_tx,0,if_pcb,NULL,0);
@


1.6
log
@src0609
@
text
@a1263 1
		if_pcb->send = if_pca->send = ax_send;
d1383 3
@


1.5
log
@src0524
@
text
@d16 1
a16 1
 * 
d19 1
a32 1
#include <time.h>
d40 1
d42 2
d45 1
@


1.4
log
@src0420
@
text
@d120 1
a120 1
	starttime = biostime(0,0l);
d123 1
a123 1
	endtime = biostime(0,0l);
@


1.3
log
@src0221
@
text
@d158 3
a160 2
{	int n;
	int port, t1;
d389 2
a390 1
		bytecount = (hp->bufsiz - 1) - bytecount;
d932 2
a933 2
	outportb(hp->dma_wcr,hp->bufsiz - 1);
	outportb(hp->dma_wcr, (hp->bufsiz - 1) >> 8);
d940 1
a940 1
/*	xwrite_scc(hp,cmd,R0,RES_Rx_CRC); */
d1157 1
d1365 5
a1369 1
	hp->txdmabuf = (char *)alloc_mbuf(hp->bufsiz);
@


1.2
log
@src0202
@
text
@d38 1
d46 1
a46 1
static int pi_ctl __ARGS((struct iface *iface,int argc,char *argv[]));
d53 1
a53 1
static void tdelay __ARGS((register struct pichan *hp,unsigned char time));
d61 3
d80 4
a83 5
	for(n = 0; n < 20 ;n++)
	{
		if((bp[n] = alloc_mbuf(size)) == NULLBUF)
		{
			while(--n >= 0) /* Free the buffers which failed the test */
a86 1

a87 1

d93 5
a97 4
		if(((dma_abs+size) >> 16) == dma_page)
		{
			retbuf = bp[n]; /* Save the one that passed */
			while(--n >= 0) /* Free the buffers which failed the test */
d102 2
a103 1
	while(--n >= 0) /* Free the buffers which failed the test */
d109 4
a112 4
   which satify the SCC's access recovery time.  It needs to be timed and
   calculated because a fixed value would not work in a 4.77mhz XT
   to a 40mhz 486 (and beyond).
*/
d157 1
a157 1
unsigned char time; /* Time to delay in milliseconds */
d162 1
a162 2
	if(hp->base & 2) /* If A channel */
	{
d166 1
a166 2
	}
	else {
d172 12
a183 4
	outportb(hp->cardbase+TMRCMD, sc|LSB_MSB|MODE0); /* Setup timer sc */
	for(n=0; n<5;n++) ; /* satisfy access time restriction */
	outportb(port, (t1 << 1) & 0xFF);/* times 2 to make millisecs */
	for(n=0; n<5;n++) ; /* satisfy access time restriction */
d186 2
a187 1
	xwrite_scc(hp,hp->base+CTL,R15,CTSIE); /* Enable correct int for timeout */
d208 3
a210 2
	/* Read interrupt status register (only valid from channel A)			*/
	/* Process all pending interrupts in while loop							*/
d212 2
a213 3
	while((st = xread_scc(hp,pcbase+CHANA+CTL,R3)) != 0)
	{
		if (st & CHARxIP) {
d217 1
a217 1
		} else if (st & CHATxIP) {
d221 1
a221 1
		} else if (st & CHAEXT) {
d225 1
a225 1
		} else if (st & CHBRxIP) {
d229 1
a229 1
		} else if (st & CHBTxIP) {
d233 1
a233 1
		} else if (st & CHBEXT) {
d250 1
d261 1
a261 2
	if((hp->rstate >= ACTIVE) && (st & BRK_ABRT))
	{	
d265 25
d291 12
a302 34
	switch(hp->tstate)
	{
		case ACTIVE:
			free_p(hp->sndbuf);
			hp->sndbuf = NULLBUF;
			hp->tstate = FLAGOUT;
			tdelay(hp,hp->params[SQUELDELAY]);
			break;
		case FLAGOUT:
			if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF)
			{
				/* Nothing to send - return to receive mode */
				hp->tstate = IDLE;
				rts(hp,OFF);
				restore(i_state);
				return;
			}
			/* NOTE - fall through if more to send */
		case ST_TXDELAY:
			outportb(DMA_MASK, DMA_DISABLE|hp->dmachan);/* Disable DMA chan */
			xwrite_scc(hp,cmd,R1,WT_FN_RDYFN|EXT_INT_ENAB);/*Set up for TX dma*/
			length = pullup(&hp->sndbuf,hp->txdmabuf,hp->bufsiz); /* Get all chars */
			setup_tx_dma(hp,hp->txdmabuf,length);/* Setup DMA controller for tx */
			/* select transmit interrupts to enable */
			outportb(DMA_MASK,DMA_ENABLE|hp->dmachan);/* Allow DMA on chan */
			xwrite_scc(hp,cmd,R0,RES_Tx_CRC|RES_Tx_P);/* reset CRC, Txint pend*/
			xwrite_scc(hp,cmd,R15,TxUIE);	    /* allow Underrun int only */
			/* Enable TX DMA */
			xwrite_scc(hp,cmd,R1,WT_RDY_ENAB|WT_FN_RDYFN|EXT_INT_ENAB);
			xwrite_scc(hp,cmd,R0,RES_EOM_L);	/* Send CRC on underrun */
											/* Rest of frame sent by DMA */
			hp->tstate = ACTIVE;			/* packet going out now */
			break;
		case DEFER:	    /* we have deferred prev xmit attempt */
d304 2
a305 11
			/* See Intel Microcommunications Handbook, p2-308 */
			xwrite_scc(hp,cmd,R0,RES_EXT_INT);
			xwrite_scc(hp,cmd,R0,RES_EXT_INT);
			if((xread_scc(hp,cmd,R0) & DCD) > 0)
			{	hp->tstate = DEFER;
				tdelay(hp,100);
				/* Defer until dcd transition or 100mS timeout */
				xwrite_scc(hp,CTL+hp->base,R15,CTSIE|DCDIE);
				restore(i_state);
				return;
			}
d307 2
a308 7
 			if((rand() & 0xff) > uchar(hp->params[PERSIST]))
 			{
				hp->tstate = DEFER;
				tdelay(hp,hp->params[SLOTIME]);
				restore(i_state);
				return;
			}
d310 27
a336 5
			xwrite_scc(hp,cmd,R5,TxCRC_ENAB|RTS|Tx8);/* Assert RTS early minimize */
												/* collision window */
			rts(hp,ON);						/* Transmitter on */
			hp->tstate = ST_TXDELAY;
			tdelay(hp,hp->params[TXDELAY]);
d339 15
a353 1

d369 1
a369 1
	struct phdr *phdr;
d376 2
a377 2
	if(rse & Rx_OVR) /* If receiver overrun */
	{
d382 2
a383 2
	if(rse & END_FR) /* If end of frame */
	{
d390 3
a392 4
		if((rse & CRC_ERR)||(hp->rstate > ACTIVE)||(bytecount < 10))
		{
			if((bytecount >= 10) && (rse & CRC_ERR)) /* Ignore noise */
				hp->crcerr++;
d397 1
a397 3
		}
		else
		{
d399 7
a405 14
			hp->rcvbuf->cnt = bytecount - 2;   /* Toss 2 crc bytes */
			bp = alloc_mbuf(sizeof(struct phdr));
			if(!bp)
			{
				setup_rx_dma(hp);
				xwrite_scc(hp,hp->base+CTL,R0,ERR_RES);	/* error reset */
				restore(i_state);
				return;
			};
			bp->cnt = sizeof(struct phdr);			
			phdr = (struct phdr *)bp->data;
			phdr->type = CL_AX25;
			phdr->iface = hp->iface;
			bp->next = hp->rcvbuf;
d411 4
a414 1
			hp->rcvbuf = alloc_mbuf(hp->bufsiz);
d429 1
d434 41
a474 39
	switch(hp->tstate)
	{
		case IDLE:
			/* Transmitter idle. Find a frame for transmission */
			if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF)
			{
				rts(hp,OFF);
				restore(i_state);
				return;
			}
			/* If a buffer to send, we drop thru here */
		case DEFER:	    /* we may have deferred prev xmit attempt */

			/* Check DCD - debounce it */
			/* See Intel Microcommunications Handbook, p2-308 */
			xwrite_scc(hp,cmd,R0,RES_EXT_INT);
			xwrite_scc(hp,cmd,R0,RES_EXT_INT);
			if((xread_scc(hp,cmd,R0) & DCD) > 0)
			{	hp->tstate = DEFER;
				tdelay(hp,100);
				/* defer until DCD transition or timeout */
				xwrite_scc(hp,cmd,R15,CTSIE|DCDIE);
				restore(i_state);
				return;
			}

 			if((rand() & 0xff) > uchar(hp->params[PERSIST]))
 			{
				hp->tstate = DEFER;
				tdelay(hp,hp->params[SLOTIME]);
				restore(i_state);
				return;
			}

			xwrite_scc(hp,cmd,R5,TxCRC_ENAB|RTS|Tx8);/* Assert RTS early minimize */
												/* collision window */
			rts(hp,ON);						/* Transmitter on */
			hp->tstate = ST_TXDELAY;
			tdelay(hp,hp->params[TXDELAY]);
d477 1
d479 9
a487 2
		default:
			break;
d500 1
a500 1
	struct phdr *phdr;
d506 1
a506 2
	if ((xread_scc(hp,cmd,R0)) & Rx_CH_AV)
	{
d511 1
a511 1
		if(rse & Rx_OVR) {
d513 2
a514 1
			hp->rcp = hp->rcvbuf->data;	/* reset buffer pointers */
d518 1
a518 1
		} else if(hp->rcvbuf->cnt >= hp->bufsiz) {
d520 2
a521 1
			hp->rcp = hp->rcvbuf->data;	/* reset buffer pointers */
d526 3
a528 3
		if(hp->rstate == ACTIVE) {			/* If no errors... */
			*hp->rcp++ = xread_scc(hp,cmd,R8);	/* char to rcv buff */
			hp->rcvbuf->cnt++;		   		/* bump count */
d537 1
a537 2
	if(rse & END_FR)
	{
d539 4
a542 6
		if(hp->rcvbuf->cnt > 0)
		{
			if((rse & CRC_ERR)||(hp->rstate > ACTIVE)||(hp->rcvbuf->cnt < 10))
			{
				if((hp->rcvbuf->cnt >= 10) && (rse & CRC_ERR))/* Ignore noise */
					hp->crcerr++;
d548 6
a553 14
				hp->rcvbuf->cnt -= 2;	       /* Toss 2 crc bytes */
				bp = alloc_mbuf(sizeof(struct phdr));
				if(!bp) /* we can't get memory - throw it away */
				{
					hp->rcp = hp->rcvbuf->data;
					hp->rcvbuf->cnt = 0;
					restore(i_state);
					return;
				}
				bp->cnt = sizeof(struct phdr);			
				phdr = (struct phdr *)bp->data;
				phdr->type = CL_AX25;
				phdr->iface = hp->iface;
				bp->next = hp->rcvbuf;
d558 4
a561 3
				hp->rcvbuf = alloc_mbuf(hp->bufsiz);
				if(hp->rcvbuf == NULLBUF) {
					xwrite_scc(hp,cmd,R3,Rx8); /* No memory - abort rx */
d565 1
d589 1
a589 1
	switch(hp->tstate) {
d592 1
a592 1
		tdelay(hp,hp->params[SQUELDELAY]);
d597 1
a597 1
		if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF) {
d611 2
a612 2
		if((xread_scc(hp,cmd,R0) & DCD) > 0)
		{	hp->tstate = DEFER;
a618 1

d620 2
a621 2
		if(inportb(hp->cardbase+TMR0) > hp->params[PERSIST])
		{	inportb(hp->cardbase+TMR0); /* Discard MSB */
d623 1
a623 1
			tdelay(hp,hp->params[SLOTIME]);
d631 1
a631 1
		tdelay(hp,hp->params[TXDELAY]);
d638 2
a639 1
			xwrite_scc(hp,cmd,R8,c);		/* next char is gone */
d644 3
a646 2
			if((xread_scc(hp,cmd,R0) & 0x40)) /* Did we underrun? */
			{	/* unexpected underrun */
d650 1
a650 1
				tdelay(hp,hp->params[SQUELDELAY]);
d656 1
a656 1
			if(hp->speed) { /* If externally clocked */
d692 1
a692 1
	switch(hp->tstate) {
d698 1
a698 1
		tdelay(hp,hp->params[SQUELDELAY]);
d707 1
a707 1
		if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF) {
d717 2
a718 2
		pullup(&hp->sndbuf,&c,1);	    /* one char at a time */
		xwrite_scc(hp,cmd,R0,RES_Tx_CRC);	/* reset for next frame */
d721 1
a721 1
		if(hp->speed) { /* If externally clocked */
d727 2
a728 2
		xwrite_scc(hp,cmd,R8,c);			/* First char out now */
		xwrite_scc(hp,cmd,R0,RES_EOM_L);	/* Reset end of message latch */
d732 1
a732 1
		xwrite_scc(hp,cmd,R15,TxUIE);	    /* allow Underrun int only */
d741 3
a743 2
		/* Check DCD - debounce it */
		/* See Intel Microcommunications Handbook, p2-308 */
d746 2
a747 2
		if((xread_scc(hp,cmd,R0) & DCD) > 0)
		{	hp->tstate = DEFER;
a753 1

d755 2
a756 2
		if(inportb(hp->cardbase+TMR0) > hp->params[PERSIST])
		{	inportb(hp->cardbase+TMR0); /* Discard MSB */
d758 1
a758 1
			tdelay(hp,hp->params[SLOTIME]);
d766 1
a766 1
		tdelay(hp,hp->params[TXDELAY]);
d773 2
a774 2
		pullup(&hp->sndbuf,&c,1);	    /* one char at a time */
		xwrite_scc(hp,cmd,R0,RES_Tx_CRC);	/* reset for next frame */
d777 1
a777 1
		if(hp->speed) { /* If externally clocked */
d783 2
a784 2
		xwrite_scc(hp,cmd,R8,c);			/* First char out now */
		xwrite_scc(hp,cmd,R0,RES_EOM_L);	/* Reset end of message latch */
d788 1
a788 1
		xwrite_scc(hp,cmd,R15,TxUIE);	    /* allow Underrun int only */
d790 2
a791 1
		xwrite_scc(hp,cmd,R1,TxINT_ENAB|EXT_INT_ENAB);  /* Tx/Extern ints on */
a795 1

d803 1
a803 1
	if((hp->rstate == ACTIVE) && (st & BRK_ABRT)) {
a809 1

d828 3
a830 2
	if(x == ON) {				/* Turn Tx ON and Receive OFF */
		xwrite_scc(hp,cmd,R15,0);	/* Exints off first to avoid abort int */
d833 4
a836 3
		if(cmd & 2) /* if channel a */
			xwrite_scc(hp,cmd,R1,WT_FN_RDYFN|EXT_INT_ENAB);	/* Set up for TX dma */
		else
d838 4
a841 4

		if(hp->speed) {						/* if internally clocked */
			br = hp->speed;			 		/* get desired speed */
			tc = (XTAL/br)-2;				/* calc 1X BRG divisor */
a844 1

d851 1
a851 1
		if(hp->speed) {							/* if internally clocked */
d853 11
a863 7
			xwrite_scc(hp,cmd,R14,BRSRC);		    /* BRG off, keep Pclk source */
			br = hp->speed;			 			/* get desired speed */
			tc = ((XTAL/32)/br)-2;				/* calc 32X BRG divisor */
			xwrite_scc(hp,cmd,R12,tc&0xFF);			/* lower byte */
			xwrite_scc(hp,cmd,R13,(tc>>8)&0xFF);	/* upper bite */
			xwrite_scc(hp,cmd,R14,BRSRC|SEARCH);	/* SEARCH mode, BRG source */
			xwrite_scc(hp,cmd,R14,BRSRC|BRENABL);	/* Enable the BRG */
a864 1

d867 1
a867 1
		hp->rstate = ACTIVE;			/* Normal state */
d869 1
a869 1
		if(cmd & 2) {/* if channel a */
d872 4
a875 2
		/*	xwrite_scc(hp,cmd,R0,ERR_RES); */	/* reset error bits */
			hp->rcp = hp->rcvbuf->data;	/* reset buffer pointers */
a878 1

d880 2
d898 3
a900 2
	if(!hp->rcvbuf) /* No rx buffer available */
	{	restore(i_state);
d905 2
a906 3
		them in the DMA page register
	*/

d913 3
d920 2
a921 2
		auto init, writes
	*/
d924 4
a927 3
	outportb(hp->page_addr,dma_page); /* Store in  64K DMA page */
	outportb(DMA_RESETFF,0); /* reset byte pointer flipflop */
	outportb(hp->dma_dest,dma_abs);	/* Output buffer start (dest) address */
d936 3
a938 2
		to mess up the crc to avoid receiving a partial packet */
	xwrite_scc(hp,cmd,R0,RES_Rx_CRC);
d959 2
a960 2
		them in the DMA page register
	*/
d970 2
a971 2
		tprintf("PI: ERROR - DMA page boundary violation\n");
	--length; /* Adjust length for DMA chip */
d973 2
a974 2
		no auto init, reads
	*/
d978 1
a978 1
	outportb(DMA_RESETFF,0); /* reset byte pointer flipflop */
d1023 1
a1023 1
	xwrite_scc(hp,cmd,R4,SDLC|X1CLK);	       /* SDLC mode and X1 clock */
d1027 1
a1027 1
	if(hp->speed) {
d1043 3
a1045 2
	/* Set up the Transmitter but don't enable it */
	/*  DTR, 8 bit TX chars only - TX NOT ENABLED */
d1056 3
a1058 3
	if(hp->speed) {
		br = hp->speed; 			/* get desired speed */
		tc = ((XTAL/32)/br)-2;			/* calc 32X BRG divisor */
d1064 1
a1064 1
	xwrite_scc(hp,cmd,R13,(tc>>8)&0xFF); /* upper bite */
d1069 9
a1077 7
	if(hp->speed)
		xwrite_scc(hp,cmd,R14,BRSRC|SSBR);/*DPLL frm BRG, BRG src PCLK */
	else
		xwrite_scc(hp,cmd,R14,BRSRC|SSRTxC);/*DPLL frm rtxc,BRG src PCLK */

	xwrite_scc(hp,cmd,R14,BRSRC|SEARCH);	   /* SEARCH mode, keep BRG source */
	xwrite_scc(hp,cmd,R14,BRSRC|BRENABL);	/* Enable the BRG */
d1092 3
a1094 3
   This could be done in the function network() in config.c,
   to save a context switch.  I put it here so the driver would
   be more self contained.
d1106 2
a1107 2
	for(;;)
	{	pwait(NULL);
d1109 1
a1109 2
		for(i=0; i<pinbr; i++) /* for each card */
		{
d1112 1
a1112 2
			if(!hp0->rcvbuf) /* No rx buffer allocated */
			{
d1114 3
a1116 1
				hp0->rcvbuf = alloc_mbuf(hp0->bufsiz);
d1121 4
a1124 4
			if(!hp1->rcvbuf && (hp1->rstate == ACTIVE))/* No rx buf allocated */
			{
				if((hp1->rcvbuf = alloc_mbuf(hp1->bufsiz)) != NULL)
				{	
d1163 4
a1166 3
	if(acc_delay == 0)	/* Only do this once */
		set_acc_delay();/* Adapt recovery time delay to processor speed */

d1181 1
a1181 2
	/* Note: each card must have a unique address, IRQ and DMA 
	 */
d1183 1
a1183 1
	if(pinbr >= PIMAX) {
d1194 2
a1195 1
	outportb(Pi[dev].addr+TMRCMD, SC0|LSB_MSB|MODE3); /* 500 uS square wave */
a1224 1

a1236 1

d1255 1
a1255 1
	if(strcmp(argv[4],"ax25") == 0) {
d1271 1
a1271 2

	hp = &Pichan[2*dev+1];				/* pi1 is offset 1 */
d1281 5
a1285 5
	/* default KISS Params */
	hp->params[TXDELAY] = 30;		/* 300 Ms */
	hp->params[PERSIST] = 128;		/* 50% persistence */
	hp->params[SLOTIME] = 30;		/* 300 Ms */
	hp->params[SQUELDELAY] = 3;		/* 30 Ms */
d1296 1
a1296 1
	hp->rcvbuf = alloc_mbuf(hp->bufsiz);
d1298 7
a1304 7
	if(hp->rcvbuf == NULLBUF) {
	    /* No memory, abort receiver */
	    tprintf("PI: No memory available for receive buffers\n");
	    /* Restore original interrupt vector */
	    setirq(Pi[dev].vec,Pi[dev].oldvec);
	    pinbr--;
	    return(-1);
d1306 1
d1312 1
a1312 1
	hp = &Pichan[2*dev];			/* pi0a is offset 0 */
d1315 9
a1323 11
	switch(hp->dmachan) {
		case 0:
		case 1:
			hp->page_addr = 0x83;
			break;
		case 2:
			hp->page_addr = 0x81;
			break;
		case 3:
			hp->page_addr = 0x82;
			break;
d1325 1
d1335 5
a1339 5
	/* default KISS Params */
	hp->params[TXDELAY] = 15;		/* 15 mS */
	hp->params[PERSIST] = 128;		/* 50% persistence */
	hp->params[SLOTIME] = 15;		/* 15 mS */
	hp->params[SQUELDELAY] = 1;		/* 1 mS */
a1341 1

d1343 3
a1345 2
	i_state = dirps();/* buffer is allocated with ints off */
	hp->rcvbuf = alloc_mbuf(hp->bufsiz);
d1347 1
a1347 1
	if(hp->rcvbuf == NULLBUF) {
d1355 1
d1360 2
a1361 1
	i_state = dirps();/* buffer is allocated with ints off */
d1368 2
a1369 1
	xwrite_scc(hp,CTL+hp->base,R9,MIE|NV);		/* master interrupt enable */
d1388 2
a1389 2
	dev >>= 1;	/* Convert back into pi number */
	hp = &Pichan[2*dev];			/* pi0a is offset 0 */
d1423 12
a1434 13
	if(kickflag)			/* simulate interrupt to xmit */
	{
		switch(hp->base & 2)
		{
			case 2:
				a_txint(hp);		/* process interrupt */
				break;
			case 0:
				i_state = dirps();
				if(hp->tstate == IDLE)
					b_txint(hp);
				restore(i_state);
				break;
d1450 1
a1450 2
	for(i=0; i<pinbr*2; i++)
	{
d1454 7
a1460 7
			hp->base, hp->rxints, hp->txints, hp->exints, hp->enqueued,
			hp->rxframes, hp->crcerr, hp->rovers, hp->tunders,
		    hp->rstate==0 ?
				"IDLE" : hp->rstate==1 ?
					"ACTIVE" : hp->rstate==2 ?
						"RXERROR" : hp->rstate==3 ?
							"RXABORT":"TOOBIG"
d1464 7
a1470 7
			hp->tstate == 0 ?
				"IDLE" : hp->tstate == 1 ?
					"ACTIVE" : hp->tstate == 2 ?
						"UNDERRUN" : hp->tstate == 3 ?
							"FLAGOUT" : hp->tstate == 4 ?
								"DEFER" : hp->tstate == 5 ?
									"TXDELAY" : "CRCOUT"
d1477 2
a1478 2
int
pi_ctl(iface,argc,argv)
d1480 3
a1482 2
int argc;
char *argv[];
d1485 1
a1485 1
	int p, v;
a1486 4
	if(argc < 2){
		tprintf("PI: Insufficient parameters\n");
		return 1;
	}
d1488 32
a1519 4
	p = atoi(argv[0]);	      /* parameter in binary */
	if(p > 3){
		tprintf("PI: Parameter %d out of range\n",p);
		return 1;
d1521 1
a1521 3
	v = atoi(argv[1]);	      /* value to be loaded */
	hp->params[p] = v;	      /* Stuff in Kiss array */
	return 0;
a1522 1

@


1.1
log
@Initial revision
@
text
@d4 1
d51 2
d110 1
d151 2
a152 1
static tdelay(hp,time)
d239 1
a239 1
	int i,length;
a852 1
	char dummy;
@
