#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <process.h>
#include <alloc.h>
#include <errno.h>
#include "asynscc.h"


void interrupt far rxonly(void), (*oldvect)(void);


typedef char buffer_item;
unsigned char BUFF_LEN=255;
buffer_item *buffer;
unsigned char rp=0, wp=0, ip, p=0;
char shell_buffer[4096], wr5=TxENAB&~DTR;
FILE *log;


int BASEADDR, RR3;

void tx(void), rx(char), shell(void), rts(void), setlog(void);
int stat8530(void), init(char);



void main(void)
{
char kb, end=1, i, bit;
unsigned int param, br;
char p[5];


bit=init(1);

buffer=(buffer_item *)calloc(BUFF_LEN,sizeof(buffer_item));
printf("BASEADDR= %X",BASEADDR);
delay(500);

window(1,1,80,25);
clrscr();
textcolor(CYAN);
cprintf("  ASYNSCC     v1.0   (c) 1995   IK5NAX Ŀ");
for(i=1;i<15;i++)
cprintf("                                                                              ");
cprintf("Ĵ");
for(i=1;i<7;i++)
cprintf("                                                                              ");
cprintf(" Alt X  eXit      Alt D  Dos Shell     Alt T  TX/RX    Alt L  Log ");
textcolor(LIGHTGRAY);


while(end){
	if(kbhit())
		{
		switch(kb=getch()){
			case 0: switch(getch()){
				case 45: end=0; break; 		//Alt X
				case 32: shell(); break;        //Alt D
				case 20: rts(); break;		//Alt T
				case 38: setlog(); break; 	//Alt L
				}
// Per qualsiasi altro tasto viene scritto il carattere nel buffer di trasmissione
// Se il buffer e' pieno, per non sovrascrivere, viene emesso un beep e il tasto viene ignorato
			default: if(wp-rp==BUFF_LEN) {sound(800); delay(20); nosound();}
					else	{
					*(buffer+wp)=kb;
					wp++;
	}

			}
		}
	if(wp!=rp) tx();
bit++;
}
init(0);
free(buffer);
window(1,1,80,25);
clrscr();
}


void tx(void)
{
char out;
static r=0, c=0;

// Se il buffer di trasmissione e' vuoto
if(inportb(BASEADDR)&Tx_BUF_EMP)
	{
	// Trasmetti il primo byte disponibile nel buffer
	out=*(buffer+rp);
	rp++;
	window(2,17,79,22);
	gotoxy(r,c);
	cprintf("%c",out);
	if(out==0x0d) putch(0x0a);
	r=wherex();
	c=wherey();
	outportb(BASEADDR+1,out);
	}
}


int stat8530(void)
{
int stat, d;
stat=inportb(BASEADDR);
outportb(BASEADDR,R1);
d=inportb(BASEADDR);
stat+=(d<<8);
return stat;
}



int init(char c)
{
char i, bit=BIT8, wr4=NULLCODE, wr3=RxENABLE;
unsigned int param, br, base;
unsigned long paraml;
char p[5];
static unsigned char INTR, mask;

if(c==1){
if(_argc<8) {
	cputs("ASYNSCC  v1.1                                                  IK5NAX  1995\r\n\n");
	cputs("Use:  ASYNSCC <baseaddr> <irq> <port> <baud> <par> <bit> <stop>\r\n\n");
	cputs("<baseaddr> = base address of SCC board  (dip-switch) in HEX \r\n");
	cputs("<irq> = <5|6|7|9|10|11|12|15>\r\n");
	cputs("<port> = <0|1|2|3>\r\n");
	cputs("<baud> from 38 to 1228800 bit/s [auto rounding]\r\n");
	cputs("<par> = <n|e|o>\r\n");
	cputs("<bit> =<5|6|7|8>\r\n");
	cputs("<stop> = <1|2>\r\n");
	exit(0);
	}
sscanf(_argv[1],"%x",&param);
if(param>0x3ff) {cputs("<baseaddr> error"); exit(1);}
BASEADDR=param;
base=BASEADDR;

sscanf(_argv[2],"%d",&param);
switch(param){
	case 5:   INTR=0x0d; mask=0xdf; break;
	case 6:   INTR=0x0e; mask=0xbf; break;
	case 7:   INTR=0x0f; mask=0x7f; break;
	case 9:   INTR=0x71; mask=0xfd; break;
	case 10:  INTR=0x72; mask=0xfb; break;
	case 11:  INTR=0x73; mask=0xf7; break;
	case 12:  INTR=0x74; mask=0xef; break;
	case 15:  INTR=0x77; mask=0x7f; break;
	default: cputs("<irq> error"); exit(1);
}

sscanf(_argv[3],"%d",&param);
switch(param){
	case 0: BASEADDR+=2; ip=CHARxIP; RR3=BASEADDR; break;
	case 1: BASEADDR+=0; ip=CHBRxIP; RR3=BASEADDR+2; break;
	case 2: BASEADDR+=6; ip=CHARxIP; RR3=BASEADDR; break;
	case 3: BASEADDR+=4; ip=CHBRxIP; RR3=BASEADDR+2; break;
	default: cputs("<port> error"); exit(1);
	}
cprintf("\n\rSCC%d    ",param);

sscanf(_argv[4],"%lu",&paraml);
if(paraml<38||paraml>1228800) {cputs("<baud> error"); exit(1);}
br=2457600L/paraml-2;
cprintf("%lu    ",2457600L/(br+2));

sscanf(_argv[5],"%s",&p);
switch(p[0]){
	case 'n':
	case 'N': cprintf("N   "); break;
	case 'o':
	case 'O': cprintf("O   "); wr4|=PAR_ENA; break;
	case 'e':
	case 'E': cprintf("E   "); wr4|=PAR_ENA|PAR_EVEN; break;
	default: cputs("<par> error"); exit(0);
	}

sscanf(_argv[6],"%d",&param);
switch(param){
	case 5: wr3|=Rx5; wr5|=Tx5; cprintf("5   "); bit=BIT5; break;
	case 6: wr3|=Rx6; wr5|=Tx6; cprintf("6   "); bit=BIT6; break;
	case 7: wr3|=Rx7; wr5|=Tx7; cprintf("7   "); bit=BIT7; break;
	case 8: wr3|=Rx8; wr5|=Tx8; cprintf("8   "); bit=BIT8; break;
	default: cputs("<bit> error"); exit(1);
	}

sscanf(_argv[7],"%d",&param);
switch(param){
	case 1: wr4|=SB1; cprintf("1   "); break;
	case 2: wr4|=SB2; cprintf("2   "); break;
	default: cputs("<stop> error"); exit(1);
	}

outportb(BASEADDR,R9);
outportb(BASEADDR,FHWRES);



outportb(BASEADDR,R1);
outportb(BASEADDR,INT_ALL_Rx);
outportb(BASEADDR,R2);
outportb(BASEADDR,0x00);
outportb(BASEADDR,R3);
outportb(BASEADDR,wr3);
outportb(BASEADDR,R4);
outportb(BASEADDR,wr4);
outportb(BASEADDR,R5);
outportb(BASEADDR,wr5);
outportb(BASEADDR,R9);
outportb(BASEADDR,MIE);
outportb(BASEADDR,R10);
outportb(BASEADDR,NULLCODE);
outportb(BASEADDR,R11);
outportb(BASEADDR,TCBR|RCBR);
outportb(BASEADDR,R12);
outportb(BASEADDR,br&0x00ff);
outportb(BASEADDR,R13);
outportb(BASEADDR,br>>8);
outportb(BASEADDR,R12);
if(inportb(BASEADDR)!=(br&0x00ff)) {printf("\nSCC board not found at address %X!",base); exit(1); }
outportb(BASEADDR,R13);
if(inportb(BASEADDR)!=(br>>8)) {printf("\nSCC board not found at address %X!",base); exit(1); }
outportb(BASEADDR,R14);
outportb(BASEADDR,BRENABL|BRSRC);
outportb(BASEADDR,R15);
outportb(BASEADDR,NULLCODE);

disable();
oldvect=getvect(INTR);
setvect(INTR,rxonly);
if(INTR<0x10) outportb(0x21,inportb(0x21)&mask);
else outportb(0xa1,inportb(0xa1)&mask);
enable();
}
else if(c==0)
{
outportb(BASEADDR,R1);
outportb(BASEADDR,NULLCODE);
outportb(BASEADDR,R5);
outportb(BASEADDR,wr5|DTR);
disable();
setvect(INTR,oldvect);
if(INTR<0x10) outportb(0x21,inportb(0x21)|~mask);
else outportb(0xa1,inportb(0xa1)|~mask);
enable();
wr5&=~RTS;
outportb(BASEADDR,R5);
outportb(BASEADDR,wr5);
}
return bit;
}


void interrupt far rxonly(void)
{
char in;
int st;
static char r=0, c=0;
st=stat8530();

window(2,2,79,15);
gotoxy(r,c);

/* L'RR3  unico per tutte e due le porte di ciascun 8530, cos per andare a
leggere solo quello della porta A (quello della B  sempre 0x00) si usa il
valore RR3 anzich il BASEADDR */
outportb(RR3,R3);
if((inportb(RR3)&ip)!=0)
{
if((st&((PAR_ERR|Rx_OVR|CRC_ERR)<<8)!=0))
	{
	window(2,2,79,15);
	gotoxy(r,c);
	// Stampa il carattere
	in=inportb(BASEADDR+1);
	textcolor(LIGHTRED);
	cprintf("%c",in);
	if(in==0x0d) putch(0x0a);
	textcolor(LIGHTGRAY);
	if(p==1)
		{
		fprintf(log,"%c",in);
		if(in==0x0d) fprintf(log,"%c",0x0a);
		}
	r=wherex();
	c=wherey();
	}

if((st&((PAR_ERR|Rx_OVR|CRC_ERR)<<8))!=0) outportb(BASEADDR,ERR_RES);
}
outportb(0x20,0x20); // Ci vogliono tutti e due per irq>7 mentre basterebbe
outportb(0xa0,0x20); // il primo per irq<=7. Cos dovrebbe andare ...
}

void shell(void) {
gettext(1,1,80,25,shell_buffer);
window(1,1,80,25);
textcolor(LIGHTGRAY);
textbackground(BLACK);
clrscr();
if(spawnlp(P_WAIT,"command",NULL)&errno==ENOMEM) {
			 puts("Not enogh Memory to load COMMAND.COM !");
			 puts("\nPress any key");
			 getch();
						}
puttext(1,1,80,25,shell_buffer);
}


void rts(void){
wr5^=RTS;
outportb(BASEADDR,R5);
outportb(BASEADDR,wr5);
window(1,1,80,25);
if(wr5&RTS) {
gotoxy(2,16);
textcolor(LIGHTRED);
cprintf("");
}
else {
gotoxy(2,16);
textcolor(LIGHTGREEN);
cprintf("");
}
}

void setlog(void)
{
p^=0x01;
if(p==1)
	{
	if((log=fopen("LOGFILE.TXT","wt"))==NULL)
		{
		gettext(30,8,50,10,shell_buffer);
		gotoxy(30,8);
		sound(800);
		puts("Can't open the file: LOGFILE.TXT");
		delay(400);
		nosound();
		puttext(30,8,50,10,shell_buffer);
		}
	window(1,1,80,25);
	gotoxy(69,23);
	puts("ON ");
	}
if(p==0)
	{
	fclose(log);
	window(1,1,80,25);
	gotoxy(69,23);
	puts("OFF");
	}
}