/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef EVENT_SLOTS_H
#define EVENT_SLOTS_H

#include <qobject.h>
#include <iostream.h>
#include <fstream.h>
#include "widgets.h"
#include "tnc.h"
#include "buffers.h"
#include "filesend.h"
#include "prog_defs.h"

class EventSlots: public QObject {

    Q_OBJECT

public:
    enum Running_flag{not_running, running};
    enum Autocq_mode {choose, amtor, pactor};
    enum Changeover_mode{rx, tx};
private:
    MainScreen* mainscreen_p;
    ReceiveWin* receivewin_p;
    SendWin* sendwin_p;
    Tnc* tnc_p;
    Transmit_buffer& tr_buffer;
    BufferList& buffer_list;
    int standard_size;
    Running_flag connect_script_flag;
    Running_flag send_parms_flag;
    ifstream script_file;
    ifstream parm_file;
    ifstream message_file;
    char wordwrap_buffer[WORDWRAP + 2];
    int wordwrap_buffer_count;
    int line_lettercount;
    int space_flag;
    int cw_speed_val;
public slots:
    void vhf_menu(int);
    void hf_menu(int);
    inline void change_port(void);
    inline void stream_up(void);
    inline void stream_down(void);
    void change_hfmode(int mode, int prompt_flag);             // slot methods cannot
    void change_hfmode(int mode) {change_hfmode(mode, false);} // take default values
    void make_connection(void);
    void send_message(int message_number, int prompt_flag);                      // slot methods cannot
    void send_message(int message_number) {send_message(message_number, false);} // take default values
    void send_parms(const char*, int);
    void send_tnc_config(void) {send_parms("tnc.parms", true);}
    void download(int); // the int parameter will indicate the type of
                        // DownloadFile object (binary, s_plus) to be created
    void upload(int);   // the int parameter indicates the type of
                        // FileSendBuffer object (text, binary, s_plus) to be created

    void disconnect(void);
    void enter_call(void);
    void lock_call(void);
    void auto_cq(int, int);                                    // slot methods cannot
    void auto_cq(void) {auto_cq(EventSlots::choose, false);}   // take default values
    void lock_speed(void);
    void ident(void);
    void rst(void);
    void sync(void);
    void command(void);
    void abort(void);
    void hfsend_mode(int mode) {prog_func.send_mode = (Prog_func::smode)mode;
                                mainscreen_p->display_send_mode_status();}
    void helpfile(void);
    void capture(void);
    void changeover_rx(void);
    void changeover_tx(void);
    void send_letter(uchar);
    void cw_speed(void);
    void ctrl_a(void);
    void ctrl_t(void);
    void ctrl_z(void);
    void font_change(int size) {sendwin_p->font_change(size); receivewin_p->font_change(size);}
    void settings(void);
    void set_print_mark(void);
    void print_from_mark(void);
    void context_print_mark(void);
public:
    int wordwrap_buffer_add(uchar); // returns letter added, or -1 if tr_buffer full (or we are
                                    // at beginning of a line after a backspace entered)
    void flush_wordwrap_buffer(void);
    void send_parms(void) {send_parms(0, false);}
    void run_connect_script(const char* = 0);
    Running_flag get_connect_script_flag(void) const {return connect_script_flag;}
    Running_flag get_send_parms_flag(void) const {return send_parms_flag;}
    EventSlots(MainScreen* a, ReceiveWin* b, SendWin* c, Tnc* d, Transmit_buffer& e, BufferList& f, int g):
                    mainscreen_p(a), receivewin_p(b), sendwin_p(c),
                    tnc_p(d), tr_buffer(e), buffer_list(f), standard_size(g),
                    connect_script_flag(not_running), send_parms_flag(not_running),
                    wordwrap_buffer_count(0), line_lettercount(0), space_flag(false),
                    cw_speed_val(20) {}
};


inline void EventSlots::change_port(void) {
    if (!tnc_p->tnc_func.active_port) hf_menu(tnc_p->tnc_func.active_hf_stream);
    else vhf_menu(tnc_p->tnc_func.active_vhf_stream);
}

inline void EventSlots::stream_up(void) {
    if (!tnc_p->tnc_func.active_port) {
        if (tnc_p->tnc_func.active_vhf_stream == MAXUSERS - 1) vhf_menu(0);
	else vhf_menu(tnc_p->tnc_func.active_vhf_stream + 1);
    }
    else if (tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        if (tnc_p->tnc_func.active_hf_stream == MAXUSERS - 1) hf_menu(0);
	else hf_menu(tnc_p->tnc_func.active_hf_stream + 1);
    }
}

inline void EventSlots::stream_down(void) {
    if (!tnc_p->tnc_func.active_port) {
        if (!tnc_p->tnc_func.active_vhf_stream) vhf_menu(MAXUSERS - 1);
	else vhf_menu(tnc_p->tnc_func.active_vhf_stream - 1);
    }
    else if (tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        if (!tnc_p->tnc_func.active_hf_stream) hf_menu(MAXUSERS - 1);
        else hf_menu(tnc_p->tnc_func.active_hf_stream - 1);
    }
}

#endif
