/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <qwidgetstack.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qfiledialog.h>
#include <strstream.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>
#include "event_slots.h"
#include "dialogs.h"
#include "download.h"

// PRINT_MARK is the mark which will be printed to screen when a print mark is set
#define PRINT_MARK 167

void EventSlots::make_connection(void) {
  //check preconditions
    if (connect_script_flag == running
	|| tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port]
	    == Tnc_func::connected
	|| (tnc_p->tnc_func.active_port
	     && (tnc_p->tnc_func.hfmode == Tnc_func::rtty
		 || tnc_p->tnc_func.hfmode == Tnc_func::ascii
		 || tnc_p->tnc_func.hfmode == Tnc_func::cw))) {
        QApplication::beep();
	return;
    }

// proceed
    char* connect_call;
    ConnectDialog* connect_dialog_p = new ConnectDialog(tnc_p, standard_size, mainscreen_p);
    if (!connect_dialog_p) {
        cerr << "Memory allocation error in EventSlots::make_connection()" << endl;
	exit(MEM_ERROR);
    }
    int result = connect_dialog_p->exec();
    if (result == QDialog::Accepted && strlen(connect_call = (char*)connect_dialog_p->get_call())) {
        if (!tnc_p->tnc_func.active_port
	    || tnc_p->tnc_func.hfmode == Tnc_func::packet) { // check to see if we need to run a connect script
	    char* filename = new char[strlen(prog_func.filedir) + strlen(connect_call) + 2];
	    if (!filename) {
	        cerr << "Memory allocation error in EventSlots::make_connection()" << endl;
		exit(MEM_ERROR);
	    }
	    strcpy(filename, prog_func.filedir);
	    strcat(filename, "/");
	    strcat(filename, connect_call);

	    if (!access(filename, F_OK)) run_connect_script(filename);
	    delete[] filename;
	}

	if (connect_script_flag == not_running) {
	    if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
	        tnc_p->send_specialcommand(packetCMD);
		usleep(200000);
	    }

	    char* commandmessage;
	    if ((commandmessage = new char[strlen(connect_call) + 10]) == 0) {
	        cerr << "Memory allocation error in connect()" << endl;
		exit(MEM_ERROR);
	    }

	    if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet) {
	        strcpy (commandmessage, packet_connectCMD);
	    }

	    else if (tnc_p->tnc_func.hfmode == Tnc_func::amtor ||
		     tnc_p->tnc_func.hfmode == Tnc_func::lamtor || 
		     tnc_p->tnc_func.hfmode == Tnc_func::fec) {
	        strcpy (commandmessage, amtor_connectCMD);
		tnc_p->tnc_func.hfmode = Tnc_func::amtor;
		mainscreen_p->display_mode();
		mainscreen_p->set_abort_button();
	    }

	    else if (tnc_p->tnc_func.hfmode == Tnc_func::gtor ||
		     tnc_p->tnc_func.hfmode == Tnc_func::gmon) {
	        strcpy (commandmessage, gtor_connectCMD);
		tnc_p->tnc_func.hfmode = Tnc_func::gtor;
		mainscreen_p->display_mode();
	    }

	    else if (tnc_p->tnc_func.hfmode == Tnc_func::pactor) {
	        strcpy (commandmessage, pactor_connectCMD);
	    }

	    strcat(commandmessage, connect_call);
	    tnc_p->send_kamcommand(commandmessage);

	    if (!tnc_p->tnc_func.active_port || (tnc_p->tnc_func.hfmode != Tnc_func::amtor
		   && tnc_p->tnc_func.hfmode != Tnc_func::lamtor
	           && tnc_p->tnc_func.hfmode != Tnc_func::fec)) {
		if (*connect_call == '!') connect_call++; // remove leading '!' if a pactor connect on long path
		char* temp;
		int count;
		for (count = 0, temp = connect_call; count < hisCall_SIZE
		       && *temp && *temp != ' '; temp++, count++) {}
		*temp = 0;    // terminate string at first space
		strcpy(tnc_p->tnc_func.hisCall[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port], connect_call);
		if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
		    tnc_p->tnc_func.hisCall_lock = Tnc_func::on;
		    if (tnc_p->is_validcall(connect_call)) tnc_p->make_selcall(connect_call, tnc_p->tnc_func.selCall);
		    mainscreen_p->set_call_lock_button();
		}
		mainscreen_p->display_callsign();
	    }
	    else if (tnc_p->tnc_func.active_port) strcpy(tnc_p->tnc_func.selCall, connect_call);
	    delete[] commandmessage;
	}
    }
    delete connect_dialog_p;
}

void EventSlots::vhf_menu(int stream) {
  // check preconditions
    if (connect_script_flag == running 
	|| send_parms_flag == running
	|| tnc_p->get_active_freebytes() <= tr_buffer.letters_used() + 3) {
        QApplication::beep();
        return;
    }

    if (tnc_p->tnc_func.active_port || tnc_p->tnc_func.active_stream() != stream) {
        if(tnc_p->get_active_freebytes() > tr_buffer.letters_used() + 3) {
	    receivewin_p->scrollout(true);
	    tnc_p->tnc_func.active_port = 0;
	    tnc_p->tnc_func.active_vhf_stream = stream;
	    receivewin_p->raiseWidget(stream);
	    receivewin_p->buffer_flush();
	    receivewin_p->set_textselected_items();

	    mainscreen_p->display_current_stream();
	    mainscreen_p->display_callsign();
	    mainscreen_p->display_connected_status();
	    mainscreen_p->make_torline();
	    mainscreen_p->display_freebytes();
	    mainscreen_p->set_call_lock_button();
	    mainscreen_p->set_connect_button();
	    mainscreen_p->set_disconnect_button();
	    mainscreen_p->set_speed_lock_button();
	    mainscreen_p->set_auto_cq_button();
	    mainscreen_p->set_speed_lock_button();
	    mainscreen_p->set_ident_button();
	    mainscreen_p->set_sync_button();
	    mainscreen_p->set_abort_button();
	    mainscreen_p->set_rx_button();
	    mainscreen_p->set_tx_button();
	    mainscreen_p->set_cw_speed_button();
	    mainscreen_p->update_print_mark_items();

	    // notify the Kam LEDs of the change
	    tnc_p->send_kamcommand("");
	}
	else QApplication::beep();
    }
}

void EventSlots::hf_menu(int stream) {
  // check preconditions
    if (connect_script_flag == running 
	|| send_parms_flag == running
	|| tnc_p->get_active_freebytes() <= tr_buffer.letters_used() + 3) {
        QApplication::beep();
        return;
    }

    if (!tnc_p->tnc_func.active_port
	|| (tnc_p->tnc_func.active_stream() != stream && tnc_p->tnc_func.hfmode == Tnc_func::packet)) {
        if(tnc_p->get_active_freebytes() > tr_buffer.letters_used() + 3) {
	    receivewin_p->scrollout(true);
	    tnc_p->tnc_func.active_port = 1;
	    if (tnc_p->tnc_func.hfmode == Tnc_func::packet) tnc_p->tnc_func.active_hf_stream = stream;
	    else tnc_p->tnc_func.active_hf_stream = 0;
	    receivewin_p->raiseWidget(stream + MAXUSERS);
	    receivewin_p->buffer_flush();
	    receivewin_p->set_textselected_items();

	    mainscreen_p->display_current_stream();
	    mainscreen_p->display_callsign();
	    mainscreen_p->display_connected_status();
	    mainscreen_p->make_torline();
	    mainscreen_p->display_freebytes();
	    mainscreen_p->update_lockinfo();
	    mainscreen_p->update_torinfo();
	    mainscreen_p->update_txinfo();
	    mainscreen_p->set_call_lock_button();
	    mainscreen_p->set_connect_button();
	    mainscreen_p->set_disconnect_button();
	    mainscreen_p->set_speed_lock_button();
	    mainscreen_p->set_auto_cq_button();
	    mainscreen_p->set_speed_lock_button();
	    mainscreen_p->set_ident_button();
	    mainscreen_p->set_sync_button();
	    mainscreen_p->set_abort_button();
	    mainscreen_p->set_rx_button();
	    mainscreen_p->set_tx_button();
	    mainscreen_p->set_cw_speed_button();
	    mainscreen_p->update_print_mark_items();

	    // notify the Kam LEDs of the change
	    tnc_p->send_kamcommand("");
	}
	else QApplication::beep();
    }
}

void EventSlots::run_connect_script(const char* script) {
// script can have a value of 0 (null pointer) if no file needs to be opened
// because run_connect_script_flag == running
// script has a default value of 0

    if (script && connect_script_flag == not_running) {
        tnc_p->tnc_func.got_disconnect_flag = FALSE;
        script_file.open(script, ios::in | ios::nocreate);
	if (!script_file) {
	    ostrstream strm;
	    strm << script << " cannot be opened" << ends;
	    char* message = strm.str();
	    QMessageBox::warning(mainscreen_p, "Connect Script", message,
				    QMessageBox::Ok | QMessageBox::Default, 0);
	    delete[] message;
	    script_file.clear();
	}
	else {
	    char buffer[257];
	    int firstline_flag = FALSE;
	    int count;
	    while (!firstline_flag && script_file.getline(buffer, 256)) {
	        if ((count = script_file.gcount()) > 1 && *buffer != '#') {  // # at start of line is a comment
		    buffer[--count] = 0;  // null terminate the string
		    firstline_flag = TRUE;
		}
	    }
	    if (!firstline_flag) {
	        ostrstream strm;
		strm << script << " is empty - check the script" << ends;
		char* message = strm.str();
		QMessageBox::warning(mainscreen_p, "Connect Script", message,
					 QMessageBox::Ok | QMessageBox::Default, 0);
		delete[] message;
		script_file.close();
	    }

	    else { 
	        char* commandmessage = new char[strlen(packet_connectCMD) + strlen(buffer) + 1];
		if (!commandmessage) {
		    cerr << "Memory allocation error in Keyboard_controller::run_connect_script()" << endl;
		    exit(MEM_ERROR);
		}
		strcpy(commandmessage, packet_connectCMD);
		strcat(commandmessage, buffer);
		tnc_p->send_kamcommand(commandmessage);
		delete[] commandmessage;
		connect_script_flag = running;
	    }
	}
    }

    // if we never made the initial connect 
    // cancel the attempt to run the script
    else if (connect_script_flag == running
	     && tnc_p->tnc_func.got_disconnect_flag
	     && tnc_p->tnc_func.disconnect_stream.port == tnc_p->tnc_func.active_port
	     && tnc_p->tnc_func.disconnect_stream.stream == tnc_p->tnc_func.active_stream()) {
        connect_script_flag = not_running;
	script_file.close();
    }

    else if (connect_script_flag == running
	     && tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()]
	               [tnc_p->tnc_func.active_port] ==  Tnc_func::connected) {
        char buffer[256];
	char* buffer_ptr;
	int count;
        if ((tnc_p->get_packet_freebytes() > 256) && script_file.getline(buffer, 256)) {
	    if ((count = script_file.gcount()) > 1 && *buffer != '#') {  // # at start of line is a comment
	        buffer_ptr = buffer;
		int index;
		count--;
		for (index = 0; index < count; index++, buffer_ptr++) {
		    tr_buffer.add_letter(*buffer_ptr);
		}
		buffer[index] = 0;  // null terminate string
		sendwin_p->write(buffer);
		tr_buffer.add_letter('\n');
		sendwin_p->new_line();
		usleep(100000);
	    }
	}
	if (!script_file) {              // finished sending script
	    script_file.close();
	    connect_script_flag = not_running;
	}
    }
}

void EventSlots::send_parms(const char* file, int prompt_flag) {
// file can have a value of 0 (null pointer) if no file needs to be opened
// because send_parms_flag == running

//check preconditions
    if (connect_script_flag == running) {
        QApplication::beep();
	return;
    }

    if (prompt_flag) {
        PromptDialog* dialog_p = new PromptDialog("Send Kam set-up parameters?", "Send Parms", standard_size, mainscreen_p);
	if (!dialog_p) {
	    cerr << "Memory allocation error in EventSlots::send_parms()" << endl;
	    exit(MEM_ERROR);
	}
	int result = dialog_p->exec();
	delete dialog_p;
	if (result != QDialog::Accepted) return;
    }

// proceed        
    if (send_parms_flag == not_running) {
        if (file) {
	    // test to see whether file contains path information
	    char* result = strchr(file, '/');

	    ostrstream s1;
	    if (!result) s1 << prog_func.filedir << "/parms/";
	    s1 << file << ends;
	    char* filename = s1.str();
	    
	    parm_file.open(filename, ios::in | ios::nocreate);
	    if (!parm_file) {
	        ostrstream s2;
		s2 << "File " << filename << "\ncannot be found/opened"
		   << "\nCheck that FILEDIR: in kamrc is correct" << ends;
		char* message = s2.str();
		QMessageBox::warning(mainscreen_p, "Send Parameters", message,
					 QMessageBox::Ok | QMessageBox::Default, 0);
		delete[] message;
		parm_file.clear();
	    }
	    else {
	        send_parms_flag = running;
		if (!strcmp(file, "tnc.parms")) { // if we are sending tnc.parms, set up myCall and mySelCall also
		    char* commandmessage;
		    int length = strlen(prog_func.myCall) + 8;
		    if (length < selCall_SIZE + 10) length = selCall_SIZE + 10;
		    if ((commandmessage = new char[length]) == 0) {
		        cerr << "Memory allocation error in EventSlots::sendparms()" << endl;
			exit(MEM_ERROR);
		    }
		    strcpy(commandmessage, "MYCALL ");
		    strcat(commandmessage, prog_func.myCall);
		    tnc_p->send_kamcommand(commandmessage);
		    usleep(200000);
		    strcpy(commandmessage, "MYSELCAL ");
		    strcat(commandmessage, prog_func.mySelCall);
		    tnc_p->send_kamcommand(commandmessage);
		    delete[] commandmessage;
		}
	    }
	    delete[] filename;
	}
	else {
	    receivewin_p->write("\nError in  EventSlots::send_parms()");
	    receivewin_p->write("\nNo file open or file parameter passed()");
	    receivewin_p->write("\nPlease report to address in BUGS file\n");
	}
    }
    if (send_parms_flag == running) {
        char buffer[258];
	int count = 0;

// now keep going in a while loop until we get a line which isn't empty
// and isn't a comment(# at start of line is a comment)
	while(parm_file.getline(buffer, 256) && ((count = parm_file.gcount()) < 2  || *buffer == '#')) {}
	if (parm_file) { // we have a command
	    buffer[--count] = 0;   // null terminate the string
	    char* buffer_ptr = buffer; // get rid of any trailing comment
	    while(*buffer_ptr != 0 && *buffer_ptr != '#') buffer_ptr++;
	    if (*buffer_ptr == '#') {
	        *buffer_ptr = 0;
	    }
	    tnc_p->send_kamcommand(buffer);
	    usleep(200000);
	}
	else {  // we have sent all the commands in tnc.parms
	    parm_file.close();
	    parm_file.clear();
	    send_parms_flag = not_running;
	}
    }
}

void EventSlots::send_message(int message_number, int prompt_flag) {
  //check preconditions
    if (connect_script_flag == running) {
        QApplication::beep();
	return;
    }
    if (prompt_flag) {
        PromptDialog* dialog_p = new PromptDialog("Send message?", "Send Message", standard_size, mainscreen_p);
	if (!dialog_p) {
	    cerr << "Memory allocation error in EventSlots::send_message()" << endl;
	    exit(MEM_ERROR);
	}
	int result = dialog_p->exec();
	delete dialog_p;
	if (result != QDialog::Accepted) return;
    }
        
// now proceed

    char* filename = new char[strlen(prog_func.filedir) + 10];
    if (!filename) {
        cerr << "Memory allocation error in EventSlots::send_message()" << endl;
	exit(MEM_ERROR);
    }
    strcpy(filename, prog_func.filedir);
    strcat(filename, "/messages");

    message_file.open(filename, ios::in | ios::nocreate);
    if(!message_file) {
        ostrstream strm;
	strm << filename << " cannot be found/opened" << ends;
	char* message = strm.str();
	QMessageBox::warning(mainscreen_p, "Send Message", message,
				 QMessageBox::Ok | QMessageBox::Default, 0);
	delete[] message;
	message_file.clear();
    }
    else {
	char buffer[MESSAGE_SIZE + 1];
	int extracted = 0;
	int result = 0;
	while(!result && message_file.getline(buffer, MESSAGE_SIZE)) {
	    if (*buffer == '#' && *(buffer + 1) == (char)message_number) {
	        // now get next line
	        if (message_file.getline(buffer, MESSAGE_SIZE) && (extracted = message_file.gcount()) > 0)  {
		    buffer[extracted - 1] = 0;  // null terminate last line extracted
		    result = 1;
		}
	    }
	}
	if (result) {
	    if ((char)message_number == '0' || (char)message_number > '5') {  // send a file
	        message_file.close();
		FilesendBuffer* filesend_ptr = new FilesendBuffer(FileBuffer::text,
		     tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port, tnc_p,
		      sendwin_p, receivewin_p);
		if (!filesend_ptr) {
		    cerr << "Memory allocation error in Keyboard_controller::send_message()" << endl;
		    exit(MEM_ERROR);
		}
		if (filesend_ptr->open_file(buffer, TRUE)) buffer_list.add(filesend_ptr);
		else delete filesend_ptr;
	    }
	    else {  // send the message in ./messages
	        int count = 0;
		int index;
		char letter;
		result = 0;
		//sendwin_p->setAutoUpdate(false);

		do {
		    if (count) {  // terminate any former line with '\n'
		        wordwrap_buffer_add('\n');
		    }
		    buffer[--extracted] = 0;
		    for (index = 0; (letter = buffer[index]) != 0
			     && count < MESSAGE_SIZE && result != -1; index++, count++) {

		        if (tnc_p->tnc_func.active_port && (uchar)letter > 31) {
			    if (tnc_p->tnc_func.hfmode == Tnc_func::rtty
				|| tnc_p->tnc_func.hfmode == Tnc_func::fec
				|| tnc_p->tnc_func.hfmode == Tnc_func::amtor
				|| (tnc_p->tnc_func.hfmode == Tnc_func::gtor
				    && tnc_p->tnc_func.stream_status[0][1] == Tnc_func::disconnected)
				|| (tnc_p->tnc_func.hfmode == Tnc_func::tor
				    && (tnc_p->tnc_func.stream_status[0][1] == Tnc_func::disconnected
					|| tnc_p->tnc_func.tor_connected_mode == Tnc_func::not_pactor_gtor))) {
			        if (!is_baudot(letter)) letter = 0;
				else if (tnc_p->tnc_func.hfmode == Tnc_func::rtty) letter = toupper(letter);
			    }
			    else if (tnc_p->tnc_func.hfmode == Tnc_func::cw) {
			        if (!is_morse(letter) && letter != '$') letter = 0; // allow the $ token through
				else letter = toupper(letter);
			    }
			}

#if CHAR_SET==LATIN_1
			if ((uchar)letter > 31 || letter == '\n') {
#elif CHAR_SET==CP437
			if (((uchar) letter < 256 && (uchar)letter > 31) || letter == '\n') {
#else
			if ((letter < 127 && letter > 31) || letter == '\n') {
#endif
			    if (letter == '$') {
			        int second_letter = buffer[index + 1];
				if (second_letter == 'a') {
				    for (char* letter_ptr = prog_func.myCall;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'a' code
				}
				else if (second_letter == 'b') {
				    for (char* letter_ptr = prog_func.mySelCall;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'b' code
				}
				else if (second_letter == 'c') {
				    for (char* letter_ptr = tnc_p->tnc_func.hisCall[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'c' code
				}
				else if (second_letter == 'd') {
				    time_t time_val;
				    time(&time_val);
				    tm* time_ptr = gmtime(&time_val);
				    ostrstream s1;
				    s1 << setfill('0') << setw(2) << time_ptr->tm_hour
				       << ":" << setw(2) << time_ptr->tm_min << ends;
				    char* time_string = s1.str();
				    for (char* letter_ptr = time_string;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    delete[] time_string;
				    index++; // get rid of the 'd' code
				}
				else if (second_letter == 'e') {
				    time_t time_val;
				    time(&time_val);
				    tm* time_ptr = gmtime(&time_val);
				    ostrstream s1;
				    char month[4];
				    get_month(month, time_ptr->tm_mon);
				    s1 << time_ptr->tm_mday << "-" << month  << "-"
				       << setfill('0') << setw(2) << (time_ptr->tm_year)%100 << ends;
				    char* date_string = s1.str();
				    for (char* letter_ptr = date_string;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    delete[] date_string;
				    index++; // get rid of the 'e' code
				}
				else if (second_letter == 'f') {
				    for (char* letter_ptr = prog_func.rst;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'f' code
				}
				else if (second_letter == 0) {  // last letter of line is a '$'
				    result = wordwrap_buffer_add('$');
				}
			    }
			    else {
			        result = wordwrap_buffer_add(letter);
			    }
			}
		    }
		} while (result != -1 && count < MESSAGE_SIZE && message_file.getline(buffer, MESSAGE_SIZE) &&
			 *buffer != '#' && *buffer != 0 && (extracted = message_file.gcount()) > 0);
		message_file.close();
	    }
	}
	else {  // no entry in ./messages for this message number
	    QApplication::beep();
	    message_file.close();
	}
    }
    delete[] filename;
}


void EventSlots::change_hfmode(int mode, int prompt_flag) {
// check preconditions
    if (connect_script_flag == running 
	|| prog_func.sending_autocq
	|| tnc_p->tnc_func.hfmode == mode) {
        if (mode == Tnc_func::cw) cw_speed();
        return;
    }

// now proceed

    ostrstream command_strm;
    ostrstream message_strm;

    message_strm << "Change to ";

    switch(mode) {
    case(Tnc_func::packet):
        command_strm << ends;
	message_strm << "Packet";
	break;
    case(Tnc_func::pactor):
        command_strm << pactorCMD << ends;
	message_strm << "Pactor";
	break;
    case(Tnc_func::rtty):
	command_strm << rttyCMD << ends;
	message_strm << "RTTY";
	break;
    case(Tnc_func::ascii):
	command_strm << asciiCMD << ends;
	message_strm << "ASCII";
	break;
    case(Tnc_func::amtor):
	command_strm << amtorCMD << ends;
	message_strm << "Amtor";
	break;
    case(Tnc_func::lamtor):
	command_strm << lamtorCMD << ends;
	message_strm << "Lamtor";
	break;
    case(Tnc_func::fec):
	command_strm << fecCMD << ends;
	message_strm << "Fec";
	break;
    case(Tnc_func::gtor):
	command_strm << gtorCMD << ends;
	message_strm << "Gtor";
	break;
    case(Tnc_func::gmon):
	command_strm << gmonCMD << ends;
	message_strm << "Gmon";
	break;
    case(Tnc_func::tor):
	command_strm << torCMD << ends;
	message_strm << "Tor";
	break;
    case(Tnc_func::cw):
	command_strm << cwCMD << ends;
	message_strm << "CW";
	break;
    }

    char* command = command_strm.str();
    message_strm << "?" << ends;
    char* message = message_strm.str();

    int result = QDialog::Rejected;
    if (prompt_flag) {
        PromptDialog* dialog_p = new PromptDialog(message, "Change Mode", standard_size, mainscreen_p);
	if (!dialog_p) {
	    cerr << "Memory allocation error in EventSlots::change_hfmode()" << endl;
	    exit(MEM_ERROR);
	}
	result = dialog_p->exec();
	delete dialog_p;
    }

    if (!prompt_flag || result == QDialog::Accepted) {
        tr_buffer.reset();
	if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.active_hf_stream != 0) {
	    tnc_p->tnc_func.active_port = 1;
	    tnc_p->tnc_func.active_hf_stream = 0;
	    receivewin_p->raiseWidget(MAXUSERS);
	}
	else receivewin_p->scrollout(true);
	
	tnc_p->send_specialcommand(packetCMD);

	if (tnc_p->tnc_func.capture_stream.port   // if file capture was set to a HF Packet, cancel
		 && tnc_p->tnc_func.capturefile_flag) {
	    tnc_p->tnc_func.capturefile_flag = FALSE;
	    tnc_p->tnc_func.capturefile.close();
	    mainscreen_p->display_capture_status();
	}

	if (mode != Tnc_func::packet) {
	    usleep(200000);
	    tnc_p->send_kamcommand(command);
	}

	tnc_p->tnc_func.hfmode = (Tnc_func::Hfmode)mode;
	mainscreen_p->display_mode();

	tnc_p->tnc_func.speed_lock = Tnc_func::off;
	tnc_p->tnc_func.have_sent_lock = Tnc_func::no;
	tnc_p->tnc_func.sending_cw_flag = FALSE;
	mainscreen_p->display_current_stream();
	mainscreen_p->display_callsign();
	mainscreen_p->display_connected_status();
	mainscreen_p->make_torline();
	mainscreen_p->display_freebytes();
	mainscreen_p->set_call_lock_button();
	mainscreen_p->set_connect_button();
	mainscreen_p->set_disconnect_button();
	mainscreen_p->set_speed_lock_button();
	mainscreen_p->set_auto_cq_button();
	mainscreen_p->set_speed_lock_button();
	mainscreen_p->set_ident_button();
	mainscreen_p->set_sync_button();
	mainscreen_p->set_abort_button();
	mainscreen_p->set_rx_button();
	mainscreen_p->set_tx_button();
	mainscreen_p->set_cw_speed_button();
	receivewin_p->buffer_flush();

	if (mode != Tnc_func::packet) {
	    mainscreen_p->update_lockinfo();
	    mainscreen_p->update_torinfo();
	    mainscreen_p->update_txinfo();
	    mainscreen_p->show_tormenu_streams();
	}
	else mainscreen_p->show_packetmenu_streams();
	// notify the Kam LEDs of the change
	tnc_p->send_kamcommand("");
    }
    delete[] command;
    delete[] message;
}

void EventSlots::capture(void) {

    if (tnc_p->tnc_func.capturefile_flag) {
        tnc_p->tnc_func.capturefile_flag = FALSE;
	tnc_p->tnc_func.capturefile.close();
    }

    else {
        tnc_p->tnc_func.capturefile_flag = TRUE;
	tnc_p->tnc_func.capture_stream.port = tnc_p->tnc_func.active_port;
	tnc_p->tnc_func.capture_stream.stream = tnc_p->tnc_func.active_stream();
	char* filename = new char[strlen(prog_func.filedir) + 13];
	if (!filename) {
	    cerr << "Memory allocation error in EventSlots::capture()" << endl;
	    exit(MEM_ERROR);
	}
	strcpy(filename, prog_func.filedir);
	strcat(filename, "/capture.txt");
		    
	tnc_p->tnc_func.capturefile.open(filename, ios::out | ios::app);
	if (!tnc_p->tnc_func.capturefile) {
	    QMessageBox::warning(mainscreen_p, "Capture",
				     "File capture.txt could not be opened",
				     QMessageBox::Ok | QMessageBox::Default, 0);
	  tnc_p->tnc_func.capturefile_flag = FALSE;
	}
	delete[] filename;
    }
    mainscreen_p->display_capture_status();
    mainscreen_p->set_capture_button();
}

void EventSlots::lock_call(void) {
// check preconditions
    if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        return;
    }

// proceed

    if (tnc_p->tnc_func.hisCall_lock == Tnc_func::off) {
        tnc_p->tnc_func.hisCall_lock = Tnc_func::on;
    }
    else tnc_p->tnc_func.hisCall_lock = Tnc_func::off;
    mainscreen_p->display_callsign();
    mainscreen_p->set_call_lock_button();
}

void EventSlots::disconnect(void) {

// check preconditions
    if (tnc_p->tnc_func.active_port
	&& tnc_p->tnc_func.hfmode != Tnc_func::packet
	&& tnc_p->tnc_func.hfmode != Tnc_func::amtor
	&& tnc_p->tnc_func.hfmode != Tnc_func::gtor
	&& tnc_p->tnc_func.hfmode != Tnc_func::pactor
	&& tnc_p->tnc_func.hfmode != Tnc_func::tor) {
        return;
    }

// proceed
    PromptDialog* dialog_p = new PromptDialog("Disconnect?", "Disconnect", standard_size, mainscreen_p);
    if (!dialog_p) {
        cerr << "Memory allocation error in EventSlots::disconnect()" << endl;
	exit(MEM_ERROR);
    }
    int result = dialog_p->exec();
    delete dialog_p;

    if (result == QDialog::Accepted) {
        tr_buffer.reset();
	if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet) {
	  tnc_p->send_kamcommand(packet_disconnectCMD);
	}
	else tnc_p->send_specialcommand(tor_disconnectCMD);
    }
}

void EventSlots::ident(void) {
// check preconditions
    if (!tnc_p->tnc_func.active_port
	|| tnc_p->tnc_func.hfmode == Tnc_func::packet
	|| connect_script_flag == running) {

        QApplication::beep();
	return;
    }

// proceed
    char* message = new char[strlen(prog_func.myCall) + hisCall_SIZE + 5]; // must be large enough for
    if (!message) {
        cerr << "Memory allocation error in EventSlots::ident()" << endl;
	exit(MEM_ERROR);
    }
    strcpy(message, tnc_p->tnc_func.hisCall[0][1]);     // myCall and hisCall and " de "
    if (tnc_p->tnc_func.hfmode == Tnc_func::rtty
	|| tnc_p->tnc_func.hfmode == Tnc_func::cw) {
        strcat(message, " DE ");
    }
    else strcat(message, " de ");
    strcat(message, prog_func.myCall);
    strcat(message, " ");

    int index;
    int result;
    for (index = result = 0; result != -1 && message[index]; index++) {
        result = wordwrap_buffer_add(message[index]);
    }
    delete[] message;
}

void EventSlots::sync(void) {
//check preconditions
    if (!tnc_p->tnc_func.active_port
	|| (tnc_p->tnc_func.hfmode != Tnc_func::cw
	    && tnc_p->tnc_func.hfmode != Tnc_func::lamtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::fec
	    && !(tnc_p->tnc_func.hfmode == Tnc_func::amtor
		 && tnc_p->tnc_func.stream_status[0][1] == Tnc_func::disconnected))) {
        return;
    }

// proceed
    if (tnc_p->tnc_func.hfmode == Tnc_func::cw) {
        tnc_p->send_specialcommand('L');
	usleep(200000);
	tnc_p->send_specialcommand('U');
    }
    else {
        tnc_p->send_specialcommand(immediate_rxCMD);
	usleep(100000);
    }
}

void EventSlots::abort(void) {
// check preconditions
    if (!tnc_p->tnc_func.active_port
	|| (tnc_p->tnc_func.hfmode != Tnc_func::amtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::pactor
	    && tnc_p->tnc_func.hfmode != Tnc_func::gtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::tor)) {
        return;
    }

// proceed
    PromptDialog* dialog_p = new PromptDialog("Abort?", "Abort", standard_size, mainscreen_p);
    int result = dialog_p->exec();
    delete dialog_p;

    if (result == QDialog::Accepted) {
        tr_buffer.reset();
	tnc_p->send_specialcommand(aborttxCMD);
    }
}

void EventSlots::enter_call(void) {
    char* callsign = 0;
    CallsignDialog* callsign_dialog_p = new CallsignDialog(tnc_p, standard_size, mainscreen_p);
    if (!callsign_dialog_p) {
        cerr << "Memory allocation error in EventSlots::enter_call()" << endl;
	exit(MEM_ERROR);
    }
    int result = callsign_dialog_p->exec();

    if (result == QDialog::Accepted && strlen(callsign = (char*)callsign_dialog_p->get_call())) {
        strcpy(tnc_p->tnc_func.hisCall[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port], callsign);
	if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
	    tnc_p->tnc_func.hisCall_lock = Tnc_func::on;
	    if (tnc_p->is_validcall(callsign)) tnc_p->make_selcall(callsign, tnc_p->tnc_func.selCall);
	    mainscreen_p->set_call_lock_button();
	}
	mainscreen_p->display_callsign();
    }
    delete callsign_dialog_p;
}

void EventSlots::command(void) {
    char* command = 0;
    CommandDialog* command_dialog_p = new CommandDialog(standard_size, mainscreen_p);
    if (!command_dialog_p) {
        cerr << "Memory allocation error in EventSlots::command()" << endl;
	exit(MEM_ERROR);
    }
    int result = command_dialog_p->exec();
    if (result == CommandDialog::accepted && strlen(command = (char*)command_dialog_p->get_command())) {
        tnc_p->send_kamcommand(command);
    }
    else if (result == CommandDialog::script) {

        char* startdir = new char[strlen(prog_func.filedir) + 7];
	if (!startdir) {
	    cerr << "Memory allocation error in EventSlots::command()" << endl;
	    exit(MEM_ERROR);
	}
	strcpy(startdir, prog_func.filedir);
	strcat(startdir, "/parms");
        QString filename = QFileDialog::getOpenFileName(startdir);
	if (!filename.isNull()) {
	    send_parms(filename, false);
	}
    }
    delete command_dialog_p;
}

void EventSlots::changeover_rx(void) {
// check preconditions
    if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        return;
    }

// proceed
    if (tr_buffer.letters_free() > 5) {
        if (tnc_p->tnc_func.stream_status[0][1] == Tnc_func::connected) {
	    if (tnc_p->tnc_func.tor_connected_mode == Tnc_func::pactor_gtor) {
	        wordwrap_buffer_add('=');
		wordwrap_buffer_add('>');
	    }
	    else if (tnc_p->tnc_func.hfmode == Tnc_func::amtor
		     || (tnc_p->tnc_func.hfmode == Tnc_func::tor
			 && tnc_p->tnc_func.tor_connected_mode == Tnc_func::not_pactor_gtor)) {
	        sendwin_p->write("+?");
	    }
	}
	flush_wordwrap_buffer();
	if (tnc_p->tnc_func.hfmode == Tnc_func::cw) {
	    tnc_p->send_specialcommand(immediate_rxCMD);
	    tnc_p->tnc_func.sending_cw_flag = FALSE;
	    usleep(100000);
	}
	else {
	    tr_buffer.add_letter(CMDinbuffer);
	    tr_buffer.add_letter(rxCMD);
	    tr_buffer.add_letter(CMDinbuffer);
	}
    }
    else {
      QApplication::beep();
    }
}


void EventSlots::changeover_tx(void) {
// check preconditions
    if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        return;
    }

// proceed
    tnc_p->send_specialcommand(txCMD);
    if (tnc_p->tnc_func.hfmode == Tnc_func::cw) tnc_p->tnc_func.sending_cw_flag = TRUE;
    usleep(100000);
}

int EventSlots::wordwrap_buffer_add(uchar letter) {
    int return_val = letter;
    char text[2] = {0};
    if (letter == ' ') {
        if (tr_buffer.letters_free() > wordwrap_buffer_count + 2) { // leave space for ' ' and possible '\n'
	    flush_wordwrap_buffer();
	    if (line_lettercount < WORDWRAP) {
	        *text = ' ';
		sendwin_p->write(text);
		line_lettercount++;
		space_flag = TRUE;
	    }
	    else {
	        tr_buffer.add_letter('\n');
		sendwin_p->new_line();
		line_lettercount = 0;
		space_flag = FALSE;
	    }
	}
	else {
	    QApplication::beep();
	    return_val = -1;
	}
    }
    
    else if (letter == '\n') {
        if (tr_buffer.letters_free() > wordwrap_buffer_count + 2) { // leave space for '\n' and possible ' '
	    flush_wordwrap_buffer();
	    tr_buffer.add_letter('\n');
	    sendwin_p->new_line();
	    line_lettercount = 0;
	    space_flag = FALSE;
	}
	else {
	    QApplication::beep();
	    return_val = -1;
	}
    }

    else if (letter == 8) {
        if (line_lettercount) {
	    if (wordwrap_buffer_count) {
	        wordwrap_buffer_count--;
		line_lettercount--;
		sendwin_p->backspace();        // now erase letter from screen
	    }
	    else if (space_flag) {
	        space_flag = FALSE;            // we cancel the space reserved to go before the word in wordwrap_buffer
		line_lettercount--;
		sendwin_p->backspace();        // now erase letter from screen
	    }
	    else if (tr_buffer.view_letter() != 8) {  // we don't want to delete a delete!
	        int result = tr_buffer.erase_letter();
		if (!result) {
		    QApplication::beep();
		}
		else {
		    if (result == -1) {  // if last letter already extracted, and we are in pactor or gtor,
		                         // we need to send value 8 to the Kam
		        tr_buffer.add_letter(8);
		    }
		    line_lettercount--;
		    sendwin_p->backspace();        // now erase letter from screen
		}
	    }
	    else { // add another delete to a delete
	        tr_buffer.add_letter(8);
		line_lettercount--;
		sendwin_p->backspace();        // now erase letter from screen
	    }
	}
	else {
	    QApplication::beep();
	    return_val = -1;
	}
    }

    else if (line_lettercount > WORDWRAP) {
        if (tr_buffer.letters_free() > wordwrap_buffer_count + 2) { // leave space for a '\n'
	    if (line_lettercount > wordwrap_buffer_count) { // check to see if the whole
			                                    // line is one word!
	        int line, col;
		sendwin_p->cursorPosition(&line, &col);
		sendwin_p->setCursorPosition(line, col - wordwrap_buffer_count);
		sendwin_p->del_line();
		tr_buffer.add_letter('\n');
		line_lettercount = wordwrap_buffer_count;
		space_flag = FALSE;
		wordwrap_buffer[wordwrap_buffer_count] = 0; // null terminate wordwrap_buffer
		sendwin_p->insertLine(wordwrap_buffer);
		sendwin_p->setCursorPosition(END_OF_WINDOW, END_OF_WINDOW);  // END_OF_WINDOW is defined in widgets.h
	    }
	    else {           // the whole line was one word - break it
	        flush_wordwrap_buffer();
	        tr_buffer.add_letter('\n');
		sendwin_p->new_line();
		line_lettercount = 0;
	    }
	    wordwrap_buffer[wordwrap_buffer_count++] = letter;
	    *text = (unsigned char)letter;
	    sendwin_p->write(text);
	    line_lettercount++;
	}
	else {
	    QApplication::beep();
	    return_val = -1;
	}
    }
    
    else {
        if (tr_buffer.letters_free() > wordwrap_buffer_count + 2) { // leave space for a possible ' '
	    wordwrap_buffer[wordwrap_buffer_count++] = letter;
	    *text = (unsigned char)letter;
	    sendwin_p->write(text);
	    line_lettercount++;
	}
	else {
	    QApplication::beep();
	    return_val = -1;
	}
    }
    return return_val;
}

void EventSlots::flush_wordwrap_buffer(void) {
    if (space_flag) tr_buffer.add_letter(' ');
    int index;
    for (index = 0; index < wordwrap_buffer_count; index++) {
        tr_buffer.add_letter(wordwrap_buffer[index]);
    }
    wordwrap_buffer_count = 0;
}

void EventSlots::send_letter(uchar letter) {
// check preconditions
    if (tnc_p
	&& (connect_script_flag == EventSlots::running
	    ||  buffer_list.get_upload_status(tnc_p->tnc_func.active_stream(),
					      tnc_p->tnc_func.active_port) == BufferList::file)) {
        return;
    }

// proceed
    if (tnc_p && tnc_p->tnc_func.active_port) {
        if (tnc_p->tnc_func.hfmode == Tnc_func::rtty
	    || tnc_p->tnc_func.hfmode == Tnc_func::fec
	    || tnc_p->tnc_func.hfmode == Tnc_func::amtor
	    || (tnc_p->tnc_func.hfmode == Tnc_func::gtor
		&& tnc_p->tnc_func.stream_status[0][1] == Tnc_func::disconnected)
	    || (tnc_p->tnc_func.hfmode == Tnc_func::tor
		&& (tnc_p->tnc_func.stream_status[0][1] == Tnc_func::disconnected
		    || tnc_p->tnc_func.tor_connected_mode == Tnc_func::not_pactor_gtor))) {
	    if (!is_baudot((char)letter) && letter != 8) letter = 0;
	    else if (tnc_p->tnc_func.hfmode == Tnc_func::rtty) letter = toupper(letter);
	}
		
	else if (tnc_p->tnc_func.hfmode == Tnc_func::cw) {
	    if (!is_morse((char)letter) && letter != 8) letter = 0;
	    else letter = toupper(letter);
	}
    }

#if CHAR_SET==LATIN_1
    if (letter > 31 || letter == '\n' || letter == 8) {
#elif CHAR_SET==CP437
    if ((letter < 256 && letter > 31) || letter == '\n' || letter == 8) {
#else
    if ((letter < 127 && letter > 31) || letter == '\n' || letter == 8) {
#endif
        wordwrap_buffer_add(letter);
    }
}

void EventSlots::lock_speed(void) {
//check preconditions
    if (!tnc_p->tnc_func.active_port
	|| (tnc_p->tnc_func.hfmode != Tnc_func::pactor
	    && tnc_p->tnc_func.hfmode != Tnc_func::gtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::tor)) {

        return;
    }

// proceed
    if (tnc_p->tnc_func.speed_lock == Tnc_func::off) {
        tnc_p->tnc_func.speed_lock = Tnc_func::on;
	tnc_p->tnc_func.have_sent_lock = Tnc_func::yes;
	tnc_p->send_specialcommand('1');
    }
    else {
        tnc_p->tnc_func.speed_lock = Tnc_func::off;
	tnc_p->tnc_func.have_sent_lock = Tnc_func::no;
	tnc_p->send_specialcommand('0');
    }
    mainscreen_p->update_lockinfo();
    mainscreen_p->set_speed_lock_button();
}

void EventSlots::rst(void) {
    char* report = 0;
    RstDialog* rst_dialog_p = new RstDialog(standard_size, mainscreen_p);
    if (!rst_dialog_p) {
        cerr << "Memory allocation error in EventSlots::rst()" << endl;
	exit(MEM_ERROR);
    }
    int result = rst_dialog_p->exec();
    if (result == QDialog::Accepted && strlen(report = (char*)rst_dialog_p->get_rst())) {
        strcpy(prog_func.rst, report);
    }
    delete rst_dialog_p;
}

void EventSlots::upload(int mode) {
// check preconditions
    if (buffer_list.get_upload_status(tnc_p->tnc_func.active_stream(),
	                              tnc_p->tnc_func.active_port) == BufferList::file) {
        return;
    }

// proceed
    QString filename = QFileDialog::getOpenFileName(prog_func.filedir);
    if (!filename.isNull()) {
        ifstream file(filename, ios::in | ios::nocreate); // we just want to fine the file size
	if (!file) {
	    ostrstream strm;
	    strm << filename << " cannot be found/opened" << ends;
	    char* message = strm.str();
	    QMessageBox::warning(mainscreen_p, "Filesend", message,
				 QMessageBox::Ok | QMessageBox::Default, 0);
	    delete[] message;
	}
        else {
	    file.seekg(0, ios::end);
	    streampos size = file.tellg();
	    file.close(); // got the file size - now close it
	    if (size) {
	        UploadDialog* dialog_p = new UploadDialog(filename, size, tnc_p, buffer_list,
							  mainscreen_p, receivewin_p, standard_size);
		if (!dialog_p) {
		    cerr << "Memory allocation error in EventSlots::upload()" << endl;
		    exit(MEM_ERROR);
		}
		// the FilesendBuffer object will now take ownership of the UploadDialog object
		FilesendBuffer* filesend_p = new FilesendBuffer((FileBuffer::Buffer_mode)mode,
				     tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port, tnc_p,
				     sendwin_p, receivewin_p, dialog_p);
		if (!filesend_p) {
		    cerr << "Memory allocation error in EventSlots::upload()" << endl;
		    exit(MEM_ERROR);
		}
		if (filesend_p->open_file(filename, FALSE)) {
		    buffer_list.add(filesend_p);
		    dialog_p->show();  // UploadDialog objects are modeless and are deleted when removed
		                       // from MainScreen::upload_dialogs in method MainScreen::timerEvent()
		}
		else delete filesend_p;  // this will also delete the UploadDialog object
	    }
	}
    }
}

void EventSlots::download(int mode) {

    DownloadList* download_list_p = tnc_p->tnc_func.download_list_ptr;
// check preconditions
    if (download_list_p->get_download_status(tnc_p->tnc_func.active_stream(),
	                              tnc_p->tnc_func.active_port) == DownloadList::on) {
        return;
    }

// proceed
    int file_flag = false;
    int break_flag = false;
    QString filename;
    while (!break_flag) {
        filename = QFileDialog::getSaveFileName(prog_func.filedir);
	if (!filename.isNull()) {
	    if (!access(filename, F_OK)) { // file exists, check whether to overwrite
	        ostrstream strm;
		strm << "File " << filename << " already exists\nOverwrite it?" << ends;
		char* message = strm.str();
		switch (QMessageBox::warning(mainscreen_p, "Download", message,
					     QMessageBox::Ok | QMessageBox::Default,
					     QMessageBox::Retry,
					     QMessageBox::Cancel | QMessageBox::Escape)) {
		    case QMessageBox::Ok: file_flag = break_flag = true; break;
		    case QMessageBox::Cancel: break_flag = true; break;
		}
		delete[] message;
	    }
	    else file_flag = break_flag = true;
	}
	else break_flag = true;
    }
    if (file_flag) {
        DownloadDialog* dialog_p = new DownloadDialog(filename, tnc_p, mainscreen_p, receivewin_p,
						      standard_size);
	if (!dialog_p) {
	    cerr << "Memory allocation error in EventSlots::download()" << endl;
	    exit(MEM_ERROR);
	}
	// the DownloadFile object will now take ownership of the DownloadDialog object
        DownloadFile* download_file_p = new DownloadFile((DownloadFile::Download_mode)mode,
			tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port, dialog_p);
	if (!download_file_p) {
	    cerr << "Memory allocation error in EventSlots::download()" << endl;
	    exit(MEM_ERROR);
	}
	if (download_file_p->open_file(filename)) {
	    download_list_p->add(download_file_p);
	    mainscreen_p->display_connected_status();
	    dialog_p->show();  // DownloadDialog objects are modeless and are deleted when the DownloadFile
		               // object is deleted in the method DownloadDialog::end_download() or
	                       // in Tnc::read_state_message()
	}
	else {
	    delete download_file_p;  // this will also delete the DownloadDialog object
	    ostrstream strm;
	    strm << filename << " cannot be opened for writing" << ends;
	    char* message = strm.str();
	    QMessageBox::warning(mainscreen_p, "Download File", message,
				 QMessageBox::Ok | QMessageBox::Default, 0);
	    delete[] message;
	}
    }
}

void EventSlots::auto_cq(int mode, int prompt) {
// check preconditions

    if (!tnc_p->tnc_func.active_port
	|| (tnc_p->tnc_func.hfmode != Tnc_func::pactor
	    && tnc_p->tnc_func.hfmode != Tnc_func::amtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::gtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::tor)
	|| tnc_p->tnc_func.stream_status[0][1] == Tnc_func::connected
	|| (mode == EventSlots::pactor && tnc_p->tnc_func.hfmode != Tnc_func::tor)
	|| (!prog_func.sending_autocq
	    && buffer_list.get_upload_status(0, 1) == BufferList::file)) {
        return;
    }

// proceed
    int result;
    if (prog_func.sending_autocq) {
	result = QDialog::Rejected;
	if (prompt) {
	    PromptDialog* dialog_p = new PromptDialog("Stop sending Auto-CQ?", "Stop Auto-CQ", standard_size, mainscreen_p);
	    if (!dialog_p) {
	        cerr << "Memory allocation error in EventSlots::auto_cq()" << endl;
		exit(MEM_ERROR);
	    }
	    result = dialog_p->exec();
	    delete dialog_p;
	}
	if (!prompt || result == QDialog::Accepted) { // we need to find the file buffer sending the cq message
	    buffer_list.reset(DList_enum::bottom_end);
	    FileBuffer* file_buffer_p;
	    while ((file_buffer_p = (FileBuffer*)buffer_list.inspect(DList_enum::up)) != 0
		   && !(file_buffer_p->get_stream() == 0
			&& file_buffer_p->get_port() == 1)) {}
	    if (file_buffer_p) file_buffer_p->end_loading();
	    // EventSlots::display_connected_status() will be called in CqsendBuffer::load_buffer(),
	    // and EventSlots::set_auto_cq_button() will be called in EventSlots::timerEvent()
	    // once the buffer is extracted - calling them now will give a false display

	    else {
	        receivewin_p->write("\nOops - can't find the cq file buffer to delete\n");
		QApplication::beep();
		prog_func.sending_autocq = FALSE;
		mainscreen_p->display_connected_status();
		mainscreen_p->set_auto_cq_button();
	    }
	}
    }
    else {
        if (mode == EventSlots::pactor) prog_func.tor_autocq_mode = Prog_func::pactor;
	else prog_func.tor_autocq_mode = Prog_func::amtor;

	result = QDialog::Rejected;
	if (mode == EventSlots::choose
	    && tnc_p->tnc_func.hfmode == Tnc_func::tor) {
	    Autocq_modeDialog* autocq_dialog_p = new Autocq_modeDialog(standard_size, mainscreen_p);
	    if (!autocq_dialog_p) {
	        cerr << "Memory allocation error in EventSlots::auto_cq()" << endl;
		exit(MEM_ERROR);
	    }
	    result = autocq_dialog_p->exec();
	    delete autocq_dialog_p;
	    prompt = true;
	}
	else if (prompt) {
	    PromptDialog* dialog_p = new PromptDialog("Send Auto-CQ?", "Auto-CQ", standard_size, mainscreen_p);
	    if (!dialog_p) {
	        cerr << "Memory allocation error in EventSlots::auto_cq()" << endl;
		exit(MEM_ERROR);
	    }
	    result = dialog_p->exec();
	    delete dialog_p;
	}
	if (!prompt || result == QDialog::Accepted) {
	    CqsendBuffer* cqsend_p = new CqsendBuffer(tnc_p, mainscreen_p, sendwin_p,
							    receivewin_p);
	    if (!cqsend_p) {
	        cerr << "Memory allocation error in EventSlots::auto_cq()" << endl;
		exit(MEM_ERROR);
	    }
	    // EventSlots::display_connected_status() and
	    // EventSlots::set_auto_cq_button() will be called in CqsendBuffer::load_buffer()
	    if (cqsend_p->load_buffer()) buffer_list.add(cqsend_p);
	    else delete cqsend_p;
	}
	else mainscreen_p->set_auto_cq_button(); // if the prompt was not accepted, unset button
    }
}

void EventSlots::helpfile(void) {

    HelpDialog* dialog_p = new HelpDialog(standard_size);
    if (!dialog_p) {
        cerr << "Memory allocation error in EventSlots::helpfile()" << endl;
	exit(MEM_ERROR);
    }
    if (dialog_p->is_opened()) dialog_p->show(); // HelpDialog is modeless - it shouldn't be deleted here
    else dialog_p->kill_dialog();
}

void EventSlots::ctrl_a(void) {
    if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()]
	[tnc_p->tnc_func.active_port] == Tnc_func::connected
	&& (!tnc_p->tnc_func.active_port
	    || tnc_p->tnc_func.hfmode == Tnc_func::packet
	    || tnc_p->tnc_func.tor_connected_mode == Tnc_func::pactor_gtor)) {
        flush_wordwrap_buffer();
	tr_buffer.add_letter(1);
	QApplication::beep();
    }
    else change_hfmode(Tnc_func::amtor, true);
}

void EventSlots::ctrl_t(void) {
    if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()]
	[tnc_p->tnc_func.active_port] == Tnc_func::connected
	&& (!tnc_p->tnc_func.active_port
	    || tnc_p->tnc_func.hfmode == Tnc_func::packet
	    || tnc_p->tnc_func.tor_connected_mode == Tnc_func::pactor_gtor)) {
        flush_wordwrap_buffer();
	tr_buffer.add_letter(20);
    }
    else change_hfmode(Tnc_func::tor, true);
}

void EventSlots::ctrl_z(void) {
    if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()]
	[tnc_p->tnc_func.active_port] == Tnc_func::connected
	&& (!tnc_p->tnc_func.active_port
	    || tnc_p->tnc_func.hfmode == Tnc_func::packet
	    || tnc_p->tnc_func.tor_connected_mode == Tnc_func::pactor_gtor)) {
        flush_wordwrap_buffer();
	tr_buffer.add_letter(26);
    }
}

void EventSlots::cw_speed(void) {
    CwSpeedDialog* cw_speed_dialog_p = new CwSpeedDialog(standard_size, cw_speed_val, mainscreen_p);
    if (!cw_speed_dialog_p) {
        cerr << "Memory allocation error in EventSlots::cw_speed()" << endl;
	exit(MEM_ERROR);
    }
    int result = cw_speed_dialog_p->exec();
    if (result == QDialog::Accepted) {
        cw_speed_val = cw_speed_dialog_p->get_speed();
        int tnc_val = cw_speed_val/5;
	if (tnc_val && tnc_val < 11) {
	    if (tnc_val == 10) tnc_p->send_specialcommand('0');
	    else tnc_p->send_specialcommand(tnc_val | 0x30);
	}
	else QMessageBox::warning(mainscreen_p, "Cw Speed", "Invalid speed entered",
				      QMessageBox::Ok | QMessageBox::Default, 0);
    }
    delete cw_speed_dialog_p;
}

void EventSlots::settings(void) {
    Settings current_settings;
    current_settings.rx_endstop_flag = prog_func.rx_endstop_flag;
    current_settings.cw_rx_flag = !tnc_p->tnc_func.no_rx_cw_flag;
    current_settings.bell_flag = tnc_p->tnc_func.rx_bell_flag;

    SettingsDialog* settings_dialog_p = new SettingsDialog(standard_size, current_settings, mainscreen_p);
    int result = settings_dialog_p->exec();
    if (result == QDialog::Accepted) {
        Settings new_settings = settings_dialog_p->get_settings();
	prog_func.rx_endstop_flag = new_settings.rx_endstop_flag;
	tnc_p->tnc_func.no_rx_cw_flag = !new_settings.cw_rx_flag;
	tnc_p->tnc_func.rx_bell_flag = new_settings.bell_flag;
    }
    delete settings_dialog_p;
}

void EventSlots::set_print_mark(void) {

    PrintList* print_list_p = tnc_p->tnc_func.print_list_ptr;
// check pre-conditions
    if (print_list_p->get_print_status(tnc_p->tnc_func.active_stream(),
	  tnc_p->tnc_func.active_port) ==  PrintList::on) {
        return;
    }

    PromptDialog* dialog_p = new PromptDialog("Set print mark?", "Set Print Mark", standard_size, mainscreen_p);
    if (!dialog_p) {
        cerr << "Memory allocation error in EventSlots::set_print_mark()" << endl;
	exit(MEM_ERROR);
    }
    int result = dialog_p->exec();
    delete dialog_p;
    if (result != QDialog::Accepted) return;

// proceed
    PrintFile* print_file_p = new PrintFile(tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);
    if (!print_file_p) {
        cerr << "Memory allocation error in EventSlots::set_print_mark()" << endl;
	exit(MEM_ERROR);
    }
    if (print_file_p->start_store()) {
        print_list_p->add(print_file_p);
	unsigned char mark_string[2] = {PRINT_MARK, 0};
	receivewin_p->write((char*)mark_string);
	mainscreen_p->update_print_mark_items();
    }
    else {
        delete print_file_p;
	const char message[] = "Temporary print file cannot be opened for writing\n"
	                       "Please check permissions in /tmp directory";
	QMessageBox::warning(mainscreen_p, "Print File", message,
				 QMessageBox::Ok | QMessageBox::Default, 0);
    }
}

void EventSlots::print_from_mark(void) {

    PrintList* print_list_p = tnc_p->tnc_func.print_list_ptr;
// check pre-conditions
    if (print_list_p->get_print_status(tnc_p->tnc_func.active_stream(),
	  tnc_p->tnc_func.active_port) ==  PrintList::off) {
        return;
    }

    PrintMarkDialog* dialog_p = new PrintMarkDialog(standard_size, mainscreen_p);
    if (!dialog_p) {
        cerr << "Memory allocation error in EventSlots::print_from_mark()" << endl;
	exit(MEM_ERROR);
    }
    int result = dialog_p->exec();
    delete dialog_p;
    if (result == PrintMarkDialog::rejected) return;

// proceed
    print_list_p->reset(DList_enum::bottom_end);
    PrintFile* print_file_p;
    while ((print_file_p = (PrintFile*)print_list_p->inspect(DList_enum::up)) != 0
	     && !(print_file_p->get_stream() == tnc_p->tnc_func.active_stream()
		    && print_file_p->get_port() == tnc_p->tnc_func.active_port)) {}
    if (print_file_p) {
        print_list_p->extract();
	if (result == PrintMarkDialog::accepted) print_file_p->print();
	else print_file_p->cancel();
	delete print_file_p;
	mainscreen_p->update_print_mark_items();
    }
    else {
        receivewin_p->write("\nOops - can't find the print file object to delete\n"
			    "Please report bug\n");
	QApplication::beep();
    }
}

void EventSlots::context_print_mark(void) {
    if (tnc_p->tnc_func.print_list_ptr->get_print_status(tnc_p->tnc_func.active_stream(),
	  tnc_p->tnc_func.active_port) ==  PrintList::off) {
        set_print_mark();
    }
    else print_from_mark();
}
