/* Global definitions used by every source file.
 * Some may be compiler dependent.
 */

/* Indexes into binmode in files.c; hook for compilers that have special
 * open modes for binary files
 */
#define	READ_BINARY	0
#define	WRITE_BINARY	1
#define APPEND_BINARY   2
extern char *binmode[];

/* not all compilers grok defined() */
#ifdef NODEFINED
#define defined(x) (x)
#endif

/* These two lines assume that your compiler's longs are 32 bits and
 * shorts are 16 bits. It is already assumed that chars are 8 bits,
 * but it doesn't matter if they're signed or unsigned.
 */
typedef int int32;		/* 32-bit signed integer */
typedef unsigned short int16;	/* 16-bit unsigned integer */
#define	uchar(x) ((x) & 0xFF)
#define	MAXINT16 65535		/* Largest 16-bit integer */

/* Since not all compilers support structure assignment, the ASSIGN()
 * macro is used. This controls how it's actually implemented.
 */
#ifdef	NOSTRUCTASSIGN	/* Version for old compilers that don't support it */
#define	ASSIGN(a,b)	memcpy((char *)&(a),(char *)&(b),sizeof(b));
#else			/* Version for compilers that do */
#define	ASSIGN(a,b)	((a) = (b))
#endif

/* Define null object pointer in case stdio.h isn't included */
#ifndef	NULL
/* General purpose NULL pointer */
#define NULL (void *)0
#endif
#define	NULLCHAR (char *)0	/* Null character pointer */
#define	NULLFP	 (int (*)())0	/* Null pointer to function returning int */
#define	NULLVFP	 (void (*)())0	/* Null pointer to function returning void */
#define	NULLFILE (FILE *)0	/* Null file pointer */

/* General purpose function macros */
#define	min(x,y)	((x)<(y)?(x):(y))	/* Lesser of two args */
#define	max(x,y)	((x)>(y)?(x):(y))	/* Greater of two args */

/* Convert an address to a LONG value for printing */
#define ptr2long(x)	((long) (x))	/* typecast suffices for others */

/* Extract a short from a long */
#define hiword(x)	((int16)((x) >> 16))
#define	loword(x)	((int16)(x))

/* Extract a byte from a short */
#define	hibyte(x)	((unsigned char)((x) >> 8))
#define	lobyte(x)	((unsigned char)(x))

/* Extract nibbles from a byte */
#define	hinibble(x)	(((x) >> 4) & 0xf)
#define	lonibble(x)	((x) & 0xf)

/* Heavily used functions from the standard library */
char *malloc(),*calloc(),*ctime(),*tmpnam();


