/* monfile.h */

/* This file defines the structure of the monitor file records used by
   stats and report.


The basic structure is:


	<record type (one char)><data><\n>



A set of records is output every 5 minutes.  Each group is prefaced by
a timestamp record.  Following are all of the data records for
that interval.  

*/


/* Concepts -
	
	unique packets - items received not including duplicates
			caused by re-transmission or digipeating

	total packets/bytes - total items received.
	
*/

/* Record types */
#define CIRCUIT_TYPE 'C'
#define DIGI_TYPE 'D'
#define FREQ_TYPE 'F'
#define ID_TYPE   'I'
#define TIME_TYPE 'T'

/* Time record */
/* A time stamp for all other records that follow.  The time is the time
   of the START of the interval */

struct TIME_RECORD {
	unsigned long time_stamp;
	};


/* Circuit record.

A circuit record contains data for a circuit for the five minute interval.
A circuit is a level two to/from pair.
*/
        

struct CIRCUIT_RECORD {
	char to[10];			/* to call */
	char from[10];			/* from call */
	unsigned int digis;		/* number of digipeaters for this circuit */
	unsigned int pid;		/* pid in use on this circuit */	
	unsigned long u_dpackets;	/* unique data packets */
	unsigned long nd_dpackets;	/* non-digipeated data packets */
	unsigned long t_dpackets;	/* total data packets */
	unsigned long nd_packets;	/* non-digipeated packets */
	unsigned long t_packets;	/* total packets */
	unsigned long u_dbytes;		/* unique data bytes */
	unsigned long nd_dbytes;	/* non-digipeated data bytes */
	unsigned long t_dbytes;		/* total data bytes */
	unsigned long nd_bytes;		/* non-digipeated bytes */
	unsigned long t_bytes;		/* total bytes */
	unsigned long c_time;		/* time circuit placed in table */
					/* total packet type counters 
						(does not include digipeats)
					*/
	unsigned long sabm;
	unsigned long ua;
	unsigned long disc;
	unsigned long dm;
	unsigned long rej;
	unsigned long rr;
	unsigned long rnr;
	unsigned long i;
	unsigned long ui;
	unsigned long frmr;
	unsigned long poll;
	unsigned long final;
					/* size of DATA portion of I frame */
					/* unique frames only */
	unsigned long l32;		/* <=32 */
	unsigned long l64;		/* <=64 */
	unsigned long l128;		/* <=128 */
	unsigned long l256;		/* <=256 */
	unsigned long g256;		/* > 256 */
	};



/* digipeater record */
/* Gives total traffic sent by a digipeater without regard to the
    destination */

struct DIGI_RECORD {
	unsigned char call[10];		/* call of digi */
	unsigned long t_packets;	/* total packets */
	unsigned long t_bytes;		/* total bytes */
	};

/* frequency record */
/* This record gives values for the frequency without regard to
circuits.
*/

struct FREQ_RECORD {
	unsigned long t_packets;	/* total packets */
	unsigned long t_bytes;		/* total bytes */
	unsigned long u_packets;	/* unique packets */
	unsigned long u_bytes;		/* unique bytes */
	unsigned long l32;		/* <=32 */
	unsigned long l64;		/* <=64 */
	unsigned long l128;		/* <=128 */
	unsigned long l256;		/* <=256 */
	unsigned long g256;		/* > 256 */
	unsigned long dcd_on_ticks;	/* ticks when DCD was on */
	unsigned long dcd_off_ticks;	/* ticks when DCD was off */
	};


/* file id record */
/* This record is intended to label the file to make storage and later 
analysis easier.  For example, the baud rate would be 1200, the frequency
145.01, and the comment "Via remote on Mt. Wilson ".  The contents of
this record set via commands to the MON program,
the record is emitted by MON once at the start of the file.
*** Not yet Implemented ***

*/

struct ID_RECORD {
	char freq[10];		/* freq ID string */
	char baud[5];		/* baud rate */
	char comments[80];	/* comments */
	};



struct SEL {
	int c;
	int d;
	int f;
	int i;
	int t;
	};



