/*
	hdr.h

	Extract FTL0 header from a file


	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk
*/

typedef struct
{
  /* required Header Information */
  unsigned long fileId;              /* 0x01 */
  char          fileName[9];         /* 0x02 */
  char          fileExt[4];          /* 0x03 */
  unsigned long fileSize;            /* 0x04 */
  unsigned long createTime;          /* 0x05 */
  unsigned long modifiedTime;        /* 0x06 */
  unsigned char SEUflag;             /* 0x07 */
  unsigned char fileType;            /* 0x08 */
  unsigned int  bodyCRC;             /* 0x09 */
  unsigned int  headerCRC;           /* 0x0A */
  unsigned int  bodyOffset;          /* 0x0B */

  /* Extended Header Information */
  char          source[33];          /* 0x10 */
  char          uploader[7];         /* 0x11 */
  unsigned long uploadTime;          /* 0x12 */
  unsigned char downloadCount;       /* 0x13 */
  char          destination[33];     /* 0x14 */
  char          downloader[7];       /* 0x15 */
  unsigned long downloadTime;        /* 0x16 */
  unsigned long expireTime;          /* 0x17 */
  unsigned char priority;            /* 0x18 */
  unsigned char compression;         /* 0x19 */
  char          BBSMessageType;      /* 0x20 */
  char          BID[33];             /* 0x21 */
  char          title[65];           /* 0x22 */
  char          keyWords[33];        /* 0x23 */
  char          description[33];     /* 0x24 */
  char          compressionDesc[33]; /* 0x25 */
  char          userFileName[33];    /* 0x26 */
}
HEADER;

HEADER *ExtractHeader(unsigned char *buffer, int nBytes, int *size);
