
#ifndef CSOCK_H
#define CSOCK_H

#define HAVE_INET
#define HAVE_AX25
#define HAVE_NETROM
#undef HAVE_ROSE

#include <netinet/in.h>
#ifdef HAVE_AX25
#include <linux/ax25.h>
#endif
#ifdef HAVE_ROSE
#include <linux/rose.h>
#endif
#include <zlib.h>

#include "luser.h"
#include "login.h"

#define CS_E_BASE		-100
#define CS_E_TO			* -1 + CS_E_BASE

#define CS_E_SUCC		0 CS_E_TO
#define CS_E_INVPORT		1 CS_E_TO
#define CS_E_INVCALL		2 CS_E_TO
#define CS_E_INVNODE		3 CS_E_TO
#define CS_E_NOHOST		4 CS_E_TO
#define CS_E_NOSERV		5 CS_E_TO
#define CS_E_MAX		5

#define DEF_BUFLEN_IN	10
#define DEF_BUFLEN_AX	256
#define DEF_BUFLEN_NR	1500
#define DEF_BUFLEN_RS	512
#define	DEF_OBUFLEN	256

#define MAX_SENDLEN	1024

#define ZERR_STREAM_END		1024
#define ZERR_STREAM_ERROR	1025
#define ZERR_DATA_ERROR		1026
#define ZERR_MEM_ERROR		1027
#define ZERR_BUF_ERROR		1028
#define ZERR_UNKNOWN		1029

#define AX25_EOL	"\r"
#define INET_EOL	"\r\n"
#define UNSPEC_EOL	"\n"

enum eolmode_t {
	eol_raw,
	eol_text
};

enum eoltype_t {
	ax25_eol,
	inet_eol,
	unspec_eol
};

struct sbuf_t {
	int pos;
	int len;
	int tresh;
	char *buf;
};

enum cstype_t {
	cst_unknown,
	cst_incoming,
	cst_outgoing
};

enum csstate_t {
	css_unknown,
	css_connecting,
	css_connected,
	css_disconnecting,
	css_disconnected
};

struct cscomp_t {	/* Compression metadata structure for a socket */
	z_stream		zin;		/* decompressor structure */
	z_stream		zout;		/* compressor structure */
	int			z_error;	/* zlib "errno" */
};

struct csock_t {	/* Clusse Socket (TM) */
	int			fd;
	int			cs_errno;
	
	/* Type, state */
	enum cstype_t		type;
	enum csstate_t		state;
	
	/* Who, where */
	int			af_type;
	union {
#ifdef HAVE_AX25
		struct full_sockaddr_ax25 ax25;
#elif HAVE_NETROM
		struct full_sockaddr_ax25 ax25;
#endif
#ifdef HAVE_ROSE
		struct sockaddr_rose      rose;
#endif
#ifdef HAVE_INET
		struct sockaddr_in        inet;
#endif
	} sockaddr;
        int			addrlen;
	char			*call;
	char			*node;
	char			*port;
	
	/* EOL */
	enum eolmode_t		eolmode;
	enum eoltype_t		eoltype;
	char *eol;
	
	/* Character set */
	struct charset_t	*charset;
	
	/* Socket tracing */
	char			*trace_file;
	
	/* For telnet state */
	int			tn_linemode;
	int			tn_echo;
	
	/* Input buffer */
	struct sbuf_t		*ribuf;	/* Raw from the socket... */
	struct sbuf_t		ibuf;	/* To the application...
					   if compressed, this is the
					   decoded stream */
	
	/* Output buffer */
	struct sbuf_t		obuf;	/* From the application...
					   if compressed, this is the plaintext
					   before encoding */
	struct sbuf_t		*robuf;	/* Raw to the socket. */
	
	/* Statistics counters */
	long			out_count;
	long			in_count;
	
	/* Current handler functions */
	int (*in_handler) (struct csock_t *s, void *data, int len);
	void (*conn_handler) (struct csock_t *s);
	void (*disc_handler) (struct csock_t *s);
	
	/* Compression */
	struct cscomp_t		*comp;
	
	/* User/login/link structure pointers */
	struct luser_t		*lu;
	struct link_t		*link;
	struct login_t		*login;
	
	struct csock_t		*next;
	struct csock_t		**prevp;
};

struct listenq_t {	/* Listening sockets */
	int	af_type;	/* One of AF_AX25, NETROM, ROSE or INET */
	int	fd;		/* The listening socket fd */
	
	char	*call;		/* Callsign in listing entries */
	char	*node;		/* Node call */
	char	*port;		/* Port call, only set across the port list */
	
        union {
#ifdef HAVE_AX25
        	struct full_sockaddr_ax25 ax25;
#endif
#ifdef HAVE_ROSE

		struct sockaddr_rose      rose;
#endif
#ifdef HAVE_INET
		struct sockaddr_in        inet;
#endif
	} sockaddr;
	
        int	addrlen;
        
        void (*accept) (struct listenq_t *lq);
        
        /* Options: */
        int	compress;
        
	struct listenq_t *next;
};

extern struct csock_t *sockets;
extern struct listenq_t *listenq;

extern fd_set readfds, writefds;
extern int maxfd;

extern int cs_errno;

/* For af_* */
extern struct csock_t *sock_alloc(int fd, int af_type, int def_buflen, 
					int obuf_tresh, int compressed);
extern int sock_login(struct csock_t *s);
extern int sock_disconnect(struct csock_t *s);
extern struct csock_t *sock_connect(int af_type, int compressed, int argc, char **argv);

/* Socket output */
extern int csflush(struct csock_t *s); /* Flush a socket */
extern int csflush_all(void); /* Flush all sockets */
extern int csrwritec(struct csock_t *s, char c); /* Raw meat */
extern int cswritec(struct csock_t *s, char c); /* Raw, with telnet escaping */
extern int cswrite(struct csock_t *s, void *buf, int n); /* Same, for blocks */
extern int csputc(struct csock_t *s, char c); /* With EOL conversion too */
extern int csputs(struct csock_t *s, char *str); /* The same for a string */
extern int csprintf(struct csock_t *s, const char *fmt, ...); /* formatting */

/* Misc */
extern int strtoaf(char *s);
extern char *csstrerror(int errnum);

/* For main() */
void csock_init(void);
void select_loop(void);

#endif
