
/*
 *	cmd_usercfg.c
 *
 *	Per-user configuration commands
 */

#include <string.h>
 
#include "csock.h"
#include "cmd_usercfg.h"
#include "luser.h"
#include "cfgfile.h"
#include "f_luser.h"

/*
 *	View or change name
 */
 
int cmd_name(struct csock_t *s, int argc, char **argv)
{
	if (argc > 1) {
		strncpy(s->lu->f->name, argstr(1, argc, argv), sizeof(s->lu->f->name));
		s->lu->f->name[sizeof(s->lu->f->name)-1] = '\0';
		csputs(s, "Thank you. ");
		write_luserf(s->lu->f);
	}
	
	if (*s->lu->f->name)
		csprintf(s, "Your name is set to: %s\n", s->lu->f->name);
	else
		csputs(s, "Your name is not set.\n");
	
	return 0;
}

/*
 *	View or change messages
 */

int cmd_messages(struct csock_t *s, int argc, char **argv)
{
	int setto = 1;
	int i;
	char *p;
	unsigned long *m = &s->lu->f->messages;
	
	for (i = 1; i < argc; i++) {
		for (p = argv[i]; (*p); p++) {
			switch (*p) {
			case '+':
				setto = 1;
				break;
			case '-':
				setto = 0;
				break;
			case 'd':
				if (setto)	*m |= M_DX;
				else		*m &= ~M_DX;
				break;
			case 'a':
				if (setto)	*m |= M_ANN;
				else		*m &= ~M_ANN;
				break;
			case 'w':
				if (setto)	*m |= M_WWV;
				else		*m &= ~M_WWV;
				break;
			case 't':
				if (setto)	*m |= M_TALK;
				else		*m &= ~M_TALK;
				break;
			case 'u':
				if (setto)	*m |= M_NUSER;
				else		*m &= ~M_NUSER;
				break;
			case 'l':
				if (setto)	*m |= M_LUSER;
				else		*m &= ~M_LUSER;
				break;
			case 'i':
				if (setto)	*m |= M_LINK;
				else		*m &= ~M_LINK;
				break;
			case 'n':
				if (setto)	*m |= M_NODE;
				else		*m &= ~M_NODE;
				break;
			default:
				csprintf(s, "Unknown argument: %c\n", *p);
				break;
			}
		}
	}
	
	if (argc > 1)
		write_luserf(s->lu->f);
		
	csputs(s, "Messages:\n");
	if (*m & M_DX)		csputs(s, " Dx");
	if (*m & M_ANN)		csputs(s, " Announce");
	if (*m & M_WWV)		csputs(s, " Wwv");
	if (*m & M_TALK)	csputs(s, " Talk");
	if (*m & M_NUSER)	csputs(s, " User");
	if (*m & M_LUSER)	csputs(s, " Localuser");
	if (*m & M_LINK)	csputs(s, " lInk");
	if (*m & M_NODE)	csputs(s, " Node");
	csputc(s, '\n');
	
	return 0;
}

/*
 *	View or change the prompt
 */

int cmd_prompt(struct csock_t *s, int argc, char **argv)
{
	int setto = 1;
	int i;
	char *c;
	int *p = &s->lu->f->prompt;
	
	for (i = 1; i < argc; i++) {
		for (c = argv[i]; (*c); c++) {
			switch (*c) {
			case '+':
				setto = 1;
				break;
			case '-':
				setto = 0;
				break;
			case '0':
				*p = P_TRAD;
				break;
			case '1':
				if (setto)	*p |= P_UCALL;
				else		*p &= ~P_UCALL;
				break;
			case '2':
				if (setto)	*p |= P_CCALL;
				else		*p &= ~P_CCALL;
				break;
			case '3':
				if (setto)	*p |= P_TIME;
				else		*p &= ~P_TIME;
				break;
			case '4':
				if (setto)	*p |= P_DATE;
				else		*p &= ~P_DATE;
				break;
			case '5':
				if (setto)	*p |= P_UPTIME;
				else		*p &= ~P_UPTIME;
				break;
			case '6':
				if (setto)	*p |= P_NUSERS;
				else		*p &= ~P_NUSERS;
				break;
			case '7':
				if (setto)      *p |= P_NONE;
				else            *p &= ~P_NONE;
				break;
			default:
				csprintf(s, "Unknown argument: %c\n", *c);
				break;
			}
		}
	}
	
	if (argc > 1)
		write_luserf(s->lu->f);

	csputs(s, "Your prompt: ");
	if (!*p || (*p & P_NONE))
		csputc(s, '\n');
		
	return 0;
}
