
/*
 *	cluster.c
 *
 *	Clusse-style linemode terminal cluster user interface
 *	command list, prompt, cluster event message sending
 */

#include <stdio.h>

#include "cluster.h"
#include "command.h"
#include "help.h"
#include "cmd_sys.h"
#include "cmd_cluster.h"
#include "cmd_net.h"
#include "cmd_usercfg.h"
#include "network.h"
#include "net_ping.h"
#include "luser.h"
#include "ctime.h"
#include "config.h"

/*
 *	Cluster commands
 */

struct cmd cluster_cmds[] = {
	{ "announce",		cmd_announce		},
	{ "bye",		cmd_bye			},
	{ "commands",		cmd_commands		},
	{ "dx",			cmd_dx			},
	{ "help",		cmd_help		},
	{ "links",		cmd_links		},
	{ "messages",		cmd_messages		},
	{ "memory",		cmd_memory		},
	{ "nodes",		cmd_nodes		},
	{ "name",		cmd_name		},
	{ "say",		cmd_say			},
	{ "shout",		cmd_shout		},
	{ "sockets",		cmd_sockets		},
	{ "talk",		cmd_talk		},
	{ "treply",		cmd_treply		},
	{ "users",		cmd_users		},
	{ "ping",		cmd_ping		},
	{ "pstatus",		cmd_pstatus		},
	{ "version",		cmd_version		},
	{ "?",			cmd_commands		},
	{ "!",			cmd_version		},
	{ NULL,			NULL,			}
};

/*
 *	Send a prompt
 */

void prompt(struct csock_t *s)
{
        csprintf(s, "c>\n");
}

/*
 *	Cluster events as sent to users
 */

void user_linkadd(struct link_t *l)
{
	send_us(M_LINK, "Linked to %s$t.", l->name);
}

void user_linkdel(struct link_t *l, char *reason)
{
	send_us(M_LINK, "Link to %s failed$t (%s).", l->name, reason);
}

void user_nodeadd(struct node_t *n)
{
	send_us(M_NODE, "Node %s added$t.", n->call);
}

void user_nodedel(struct node_t *n, char *reason)
{
	send_us(M_NODE, "Node %s vanished$t.", n->call);
}

void user_useradd(struct nuser_t *u)
{
	send_us((u->node == localnode) ? M_LUSER|M_NUSER : M_NUSER,
		"User %s logged in$t.", u->call);
}

void user_userdel(struct nuser_t *u)
{
	send_us((u->node == localnode) ? M_LUSER|M_NUSER : M_NUSER,
		"User %s logged out$t.", u->call);
}

void user_userhere(struct nuser_t *u)
{
	send_us((u->node == localnode) ? M_LUSER|M_NUSER : M_NUSER,
		"User %s came back$t.", u->call);
}

void user_useraway(struct nuser_t *u)
{
	send_us((u->node == localnode) ? M_LUSER|M_NUSER : M_NUSER,
		"User %s went away$t%s%s%s", u->call,
		(u->away_str) ? ": " : ".", 
		(u->away_str) ? u->away_str : "");
}

void user_dx(struct dx_t *d)
{
	char s[sizeof(call_t)+2];
	
	sprintf(s, "%s:", d->fromcall);
	send_us(M_DX, "DX de %-10.10s%9.9s %-13.13s%sZ %s",
		s, freq2str(d->freq), d->call, timestr_s(d->time), d->info);
}

void user_announce(struct ann_t *a)
{
	if (!strcmp(a->tonodec, "*"))
		send_us(M_ANN, "%s shouts$t: %s", a->fromcall, a->message);
	else if (!strcmp(a->tonodec, (char *)clucall))
		send_us(M_ANN, "%s says$t: %s", a->fromcall, a->message);
	else
		send_us(M_ANN, "%s shouts @%s: %s", a->fromcall, a->tonodec, a->message);
}

void user_wwv(struct wwv_t *w)
{
}

