
#ifndef TELNET_H
#define TELNET_H

#include "csock.h"

/* Telnet command characters */
#define IAC			255	/* Interpret as command */
#define WILL			251
#define WONT			252
#define DO			253
#define DONT			254
#define SB			250	/* Subnegotiation begin */
#define SE			240	/* Subnegotiation end   */

/* Telnet options */
#define TN_TRANSMIT_BINARY	0
#define TN_ECHO			1
#define TN_SUPPRESS_GA		3
#define TN_STATUS		5
#define TN_TIMING_MARK		6

/* Linemode options */
#define TN_LINEMODE		34
#define TN_LINEMODE_MODE	1
#define TN_LINEMODE_MODE_EDIT	1

extern void tn_do_linemode(struct csock_t *s);
extern void tn_will_echo(struct csock_t *s);
extern void tn_wont_echo(struct csock_t *s);

extern int telnet_handle(struct csock_t *s);

#endif
