
/*
 *	login.c
 *
 *	user login with password authentication for incoming telnet
 *	connections	
 */
 
#include "login.h"
#include "luser.h"
#include "version.h"
#include "config.h"
#include "cstring.h"
#include "telnet.h"
#include "hmalloc.h"

struct login_t *loggers = NULL;

/*
 *	Allocate and initialize a local user structure
 */

struct login_t *login_alloc(struct csock_t *s)
{
	struct login_t *lo = loggers, **plo = &loggers;
	
	while (lo) {
		plo = &lo->next;
		lo = lo->next;
	}
	
	lo = hmalloc(sizeof(struct login_t));
	*plo = lo;
	
	lo->prevp = plo;
	lo->next = NULL;
	
	lo->sock = s;
	lo->call = NULL;
	lo->tries = 0;
	
	s->login = lo;
	s->in_handler = login_handler;
	s->disc_handler = login_logout;
	
	return lo;
}

/*
 *	Free a login structure
 */

void login_free(struct login_t *lo)
{
	*lo->prevp = lo->next;
	if (lo->next)
		lo->next->prevp = lo->prevp;
	
	lo->sock->login = NULL;
	hfree(lo->call);
	hfree(lo);
}

/*
 *      Handle input from a login
 */

int login_failed(struct csock_t *s)
{
	s->login->tries++;
	if (s->login->tries == 3) {
		sock_disconnect(s);
		return -2;
	}
	hfree(s->login->call);
	csprintf(s, "login: ");
	csflush(s);
	return 0;
}

int password_handler(struct csock_t *s, void *data, int len)
{
	char *p = (char *)data;
	
	if (s->af_type == AF_INET)
		tn_wont_echo(s);
	csprintf(s, "\n\n");
	s->call = hstrdup(s->login->call);
	login_free(s->login);
	luser_login(s);
	
	return 0;
}

int login_handler(struct csock_t *s, void *data, int len)
{
	char *p = (char *)data;
	
	hstrupr(p);
	
	if (valid_call((call_t *)p) == -1) {
		csprintf(s, "Invalid callsign.\n");
		return login_failed(s);
	}
	
	s->login->call = hstrdup(p);
	csprintf(s, "Password: ");
	csflush(s);
	if (s->af_type == AF_INET)
		tn_will_echo(s);
	s->in_handler = password_handler;
	
	return 0;
}

/*
 *	Login:
 */

void auth_login(struct csock_t *s)
{
	if (s->af_type == AF_INET)
		tn_do_linemode(s);
	csprintf(s, "\n%s (%s)\n\nlogin: ", SOFT_SHORTSTRING, hostname);
	csflush(s);
	login_alloc(s);
}

void login_logout(struct csock_t *s)
{
	login_free(s->login);
}
