
#include "f_nuser.h"
#include "hmalloc.h"
#include "log.h"

/*
 *	Get an entry from the network user file
 */

struct nuserf_t *read_nuserf(call_t *call)
{
	return NULL;
}

/*
 *	Write an entry to the network user file
 */

void write_nuserf(struct nuserf_t *fp)
{
}

/*
 *	Set additional information for user
 */

void set_user_data(struct nuser_t *nu, struct link_t *l, call_t *call, 
		int type, char *value)
{
	struct nuserf_t *fp;
	
	if (!valid_call(call))
		return;

	if (!(fp = read_nuserf(call))) {
		fp = hmalloc(sizeof(struct nuserf_t));
		strcpy(fp->call, (char *)call);
		*fp->node = '\0';
		fp->q = 0;
		*fp->name = '\0';
		*fp->qth = '\0';
	}
	
	switch (type) {

	case 1:
		strcpy(fp->name, value);
		if (l)
			log(L_NUSER, "%s: name set to %s", fp->call, value);
		break;

	case 2:
		strcpy(fp->qth, value);
		if (l)
			log(L_NUSER, "%s: qth set to %s", fp->call, value);
		break;

	case 4:
		if (fp->q <= 7 && strcmp(value, fp->node)) {
			strcpy(fp->node, value);
			fp->q = 7;
			if (l)
				log(L_NUSER, "%s: home node set to %s", fp->call, value);
		}
		break;
	}

	if (nu)
		strcpy(nu->name, fp->name);
	write_nuserf(fp);
	hfree(fp);
}

/*
 *	Set the home node in the network user file, if necessary
 */

void set_homenode(struct nuser_t *n, call_t *call, call_t *node, int q)
{
	struct nuserf_t *fp;

	if (!(valid_call(call) && valid_call(node)))
		return;

	if (!(fp = read_nuserf(call))) {
		fp = hmalloc(sizeof(struct nuserf_t));
		*fp->node = '\0';
		fp->q = 0;
		strcpy(fp->call, (char *)call);
		*fp->name = '\0';
		*fp->qth = '\0';
	}

	if (fp->q <= q) {
		strcpy(fp->node, (char *)node);
		fp->q = q;
		write_nuserf(fp);
	}
	
	if (n)
		strcpy(n->name, fp->name);
		
	hfree(fp);
}

