
#include <time.h>
#include <stdio.h>

#include "ctime.h"

enum dateformat_t dateformat = dmy;
char datesep = '.';
char timesep = ':';

time_t start_time;

char days[7][10] = {
	"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
};

char months[12][4] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", 
	"Oct", "Nov", "Dec"
};

/* Days in a month */

int mday[12] = {
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

/* Cumulative... */

int mdays[12] = {
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
};

/*
 *	Initialize
 */
 
void ctime_init(void)
{
	time(&start_time);
}

/*
 *	Uptime
 */

long int uptime(void)
{
	return (time(NULL) - start_time);
}

/*
 *	Seconds => d hh:mm:ss
 */
 
char *secs2str(long i)
{
	static char s[40];
	int sec, min, hou;
	int day;

	sec = i % 60;
	min = (long) (i / 60.0) % 60;
	hou = (long) (i / 3600.0) % 24;
	day = (long) (i / 86400.0);

	if (day > 0)
		sprintf(s, "%dd ", day);
	else
		*s = '\0';
	if (hou > 0)
		sprintf(s + strlen(s), "%dh", hou);
	if (min > 0)
		sprintf(s + strlen(s), "%dm", min);
	if (sec > 0 || *s == '\0')	/* If it's 0 seconds, show it anyway... */
		sprintf(s + strlen(s), "%ds", sec);
		
	return s;
}


/*
 *	Seconds => d/h/m/s 3 chars
 */

char *secs2str_s(long i)
{
	int sec, min, hou, day;
	static char s[10];

	day = (long) (i / 86400.0);
	if (day > 0) {
		sprintf(s, "%dd", day);
		return s;
	}
	
	hou = (long) (i / 3600.0) % 24;
	if (hou > 0) {
		sprintf(s, "%dh", hou);
		return s;
	}
	
	min = (long) (i / 60.0) % 60;
	if (min > 0) {
		sprintf(s, "%dm", min);
		return s;
	}
	
	sec = i % 60;
	sprintf(s, "%ds", sec);
	return s;
}

/*
 *	Minutes => d hh:mm
 */

char *mins2str(long i)
{
	/* minutes => d hh:mm */
	static char s[10];
	int min, hou, day;

	min = i % 60;
	hou = (long) (i / 60.0) % 24;
	day = (long) (i / 1440.0);

	if (day > 0)
		sprintf(s, "%dd ", day);
	else
		*s = '\0';
	if (hou > 0)
		sprintf(s + strlen(s), "%dh", hou);
	if (min > 0 || *s == '\0')
		sprintf(s + strlen(s), "%dm", min);

	return s;
}


/*
 *	Minutes => d/h/m 3 chars
 */

char *mins2str_s(long i)
{
	int min, hou, day;
	static char s[10];
	
	day = (long) (i / 1440.0);
	if (day > 0) {
		sprintf(s, "%dd", day);
		return s;
	}
	
	hou = (long) (i / 60.0) % 24;
	if (hou > 0) {
		sprintf(s, "%dh", hou);
		return s;
	}
	
	min = i % 60;
	sprintf(s, "%dm", min);
	return s;
}

/*
 *	Packed => 01/10/77
 */

char *datestr(time_t t)
{
	static char s[15];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	switch (dateformat) {
		case dmy:
			sprintf(s, "%d%c%d%c%d", tm->tm_mday, datesep,
				tm->tm_mon+1, datesep, tm->tm_year % 100);
			break;
		case mdy:
			sprintf(s, "%d%c%d%c%d", tm->tm_mon+1, datesep,
				tm->tm_mday, datesep, tm->tm_year % 100);
			break;
		case ymd:
			sprintf(s, "%d%c%d%c%d", tm->tm_year % 100, datesep,
				tm->tm_mon+1, datesep, tm->tm_mday);
			break;
		case ydm:
			sprintf(s, "%d%c%d%c%d", tm->tm_year % 100, datesep,
				tm->tm_mday, datesep, tm->tm_mon+1);
			break;
	}
	
	return s;
}

/*
 *	Packed => '1/1'
 */

char *datestr_s(time_t t)
{
	static char s[10];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	switch (dateformat) {
		case dmy:
		case ydm:
			sprintf(s, "%d%c%d", tm->tm_mday, datesep, tm->tm_mon+1);
			break;
		case mdy:
		case ymd:
			sprintf(s, "%d%c%d", tm->tm_mon+1, datesep, tm->tm_mday);
			break;
	}
	
	return s;
}

/*
 *	Packed => ' 1/1 ' (5 chars)
 */

char *datestr_s_pad(time_t t)
{
	static char s[10];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	switch (dateformat) {
		case dmy:
		case ydm:
			sprintf(s, "%-2.2d%c%2.2d", tm->tm_mday, datesep, tm->tm_mon+1);
			break;
		case mdy:
		case ymd:
			sprintf(s, "%-2.2d%c%2.2d", tm->tm_mon+1, datesep, tm->tm_mday);
			break;
	}
	
	return s;
}

/*
 *	Packed => 02:30:12
 */

char *timestr_l(time_t t)
{
	static char s[15];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	sprintf(s, "%d%c%d%c%d", tm->tm_hour, timesep,
		tm->tm_min, timesep, tm->tm_sec);
	
	return s;
}

/*
 *	Packed => 02:30
 */

char *timestr_p(time_t t)
{
	static char s[15];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	sprintf(s, "%2.2d%c%2.2d", tm->tm_hour, timesep, tm->tm_min);
	
	return s;
}

/*
 *	Packed => 2:30
 */

char *timestr(time_t t)
{
	static char s[15];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	sprintf(s, "%d%c%2.2d", tm->tm_hour, timesep, tm->tm_min);
	
	return s;
}


/*
 *	Packed => 0230
 */

char *timestr_s(time_t t)
{
	static char s[15];
	struct tm *tm;
	
	tm = gmtime(&t);
	
	sprintf(s, "%2.2d%2.2d", tm->tm_hour, tm->tm_min);
	
	return s;
}

