
 (*

     Clusse - Sound unit for Sound Blaster and LPT port DAC

     Heikki Hannikainen (OH7LZB) 1995-1997

    With the greatest thanks to Sakari Nylund, OH1KH for the idea and
  the original source code. (Contact: OH1KH @ OH1RBF.FIN.EU )

  hessu@pspt.fi oh7lzb@gw.oh7rba.ampr.org oh7lzb@oh7rba.#kuo.fin.eu

    This source code may be used in amateur radio related applications
  which are donated to the public domain, as long as the original
  authors are acknowledged in the source code, the executable, it's user
  interface and the documentation of the application.

 *)

Unit Speech;

  { Implements the "speaking dx cluster" facility. Support for
    8 bit SoundBlaster sound cards (later models are backwards
    compatible of course), and paraller port DAC's. The original
    DAC driver and word ordering system was written by Sakari Nylund,
    OH1KH. I added support for the SB, storing words in XMS, and
    audible CW. This works, but has some killer bugs in it. Some
    important stuff is unimplemented. This is sort-of-freeware, not
    under the GPL. }

Interface
Uses Dos;

Type
  TLanguage    = (Finnish, English);

Var

  Speaking     : Boolean;    { Speaking right now? }
  Language     : TLanguage;  { Language used }
  SpeechPath   : PathStr;

Const
  { CW special characters }
  CWS_SK     : char = chr(1);

Procedure Cw(Const Str:String);               { Send a string in CW }
Procedure DX(Freq:LongInt;Const Call:String); { DX spot }

Procedure Init;
Procedure UnInstall;         { Remove the interrupt handler }

 { *********** *********** *********** *********** *********** *********** }

Implementation

Uses Crt, cStrings, ConfFile, Config, xmsLib, Screen;

Const

  sbDmaChannel : Array [0..3,1..3] of Byte
             = (($87,$0,$1),($83,$2,$3),($81,$2,$3),($82,$6,$7));

  Hw2SwInt   : Array [0..15] of Byte
             = ($08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
                $70, $71, $72, $73, $74, $75, $76, $77);

  QLen       = 2048;   { Size of the word queue buffer }

  { CW characters in the word queue }
  CW_Dot     : char = chr(35);
  CW_Space   : char = chr(36);   { length of one dot }
  CW_Dash    : char = chr(37);

  { Special words in the word queue }
  W_toista   : char = chr(38); { These ones only in Finnish }
  W_kymmenen : char = chr(39);
  W_kymmenta : char = chr(40);
  W_sata     : char = chr(41);
  W_sataa    : char = chr(42);
  W_tuhat    : char = chr(43);
  W_tuhatta  : char = chr(44);
  W_miljoona : char = chr(45);
  W_miljoonaa: char = chr(46);
  W_kautta   : char = chr(47);

  W_space01  : char = chr(60); { These ones in all languages }
  W_space1   : char = chr(61);
  W_dx       : char = chr(62);
  W_khz      : char = chr(63);
  W_jaksolla : char = chr(64);


Type
 SamplePosRec = Record
                Seg,
                Ofs : Word;
                End;

 BufType      = Array[1..65535] of Byte;
 IdxRec       = Record
                Pos    : LongInt;
                Length : Word;
                End;

 IntBlock = Record { The original value of a changed int vector }
            IntOldIP  : Integer;
            IntOldCS  : Integer;
            IntNumber : Byte;
            End;

 TQueue   = Array[1..QLen] of Char; { Word queue type }

Var

 buff       : ^BufType;
 BufLen     : Word;

 xmsHandle  : Word;
 WList      : Array [35..90] of IdxRec;  { Word index }

 Queue      : ^TQueue;      { Words queued for playing }
 QWrite,                    { pointers to the word queue: writing }
 QRead      : Word;         { ... reading }

 SamplePos  : SamplePosRec;              { Where is the player going }
 PTTState   : Boolean;                   { PTT on/off? }


 { Interrupts }

 SwInt      : Byte;                      { Software int }
 Block      : IntBlock;                  { Original int vector }

 PICPort    : Byte;
 IntStopMask, IntStartMask: Byte;

 lptBase    : Word;

 { DMA }

 DMACh           : Byte;
 DMAMaskPort     : Word;
 DMAClrPtrPort   : Word;
 DMAModePort     : Word;
 DMABaseAddrPort : Word;
 DMACountPort    : Word;
 DMAPagePort     : Word;

 DMAStartMask    : Byte;
 DMAStopMask     : Byte;
 DMAMode         : Byte;

 { SoundBlaster }

 sbDataAvail,
 sbRead,
 sbWrite,
 sbReset    : Word;

 sbOfs,
 sbPage     : Word;

 { *********** *********** *********** *********** *********** *********** }
 { Read/Write a byte from/to the SB's DSP                                            }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbWriteDSP(Data : Byte);
Begin
 While Port[sbWrite] and $80 <> 0 do;
 Port[sbWrite] := Data;
End;

Function sbReadDSP : Byte;
Begin
 While Port[sbDataAvail] and $80 = 0 do;
 sbReadDSP := Port[sbRead];
End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the SB mixer                                                    }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbSpeakerOn;
Begin
 sbWriteDSP($D1);
End;

Procedure SpeakerOff;
Begin
 sbWriteDSP($D3);
End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the interrupts                                                  }
 { *********** *********** *********** *********** *********** *********** }

Procedure IntStop;
Begin
  Port[PICPort] := Port[PICPort] or IntStopMask;
End;

Procedure IntStart;
Begin
  Port[PICPort] := Port[PICPort] and IntStartMask;
End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the SB's DMA controller                                         }
 { *********** *********** *********** *********** *********** *********** }

Procedure DMAStop;
Begin
 sbWriteDSP($D0);
End;

Procedure DMAContinue;
Begin
 sbWriteDSP($D4);
End;

 { *********** *********** *********** *********** *********** *********** }
 { Play a sample through the SB:
    Size           Size of data block (Max. 64 Kb at a time!)
    Freq           Sampling rate in hertz                                  }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbPlaySample(b:Byte);
Begin

 Dec(BufLen);
 sbOfs := Seg(Buff^) Shl 4 + Ofs(Buff^);
 sbPage := (Seg(Buff^) + Ofs(Buff^) Shr 4) Shr 12;
 Port[DMAMaskPort]     := DMAStopMask;  (* Stop any DMA activity so far *)
 Port[DMAClrPtrPort]   := $00;
 Port[DMAModePort]     := DMAMode;
 Port[DMABaseAddrPort] := Lo(sbOfs);
 Port[DMABaseAddrPort] := Hi(sbOfs);
 Port[sbDMAChannel[1,1]] := sbPage;
 Port[sbDMAChannel[1,3]] := Lo(BufLen);
 Port[sbDMAChannel[1,3]] := Hi(BufLen);
 Port[DMAMaskPort] := Conf^.Sound.sbDMA;
 sbWriteDSP($D1); {?}
 sbWriteDSP($40);
 sbWriteDSP(156); { sampling frequency }
 sbWriteDSP($14);
 sbWriteDSP(Lo(BufLen));
 sbWriteDSP(Hi(BufLen));
 Inc(BufLen);
 IntStart;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the PTT line                                                    }
 { *********** *********** *********** *********** *********** *********** }

Procedure PTT(State:Boolean);
Begin

 If State
   then Port[LPTBase+2] := Port[LPTBase+2] and 254
   else Port[LPTBase+2] := Port[LPTBase+2] or 1;
 PttState := State;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Start playing from word...                                              }
 { *********** *********** *********** *********** *********** *********** }

Procedure SpeakWord(ch:Char);
Var
 b : Byte;
 w : Word;
Begin

 b := Ord(Ch);
 BufLen := WList[b].Length;
 w := BufLen;
 If odd(w)
   then Inc(w);
 GetMem(Buff,w);
 XMBtoBase(w,Buff,xmsHandle,WList[b].Pos);

 With Conf^.Sound do
 Case SoundHw of

   SHW_sb : sbPlaySample(b);

   SHW_lptDac
          : Begin
            SamplePos.Seg := Seg(Buff^);  { Where shall we play from... }
            SamplePos.Ofs := Ofs(Buff^);

            Port[LPTbase+2] := Port[LPTbase+2] or $10; { Enable interrupts, paraller port controller }
            IntStart;
            End;

 End;

 Speaking := True;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Take the next word from the queue...                                    }
 { *********** *********** *********** *********** *********** *********** }

Procedure NextWord;
Begin

 If not (QRead = QWrite)
   then Begin { We still have words queued.. }
        Inc(QRead);
        If QRead > QLen then QRead := 1;
        SpeakWord(Queue^[QRead]);
        SpeechState(PTTState, QWrite, QRead, Byte(Queue^[QRead]));
        End
   else Begin { Finished. }
        Speaking := False;
        PTT(False);
        SpeechState(PTTState, QWrite, QRead, 0);
        End;

End;

 { *********** *********** *********** *********** *********** *********** }
 { This procedure is executed every time the ACK pin (10) of the LPT port  }
 { goes high. Puts one byte into the LPT port.                             }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptIntHandler; Interrupt;
Var
  Out : Byte;
Begin

  Out := mem[SamplePos.Seg:SamplePos.Ofs];

  If out = 0               { When the word ends... }
    then Begin
         IntStop; { Disable interrupts, PIC }
         If odd(BufLen)
           then Inc(BufLen);
         FreeMem(Buff,BufLen);
         NextWord; { Next word.. }
         End
    else Begin
         Port[LPTbase] := out;    { Next byte to the LPT port }
         Inc(SamplePos.Ofs);
         End;

  Inline($FA);             { CLI }
  Port[$20] := $20;        { clear interrupt flag }

End;

 { *********** *********** *********** *********** *********** *********** }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbIntHandler; Interrupt;
Var
  Info : Byte;
Begin
  asm CLI end;  (* NO Interrupts while in this code! *)
  IntStop;
  Info := Port[sbDataAvail];
  If odd(BufLen)
    then Inc(BufLen);
  FreeMem(Buff,BufLen);
  NextWord;
  asm STI end;      (* Interupts are OK now! *)
  Port[PICPort - 1] := $20;
end;

 { *********** *********** *********** *********** *********** *********** }
 { Start speaking, if not already speaking and if we have something to say }
 { *********** *********** *********** *********** *********** *********** }

Procedure KickSpeech;
Begin

 If not (speaking or (QRead = QWrite))
  then Begin
       Inc(QRead);
       If QRead > QLen then QRead := 1;
       PTT(True);
       SpeakWord(Queue^[QRead]);
       End;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Put a string to the queue                                               }
 { *********** *********** *********** *********** *********** *********** }

Procedure SpeakString(Const Str:String);
Var
  b : Byte;
Begin

 For b := 1 to Length(Str)
  do Begin
     Inc(QWrite);
     If QWrite > QLen then QWrite := 1;
     Queue^[QWrite] := Str[b];
     End;

 KickSpeech;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Spell a frequency                                                       }
 { *********** *********** *********** *********** *********** *********** }

Procedure Sataset(Var f:Byte; Var luku, jono:String; Const Lisa1, Lisa2:String);
Var
  Tyo : string;
Begin

  Tyo:='';
  { ykkoset }
  If f = 1
    then If luku[f] = '1'
           then Begin
                If Length(luku) = 1
                  then tyo := '1';
                Dec(f);
                End
           else Begin
                tyo := luku[f];
                Dec(f);
                End;

  If f > 1
    then If luku[f-1] = '1'
           then Begin
                If luku[f] <> '0'
                  then tyo := luku[f] + W_toista
                  else tyo := W_kymmenen;
                Dec(f,2);
                End
           else Begin
                If luku[f] <> '0'
                  then tyo := luku[f];
                 Dec(f);
                If f > 0
                  then If luku[f] <> '0'
                         then Begin
                              tyo := luku[f] + W_kymmenta + tyo;
                              Dec(f);
                              End
                         else Dec(f);
                end;
  { sadat }
  If f > 0
    then If luku[f] <> '0'
           then Begin
                If luku[f]= '1'
                  then Begin
                       tyo := W_sata + tyo;
                       Dec(f);
                       End
                  else Begin
                       tyo := luku[f] + W_sataa + tyo;
                       Dec(f);
                       End;
                End
           else Dec(f);

  if tyo = ''
    then Begin
         If f = 0
           then jono := lisa1 + jono;
         end
    else If tyo = '1'
           then jono := tyo + lisa1 + jono
           else jono := tyo + lisa2 + jono;

End;


Procedure SpeakFreq(Const f:LongInt);
Var
  s    : String[8];
  Jono : String[20];
  b    : Byte;
Begin

 Str(Round(f / 10),s);
 Case Language of

  English : Jono := s;
  Finnish : Begin { Not at all so simple... }

            b := Length(s);
            jono := '';

            SataSet(b,s,jono,'','');
            Jono := W_space01 + jono;

            If b > 0
              then Begin
                   SataSet(b,s,jono,W_tuhat,W_tuhatta);
                   Jono := W_space01+jono;
                   End;

            If b > 0
              then Begin
                   SataSet(b,s,jono,W_miljoona,W_miljoonaa);
                   Jono := W_space01 + jono;
                   End;

            If b > 0
              then Begin
                   SataSet(b,s,jono,W_tuhat,W_tuhatta);
                   Jono := W_space01 + jono;
                   End;

            End;

 End;

 SpeakString(Jono);
 KickSpeech;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Put a string in the queue, in CW                                        }
 { *********** *********** *********** *********** *********** *********** }

Procedure CW(Const Str:String);
Var
  b, p   : Byte;
  CWStr  : String[6];
  CWOStr : String;
Begin

 CWOStr := '';

 For b := 1 to Length(Str)
  do Begin
     Case Str[b] of
       '0' : CWStr := '-----';
       '1' : CWStr := '.----';
       '2' : CWStr := '..---';
       '3' : CWStr := '...--';
       '4' : CWStr := '....-';
       '5' : CWStr := '.....';
       '6' : CWStr := '-....';
       '7' : CWStr := '--...';
       '8' : CWStr := '---..';
       '9' : CWStr := '----.';
       'A' : CWStr := '.-';
       'B' : CWStr := '-...';
       'C' : CWStr := '-.-.';
       'D' : CWStr := '-..';
       'E' : CWStr := '.';
       'F' : CWStr := '..-.';
       'G' : CWStr := '--.';
       'H' : CWStr := '....';
       'I' : CWStr := '..';
       'J' : CWStr := '.---';
       'K' : CWStr := '-.-';
       'L' : CWStr := '.-..';
       'M' : CWStr := '--';
       'N' : CWStr := '-.';
       'O' : CWStr := '---';
       'P' : CWStr := '.--.';
       'Q' : CWStr := '--.-';
       'R' : CWStr := '.-.';
       'S' : CWStr := '...';
       'T' : CWStr := '-';
       'U' : CWStr := '..-';
       'V' : CWStr := '...-';
       'W' : CWStr := '..-';
       'X' : CWStr := '-..-';
       'Y' : CWStr := '-.--';
       'Z' : CWStr := '--..';
       '' : CWStr := '.--.-';
       '' : CWStr := '.-.-';
       '' : CWStr := '---.';
       '.' : CWStr := '.-.-.-';
       ',' : CWStr := '--,,--';
       '/' : CWStr := '-..-.';
       '-' : CWStr := '_...._';
       '=' : CWStr := '_..._';
       '?' : CWStr := '..--..';
       ' ' : CWStr := ',,';
       Chr(1) : CWStr := '...-.-';  { [SK] }
     End;

     CWOStr := CWOStr + CW_Space + CW_Space;
     For p := 1 to Length(CWStr)
      do Begin
         CWOStr := CWOStr + CW_Space;
         Case CWStr[p] of
          '.' : CWOStr := CWOStr + CW_Dot;
          '-' : CWOStr := CWOStr + CW_Dash;
          ',' : CWOStr := CWOStr + CW_Space + CW_Space;
         End;
         End;

     End;

 SpeakString(CWOStr);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Add a DX spot to the queue                                              }
 { *********** *********** *********** *********** *********** *********** }

Procedure DX(Freq:LongInt;Const Call:String);
Begin

 SpeakString(W_Space01 + W_Dx + W_Space1 + Call + W_Space1
             + W_Jaksolla + W_Space1);
 SpeakFreq(Freq);
 SpeakString(W_Space01 + W_KHz + W_Space1);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Read the speech data from disk to memory                                }
 { *********** *********** *********** *********** *********** *********** }
 { Does not include I/O error checking yet ... needs to be added ... }

Procedure ReadData;
Var
  IdF    : File of IdxRec;
  f      : File;

  xPos   : LongInt; { Position in XMS }
  xSize  : LongInt; { XMS chunk size }

  Words  : Byte;    { How many samples }
  wIndex : Byte;

  w      : Word;

  b, rb  : Byte;

  dotlen : Word;

Const
 Lang    : Array [Finnish..English] of String[7] = ('Finnish', 'English');
Begin

 Write(' o Reading speech data: ');

 dotlen := Round(5000 / (Conf^.Sound.cwSpeed / 1.2));  { Length of a dot, in bytes! }
 If odd(dotlen) then Inc(dotlen);

 Assign(IdF,SpeechPath + 'all.idx');
 Reset(IdF);

 Words := 37;
 XPos := 0;
 While not eof(IdF)
   do Begin
      Inc(Words);
      Read(IdF,WList[Words]);
      Inc(xPos,WList[Words].Length);
      If odd(xPos) then inc(xPos);
      End;

 Close(IdF);

 Inc(xPos, 5 * dotlen); { Reserve some space for the cw }
 XMSCheck(allocateXMB((xPos div 1024) + 1,xmsHandle,'Speech data'));

 Assign(f,SpeechPath + 'all.voc');
 Reset(f,1);
 New(Buff);

 xPos := 0;

 For wIndex := 38 to Words
   do Begin
      WList[wIndex].Pos := XPos;
      BlockRead(f,Buff^,WList[wIndex].Length,w); { hey, add some error checking! }
      If odd(w) then inc(w);
      XMSCheck(BaseToXMB(w,Buff,xmsHandle,xPos));
      Inc(xPos,w);

      If wIndex = 38
        then Begin { Recognize the language }
             rb := 0;
             For b := 2 to 20 do rb := rb or Buff^[b];
             If rb = $80
               then Language := English
               else Language := Finnish;
             Write(Lang[Language] + ' grammar - ');
             End;
      End;

 Close(f);

 { Initialize CW data }
 WList[35].Length := dotlen;
 WList[35].Pos := xPos;
 For w := 1 to dotlen
  do Buff^[w] := Trunc((Sin(w / 1.95) + 1) * 127) + 1; { Sine wave... [1..255] }
 Buff^[dotlen] := 0; { Set the last byte to 0! }
 XMSCheck(BaseToXMB(dotlen,Buff,xmsHandle,xPos));
 Inc(xPos,dotlen);

 WList[36].Length := dotlen; { A pause, length of a dot }
 WList[36].Pos := xPos;
 For w := 1 to dotlen
  do Buff^[w] := $80;
 Buff^[dotlen] := 0;
 XMSCheck(BaseToXMB(dotlen,Buff,xmsHandle,xPos));
 Inc(xPos,dotlen);

 dotlen := dotlen * 3; { A dash is three times as long as a dot }
 WList[37].Length := dotlen * 3;
 WList[37].Pos := xPos;
 For w := 1 to dotlen
  do Buff^[w] := Trunc((Sin(w / 1.95) + 1) * 127) + 1;
 Buff^[dotlen] := 0;
 XMSCheck(BaseToXMB(dotlen,Buff,xmsHandle,xPos));
 Inc(xPos,dotlen);

 Dispose(Buff);

 CWriteLn(Bytes2StrL(xPos) + ' bytes loaded into XMS, Done.');

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize the interrupt masks                                          }
 { *********** *********** *********** *********** *********** *********** }

Procedure SetIntMasks(b:Byte);
Begin

 Write('IRQ ' + Int2Str(b));

 If b <= 7 then PICPort := $21 else PICPort := $A1;

 IntStopMask  := 1 shl (b mod 8);
 IntStartMask := not (IntStopMask);

 SwInt := Hw2SwInt[b];

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize the lpt port.                                                }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptPortInstall;
Begin

 Write(' LPT port at ' + HexW2Str(LPTBase) + 'h, ');
 Port[LPTBase+2] := 11; { All LPT control lines down }
 Port[LPTbase]   := $80; { LPT data lines down }
 Port[LPTBase+2] := 5;   { PTT down, others up (power the oscillator) }

End;

 { *********** *********** *********** *********** *********** *********** }
 { Install the interrupt handler and initialize the LPT port.              }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptInstall;
Var
  Regs   : Registers;
Begin

 lptPortInstall;

 SetIntMasks(Conf^.Sound.lptInt);

 { Get the original interrupt vector }
 Block.IntNumber := SwInt;
 Regs.AH         := $35;
 Regs.AL         := SwInt;
 MSDos(Regs);
 Block.IntOldCS  := Regs.ES;
 Block.IntOldIP  := Regs.BX;
 { and point it to our handler... }
 Regs.AH         := $25;
 Regs.AL         := SwInt;
 Regs.DS         := seg(lptIntHandler);
 Regs.DX         := ofs(lptIntHandler);
 MSDos(Regs);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Removes the interrupt handler and turns off the LPT port.               }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptUnInstall;
Var
  Regs : Registers;
Begin

  Port[$21] := Port[$21] or $80; { Disable interrupts, PIC }
  Port[LPTbase+2] := Port[LPTbase+2] and $EF; { Disable interrupts, LPT }

  Regs.AH := $25;
  Regs.AL := Block.IntNumber;
  Regs.DS := Block.IntOldCS;
  Regs.DX := Block.IntOldIP;
  MSDos(Regs);

  Port[LPTBase+2] := 11; { All LPT control lines down }

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize the Sound Blaster, check if it's there                       }
 { *********** *********** *********** *********** *********** *********** }

Function sbInstall:Boolean;
Var
  Regs   : Registers;
  sbBase : Word;
Begin

 sbBase := Conf^.Sound.sbBase;
 CWriteLn('Sound Blaster at ' + HexW2Str(sbBase) + 'h,');
 Write('   ');
 sbReset := sbBase + $06;
 sbRead := sbBase + $0A;
 sbWrite := sbBase + $0C;
 sbDataAvail := sbBase + $0E;

 SetIntMasks(Conf^.Sound.sbInt);

 { DMA }
 DMACh := Conf^.Sound.sbDMA;
 Write(', DMA channel ' + Int2Str(DMACh));

  DMAMaskPort     := $0A;
  DMAClrPtrPort   := $0C;
  DMAModePort     := $0B;
  DMABaseAddrPort := 2 * DMACh;
  DMACountPort    := 2 * DMACh + 1;
  Case DMACh of
    0:  DMAPagePort := $87;
    1:  DMAPagePort := $83;
    2:  DMAPagePort := $81;
    3:  DMAPagePort := $82;
  end;
  DMAStopMask  := DMACh + $04;
  DMAStartMask := DMACh + $00;
  DMAMode      := DMACh + $48;

 sbInstall := false;
 Port[sbReset] := 1;
 Delay(10);
 Port[sbReset] := 0;
 Delay(10);
 If (Port[sbDataAvail] and $80 = $80) and (Port[sbRead] = $AA)
   then sbInstall := True
   else sbInstall := False;

 IntStop;
 { Get the original interrupt vector }
 Block.IntNumber := SwInt;
 Regs.AH         := $35;
 Regs.AL         := SwInt;
 MSDos(Regs);
 Block.IntOldCS  := Regs.ES;
 Block.IntOldIP  := Regs.BX;
 { and point it to our handler... }
 Regs.AH         := $25;
 Regs.AL         := SwInt;
 Regs.DS         := seg(sbIntHandler);
 Regs.DX         := ofs(sbIntHandler);
 MSDos(Regs);
 IntStart;
 sbSpeakerOn;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Removes the sb interrupt handler                                        }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbUnInstall;
Var
  Regs : Registers;
Begin

  IntStop;
  DMAStop;
  Regs.AH := $25;
  Regs.AL := Block.IntNumber;
  Regs.DS := Block.IntOldCS;
  Regs.DX := Block.IntOldIP;
  MSDos(Regs);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize hardware                                                     }
 { *********** *********** *********** *********** *********** *********** }

Procedure Init;
Begin

 With Conf^.Sound do Begin

 If SoundHw = SHW_none then Exit;

 Write(' o Initializing sound hardware:');

 New(Queue);
 Inc(OtherStaticMem,SizeOf(Queue^));
 For QWrite := 1 to 2048 do Queue^[QWrite] := Chr(0);

 Speech.lptBase := lptBase;
 Case SoundHw of

   SHW_sb  : Begin
             lptPortInstall;
             If not sbInstall
               then Exit;
             End;

   SHW_lptDac  : lptInstall;

 End;

 End;

 CWriteLn(' - Done.');
 ReadData;

End;

 { *********** *********** *********** *********** *********** *********** }
 { UnInstall the sound driver                                              }
 { *********** *********** *********** *********** *********** *********** }

Procedure UnInstall;
Begin

 Case Conf^.Sound.SoundHw of

   SHW_sb      : sbUnInstall;
   SHW_lptDac  : lptUnInstall;

 End;

End;

 { *********** *********** *********** *********** *********** *********** }

Begin { Init }

 { Initial values... }
 Speaking := False;

 QWrite := 0;
 QRead := 0;

End. { Init }

