
Unit s_Adm;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

  PSecrNum = ^TSecrNum;
  TSecrNum = object(TInputLine)
    SecrData : PSecretNumber;
    constructor Init(var Bounds: TRect; Dat:PSecretNumber);
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PLogEntry = ^TLogEntry;
  TLogEntry = object(TCheckBoxes)
    LogMask      : PLogItems;
    constructor Init(var Bounds: TRect; Mask: PLogItems; AStrings: PSItem);
    destructor Done; virtual;
  end;

   { User parameters }
  PAdm = ^TAdm;
  TAdm = object(TDialog)
    Backup      : PConfig;
    Abandon     : Boolean;

    SysopCall   : PCallStr;
    SecrNum     : PSecrNum;
    OpGroup     : PByteEntry;

    LogEntry    : PLogEntry;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RAdm: TStreamRec = (
     ObjType: 10045;
     VmtLink: Ofs(TypeOf(TAdm)^);
     Load:    @TAdm.Load;
     Store:   @TAdm.Store
  );

Procedure RegisterAdmForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TSecrNum *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TSecrNum.Init(var Bounds: TRect; Dat:PSecretNumber);
Var
 b : Byte;
Begin

 inherited Init(Bounds, 255);
 SecrData := Dat;
 For b := 1 to 255
   do Data^[b] := Chr(Dat^[b] + 48);
 Data^[0] := Chr(Dat^[0]);

End;

Destructor TSecrNum.Done;
Var
 b : Byte;
Begin

 SecrData^[0] := Length(Data^);
 For b := 1 to SecrData^[0]
  do SecrData^[b] := Ord(Data^[b]) - 48;
 inherited Done;

End;

Procedure TSecrNum.HandleEvent(var Event: TEvent);
Begin

 Case Event.What of
   evKeyDown : Begin

               If (Event.CharCode = #0) or (Event.CharCode = #8)
                 then inherited HandleEvent(Event)
                 else

               If ((Event.CharCode >= '0') and (Event.CharCode <= '9'))
                 then inherited HandleEvent(Event);

               End;
   else inherited HandleEvent(Event);
 End;

End;

 { *** TLogEntry *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TLogEntry.Init(var Bounds: TRect; Mask : PLogItems; AStrings: PSItem);
Var
 i : ^Byte;
Begin

 inherited Init(Bounds, AStrings);

 LogMask := Mask;
 i := @LogMask^;

 SetData(i^);

End;

Destructor TLogEntry.Done;
Var
 i : Word;
 m : PLogItems;
Begin

 GetData(i);
 m := @i;
 LogMask^ := m^;

 inherited Done;

End;


 { *** TAdm *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TAdm.Init;
Var
  R : TRect;
Begin

  R.Assign(0, 0, 75, 19);
  inherited Init(R,'Administrative settings');

  R.Assign(29,2,37,3);
  SysopCall := New(PCallStr, Init(R,@Conf^.Adm.SysopCall,6));
  Insert(SysopCall);

  R.Assign(2, 2, 28, 3);
  Insert(New(PLabel, Init(R, 'System ~o~perator callsign:', SysopCall)));

  R.Assign(57,2,61,3);
  OpGroup := New(PByteEntry, Init(R,@Conf^.Adm.OpGroup,2,1,20));
  Insert(OpGroup);

  R.Assign(39,2,55,3);
  Insert(New(PLabel, Init(R, 'Operator ~g~roup:', OpGroup)));

  R.Assign(2,5,73,6);
  SecrNum := New(PSecrNum, Init(R,@Conf^.Adm.SysopSecretNumber));
  Insert(SecrNum);

  R.Assign(2, 4, 45, 5);
  Insert(New(PLabel, Init(R, '~S~ecret number (for remote sysop access):', SecrNum)));

  R.Assign(4, 8, 35, 15);
  LogEntry := New(PLogEntry, Init(R, @Conf^.Adm.LogMask,
    NewSItem('Local node up/down', NewSItem('Local user login/logout',
    NewSItem('Network user in/out', NewSItem('Network node in/out',
    NewSItem('Link up/down', NewSItem('SuperUser tries',
    NewSItem('Console login/logout', nil )))))))));
  Insert(LogEntry);

  R.Assign(2, 7, 45, 8);
  Insert(New(PLabel, Init(R, '~L~ogged events:', LogEntry)));

  R.Assign(9, 16, 19, 18);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TAdm.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TAdm.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TAdm.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TAdm.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterAdmForm;
Begin
  RegisterType(RAdm);
End;

End.
