/******************************************************************************
* G1NNA BBS pre-message creation filter.                                      *
*                                                                             *
* This program is called by the G1NNA BBS program after an send message       *
* command and the subject has been entered, but before the body of the        *
* message is requested.                                                       *
*                                                                             *
* This is a noddy filter to illustrate what can be done. This one checks to   *
* see whether the word SPIDER is contained within the subject, and if it does *
* returns the value 1 to indicate that the message isn't wanted.              *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define FALSE	0
#define TRUE	1

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = callsign.
argv[5] = name.
argv[6] = to field.
argv[7] = at field.
argv[8] = from field.
argv[9] = BID/MID.
argv[10]..argv[argc - 1] = received data / subject (one word per argument).
*/

void main(int argc, char * argv[])
{
	char		found;
	int		i;
	FILE * 	fp;

	// Don't run filter for BBSs.
	if (atoi(argv[3]) & 8)
	{
		exit(0);
	}

	found = FALSE;
	for (i = 10; i < argc; i++)
	{
		if (strstr(strupr(argv[i]), "SPIDER") != NULL)
		{
			found = TRUE;
		}
	}
	if (found)
	{
		fp = fopen(argv[2], "w");
		fprintf(fp, "I don't like spiders!\n");
		fclose(fp);
		exit(1);
	}
	exit(0);
}
