/******************************************************************************
* G1NNA BBS post-file transfer filter.                                        *
*                                                                             *
* This program is called by the G1NNA BBS program after a file transfer       *
* operation takes place (i.e. D, DI, DB, YD, U, UI, UB, YU).                  *
* It is not called when a file transfer is carried out from a terminal        *
* window.                                                                     *
*                                                                             *
* This example keeps a record of the number of files uploaded and downloaded  *
* by each user. It creates a file CALLSIGN.UP (where CALLSIGN is the user     *
* callsign) or CALLSIGN.DN as appropriate in a directory called STATS in      *
* the main BBS directory. 																	   *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>

#define FALSE	0
#define TRUE	1


/*****************************************************************************/


/*******
* main *
*******/

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = callsign.
argv[5] = name.
argv[6] = name of file transferred.
argv[7] = type of file transfer (1 = text, 2 = NPF binary, 3 = NPF image,
			 4 = YAPPC).
argv[8] = direction of transfer ("U" for upload, "D" for download).
argv[9] .. argv[argc - 1] = received data.
*/

void main(int argc, char * argv[])
{
	int		count;
	char		filename[128];
	FILE *	fp;

	/* Work out whether this is an upload or download, and create the appropriate
	file name. */
	if (strcmp(argv[8], "U") == 0)
	{
		sprintf(filename, "STATS\\%s.UP", argv[4]);
	}
	else
	{
		sprintf(filename, "STATS\\%s.DN", argv[4]);
	}

	fp = fopen(filename, "r");
	if (fp == NULL)
	{
		/* If there is no file, this is the first transfer. */
		count = 1;
	}
	else
	{
		/* Get the number of previous transfers, and increment the count. */
		fscanf(fp, "%d", &count);
		count++;
		fclose(fp);
	}

	/* Write the new transfer count back to the file. */
	fp = fopen(filename, "w");
	fprintf(fp, "%d", count);
	fclose(fp);

	exit(0);
}
