#include <stdio.h>
#include <string.h>
#include <process.h>
#include <dir.h>
#define FALSE 1
#define TRUE 0

FILE *in,*out;
char line[1000],*p,oldname[13],path=FALSE;
struct ffblk ff;

void clean_it(char *fname);

void main(int argc,char **argv)
{
	int done;
	if (argc<2)
	{
		printf("\nRPSTRIP is a utility to strip the Path: and R[oute]: information\n"
		"from a packet radio log file.\n"
		"It makes a backup of the origonal file as <filename>.BAK\n"
		"USEAGE: RPSTRIP <filename>\n"
		"filename can be a single file e.g. 931011.run or a wildcard e.g. *.run\n"
		"in which case all files with a 'run' extension will be stripped."
		"\nThis program is supplied AS IS with no warranty.\n"
		"This file and the source code is (C) Ken Robson GM1JLP 1993\n"
		"Any comments and/or suggestions to GM1JLP @ GB7JED\n"
		"Written in Borland C\n");
		exit(0);
	}
	strcpy(oldname,argv[1]);
	if (strchr(oldname,'*'))
	{
		done=findfirst(oldname,&ff,0);
		while (!done)
		{
			clean_it(ff.ff_name);
			done=findnext(&ff);
		}
	}
	else
		clean_it(oldname);
}

void clean_it(char *fname)
{

	in=fopen(fname,"rt");
	if (in==NULL)
	{
		printf("Cannot open file %s\n",fname);
		exit(1);
	}
	out=fopen("temp.ken","wt");
	printf("Cleaning up %s\n",fname);
	p=line;
	fgets(p,1000,in);
	while (!feof(in))
	{
		if (path==FALSE)
		{
			if (*p!='R')
				if( *(p+1)!=':')
					if(*p=='P' && *(p+4)==':')
							path=TRUE;
						else
							fputs(p,out);
		}
		else
			if (*(p+1)!='\n')
				fgets(p,1000,in);
			else
				path=FALSE;
		fgets(p,1000,in);
	}
	fcloseall();
	strncpy(line,fname,strchr(fname,'.')-fname);
	line[strchr(fname,'.')-fname]='\0';
	strcat(line,".BAK");
	rename(fname,line);
	rename("temp.ken",fname);
}



