// ConsoleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "fbbW.h"
#include "fbbWDlg.h"
#include "ConsoleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FONTHEIGHT	12

/////////////////////////////////////////////////////////////////////////////
// CConsoleDlg dialog


CConsoleDlg::CConsoleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConsoleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConsoleDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pParentWnd = pParent;
	nXPos = nYPos = 0;
	nWidth = nHeight = 100;
}


CConsoleDlg::CConsoleDlg(int nX, int nY, CWnd* pParent /*=NULL*/)
	: CDialog(CConsoleDlg::IDD, pParent)
{
	m_pParentWnd = pParent;
	nXPos = nX;
	nYPos = nY;
}


void CConsoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConsoleDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConsoleDlg, CDialog)
	//{{AFX_MSG_MAP(CConsoleDlg)
	ON_WM_PAINT()
	ON_WM_MOVE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConsoleDlg message handlers

void CConsoleDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
}

BOOL CConsoleDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	MoveWindow(nXPos, nYPos, nWidth, nHeight, FALSE);

	// To size input and output window
	CRect rectInput, rectOutput;
	GetClientRect(&rectInput);
	rectOutput = rectInput;

	rectInput.top  = rectInput.bottom - 77;
	m_InputCtrl.Create(ES_MULTILINE | ES_AUTOVSCROLL | ES_AUTOHSCROLL |
		ES_WANTRETURN | WS_VISIBLE | WS_BORDER | WS_VSCROLL, 
		rectInput, this, 0);

	// Output Window
	rectOutput.bottom -= 77;
	m_OutputCtrl.Create(NULL, "Display", WS_CHILD | WS_VISIBLE |
		WS_VSCROLL|WS_BORDER, 
		rectOutput, this, 100);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

////////////////////////////////////////////////////////////////////////////
// Add a string to the ouput window
// lpszText : string to add
// crColor  : color of string

void CConsoleDlg::AddString(LPCTSTR lpszText, int len, COLORREF crColor)
{
	m_OutputCtrl.AddString(lpszText, len, crColor);
}

////////////////////////////////////////////////////////////////////////////
// Send a string to the server
// lpszText : string to send

void CConsoleDlg::Send(LPCTSTR lpszText)
{
	((CFbbWDlg *) GetParent())->SendToServer(lpszText);
	m_OutputCtrl.AddString(lpszText, strlen(lpszText), RGB(127, 0, 127));
}

void CConsoleDlg::OnOK() 
{
	char buffer[100];
	int pos = m_InputCtrl.LineFromChar();
	int nb = m_InputCtrl.GetLine(pos, buffer, sizeof(buffer));
	m_InputCtrl.SetWindowText("");
	buffer[nb] = '\0';
	strcat(buffer, "\n");
	if (!m_bAnsi)
		CharToOem(buffer, buffer);
	Send(buffer);
}

void CConsoleDlg::OnCancel() 
{
	m_pParentWnd->PostMessage(WM_CLOSECONSOLE);
}

void CConsoleDlg::OnMove(int x, int y) 
{
	// TODO: Add your message handler code here
	RECT Rect;
	GetWindowRect(&Rect);
	char szStr[80];
	sprintf(szStr, "%04d %04d", Rect.left, Rect.top);
	((CFbbWApp *)AfxGetApp())->WriteIni("Position_c", szStr);	
}

void CConsoleDlg::OnSize(UINT nType, int cx, int cy) 
{
	RECT Rect;
	GetWindowRect(&Rect);

	// TODO: Add your message handler code here
	char szStr[80];
	sprintf(szStr, "%04d %04d", Rect.right-Rect.left, Rect.bottom-Rect.top);
	((CFbbWApp *)AfxGetApp())->WriteIni("Size_c", szStr);

	cy -= 77;
	m_nYPos = cy;

	if (cy < 0)
		cy = 0;
	if (m_OutputCtrl.GetSafeHwnd())
		m_OutputCtrl.MoveWindow(0, 0, cx, cy);
	if (m_InputCtrl.GetSafeHwnd())
		m_InputCtrl.MoveWindow(0, cy, cx, 77);
}

void CConsoleDlg::SetPosition(int nX, int nY, int nW, int nH)
{
	nXPos = nX;
	nYPos = nY;
	nWidth = nW;
	nHeight = nH;
	if (GetSafeHwnd())
	{
		MoveWindow(nX, nY, nW, nH, FALSE);
	}
}

void CConsoleDlg::SetFont(CFont *pFont, BOOL bRedraw)
{
	m_InputCtrl.SetFont(pFont, bRedraw);
	m_OutputCtrl.SetFont(pFont, bRedraw);
}

BOOL CConsoleDlg::PreTranslateMessage(MSG* pMsg) 
{
	// for modeless processing (or modal)
	ASSERT(m_hWnd != NULL);

	// allow tooltip messages to be filtered
	if (CWnd::PreTranslateMessage(pMsg))
		return TRUE;

	// don't translate dialog messages when in Shift+F1 help mode
	CFrameWnd* pFrameWnd = GetTopLevelFrame();
	if (pFrameWnd != NULL && pFrameWnd->m_bHelpMode)
		return FALSE;

	// fix around for VK_ESCAPE that is on a Dialog
	// that doesn't want the cancel.
	if (pMsg->message == WM_KEYDOWN &&
		(pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_CANCEL))
	{
		return TRUE;
	}

	// filter both messages to dialog and from children
	return PreTranslateInput(pMsg);
}

void CConsoleDlg::SetAnsi(BOOL bAnsi)
{
	m_bAnsi = bAnsi;

	if (m_InputCtrl.GetSafeHwnd())
		m_InputCtrl.SetAnsi(bAnsi);

	if (m_OutputCtrl.GetSafeHwnd())
		m_OutputCtrl.SetAnsi(bAnsi);
}

