// fbbWeditView.cpp : implementation of the CFbbWeditView class
//

#include "stdafx.h"
#include "fbbW.h"

#include "fbbWDlg.h"
#include "fbbWeditDoc.h"
#include "fbbWeditView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditView

IMPLEMENT_DYNCREATE(CFbbWeditView, CEditView)

BEGIN_MESSAGE_MAP(CFbbWeditView, CEditView)
	//{{AFX_MSG_MAP(CFbbWeditView)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CEditView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditView construction/destruction

CFbbWeditView::CFbbWeditView()
{
	// TODO: add construction code here

}

CFbbWeditView::~CFbbWeditView()
{
}

BOOL CFbbWeditView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping

	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditView drawing

void CFbbWeditView::OnDraw(CDC* pDC)
{
	CFbbWeditDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditView printing

BOOL CFbbWeditView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default CEditView preparation
	return CEditView::OnPreparePrinting(pInfo);
}

void CFbbWeditView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView begin printing.
	CEditView::OnBeginPrinting(pDC, pInfo);
}

void CFbbWeditView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView end printing
	CEditView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditView diagnostics

#ifdef _DEBUG
void CFbbWeditView::AssertValid() const
{
	CEditView::AssertValid();
}

void CFbbWeditView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CFbbWeditDoc* CFbbWeditView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFbbWeditDoc)));
	return (CFbbWeditDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditView message handlers

int CFbbWeditView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CFont *m_font = new CFont;
	m_font->CreatePointFont(100,"Courier New");
	SetFont(m_font);
	
	return 0;
}

void CFbbWeditView::Serialize(CArchive& ar) 
{
	if (ar.IsStoring())
	{	// storing code
		CEditView::SerializeRaw(ar);
	}
	else
	{	// loading code
		CFile* pFile = ar.GetFile();
		ASSERT(pFile->GetPosition() == 0);
		DWORD nLen = pFile->GetLength();
		
		LPVOID hInText = LocalAlloc(LMEM_MOVEABLE, (nLen+1));
		if (hInText == NULL)
			AfxThrowMemoryException();
		
		LPTSTR lpszInText = (LPTSTR)LocalLock(hInText);
		ASSERT(lpszInText != NULL);
		if (ar.Read(lpszInText, nLen) != nLen)
		{
			LocalUnlock(hInText);
			LocalFree(hInText);
			AfxThrowArchiveException(CArchiveException::endOfFile);
		}
		
		LPVOID hText = LocalAlloc(LMEM_MOVEABLE, (nLen*2+1));
		if (hText == NULL)
			AfxThrowMemoryException();
		
		LPTSTR lpszText = (LPTSTR)LocalLock(hText);
		ASSERT(lpszText != NULL);
		
		// Formats the input data in MsDos (r) text mode
		DWORD nOut = 0;
		for (DWORD nI = 0 ; nI < nLen ; nI++)
		{
			if (lpszInText[nI] != '\r')
			{
				if (lpszInText[nI] == '\n')
				{
					lpszText[nOut++] = '\r';
					lpszText[nOut++] = '\n';
				}
				else
				{
					lpszText[nOut++] = lpszInText[nI];
				}
			}
		}
		
		// Replace the editing edit buffer with the newly loaded data
		lpszText[nOut] = '\0';
		
		LocalUnlock(hInText);
		LocalFree(hInText);
		
		// set the text with SetWindowText, then free
		SetWindowText(lpszText);

		CEdit& Edit = GetEditCtrl();
		Edit.SetModify();

		LockBuffer();
		UnlockBuffer();

		LocalUnlock(hText);
		LocalFree(hText);
	}
}
