// fbbWDlg.cpp : implementation file
//

#include "afxmt.h"
#include "stdafx.h"
#include <afxpriv.h>
#include "fbbW.h"
#include "MainFrame.h"
#include "SetupDlg.h"
#include "ConsoleDlg.h"
#include "SingleWnd.h"
#include "FileTransfer.h"
#include "ListFiles.h"
#include "Buffer.h"
#include "Forward.h"
#include "fbbWDlg.h"
#include "EditUser.h"
#include "EditMessage.h"
#include "Settings.h"

extern "C" {
#include "md5.h"
}
#include "CopyrightDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define REMOTE0	0
#define REMOTE1	1
#define REMOTE2	2
#define REMOTE3	3
#define NB_REMOTE 4

#define FBB_DATA        0
#define FBB_MSGS        1
#define FBB_STATUS      2
#define FBB_NBCNX       4
#define FBB_LISTCNX     8
#define FBB_MONITOR     16
#define FBB_CONSOLE     32
#define FBB_CHANNEL     64
#define FBB_XFBBX		128

#define DEFAULT_MASK	FBB_XFBBX | FBB_LISTCNX | FBB_NBCNX

#define START_TIMER 1
#define CONNECT_TIMER 2

SOCKET			 g_hSocket = -1;
CCriticalSection g_criticalSection;
CWinThread *	 g_pThread = NULL;
CBufList		 g_buf;

////////////////////////////////////////////////////////////////////////////
// This thread listen the socket 

UINT ThreadFunc(void * pParam)
{
	struct timeval TimeOut;
	fd_set	ReadFs;
	int nNb;
	UCHAR szBuffer[1024];
	BOOL bDoDisconnect = FALSE;

	// TimeOut is 0.1 second
	TimeOut.tv_sec  = 0;
	TimeOut.tv_usec = 100000;

	for(;;)
	{
		if( g_hSocket == -1 )
			return 0;

		FD_ZERO(&ReadFs);
		FD_SET(g_hSocket, &ReadFs);

		nNb = select(0, &ReadFs, NULL, NULL, &TimeOut);
		if (nNb != 0)
		{

			// Incoming data
			if (FD_ISSET(g_hSocket, &ReadFs))
			{
				// Read header first. Be sure the 4 bytes are read
				UINT  uTotal;
				for (uTotal = 0; uTotal < 4;)
				{
					nNb = recv(g_hSocket, (char*) (szBuffer + uTotal), 
					       4 - uTotal, 0);
					if( nNb == SOCKET_ERROR )
					{
						bDoDisconnect = TRUE;
						TRACE("Error (1) : recv in ThreadFunc\n");
						break;
					}
					
					if( nNb == 0 )
					{
						bDoDisconnect = TRUE;
						break;
					}
							
					uTotal += nNb;
				}

				UINT uLength  = ((UINT) szBuffer[3] << 8) + (UINT) szBuffer[2];
				if (uLength > 0)
				{
					for (uTotal = 0; uTotal < uLength;)
					{
						nNb = recv(g_hSocket, (char*) (szBuffer + 4 + uTotal), 
							uLength - uTotal, 0);
						if( nNb == SOCKET_ERROR )
						{
							bDoDisconnect = TRUE;
							TRACE("Error (1) : recv in ThreadFunc\n");
							break;
						}
						
						if( nNb == 0 )
						{
							bDoDisconnect = TRUE;
							break;
						}
								
						uTotal += nNb;
					}
				}

				if (!bDoDisconnect)
				{
					g_criticalSection.Lock();
					g_buf.Put(szBuffer, uLength+4);
					g_criticalSection.Unlock();	
					PostMessage((HWND) pParam, WM_NEWMSG, 0, NULL);
				}
			}
		}

		// Disconnect ...
		if( bDoDisconnect )
		{
			PostMessage((HWND) pParam, WM_REMOTEDISCONNECT, 0, NULL);
			bDoDisconnect = FALSE;
			return 0;
		}
	} // End LOOP

	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg dialog

CFbbWDlg::CFbbWDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFbbWDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFbbWDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_pApp = (CFbbWApp *) AfxGetApp();

	m_hIcon = m_pApp->LoadIcon(IDR_MAINFRAME);

	m_nActiveRemoteID = IDM_DISCONNECT;	// No active remote at begenning
	m_nMask   =  0;

	// Dialog boxes construction
	m_pUserInfos      = NULL;
	m_pConsoleDlg     = new CConsoleDlg(100, 10, this);
	m_pMonitorDlg     = new CSingleWnd(100, 500, 'm', this);
	m_pAllChannelsDlg = new CSingleWnd(100, 10,	'a', this);
	m_pOneChannelDlg  = new CSingleWnd(100, 10, 'o', this);

	g_hSocket = -1;
	g_pThread = NULL;

	m_CurrFileLength = 0;
	m_TotalFileLength = 0;
	m_NbConnected = 0;
	m_nPrevChan = -1;
	m_nChan = -1;

	m_pListFiles = NULL;
	m_pForward = NULL;
	m_pWndProgress = NULL;
	m_pStatusInfo = NULL;
	m_bConnected = FALSE;
	m_pEditMessage = NULL;
	m_pEditUser = NULL;
	m_OptionMenu = 0;
	m_PactorMenu = 0;

	m_bPactorStatus = false;
	m_nPactor = 0;

	m_bMessage = false;
	LOGFONT lf;    
	BOOL bFont = false;
	char szParams[256];
	if (m_pApp->ReadIni("Settings", "Font_Params", szParams))
	{
		sscanf(szParams, "%ld %ld %ld %ld %ld %d %d %d %d %d %d %d %d",
			&lf.lfHeight,
			&lf.lfWidth,
			&lf.lfEscapement,
			&lf.lfOrientation,
			&lf.lfWeight,
			&lf.lfItalic,
			&lf.lfUnderline,
			&lf.lfStrikeOut,
			&lf.lfCharSet,
			&lf.lfOutPrecision,
			&lf.lfClipPrecision,
			&lf.lfQuality,
			&lf.lfPitchAndFamily);
		if (m_pApp->ReadIni("Settings", "Font_Name", lf.lfFaceName))
		{
			if (m_Font.CreateFontIndirect(&lf)) 
				bFont = true;
		}
	}

	if (!bFont)
		m_Font.CreateFont(15, 0, 0, 0, FW_NORMAL, false, false, false, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Courier new");

	ClearStatus();
	ClearMessages();

	m_pApp->SetEditorFont(&m_Font);
}

CFbbWDlg::~CFbbWDlg()
{
	// Delete dialog boxes
	delete m_pConsoleDlg;
	delete m_pMonitorDlg;
	delete m_pAllChannelsDlg;

	// Terminate Thread
	::TerminateThread(g_pThread, 0);
}

void CFbbWDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFbbWDlg)
	DDX_Control(pDX, IDC_STATUS_BOX, m_StatusBox);
	DDX_Control(pDX, IDC_MSG_BOX, m_MessageBox);
	DDX_Control(pDX, IDC_CONNECTEDLIST, m_ConnectedList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFbbWDlg, CDialog)
	ON_COMMAND_RANGE(IDM_REMOTE0, IDM_REMOTE3, OnRemote)
	ON_COMMAND_RANGE(IDM_DISCONNECT, IDM_DISCONNECT, OnRemote)
	ON_COMMAND_RANGE(IDM_CONFIG_REMOTE0, IDM_CONFIG_REMOTE3, OnConfig)
	ON_COMMAND_RANGE(IDM_OPTIONS, IDM_OPTIONS+26, OnOptions)
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTW, 0, 0xFFFF, OnToolTipText)
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTA, 0, 0xFFFF, OnToolTipText)
	ON_MESSAGE(WM_SETMESSAGESTRING, OnSetMessageString)
	ON_MESSAGE(WM_POPMESSAGESTRING, OnPopMessageString)
	//{{AFX_MSG_MAP(CFbbWDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(IDM_CONSOLE, OnConsole)
	ON_COMMAND(IDM_ALLCHANNELS, OnAllChannels)
	ON_COMMAND(IDM_MONITORING, OnMonitoring)
	ON_COMMAND(IDM_FILELIST, OnFilelist)
	ON_COMMAND(IDM_FORWARD, OnForward)
	ON_BN_CLICKED(IDC_MESSAGECHECK, OnMessageCheck)
	ON_BN_CLICKED(IDC_STATUSCHECK, OnStatusCheck)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_COMMAND(ID_EXIT, OnExit)
	ON_LBN_DBLCLK(IDC_CONNECTEDLIST, OnDblclkConnectedlist)
	ON_UPDATE_COMMAND_UI(IDM_ONECHANNEL, OnUpdateOnechannel)
	ON_COMMAND(IDM_ONECHANNEL, OnOneChannel)
	ON_LBN_SELCHANGE(IDC_CONNECTEDLIST, OnSelchangeConnectedlist)
	ON_UPDATE_COMMAND_UI(IDM_MONITORING, OnUpdateMonitoring)
	ON_UPDATE_COMMAND_UI(IDM_CONSOLE, OnUpdateConsole)
	ON_UPDATE_COMMAND_UI(IDM_ALLCHANNELS, OnUpdateAllchannels)
	ON_COMMAND(IDM_DISC, OnDisc)
	ON_UPDATE_COMMAND_UI(IDM_DISC, OnUpdateDisc)
	ON_COMMAND(IDM_IMMEDIATEDISC, OnImmediatedisc)
	ON_UPDATE_COMMAND_UI(IDM_IMMEDIATEDISC, OnUpdateImmediatedisc)
	ON_WM_MENUSELECT()
	ON_WM_ENTERIDLE()
	ON_COMMAND(IDM_EDITMESSAGE, OnEditmessage)
	ON_COMMAND(IDM_EDITUSER, OnEdituser)
	ON_WM_TIMER()
	ON_WM_DRAWITEM()
	ON_COMMAND(IDM_SETTINGS, OnSettings)
	ON_COMMAND(IDM_PACTORIRS, OnPactorirs)
	ON_COMMAND(IDM_PACTORISS, OnPactoriss)
	ON_COMMAND(IDM_PACTORSCAN, OnPactorscan)
	ON_UPDATE_COMMAND_UI(IDM_PACTORSCAN, OnUpdatePactorscan)
	ON_MESSAGE(WM_REMOTEDISCONNECT, OnRemoteDisconnect)
	ON_COMMAND(IDM_COPYRIGHT, OnCopyright)
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_MESSAGE(WM_NEWMSG, OnNewMessage)
	ON_MESSAGE(WM_CLOSECONSOLE, OnCloseConsole)
	ON_MESSAGE(WM_CLOSEMONITOR, OnCloseMonitoring)
	ON_MESSAGE(WM_CLOSEALLCHANNELS, OnCloseAllChannels)
	ON_MESSAGE(WM_CLOSEONECHANNEL, OnCloseOneChannel)
	ON_MESSAGE(WM_SOCKETMSG, OnSocketNotification)
	ON_MESSAGE(WM_GETHOSTBYNAME, OnGetHostByName)
	ON_COMMAND(IDM_USERINFORMATION, OnUserinformation)
	ON_UPDATE_COMMAND_UI(IDM_USERINFORMATION, OnUpdateUserinformation)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg message handlers

BOOL CFbbWDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	// Set the dialog position
	char szTxt[80];

	int nXPos = 0;
	int nYPos = 0;
	if (m_pApp->ReadIni("Settings", "Position", szTxt))
		sscanf(szTxt, "%d %d", &nXPos, &nYPos);

	if( nXPos >= 0 )
	{
		SetWindowPos(NULL, nXPos, nYPos, 0, 0, SWP_NOSIZE | SWP_NOZORDER | 
			SWP_NOREDRAW);
	}

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	// when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Set the dialog menu
	CMenu menu;
	menu.LoadMenu(IDR_FBBWDLG);
	SetMenu(&menu);
	menu.Detach();


	// Update string in submenu CONNECT according to the Remote Name
	// configurated in fbbW.ini
	CMenu * pMenu = GetMenu();
	for(int nRemote = 0; nRemote < NB_REMOTE; nRemote++)
	{
		LoadRemoteConfig(nRemote);
		pMenu->ModifyMenu(nRemote + IDM_REMOTE0, MF_STRING | MF_BYCOMMAND,
						  nRemote + IDM_REMOTE0, 
						  m_RemoteConfig.szName);
		pMenu->ModifyMenu(nRemote + IDM_CONFIG_REMOTE0, MF_STRING | MF_BYCOMMAND,
						  nRemote + IDM_CONFIG_REMOTE0, 
						  m_RemoteConfig.szName);
		if (m_RemoteConfig.bAutoConnect)
		{
			pMenu->CheckMenuItem(nRemote + IDM_CONFIG_REMOTE0, MF_BYCOMMAND | MF_CHECKED);
		}
	}

	pMenu->CheckMenuItem(IDM_ANSI, MF_BYCOMMAND | (m_bAnsi) ? MF_CHECKED : MF_UNCHECKED);
	DrawMenuBar();

	BOOL bBreak = false;
	if (m_pApp->ReadIni("Settings", "BreakLine", szTxt))
		sscanf(szTxt, "%d", &bBreak);
	SetBreakline(bBreak);

	BOOL bJust = true;
	if (m_pApp->ReadIni("Settings", "Justification", szTxt))
		sscanf(szTxt, "%d", &bJust);
	SetJustification(bJust);

	BOOL bPrefix = true;
	if (m_pApp->ReadIni("Settings", "Prefix", szTxt))
		sscanf(szTxt, "%d", &bPrefix);
	SetPrefix(bPrefix);

	BOOL bAnsi = false;
	if (m_pApp->ReadIni("Settings", "AnsiChar", szTxt))
		sscanf(szTxt, "%d", &bAnsi);
	SetAnsi(bAnsi);

	BOOL bSignature = false;
	CString cSignature;
	if (m_pApp->ReadIni("Settings", "Signature", szTxt))
		sscanf(szTxt, "%d", &bSignature);
	if (m_pApp->ReadIni("Settings", "SignatureText", szTxt))
	{
		cSignature = szTxt;
		cSignature.Replace("\\r", "\r\n");
	}
	SetSignature(bSignature, cSignature);

	static UINT auIDStatusBar[] = {
		ID_SEPARATOR,
		IDS_STATUSPROGRESS
	};

	// Create statusbar
	m_wndStatusBar.Create(this);
	m_wndStatusBar.SetIndicators(auIDStatusBar, 2);
	m_wndStatusBar.SetPaneInfo(0, m_wndStatusBar.GetItemID(0), SBPS_NORMAL, 250 );
	m_wndStatusBar.SetPaneInfo(1, m_wndStatusBar.GetItemID(1), SBPS_STRETCH, 0 );
	StatusString(IDS_NOTCONNECTED);

	// Create toolbar
	m_wndToolBar.Create(this);
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() | CBRS_FLYBY | CBRS_TOOLTIPS);
	m_wndToolBar.LoadToolBar(IDR_TOOLBAR);
	m_wndToolBar.SetHeight(29);
	m_wndToolBar.SetBorders(6, 2, 1, 1);
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() | CBRS_BORDER_BOTTOM);

	CRect rcClientStart;
	CRect rcClientNow;
	GetClientRect(rcClientStart);
	RepositionBars(AFX_IDW_CONTROLBAR_FIRST,
				   AFX_IDW_CONTROLBAR_LAST,
				   0, reposQuery, rcClientNow);

	CPoint ptOffset(rcClientNow.left - rcClientStart.left,
				    rcClientNow.top  - rcClientStart.top);
	CRect rcChild;
	CWnd* pwndChild = GetWindow(GW_CHILD);
	while (pwndChild)
	{
		pwndChild->GetWindowRect(rcChild);
		ScreenToClient(rcChild);
		rcChild.OffsetRect(ptOffset);
		pwndChild->MoveWindow(rcChild, FALSE);
		pwndChild = pwndChild->GetNextWindow();
	}

	CRect rcWindow;
	GetWindowRect(rcWindow);
	rcWindow.right  += rcClientStart.Width() - rcClientNow.Width();
	rcWindow.bottom += rcClientStart.Height() - rcClientNow.Height();
	MoveWindow(rcWindow, FALSE);

	RepositionBars(AFX_IDW_CONTROLBAR_FIRST,
				   AFX_IDW_CONTROLBAR_LAST,
				   0);

	// Initialize tool bar
	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_CONSOLE,      FALSE);
	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_MONITORING,   FALSE);
	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_ALLCHANNELS,  FALSE);
	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_ONECHANNEL,   FALSE);

	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_PACTORSCAN,   FALSE);
	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_PACTORIRS,    FALSE);
	m_wndToolBar.GetToolBarCtrl().EnableButton(IDM_PACTORISS,    FALSE);

	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_GATEWAY,        TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_FILELIST,       TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_FORWARD,        TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_USERINFORMATION,TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITUSER,       TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_DISC,           TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_IMMEDIATEDISC,  TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_TALK,           TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_LISTCONNECTIONS,TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITMESSAGE,    TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITUSER,       TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORSCAN,     TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORIRS,      TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORISS,      TRUE);
	m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PRINT,          TRUE);

	// Attach the data to the ownerdrawn controls
	::SetWindowLong(::GetDlgItem(m_hWnd, IDC_MESSAGES),  GWL_USERDATA, (LONG)&m_sMessages);
	::SetWindowLong(::GetDlgItem(m_hWnd, IDC_PRIV_MSGS), GWL_USERDATA, (LONG)&m_sPrivMsgs);
	::SetWindowLong(::GetDlgItem(m_hWnd, IDC_HELD_MSGS), GWL_USERDATA, (LONG)&m_sHeldMsgs);
	::SetWindowLong(::GetDlgItem(m_hWnd, IDC_DISK_FREE), GWL_USERDATA, (LONG)&m_sDiskFree);
	::SetWindowLong(::GetDlgItem(m_hWnd, IDC_DATA_MEM),  GWL_USERDATA, (LONG)&m_sDataMem);
	::SetWindowLong(::GetDlgItem(m_hWnd, IDC_USED_MEM),  GWL_USERDATA, (LONG)&m_sUsedMem);

	// Set the connected station listbox parameters
	m_ConnectedList.SetItemHeight(0, 14);

	OnNewNbcnxMessage(0);
	m_wndStatusBar.SetPaneText(1, "");

	SetTimer(START_TIMER, 500, NULL);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFbbWDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
// to draw the icon.  For MFC applications using the document/view model,
// this is automatically done for you by the framework.

void CFbbWDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
// the minimized window.
HCURSOR CFbbWDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFbbWDlg::PostNcDestroy() 
{
#ifndef _NOSYSTRAY	// Non systray appl
	// Delete this dialog box
	((CMainFrame*) AfxGetMainWnd())->m_pFbbWDlg = NULL;
	delete this;
#endif	// _NOSYSTRAY
	
	CDialog::PostNcDestroy();
}

////////////////////////////////////////////////////////////////////////////
// Try to connect to the server
// lpszTcpAddr : TCP address of serveur
// nTcpPort    : Port to connect to
// nMask       : Mask
//
// Return      : Opened socket or -1 if error
 
SOCKET CFbbWDlg::OpenConnection(LPCTSTR lpszTcpAddr, int nTcpPort, int nMask)
{
	m_SockAddrIn.sin_family = AF_INET;
	m_SockAddrIn.sin_port = htons (nTcpPort);

	unsigned long nIadd = inet_addr(lpszTcpAddr);
	if (nIadd == INADDR_NONE)
	{
		StatusString(IDS_LOOKUP, lpszTcpAddr);
		WSAAsyncGetHostByName(GetSafeHwnd(), WM_GETHOSTBYNAME, lpszTcpAddr, m_HostBuffer, MAXGETHOSTSTRUCT);
 		/*
		phe = gethostbyname (lpszTcpAddr);
		if (phe && phe->h_length && phe->h_addr)
			memcpy((char *) &SockAddr.sin_addr, phe->h_addr, phe->h_length);
		else
		{
			SockErrMessageBox("Error retrieving host information", 
							  WSAGetLastError());
			return (-1);
		}
		*/
		return 0;
	}
	else
	{
		m_SockAddrIn.sin_addr.S_un.S_addr = nIadd;
	}

	return doConnect(&m_SockAddrIn);
}

int CFbbWDlg::doConnect(SOCKADDR_IN *pSockAddr)
{
	SOCKET		 hSock;

	ASSERT(g_hSocket == -1);

	StatusString(IDS_CONNECTING, m_RemoteConfig.szHostName);

	if ((hSock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		SockErrMessageBox("Error creating socket", WSAGetLastError());
		return (0);
	}

	BOOL bVal = true;
	if (setsockopt(hSock, SOL_SOCKET, SO_REUSEADDR, (char *)&bVal, sizeof(BOOL)) != 0)
	{
		int err = WSAGetLastError();
		SockErrMessageBox("setsockopt SO_REUSEADDR", err);
	}

	g_hSocket = hSock;

	WSAAsyncSelect(hSock, GetSafeHwnd(), WM_SOCKETMSG, FD_CONNECT|FD_READ);

	if( connect(hSock, (SOCKADDR FAR *) pSockAddr, sizeof(SOCKADDR_IN)) == -1 )
	{
		int err = WSAGetLastError();

		if (err != WSAEWOULDBLOCK)
		{
			SockErrMessageBox("Error establishing connection", err);
			CloseConnection();
			m_nTimerDelay = 60;
			SetTimer(CONNECT_TIMER, 1000, NULL);
			return (-1);
		}
	}
	return 0;
}

////////////////////////////////////////////////////////////////////////////
// Disconnect from the server

void CFbbWDlg::CloseConnection()
{
	if( g_hSocket == -1 )	
		return;		// Not connected

	closesocket(g_hSocket);
	g_hSocket = -1;
	if (g_pThread)
		WaitForSingleObject(g_pThread, INFINITE);
	g_pThread = NULL;
	m_bConnected = FALSE;

	UpdateControls();
}

////////////////////////////////////////////////////////////////////////////
// Display a MessageBox which describe a socket problem
// lpszText   : First line of text 
// nErrorCode : Error number (see function WSAGetLastError) 

void CFbbWDlg::SockErrMessageBox(LPCTSTR lpszText, int nErrorCode)
{
	LPCTSTR lpszError;

	switch( nErrorCode )
	{
	case WSAENAMETOOLONG :
		lpszError = "Name too long";
		break;
		
	case WSANOTINITIALISED :
		lpszError = "Not initialized";
		break;
		
	case WSASYSNOTREADY :
		lpszError = "System not ready";
		break;
		
	case WSAVERNOTSUPPORTED :
		lpszError = "Version is not supported";
		break;
		
	case WSAESHUTDOWN :
		lpszError = "Can't send after socket shutdown";
		break;
		
	case WSAEINTR :
		lpszError = "Interrupted system call";
		break;
		
	case WSAHOST_NOT_FOUND :
		lpszError = "Host not found";
		break;
		
	case WSATRY_AGAIN :
		lpszError = "Try again";
		break;
		
	case WSANO_RECOVERY :
		lpszError = "Non-recoverable error";
		break;
		
	case WSANO_DATA :
		lpszError = "No data record available";
		break;
		
	case WSAEBADF :
		lpszError = "Bad file number";
		break;
		
	case WSAEWOULDBLOCK :
		lpszError = "Operation would block";
		break;
		
	case WSAEINPROGRESS :
		lpszError = "Operation now in progress";
		break;
		
	case WSAEALREADY :
		lpszError = "Operation already in progress";
		break;
		
	case WSAEFAULT :
		lpszError = "Bad address";
		break;
		
	case WSAEDESTADDRREQ :
		lpszError = "Destination address required";
		break;
		
	case WSAEMSGSIZE :
		lpszError = "Message too long";
		break;
		
	case WSAEPFNOSUPPORT :
		lpszError = "Protocol family not supported";
		break;
		
	case WSAENOTEMPTY :
		lpszError = "Directory not empty";
		break;
		
	case WSAEPROCLIM :
		lpszError = "EPROCLIM lpszError =ed";
		break;
		
	case WSAEUSERS :
		lpszError = "EUSERS lpszError =ed";
		break;
		
	case WSAEDQUOT :
		lpszError = "Disk quota exceeded";
		break;
		
	case WSAESTALE :
		lpszError = "ESTALE lpszError =ed";
		break;
		
	case WSAEINVAL :
		lpszError = "Invalid argument";
		break;
		
	case WSAEMFILE :
        lpszError = "Too many open files";
		break;
		
	case WSAEACCES :
		lpszError = "Access denied";
		break;
		
	case WSAELOOP :
		lpszError = "Too many levels of symbolic links";
		break;
		
	case WSAEREMOTE :
		lpszError = "The object is remote";
		break;
		
	case WSAENOTSOCK :
		lpszError = "Socket operation on non-socket";
		break;
		
	case WSAEADDRNOTAVAIL :
		lpszError = "Can't assign requested address";
		break;
		
	case WSAEADDRINUSE :
		lpszError = "Address already in use";
		break;
		
	case WSAEAFNOSUPPORT :
		lpszError = "Address family not supported by protocol family";
		break;
		
	case WSAESOCKTNOSUPPORT :
		lpszError = "Socket type not supported";
		break;
		
	case WSAEPROTONOSUPPORT :
		lpszError = "Protocol not supported";
		break;
		
	case WSAENOBUFS :
		lpszError = "No buffer space is supported";
		break;
		
	case WSAETIMEDOUT :
		lpszError = "Connection timed out";
		break;
		
	case WSAEISCONN :
		lpszError = "Socket is already connected";
		break;
		
	case WSAENOTCONN :
		lpszError = "Socket is not connected";
		break;
		
	case WSAENOPROTOOPT :
		lpszError = "Bad protocol option";
		break;
		
	case WSAECONNRESET :
		lpszError = "Connection reset by peer";
		break;
		
	case WSAECONNABORTED :
		lpszError = "Software caused connection abort";
		break;
		
	case WSAENETDOWN :
		lpszError = "Network is down";
		break;
		
	case WSAENETRESET :
		lpszError = "Network was reset";
		break;
		
	case WSAECONNREFUSED :
		lpszError = "Connection refused";
		break;
		
	case WSAEHOSTDOWN :
		lpszError = "Host is down";
		break;
		
	case WSAEHOSTUNREACH :
		lpszError = "Host is unreachable";
		break;
		
	case WSAEPROTOTYPE :
		lpszError = "Protocol is wrong type for socket";
		break;
		
	case WSAEOPNOTSUPP :
		lpszError = "Operation not supported on socket";
		break;
		
	case WSAENETUNREACH :
		lpszError = "ICMP network unreachable";
		break;
		
	case WSAETOOMANYREFS :
		lpszError = "Too many references";
		break;
		
	default :
		lpszError = "Unknown";
		break;
	 }

	 CString str;
	 str.Format("%s\n%s\n", lpszText, lpszError);
	 MessageBox(str, "Network", MB_ICONEXCLAMATION);
}


///////////////////////////////////////////////////////////////////////////
// Connect/Disconnect a remote server

void CFbbWDlg::OnRemote(UINT nID)
{
	KillTimer(CONNECT_TIMER);

	m_ConnectedList.ResetContent();

	if( m_nActiveRemoteID != IDM_DISCONNECT )
	{
		CloseConnection();	// If there is a connection, disconnect it b4
		Sleep(2000);
	}

	if( nID != IDM_DISCONNECT )
	{
		m_nActiveRemoteID = nID;

		SetCursor(LoadCursor(NULL, IDC_WAIT));  

		m_nMask = DEFAULT_MASK;
		m_pApp->m_nNumConfig = nID - IDM_REMOTE0;
		LoadRemoteConfig(m_pApp->m_nNumConfig);

		if( OpenConnection(m_RemoteConfig.szHostName, m_RemoteConfig.nPort, m_nMask) == -1 )
		{
			// Unable to connect ...
			nID = IDM_DISCONNECT;
			StatusString(IDS_CONNECTIONERROR, m_RemoteConfig.szHostName);
		}
		return;
	}

	// Update menu
	CMenu* pMenu = GetMenu();
	if( m_nActiveRemoteID != IDM_DISCONNECT )
		pMenu->CheckMenuItem(m_nActiveRemoteID, MF_BYCOMMAND | MF_UNCHECKED);

	m_bConnected = (nID != IDM_DISCONNECT);

	UpdateControls();

}

////////////////////////////////////////////////////////////////////////////
// Disconnect a remote serveur

afx_msg LRESULT CFbbWDlg::OnRemoteDisconnect(WPARAM wParam, LPARAM lParam)
{
	if( g_hSocket != -1 )
	{
		OnRemote(IDM_DISCONNECT);
		g_hSocket = -1;
		// MessageBox("Connection closed", "Network", MB_ICONEXCLAMATION);
		m_nTimerDelay = 60;
		SetTimer(CONNECT_TIMER, 1000, NULL);
	}
	
	return 0;
}

////////////////////////////////////////////////////////////////////////////
// Enable/Disable the console mode

void CFbbWDlg::OnConsole()
{
	CMenu* pMenu = GetMenu();

	if( m_nMask & FBB_CONSOLE )
	{
		// Close console
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_CONSOLE, FALSE);
		pMenu->CheckMenuItem(IDM_CONSOLE, MF_BYCOMMAND | MF_UNCHECKED);
		m_nMask &= ~FBB_CONSOLE;

		// Close dialog (if any)
		if (m_pConsoleDlg->GetSafeHwnd())
			m_pConsoleDlg->ShowWindow(SW_HIDE);
//		m_pConsoleDlg->DestroyWindow();
	}
	else
	{
		// Open console
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_CONSOLE, TRUE);
		pMenu->CheckMenuItem(IDM_CONSOLE, MF_BYCOMMAND | MF_CHECKED);
		m_nMask |= FBB_CONSOLE;

		char szStr[80];
		int nXPos = 0;
		int nYPos = 0;
		int nWidth = 590;
		int nHeight = 395;
		if (m_pApp->ReadIni("Position_c", szStr))
		{
			sscanf(szStr, "%04d %04d", &nXPos, &nYPos);
		}
		if (m_pApp->ReadIni("Size_c", szStr))
		{
			sscanf(szStr, "%04d %04d", &nWidth, &nHeight);
		}
		m_pConsoleDlg->SetPosition(nXPos, nYPos, nWidth, nHeight);

		if (!m_pConsoleDlg->GetSafeHwnd())
		{
			m_pConsoleDlg->Create(IDD_CONSOLE, this);
			m_pConsoleDlg->SetFont(&m_Font);
			m_pConsoleDlg->SetAnsi(m_bAnsi);
		}

	}

	SendMaskToServer();
}

////////////////////////////////////////////////////////////////////////////
// Enable/Disable the monitoring mode

void CFbbWDlg::OnMonitoring()
{
	CString strState;
	CMenu* pMenu = GetMenu();

	if( m_nMask & FBB_MONITOR )
	{
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_MONITORING, FALSE);
		pMenu->CheckMenuItem(IDM_MONITORING, MF_BYCOMMAND | MF_UNCHECKED);
		m_nMask &= ~FBB_MONITOR;

		// Close dialog (if any)
		if (m_pMonitorDlg->GetSafeHwnd())
			m_pMonitorDlg->ShowWindow(SW_HIDE);
		strState.Format("%d", SW_HIDE);
	}
	else
	{
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_MONITORING, TRUE);
		pMenu->CheckMenuItem(IDM_MONITORING, MF_BYCOMMAND | MF_CHECKED);
		m_nMask |= FBB_MONITOR;

		char szStr[80];
		int nXPos = 0;
		int nYPos = 0;
		int nWidth = 590;
		int nHeight = 400;
		if (m_pApp->ReadIni("Position_m", szStr))
		{
			sscanf(szStr, "%04d %04d", &nXPos, &nYPos);
		}
		if (m_pApp->ReadIni("Size_m", szStr))
		{
			sscanf(szStr, "%04d %04d", &nWidth, &nHeight);
		}
		m_pMonitorDlg->SetPosition(nXPos, nYPos, nWidth, nHeight);


		// Create dialog
		if (!m_pMonitorDlg->GetSafeHwnd())
		{
			m_pMonitorDlg->Create(IDD_MONITORING, this);
			m_pMonitorDlg->SetFont(&m_Font);
			m_pMonitorDlg->SetAnsi(m_bAnsi);
		}
		m_pMonitorDlg->ShowWindow(SW_SHOW);
		strState.Format("%d", SW_SHOW);
	}

	m_pApp->WriteIni("State_m", strState.GetBuffer(256));
	SendMaskToServer();
}

////////////////////////////////////////////////////////////////////////////
// Enable/Disable the All Channels monitoring mode

void CFbbWDlg::OnAllChannels()
{
	CString strState;
	CMenu* pMenu = GetMenu();

	if(IsOpened(m_pAllChannelsDlg))
	{
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_ALLCHANNELS, FALSE);
		pMenu->CheckMenuItem(IDM_ALLCHANNELS, MF_BYCOMMAND | MF_UNCHECKED);

		// Close dialog (if any)
		if (m_pAllChannelsDlg->GetSafeHwnd())
			m_pAllChannelsDlg->ShowWindow(SW_HIDE);
		strState.Format("%d", SW_HIDE);
	}
	else
	{
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_ALLCHANNELS, TRUE);
		pMenu->CheckMenuItem(IDM_ALLCHANNELS, MF_BYCOMMAND | MF_CHECKED);

		// Create dialog
		char szStr[80];
		int nXPos = 0;
		int nYPos = 0;
		int nWidth = 590;
		int nHeight = 400;
		if (m_pApp->ReadIni("Position_a", szStr))
		{
			sscanf(szStr, "%04d %04d", &nXPos, &nYPos);
		}
		if (m_pApp->ReadIni("Size_a", szStr))
		{
			sscanf(szStr, "%04d %04d", &nWidth, &nHeight);
		}
		m_pAllChannelsDlg->SetPosition(nXPos, nYPos, nWidth, nHeight);

		if (!m_pAllChannelsDlg->GetSafeHwnd())
		{
			m_pAllChannelsDlg->Create(IDD_ALLCHANNELS, this);
			m_pAllChannelsDlg->SetFont(&m_Font);
			m_pAllChannelsDlg->SetAnsi(m_bAnsi);
		}

		m_pAllChannelsDlg->ShowWindow(SW_SHOW);
		strState.Format("%d", SW_SHOW);
	}

	m_pApp->WriteIni("State_0", strState.GetBuffer(256));
	ChangeChannelMask();
}

void CFbbWDlg::OnOneChannel() 
{
	CString strState;

	// TODO: Add your command handler code here
	if(IsOpened(m_pOneChannelDlg))
	{
		// if the selection has changed, don't close the window ... A faire !!!
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_ONECHANNEL, FALSE);

		// Close dialog (if any)
		if (m_pOneChannelDlg->GetSafeHwnd())
			m_pOneChannelDlg->ShowWindow(SW_HIDE);
		strState.Format("%d", SW_HIDE);
	}
	else
	{
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_ONECHANNEL, TRUE);

		// Create dialog
		char szStr[80];
		int nXPos = 0;
		int nYPos = 0;
		int nWidth = 590;
		int nHeight = 400;
		if (m_pApp->ReadIni("Position_o", szStr))
		{
			sscanf(szStr, "%04d %04d", &nXPos, &nYPos);
		}
		if (m_pApp->ReadIni("Size_o", szStr))
		{
			sscanf(szStr, "%04d %04d", &nWidth, &nHeight);
		}
		m_pOneChannelDlg->SetPosition(nXPos, nYPos, nWidth, nHeight);

		// Create dialog
		if (m_pOneChannelDlg->GetSafeHwnd())
			m_pOneChannelDlg->ShowWindow(SW_SHOW);
		else
		{
			m_pOneChannelDlg->Create(IDD_ONECHANNEL, this);
			m_pOneChannelDlg->SetFont(&m_Font);
			m_pOneChannelDlg->SetAnsi(m_bAnsi);
		}
		OpenOneChannel();
		strState.Format("%d", SW_SHOW);
	}

	m_pApp->WriteIni("State_o", strState.GetBuffer(256));
	ChangeChannelMask();
}

////////////////////////////////////////////////////////////////////////////
// Configure the remote server

void CFbbWDlg::OnConfig(UINT nID)
{
	int nRemote = nID - IDM_CONFIG_REMOTE0;

	// Load settings (use a ini file, not the registery)
	LoadRemoteConfig(nRemote);
	
	// Update string in menu (Connect)
	CMenu * pMenu = GetMenu();

	CSetupDlg dlg;

	dlg.m_strConfigName = m_RemoteConfig.szName;
	dlg.m_strHostName   = m_RemoteConfig.szHostName;
	dlg.m_strCallSign   = m_RemoteConfig.szCallSign;
	dlg.m_strPassWord   = m_RemoteConfig.szPassword;
	dlg.m_nPort         = m_RemoteConfig.nPort;
	dlg.m_bAutoConnect  = m_RemoteConfig.bAutoConnect;

	BOOL bAuto = m_RemoteConfig.bAutoConnect;

	if( dlg.DoModal() == IDOK )
	{
		strcpy(m_RemoteConfig.szName,     dlg.m_strConfigName);
		strcpy(m_RemoteConfig.szHostName, dlg.m_strHostName);
		strcpy(m_RemoteConfig.szCallSign, dlg.m_strCallSign);
		strcpy(m_RemoteConfig.szPassword, dlg.m_strPassWord);
		m_RemoteConfig.nPort = dlg.m_nPort;
		m_RemoteConfig.bAutoConnect = dlg.m_bAutoConnect;

		SaveRemoteConfig(nRemote);


		pMenu->ModifyMenu(nRemote + IDM_REMOTE0, MF_BYCOMMAND | MF_STRING,
						  nRemote + IDM_REMOTE0, 
						  m_RemoteConfig.szName);

		pMenu->ModifyMenu(nRemote + IDM_CONFIG_REMOTE0, MF_BYCOMMAND | MF_STRING,
						  nRemote + IDM_CONFIG_REMOTE0, 
						  m_RemoteConfig.szName);
	}

	if (m_RemoteConfig.bAutoConnect && m_RemoteConfig.bAutoConnect != bAuto)
	{
		// Unvalidate other possible AutoRun

		for (int nI = 0 ; nI < NB_REMOTE ; nI++)
		{
			if (nI != nRemote)
			{
				LoadRemoteConfig(nI);
				m_RemoteConfig.bAutoConnect = false;
				SaveRemoteConfig(nI);
				pMenu->CheckMenuItem(nI + IDM_CONFIG_REMOTE0, MF_BYCOMMAND | MF_UNCHECKED);
			}
		}
		LoadRemoteConfig(nRemote);
		pMenu->CheckMenuItem(nRemote + IDM_CONFIG_REMOTE0, MF_BYCOMMAND | MF_CHECKED);
	}

}

//////////////////////////////////////////////////////////////////////////////
// Display the copyright dialog box

void CFbbWDlg::OnCopyright()
{
	CCopyrightDlg dlg;
	dlg.DoModal();
}

//////////////////////////////////////////////////////////////////////////////
// Display the about dialog box

void CFbbWDlg::OnAbout()
{
	CAboutDlg dlg;
	dlg.DoModal();
}

////////////////////////////////////////////////////////////////////////////
// Load config for a remote server
// nRemote : config number (0, 1, 2, 3)

void CFbbWDlg::LoadRemoteConfig(int nRemote)
{
	int nConfig = m_pApp->m_nNumConfig;
	m_pApp->m_nNumConfig = nRemote;

	ZeroMemory(&m_RemoteConfig, sizeof REMOTE_CONFIG);
	
	// Don't use the registery (due to my own preference)

	if (!m_pApp->ReadIni("Name", m_RemoteConfig.szName))
		wsprintf(m_RemoteConfig.szName, "Remote %d", nConfig);

	if (!m_pApp->ReadIni("Host Name", m_RemoteConfig.szHostName))
		strcpy(m_RemoteConfig.szHostName, "linux");

	if (!m_pApp->ReadIni("Callsign", m_RemoteConfig.szCallSign))
		strcpy(m_RemoteConfig.szCallSign, "F5MZN");

	if (!m_pApp->ReadIni("Password", m_RemoteConfig.szPassword))
		strcpy(m_RemoteConfig.szPassword, "1234");

	m_RemoteConfig.nPort = m_pApp->ReadIni("Port", 3286);
	m_RemoteConfig.bAutoConnect = m_pApp->ReadIni("AutoConnect");

	m_pApp->m_nNumConfig = nConfig;
}

////////////////////////////////////////////////////////////////////////////
// Save config for a remote server
// nRemote : config number (0, 1, 2, 3)

void CFbbWDlg::SaveRemoteConfig(int nRemote)
{
	int nConfig = m_pApp->m_nNumConfig;
	m_pApp->m_nNumConfig = nRemote;

	// Don't use the registery (due to my own preference)

	m_pApp->WriteIni("Name", m_RemoteConfig.szName);
	m_pApp->WriteIni("Host Name", m_RemoteConfig.szHostName);
	m_pApp->WriteIni("Callsign", m_RemoteConfig.szCallSign);
	m_pApp->WriteIni("Password", m_RemoteConfig.szPassword);

	char szStr[80];

	wsprintf(szStr, "%d", m_RemoteConfig.nPort);
	m_pApp->WriteIni("Port", szStr);

	wsprintf(szStr, "%d", m_RemoteConfig.bAutoConnect);
	m_pApp->WriteIni("AutoConnect", szStr);

	m_pApp->m_nNumConfig = nConfig;
}

void CFbbWDlg::MakeMD5Key(LPCTSTR lpszKey, LPCTSTR lpszPassword, LPSTR lpszBuffer)
{
	CHAR	szSource[1024];

	sprintf(szSource, "%s%s", lpszKey, lpszPassword);


	MD5_CTX context;
	unsigned char digest[16];
	unsigned int len = strlen (szSource);

	MD5Init (&context);
	MD5Update (&context, (unsigned char*) szSource, len);
	MD5Final (digest, &context);

	*lpszBuffer = '\0';

	for (int i = 0; i < 16; i++)
	{
		char szTmp[5];

		sprintf (szTmp, "%02X", digest[i]);
		strcat (lpszBuffer, szTmp);
	}
}

BOOL CFbbWDlg::FileTransfer(UINT uCommand, char *szBuffer, UINT uLength)
{
	CString Path;
				
	if (m_TotalFileLength == 0)
	{
		Path.Format("File = %s", szBuffer);
		
		int len = strlen((char *)szBuffer);
		m_TotalFileLength = atoi((char *)szBuffer+len+1);
		
		if (m_TotalFileLength == 0)
			return FALSE;
		
		char *ptr = strrchr(szBuffer, '/');
		if (ptr)
			++ptr;
		else 
			ptr = szBuffer;
		strcpy(m_szFileName, ptr);
		
		p_Fptr = fopen(m_szFileName, "wb");
		if (p_Fptr)
			StartProgress(m_TotalFileLength);
		return TRUE;
	}
	else
	{
		m_CurrFileLength += uLength;
		fwrite(szBuffer, uLength, 1, p_Fptr);
		SetProgress(m_CurrFileLength);
	}
	if (uLength == 0)
	{
		fclose(p_Fptr);
		p_Fptr = NULL;
		StopProgress();
		m_CurrFileLength = m_TotalFileLength = 0;
		m_pApp->RunEditor(m_szFileName);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CModelessMain::OnToolTipText
//      Handles TTN_NEEDTEXT message to display tooltips for the toolbar.
//      This code is based on CFrameWnd::OnToolTipText

BOOL CFbbWDlg::OnToolTipText(UINT, NMHDR* pNMHDR, LRESULT* pResult)
{
	ASSERT(pNMHDR->code == TTN_NEEDTEXTA || pNMHDR->code == TTN_NEEDTEXTW);

	// allow top level routing frame to handle the message
	if (GetRoutingFrame() != NULL)
		return FALSE;

	// need to handle both ANSI and UNICODE versions of the message
	TOOLTIPTEXTA* pTTTA = (TOOLTIPTEXTA*)pNMHDR;
	TOOLTIPTEXTW* pTTTW = (TOOLTIPTEXTW*)pNMHDR;
	TCHAR szFullText[256];
	CString strTipText;
	UINT nID = pNMHDR->idFrom;
	if (pNMHDR->code == TTN_NEEDTEXTA && (pTTTA->uFlags & TTF_IDISHWND) ||
		pNMHDR->code == TTN_NEEDTEXTW && (pTTTW->uFlags & TTF_IDISHWND))
	{
		// idFrom is actually the HWND of the tool
		nID = ((UINT)(WORD)::GetDlgCtrlID((HWND)nID));
	}

	if (nID != 0) // will be zero on a separator
	{
		AfxLoadString(nID, szFullText);
			// this is the command id, not the button index
		AfxExtractSubString(strTipText, szFullText, 1, '\n');
	}
#ifndef _UNICODE
	if (pNMHDR->code == TTN_NEEDTEXTA)
		lstrcpyn(pTTTA->szText, strTipText,
			(sizeof(pTTTA->szText)/sizeof(pTTTA->szText[0])));
	else
		_mbstowcsz(pTTTW->szText, strTipText,
			(sizeof(pTTTW->szText)/sizeof(pTTTW->szText[0])));
#else
	if (pNMHDR->code == TTN_NEEDTEXTA)
		_wcstombsz(pTTTA->szText, strTipText,
			(sizeof(pTTTA->szText)/sizeof(pTTTA->szText[0])));
	else
		lstrcpyn(pTTTW->szText, strTipText,
			(sizeof(pTTTW->szText)/sizeof(pTTTW->szText[0])));
#endif
	*pResult = 0;

	// bring the tooltip window above other popup windows
	::SetWindowPos(pNMHDR->hwndFrom, HWND_TOP, 0, 0, 0, 0,
		SWP_NOACTIVATE|SWP_NOSIZE|SWP_NOMOVE);

	return TRUE;    // message was handled
}

LRESULT CFbbWDlg::OnNewMessage(WPARAM wParam, LPARAM lParam)
{
	UINT uColor;
	int nLen;
	LPSTR pStr;

	g_criticalSection.Lock();
	UCHAR *pBuf = g_buf.Get(&nLen);
	g_criticalSection.Unlock();

	if (pBuf == NULL)
		return 0;

	UINT uService = (UINT) pBuf[0];
	UINT uCommand = (UINT) pBuf[1];
	UINT uLength  = ((UINT) pBuf[3] << 8) + (UINT) pBuf[2];

	pStr = (LPSTR)pBuf+4;
				
	// Decode and display service
	switch(uService)
	{
	case FBB_DATA :
		switch(uCommand)
		{
		case 0:	// List of available services
			{
				UINT nI;
				for (nI = 0 ; nI < uLength ; nI++)
				{
					switch (pStr[nI])
					{
					case 1:
					case 2:
					case 3:
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_FILELIST, FALSE);
						break;
					case 4:
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_FORWARD, FALSE);
						break;
					case 5:
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_DISC, FALSE);
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_IMMEDIATEDISC, FALSE);
						break;
					case 6:
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITUSER, FALSE);
						break;
					case 7:
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITMESSAGE, FALSE);
						break;
					case 9:
						CreateOptionsMenu();
						break;
					case 11:
						m_wndToolBar.GetToolBarCtrl().HideButton(IDM_USERINFORMATION, FALSE);
						break;
					}	
				}
			}
			break;
		case 1:	// Directory
			if (m_pListFiles)
			{
				if (m_TotalFileLength == 0)
				{
					int len = strlen((char *)pStr);
					m_TotalFileLength = atoi((char *)pStr+len+1);
					strcpy(m_szFileName, "fbb_directory.txt");
					p_Fptr = fopen(m_szFileName, "w");
					if (p_Fptr)
						StartProgress(m_TotalFileLength);
				}
				else if (uLength == 0)
				{
					if (p_Fptr)
						fclose(p_Fptr);
					p_Fptr = NULL;
					m_pListFiles->EndTransfer(m_szFileName);
					m_CurrFileLength = m_TotalFileLength = 0;
					StopProgress();
				}
				else
				{
					m_CurrFileLength += uLength;
					if (p_Fptr)
						fwrite(pStr, uLength, 1, p_Fptr);
					SetProgress(m_CurrFileLength);
				}
			}
			break;
		case 2:	// File Download
			FileTransfer(2, pStr, uLength);
			break;
		case 3:	// File Upload
			FileTransfer(3, pStr, uLength);
			break;
		case 4:	// Forward management
			if (m_TotalFileLength == 0)
			{
				int len = strlen((char *)pStr);
				m_TotalFileLength = atoi((char *)pStr+len+1);
				strcpy(m_szFileName, "forward.txt");
				p_Fptr = fopen(m_szFileName, "w");
				if (p_Fptr)
					StartProgress(m_TotalFileLength);
			}
			else if (uLength == 0)
			{
				if (p_Fptr)
					fclose(p_Fptr);
				p_Fptr = NULL;
				StopProgress();
				m_CurrFileLength = m_TotalFileLength = 0;
				if (m_pForward == NULL)
				{
					m_pForward = new CForward(m_szFileName);
					m_pForward->DoModal();
					delete m_pForward;
					m_pForward = NULL;
				}
				else
				{
					unlink(m_szFileName);
				}
			}
			else
			{
				m_CurrFileLength += uLength;
				if (p_Fptr)
				{
					fwrite(pStr, uLength, 1, p_Fptr);
					SetProgress(m_CurrFileLength);
				}
			}
			break;
		case 6:	// User management
			if (m_pEditUser)
			{
				m_pEditUser->Answer(pStr, uLength);
				break;
			}

			if (m_TotalFileLength == 0)
			{
				int len = strlen((char *)pStr);
				m_TotalFileLength = atoi((char *)pStr+len+1);
				strcpy(m_szFileName, SERVICE_FILE);
				p_Fptr = fopen(m_szFileName, "w");
				if (p_Fptr)
					StartProgress(m_TotalFileLength);
			}
			else if (uLength == 0)
			{
				if (p_Fptr)
					fclose(p_Fptr);
				p_Fptr = NULL;
				StopProgress();
				m_CurrFileLength = m_TotalFileLength = 0;
				m_pEditUser = new CEditUser;
				m_pEditUser->DoModal();
				delete m_pEditUser;
				m_pEditUser = NULL;
				unlink(SERVICE_FILE);
			}
			else
			{
				m_CurrFileLength += uLength;
				if (p_Fptr)
				{
					fwrite(pStr, uLength, 1, p_Fptr);
					SetProgress(m_CurrFileLength);
				}
			}
			break;
		case 7:	// Message management
			if (m_pEditMessage)
			{
				m_pEditMessage->Answer(pStr, uLength);
			}
			else if (m_TotalFileLength == 0)
			{
				int len = strlen((char *)pStr);
				m_TotalFileLength = atoi((char *)pStr+len+1);
				strcpy(m_szFileName, SERVICE_FILE);
				p_Fptr = fopen(m_szFileName, "w");
				if (p_Fptr)
					StartProgress(m_TotalFileLength);
			}
			else if (uLength == 0)
			{
				if (p_Fptr)
					fclose(p_Fptr);
				p_Fptr = NULL;
				StopProgress();
				m_CurrFileLength = m_TotalFileLength = 0;
				m_pEditMessage = new CEditMessage;
				m_pEditMessage->DoModal();
				delete m_pEditMessage;
				m_pEditMessage = NULL;
				unlink(SERVICE_FILE);
			}
			else
			{
				m_CurrFileLength += uLength;
				if (p_Fptr)
				{
					fwrite(pStr, uLength, 1, p_Fptr);
					SetProgress(m_CurrFileLength);
				}
			}
			break;
		case 8:	// Message Download
			FileTransfer(8, pStr, uLength);
			break;
		case 9:	// Options management
			Options(pStr, uLength);
			break;
		case 10:	// Pactor status
			if (!m_bPactorStatus)
			{
				m_bPactorStatus = true;
			}
			PactorStatus(pStr, uLength);
			break;
		case 11:	// User information
			if (m_pUserInfos)
				m_pUserInfos->SetInfoLine(pStr, uLength);
			break;
		}
		break;
		
	case FBB_CONSOLE :
		if (uLength > 3)
			OnNewConsoleMessage(pStr+3, uLength-3, 0);
		break;
		
	case FBB_MONITOR :
		if (uLength > 3)
		{
			uColor = (UINT) pBuf[5];
			OnNewMonitorMessage(pStr+3, uLength-3, uColor);
		}
		break;
		
	case FBB_CHANNEL :
		if (uLength > 3)
		{
			uColor = (UINT) pBuf[5];
			OnNewAllChannelsMessage(pStr[0], pStr[1], pStr+3, uLength-3, uColor);
		}
		break;
		
	case FBB_XFBBX :
		switch (*pStr)
		{
		case 0:	// Disconnected
			OnCloseConsole();
			break;

		case 1:	// Connected
			// Create dialog
			if (m_pConsoleDlg->GetSafeHwnd())
				m_pConsoleDlg->ShowWindow(SW_SHOW);
			break;
			
		case 2:	// Console Busy
			if (m_pConsoleDlg->GetSafeHwnd())
				m_pConsoleDlg->ShowWindow(SW_HIDE);
			MessageBox("Remote console is already connected", "fbbW",	MB_ICONEXCLAMATION);
			OnCloseConsole();
			break;
			
		case 3:	// Sx ...
			SendMsg();
			break;

		case 4:	// SR ...
			SendReply(atol(pStr+1));
			break;
		}								
		break;
		
	case FBB_LISTCNX:
		OnNewListcnxMessage(pStr);
		break;
			
	case FBB_NBCNX:
		OnNewNbcnxMessage(atoi(pStr));
		break;
			
	case FBB_MSGS:
		OnNewMsgsMessage(pStr);
		break;
			
	case FBB_STATUS:
		OnNewStatusMessage(pStr);
		break;
	}

	return 0;
}

//////////////////////////////////////////////////////////////////////////
// Put a new console message to the console windows
// wParam : color
// lParam : string

LRESULT CFbbWDlg::OnNewConsoleMessage(LPCSTR buf, int len, int color)
{
	if (m_pConsoleDlg->GetSafeHwnd())
		m_pConsoleDlg->AddString((LPSTR)buf, len, ConvertColor(color));
	else if (len == 27 ) // Bad Call/Password ...
		MessageBox((LPCTSTR) buf, "Message", MB_ICONEXCLAMATION);

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Put a new monitor message to the console windows
// wParam : color
// lParam : string

LRESULT CFbbWDlg::OnNewMonitorMessage(LPCSTR buf, int len, int color)
{
	if (m_pMonitorDlg->GetSafeHwnd())
	{
		m_pMonitorDlg->AddString(buf, len, ConvertColor(color));
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Update the connected user list
// wParam : channel number
// lParam : string

LRESULT CFbbWDlg::OnNewListcnxMessage(LPCSTR buf)
{
	CString str;
	int     nChannel;
	int		nStatus = ' ';
	CHAR    szCallsign[256];
	CHAR    szStart[256];
	CHAR    szTime[256];
	INT		nRetry;
	INT		nBuffer;
	CHAR	szCFwd[256];

	if (!isdigit(*buf))
		nStatus = *buf++;

	*szCallsign = '\0';
	*szCFwd = '\0';
	*szStart = '\0';
	*szTime = '\0';
	nRetry = 0;
	nBuffer = 0;

	int nArg = sscanf(buf, "%d %s %s %s %d %d %s", &nChannel, szCallsign,
		szStart, szTime, &nRetry, &nBuffer, szCFwd);

	if (nBuffer < 0)
		nBuffer = 0;

	if (nArg == 1)
		nStatus = '!';	// Delete

	if (nStatus == '<')
		strupr(szCFwd);	// Upcase ourgoing forwarding

	// New connected station update
	str.Format("%02d\t%s\t%s\t%s\t%d\t%d\t%s", 
			nChannel, szCallsign,
			szStart, szTime, nRetry, nBuffer, szCFwd);
	m_ConnectedList.Line(nChannel, nStatus, str.GetBuffer(256));

	// Update the connected user count
	UpdateData(FALSE);

	OnNewNbcnxMessage(m_ConnectedList.GetCount());

	// Update the OneChannelWindow if opened
	if( m_pOneChannelDlg->GetSafeHwnd() && m_pOneChannelDlg->nChan == nChannel)
	{
		char szTxt[80];
		if (*szCallsign == '\0')
			strcpy(szCallsign, "None");
		sprintf(szTxt, "  Channel %d : %s", nChannel, szCallsign);
		m_pOneChannelDlg->SetWindowText(szTxt);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Update the connected user count
// wParam : connected user count

LRESULT CFbbWDlg::OnNewNbcnxMessage(int nb)
{
	m_NbConnected = nb;

	if (m_bConnected)
	{
		char szNb[10];
		wsprintf(szNb, "%d", nb);
		StatusString(IDS_CONNECTEDSTATIONS, szNb);
	}
	else
		StatusString(IDS_NOTCONNECTED);

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Update the MESSAGE edit box
// wParam : 0
// lParam : string to put in the edit box

LRESULT CFbbWDlg::OnNewMsgsMessage(LPCSTR buf)
{
	int nbPriv, nbHeld, nbTotal;

	sscanf(buf, "%d %d %d", &nbPriv, &nbHeld, &nbTotal);

	wsprintf(m_sMessages.szText, "Total msgs :\t%d",  nbTotal);
	wsprintf(m_sHeldMsgs.szText, "Held msgs :\t%d", nbHeld);
	m_sHeldMsgs.color = (nbHeld) ? RGB(255,0,0) : RGB(0,0,0);
	wsprintf(m_sPrivMsgs.szText, "Priv msgs :\t%d", nbPriv);
	m_sPrivMsgs.color = (nbPriv) ? RGB(255,0,0) : RGB(0,0,0);

	ShowMessages(SW_SHOW);
	UpdateData(FALSE);

	return 0;
}


///////////////////////////////////////////////////////////////////////////
// Update the STATUS edit box
// wParam : 0
// lParam : string to put in the edit box

LRESULT CFbbWDlg::OnNewStatusMessage(LPCSTR buf)
{
	int nMemUsed, nMemAvail, nDisk1, nDisk2;

	char szUsed[80];
	char szAvail[80];
	char szFree[80];

	sscanf(buf, "%d %d %d %d", &nMemUsed, &nMemAvail, 
		&nDisk1, &nDisk2);

	wsprintf(m_sUsedMem.szText, "Used mem :\t%s", DisplayMemory(nMemUsed, 0, szUsed));
	wsprintf(m_sDataMem.szText, "Data mem :\t%s", DisplayMemory(nMemAvail, 1, szAvail));
	wsprintf(m_sDiskFree.szText, "Disk free :\t%s", DisplayMemory(nDisk1, 1, szFree));
	m_sHeldMsgs.color = (nDisk1 < 2000) ? RGB(255,0,0) : RGB(0,0,0);

	ShowStatus(SW_SHOW);
	UpdateData(FALSE);

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Put a new AllChannels to the AllChannels windows
// wParam : color
// lParam : string

LRESULT CFbbWDlg::OnNewAllChannelsMessage(int nChan, int nType, LPCSTR buf, int len, int color)
{
	if( m_pAllChannelsDlg->GetSafeHwnd() )
	{
		m_pAllChannelsDlg->AddString(buf, len, ConvertColor(color));
	}

	if( m_pOneChannelDlg->GetSafeHwnd() && m_pOneChannelDlg->nChan == nChan)
	{
		if ((nType & 2) == 0)	// Only Connection/disconnection headers
		{
			if (nChan != m_nPrevChan)
			{
				m_nPrevChan = nChan;
				char lbuf[80];
				wsprintf(lbuf, "[ -- Channel changed to %d -- ]\n", nChan);
				m_pOneChannelDlg->AddString(lbuf, strlen(lbuf), ConvertColor(2));
			}
			m_pOneChannelDlg->AddString(buf, len, ConvertColor(color));
		}
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Send a string to the server

void CFbbWDlg::SendToServer(LPCTSTR lpszText)
{
	if( g_hSocket != -1 )
		send(g_hSocket, lpszText, strlen(lpszText), 0);
}

////////////////////////////////////////////////////////////////////////////
// Convert uColorIndex to a RGB COLORREF value

COLORREF CFbbWDlg::ConvertColor(UINT uColorIndex)
{
	switch(uColorIndex)
	{
	case 0 :	// Data received - Blue
		return RGB(0,0,128);
	case 1 :	// Data sent - Red
		return RGB(128,0,0);
	case 2 :	// Channel info - Green
		return RGB(0,128,0);
	case 3 :	// Monitor header - Green
		return RGB(0,128,0);
	case 4 :	// Monitor data - LightBlue
		return RGB(0,0,255);
	case 5 :	// Unproto request - Cyan
		return RGB(0,128,128);
	case 6 :	// Blue
		return RGB(255,255,0);
	case 7 :	// Black
		return RGB(0,0,0);
	case 9 :	// Channel status - Brown
		return RGB(128,128,0);
	default :	// White
#ifdef _DEBUG
		TRACE("Color unknown : %d\n", uColorIndex);
		return RGB(255,255,255);
#else
		return RGB(255,255,255);
#endif
	}
}

///////////////////////////////////////////////////////////////////////////
// Close the console if it's open

LRESULT CFbbWDlg::OnCloseConsole(WPARAM wParam /*=0*/, LPARAM lParam /*=0*/)
{
	if( m_pConsoleDlg->GetSafeHwnd() && m_nMask & FBB_CONSOLE )
		OnConsole();

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Close the monitoring window if it's open

LRESULT CFbbWDlg::OnCloseMonitoring(WPARAM wParam /*=0*/, LPARAM lParam /*=0*/)
{
	if( m_pMonitorDlg->GetSafeHwnd() && m_nMask & FBB_MONITOR )
		OnMonitoring();

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Close the monitoring window if it's open

LRESULT CFbbWDlg::OnCloseAllChannels(WPARAM wParam /*=0*/, LPARAM lParam /*=0*/)
{
	if( m_pAllChannelsDlg->GetSafeHwnd() && m_nMask & FBB_CHANNEL )
		OnAllChannels();

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Close the OneChannel window if it's open

LRESULT CFbbWDlg::OnCloseOneChannel(WPARAM wParam /*=0*/, LPARAM lParam /*=0*/)
{
	if( m_pOneChannelDlg->GetSafeHwnd() && m_nMask & FBB_CHANNEL )
		OnOneChannel();

	return 0;
}


//////////////////////////////////////////////////////////////////////////////
// This is the Message check button function

void CFbbWDlg::OnMessageCheck() 
{
	CButton * pButton = (CButton*) GetDlgItem(IDC_MESSAGECHECK);
	
	if( pButton->GetCheck() )
	{
		m_nMask |= FBB_MSGS;
		m_pApp->WriteIni("Message", "1");
	}
	else
	{
		m_nMask &= ~FBB_MSGS;
		m_pApp->WriteIni("Message", "0");
		ClearMessages();
		ShowMessages(SW_HIDE);
	}

	SendMaskToServer();
	UpdateData(FALSE);
}

//////////////////////////////////////////////////////////////////////////////
// This is the Message check button function

void CFbbWDlg::OnStatusCheck() 
{
	CButton * pButton = (CButton*) GetDlgItem(IDC_STATUSCHECK);
	
	if( pButton->GetCheck() )
	{
		m_nMask |= FBB_STATUS;
		m_pApp->WriteIni("Status", "1");
	}
	else
	{
		m_nMask &= ~FBB_STATUS;
		m_pApp->WriteIni("Status", "0");
		ClearStatus();
		ShowStatus(SW_HIDE);
	}

	SendMaskToServer();	
	UpdateData(FALSE);
}

////////////////////////////////////////////////////////////////////////////
// Send the mask to the server

void CFbbWDlg::SendMaskToServer()
{
	if( g_hSocket != -1 )
	{
		CHAR szBuffer[4];
		szBuffer[0] = 0;
		szBuffer[1] = 0;
		szBuffer[2] = (CHAR) m_nMask;
		send(g_hSocket, szBuffer, 3, 0);
	}
}

void CFbbWDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	// Save the dialog position into the ini file
	CRect rect;
	GetWindowRect(&rect);
	char strPosition[80];
	wsprintf(strPosition, "%04d %04d", rect.left, rect.top);
	m_pApp->WriteIni("Settings", "Position", strPosition);
}

void CFbbWDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
//	CDialog::OnClose();
	((CMainFrame*) AfxGetMainWnd())->OnExit();
}

void CFbbWDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
}

void CFbbWDlg::OnOK() 
{
	// TODO: Add extra validation here
}

void CFbbWDlg::OnExit() 
{
	((CMainFrame*) AfxGetMainWnd())->OnExit();
}


void CFbbWDlg::OnFilelist() 
{
	m_pListFiles = new CListFiles("", this);
	if (m_pListFiles)
	{
		m_pListFiles->DoModal();
		delete m_pListFiles;
	}
	m_pListFiles = NULL;
}


void CFbbWDlg::RequestService(int nNumService, char *szRequest)
{
	int nLen = strlen(szRequest);

	if( g_hSocket == -1 )
		return;

	CHAR *szBuffer = new CHAR[nLen+4];

	szBuffer[0] = 0;
	szBuffer[1] = nNumService;
	szBuffer[2] = nLen & 0xff;
	szBuffer[3] = nLen >> 8;
	memcpy(szBuffer+4, szRequest, nLen);
	send(g_hSocket, szBuffer, nLen+4, 0);

	delete [nLen+4] szBuffer;
}

void CFbbWDlg::RequestDirectory(char *szPath)
{
	RequestService(1, szPath);
}

void CFbbWDlg::RequestFile(char *szFileName)
{
	strcpy(m_RemoteFileName, szFileName);
	RequestService(2, szFileName);
}

void CFbbWDlg::RequestOptions()
{
	RequestService(9, "GET");
}

#include <io.h>
#include <fcntl.h>
void CFbbWDlg::SendFile(char *szFileName)
{
	if( g_hSocket != -1 )
	{
		int fd = open(szFileName, O_RDONLY|O_BINARY);
		if (fd == -1)
			return;

		RequestService(3, m_RemoteFileName);

		CHAR szBuffer[1500];
		int nNb;

		do 
		{
			nNb = read(fd, szBuffer+4, 1000);

			szBuffer[0] = 0;
			szBuffer[1] = 3;
			szBuffer[2] = nNb & 0xff;
			szBuffer[3] = nNb >> 8;
			send(g_hSocket, szBuffer, nNb+4, 0);
		} while (nNb > 0);

		close(fd);
	}
	unlink(szFileName);
}

void CFbbWDlg::SendMsgData(char *szFileName, BOOL bAbort)
{
	if( g_hSocket != -1 )
	{
		CHAR szBuffer[1500];
		
		if (bAbort)
		{
			strcpy(szBuffer, "\n/ABORT\n");
			send(g_hSocket, szBuffer, strlen(szBuffer), 0);
		}
		
		else
		{
			int fd = open(szFileName, O_RDONLY|O_BINARY);
			if (fd == -1)
				return;
			
			int nNb;
			int pos;
			int idx;
			
			do 
			{
				nNb = read(fd, szBuffer, 1000);
				if (nNb > 0)
				{
					for (idx = 0, pos = 0 ; pos < nNb ; pos++)
					{
						if (szBuffer[pos] != '\r')
							szBuffer[idx++] = szBuffer[pos];
					}
					if (nNb != 1000)
					{
						szBuffer[idx++] = '\032';
						szBuffer[idx++] = '\n';
					}
					if (!m_bAnsi)
						AnsiToOemBuff(szBuffer, szBuffer, idx);
					send(g_hSocket, szBuffer, idx, 0);
				}
			} while (nNb > 0);
			
			close(fd);
		}
	}

	unlink(szFileName);	// **** A REMETTRE !!! ***
}

void CFbbWDlg::OnForward() 
{
	if (m_pForward == NULL)
		RequestService(4, "LIST");
}

char * CFbbWDlg::DisplayMemory(int nVal, int nUnit, char *szStr)
{

	char cVal[4] = { ' ', 'K', 'M', 'G' };

	while (nVal >= (10 * 1024))
	{
		nVal /= 1024;
		nUnit++;
	}
	sprintf(szStr, "%d %cB", nVal, cVal[nUnit]);

	return szStr;
}

void CFbbWDlg::OnDblclkConnectedlist() 
{
	// TODO: Add your control notification handler code here
	OnOneChannel();
}

void CFbbWDlg::ChangeChannelMask()
{
	int nMask = m_nMask;

	if ((m_pAllChannelsDlg->GetSafeHwnd() && m_pAllChannelsDlg->IsWindowVisible()) || 
			(m_pOneChannelDlg->GetSafeHwnd() && m_pOneChannelDlg->IsWindowVisible()))
		nMask |= FBB_CHANNEL;
	else
		nMask &= ~FBB_CHANNEL;

	if (nMask != m_nMask)
	{
		m_nMask = nMask;
		SendMaskToServer();
	}
}

BOOL CFbbWDlg::IsOpened(CWnd *pWnd)
{
	return (pWnd && pWnd->GetSafeHwnd() && pWnd->IsWindowVisible());
}

void CFbbWDlg::OpenOneChannel()
{
	if (!m_pOneChannelDlg->GetSafeHwnd())
		return;

	int nChan;
	char szCall[80];
	int nPos = m_ConnectedList.GetCurSel();
	if (m_ConnectedList.GetItemInfo(nPos, &nChan, szCall) != LB_ERR)
	{
		m_pOneChannelDlg->nChan = nChan;
		char szTxt[80];
		if (*szCall == '\0')
			strcpy(szCall, "None");
		sprintf(szTxt, "  Channel %d : %s", nChan, szCall);
		m_pOneChannelDlg->SetWindowText(szTxt);
	}
}

void CFbbWDlg::OnSelchangeConnectedlist() 
{
	if (m_pOneChannelDlg->GetSafeHwnd())
		OpenOneChannel();
}

void CFbbWDlg::OnUpdateOnechannel(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_bConnected && (IsOpened(m_pOneChannelDlg) || (m_ConnectedList.GetCurSel() != LB_ERR)));
}


void CFbbWDlg::OnUpdateMonitoring(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_bConnected);
}

void CFbbWDlg::OnUpdateConsole(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_bConnected);
}

void CFbbWDlg::OnUpdateAllchannels(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_bConnected);
}

void CFbbWDlg::UpdateControls()
{
	CMenu* pMenu = GetMenu();

	if (m_bConnected)
	{
		// Connect ...
		pMenu->EnableMenuItem(IDM_DISCONNECT,  MF_ENABLED);
		pMenu->EnableMenuItem(IDM_CONSOLE,     MF_ENABLED);
		pMenu->EnableMenuItem(IDM_MONITORING,  MF_ENABLED);
		pMenu->EnableMenuItem(IDM_ALLCHANNELS, MF_ENABLED);

		StatusString(IDS_INITIALISATION);
		CString cStr;
		cStr.LoadString(IDS_STATUSPROGRESS);
		m_wndStatusBar.SetPaneText(1, cStr);
	}
	else
	{
		// Update the dialog title
		SetWindowText("  fbbW - not connected");
		
		ClearStatus();
		ShowStatus(SW_HIDE);

		ClearMessages();
		ShowMessages(SW_HIDE);

		// Close dialog boxes, if any
		if( m_pConsoleDlg->GetSafeHwnd() )
			m_pConsoleDlg->ShowWindow(SW_HIDE);
		if( m_pMonitorDlg->GetSafeHwnd() )
			m_pMonitorDlg->ShowWindow(SW_HIDE);
		if( m_pAllChannelsDlg->GetSafeHwnd() )
			m_pAllChannelsDlg->ShowWindow(SW_HIDE);
		if( m_pOneChannelDlg->GetSafeHwnd() )
			m_pOneChannelDlg->ShowWindow(SW_HIDE);
		
		pMenu->EnableMenuItem(IDM_DISCONNECT,  MF_GRAYED);
		pMenu->EnableMenuItem(IDM_CONSOLE,     MF_GRAYED);
		pMenu->EnableMenuItem(IDM_MONITORING,  MF_GRAYED);
		pMenu->EnableMenuItem(IDM_ALLCHANNELS, MF_GRAYED);

		pMenu->CheckMenuItem(IDM_REMOTE0, MF_BYCOMMAND | MF_UNCHECKED);
		pMenu->CheckMenuItem(IDM_REMOTE1, MF_BYCOMMAND | MF_UNCHECKED);
		pMenu->CheckMenuItem(IDM_REMOTE2, MF_BYCOMMAND | MF_UNCHECKED);
		pMenu->CheckMenuItem(IDM_REMOTE3, MF_BYCOMMAND | MF_UNCHECKED);
		
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_GATEWAY,        TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_FILELIST,       TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_FORWARD,        TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_USERINFORMATION,TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITUSER,       TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_DISC,           TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_IMMEDIATEDISC,  TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_TALK,           TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_LISTCONNECTIONS,TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITMESSAGE,    TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_EDITUSER,       TRUE);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PRINT,          TRUE);
		
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_CONSOLE, FALSE);
		pMenu->CheckMenuItem(IDM_CONSOLE, MF_BYCOMMAND | MF_UNCHECKED);
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_MONITORING, FALSE);
		pMenu->CheckMenuItem(IDM_MONITORING, MF_BYCOMMAND | MF_UNCHECKED);
		m_wndToolBar.GetToolBarCtrl().PressButton(IDM_ALLCHANNELS, FALSE);
		pMenu->CheckMenuItem(IDM_ALLCHANNELS, MF_BYCOMMAND | MF_UNCHECKED);

		((CButton*) GetDlgItem(IDC_STATUSCHECK))->SetCheck(0);
		ShowStatus(SW_HIDE);

		((CButton*) GetDlgItem(IDC_MESSAGECHECK))->SetCheck(0);
		ShowMessages(SW_HIDE);

		m_wndStatusBar.SetPaneText(1, "");

		DestroyOptionsMenu();

		OnNewNbcnxMessage(0);
	}
	
	UpdateData(FALSE);
}


void CFbbWDlg::RequestDisconnect(BOOL bImmediate)
{
	int nChan;
	char szCall[80];
	int nPos = m_ConnectedList.GetCurSel();
	if (nPos == LB_ERR)
		return;
	
	if (m_ConnectedList.GetItemInfo(nPos, &nChan, szCall) == LB_ERR)
		return;
	
	if( g_hSocket == -1 )
		return;

	CString sText;
	sText.Format(IDS_DISCUSER, szCall);
	
	if (MessageBox(sText, "Disconnect", MB_OKCANCEL|MB_ICONEXCLAMATION) == IDCANCEL)
		return;

	char szRequest[80];
	sprintf(szRequest, "%02d %s %d", nChan, szCall, bImmediate ? 1 : 0);
	RequestService(5, szRequest);
}

void CFbbWDlg::OnDisc() 
{
	RequestDisconnect(FALSE);
}

void CFbbWDlg::OnUpdateDisc(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bConnected && (m_ConnectedList.GetCurSel() != LB_ERR));
}

void CFbbWDlg::OnImmediatedisc() 
{
	RequestDisconnect(TRUE);
}

void CFbbWDlg::OnUpdateImmediatedisc(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bConnected && (m_ConnectedList.GetCurSel() != LB_ERR));
}

void CFbbWDlg::UserInformation(BOOL bForce=false)
{
	char str[80];

	if (!bForce && m_pUserInfos && m_pUserInfos->GetSafeHwnd() && m_pUserInfos->IsWindowVisible())
	{
		m_pUserInfos->ShowWindow(SW_HIDE);
		wsprintf(str, "INFO -1");
		RequestService(11, str);
		m_nChan = -1;
	}
	else
	{
		if (m_pUserInfos == NULL)
		{
			m_pUserInfos = new CUserInfos;
			m_pUserInfos->Create(IDD_USERINFORMATION);
		}
		m_pUserInfos->ShowWindow(SW_SHOW);
		m_pUserInfos->SetFocus();

		int nChan;
		char szCall[80];
		int nPos = m_ConnectedList.GetCurSel();
		if (m_ConnectedList.GetItemInfo(nPos, &nChan, szCall) != LB_ERR && nChan != m_nChan)
		{
			wsprintf(str, "INFO %d", nChan);
			RequestService(11, str);
			m_nChan = nChan;
		}
	}
}

void CFbbWDlg::OnUserinformation() 
{
	UserInformation();
}

void CFbbWDlg::OnUpdateUserinformation(CCmdUI* pCmdUI) 
{
	int nPos = m_ConnectedList.GetCurSel();
	BOOL bActive = (m_bConnected && (nPos != LB_ERR));

	pCmdUI->Enable(bActive);
	pCmdUI->SetCheck(m_pUserInfos && m_pUserInfos->GetSafeHwnd() && m_pUserInfos->IsWindowVisible());
}

/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg::OnSetMessageString
//      OnSetMessageString updates the status bar text.
//
//      This code is based on CFrameWnd::OnSetMessageString.  We assume
//      a string ID is always passed in wParam.

LRESULT CFbbWDlg::OnSetMessageString(WPARAM wParam, LPARAM lParam)
{
	UINT    nIDMsg = (UINT)wParam;
	CString strMsg;

	if (nIDMsg)
	{

		if (nIDMsg == AFX_IDS_IDLEMESSAGE)
		{
			if (m_pStatusInfo)
			{
				delete(m_pStatusInfo);
				m_pStatusInfo = NULL;
			}
		}
		else
		{
			strMsg.LoadString(nIDMsg);
			CString Str = " " + strMsg.SpanExcluding("\n");
			if (m_pStatusInfo == NULL)
			{
				RECT rc;
				m_wndStatusBar.GetItemRect (0, &rc);
				m_pStatusInfo = new CStatic;
				m_pStatusInfo->Create(Str, WS_CHILD | WS_VISIBLE, rc, &m_wndStatusBar, 2);
				m_pStatusInfo->SetFont(m_wndStatusBar.GetFont());
			}
			else
				m_pStatusInfo->SetWindowText(Str);
		}
	}

	UINT nIDLast     = m_nIDLastMessage;
	m_nIDLastMessage = nIDMsg;
	m_nIDTracking    = nIDMsg;
	return nIDLast;

}

/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg::OnPopMessageString
//      Resets status bar message string.  This code is based on
//      CFrameWnd::OnPopMessageString

LRESULT CFbbWDlg::OnPopMessageString(WPARAM wParam, LPARAM lParam)
{
	if (m_nFlags & WF_NOPOPMSG)
		return 0;

	return SendMessage(WM_SETMESSAGESTRING, wParam, lParam);
}


/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg::OnEnterIdle
//      OnEnterIdle updates the status bar when there's nothing better to do.
//      This code is based on CFrameWnd::OnEnterIdle.

void CFbbWDlg::OnEnterIdle(UINT nWhy, CWnd *pWho)
{
	if (nWhy != MSGF_MENU || m_nIDTracking == m_nIDLastMessage)
		return;

	OnSetMessageString(m_nIDTracking);
	ASSERT(m_nIDTracking == m_nIDLastMessage);
}


/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg::OnMenuSelect
//      OnMenuSelect updates the status bar message, based on the state
//      of the dialog menu.
//
//      This code is based on CFrameWnd::OnMenuSelect.  We assume the
//      application does not support context sensitive help.

void CFbbWDlg::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu)
{
	// set the tracking state
	if (nFlags == 0xFFFF)
	{
		// cancel menu operation (go back to idle now)
		m_nIDTracking = AFX_IDS_IDLEMESSAGE;
		OnSetMessageString(m_nIDTracking);  // set string now
		ASSERT(m_nIDTracking == m_nIDLastMessage);
	}
	else if (nItemID == 0 ||
			 nFlags & (MF_SEPARATOR|MF_POPUP|MF_MENUBREAK|MF_MENUBARBREAK))
	{
		// nothing should be displayed
		m_nIDTracking = 0;
	}
	else if (nItemID >= 0xF000 && nItemID < 0xF1F0)
	{
		// special string table entries for system commands
		m_nIDTracking = ID_COMMAND_FROM_SC(nItemID);
		ASSERT(m_nIDTracking >= AFX_IDS_SCFIRST &&
			   m_nIDTracking < AFX_IDS_SCFIRST + 31);
	}
	else
	{
		// track on idle
		m_nIDTracking = nItemID;
	}
}

BOOL CFbbWDlg::StartProgress(int nMax)
{
	if (m_pWndProgress)
		return FALSE;

	RECT rc;
	m_wndStatusBar.GetItemRect (1, &rc);
	m_pWndProgress = new CProgressCtrl;
	m_pWndProgress->Create(WS_CHILD | WS_VISIBLE, rc, &m_wndStatusBar, 1);
	m_pWndProgress->SetRange(0, nMax);
	return TRUE;
}

BOOL CFbbWDlg::StopProgress()
{
	if (!m_pWndProgress)
		return FALSE;
	delete m_pWndProgress;
	m_pWndProgress = NULL;
	return TRUE;
}

BOOL CFbbWDlg::SetProgress(int nVal)
{
	if (!m_pWndProgress)
		return FALSE;
	m_pWndProgress->SetPos(nVal);
	return TRUE;
}

void CFbbWDlg::StatusString(UINT nID, CString cStr)
{
	CString Str;
	Str.Format(nID, cStr);
	m_wndStatusBar.SetPaneText(0, Str);
}


void CFbbWDlg::OnEditmessage() 
{
	RequestService(7, "LIST");
}

void CFbbWDlg::OnEdituser() 
{
	RequestService(6, "LIST");
}

void CFbbWDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CString *strHostName = &m_pApp->m_strHostName;

	CDialog::OnTimer(nIDEvent);
	
	switch(nIDEvent)
	{

	case START_TIMER:
				
		KillTimer(START_TIMER);
		if (!strHostName->IsEmpty())
		{
			for (int nRemote = 0; nRemote < NB_REMOTE; nRemote++)
			{
				LoadRemoteConfig(nRemote);
				if (strHostName->CompareNoCase(m_RemoteConfig.szName) == 0)
				{	
					OnRemote(IDM_REMOTE0 + nRemote);
					break;
				}
			}
			if (nRemote == NB_REMOTE)
			{
				CString str;
				str.Format("Cannot find %s in configuration", *strHostName);
				MessageBox(str, "Network", MB_ICONEXCLAMATION);
			}
			strHostName->Empty();
		}
		else
		{
			for (int nRemote = 0; nRemote < NB_REMOTE; nRemote++)
			{
				LoadRemoteConfig(nRemote);
				if (m_RemoteConfig.bAutoConnect)
				{	
					OnRemote(IDM_REMOTE0 + nRemote);
					break;
				}
			}
		}
		break;

	case CONNECT_TIMER:
		// Connect again ...
		if (--m_nTimerDelay == 0)
			OnRemote(m_nActiveRemoteID);
		else
		{
			CString str;
			str.Format(IDS_CONNECTAGAIN, m_RemoteConfig.szHostName, m_nTimerDelay);
			StatusString(IDS_CONNECTIONDELAY, str);
		}
	}
}

///////////////////////////////////////////////////////////////////////////
// Receive the result of the GetHostByName

LRESULT CFbbWDlg::OnGetHostByName(WPARAM wParam /*=0*/, LPARAM lParam /*=0*/)
{
	if (WSAGETASYNCERROR(lParam) != 0)
	{
		SockErrMessageBox("Error retrieving host information", 
						  WSAGETASYNCERROR(lParam));
		StatusString(IDS_NOTCONNECTED);
		return (0);
	}

	int buflen=WSAGETASYNCBUFLEN(lParam);

	HOSTENT     *phe = (HOSTENT *)m_HostBuffer;

	if (phe->h_length && phe->h_addr)
		memcpy((char *) &m_SockAddrIn.sin_addr, phe->h_addr, phe->h_length);
	doConnect(&m_SockAddrIn);
	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Receive a socket notification (connection)

LRESULT CFbbWDlg::OnSocketNotification(WPARAM wParam /*=0*/, LPARAM lParam /*=0*/)
{
	UINT   wserr = WSAGETSELECTERROR(lParam);
	SOCKET hSock = (SOCKET) wParam;
	
	switch (WSAGETSELECTEVENT(lParam)) {
	case FD_READ:
		if (!m_bConnected)
		{
			CHAR szBuffer[300];
			CHAR szKey[256];
			unsigned long val = 0;
			
			WSAAsyncSelect(hSock, GetSafeHwnd(), 0, 0);
			ioctlsocket(hSock, FIONBIO , &val);

			int nb = recv(g_hSocket, szBuffer, 256, 0);
			if( nb <= 0 )
			{
				CloseConnection();
				MessageBox("Connection closed", "Network", MB_ICONEXCLAMATION);
				m_nTimerDelay = 60;
				SetTimer(CONNECT_TIMER, 1000, NULL);
				return 0;
			}
			

			szBuffer[nb] = '\0';
			sscanf(szBuffer, "%s", szKey);
			
			StatusString(IDS_AUTHENTICATION);
			
			// Create the Thread function
			ASSERT(g_pThread == NULL);
			g_pThread = AfxBeginThread(ThreadFunc, GetSafeHwnd());
			
			// Send password
			MakeMD5Key(szKey, m_RemoteConfig.szPassword, szBuffer);
			strcat(szBuffer, "\n");
			send(g_hSocket, szBuffer, strlen(szBuffer), 0);
			
			// Update menu
			GetMenu()->CheckMenuItem(m_nActiveRemoteID, MF_BYCOMMAND | MF_CHECKED);
			
			SetCursor(LoadCursor(NULL, IDC_ARROW));  
			
			if (m_pApp->ReadIni("State_0"))
				OnAllChannels();
			
			if (m_pApp->ReadIni("State_m"))
				OnMonitoring();
			
			m_bConnected = TRUE;
			
			UpdateControls();
		}
		
		break;
	case FD_CONNECT:
		if (wserr != 0)
		{
			// Error !
			
			// Wait 1 minute and try again
			CloseConnection();
			StatusString(IDS_CONNECTIONERROR, m_RemoteConfig.szHostName);
			m_nTimerDelay = 60;
			SetTimer(CONNECT_TIMER, 1000, NULL);
		}
		else
		{
			// Connection !
			Connected(hSock);
		}
		
		break;
	}
	
	return 0;
}

void CFbbWDlg::Connected(SOCKET hSock)
{
	g_hSocket = hSock;
	
	// Update the dialog title
	CString strTitle;
	strTitle.Format("  fbbW - %s", m_RemoteConfig.szName);
	SetWindowText(strTitle);
	
	int nVal;
	
	// STATUS and MESSAGE check box settings
	nVal = m_pApp->ReadIni("Status");
	((CButton*) GetDlgItem(IDC_STATUSCHECK))->SetCheck(nVal);
	if (nVal)
		m_nMask |= FBB_STATUS;
	
	nVal = m_pApp->ReadIni("Message");
	((CButton*) GetDlgItem(IDC_MESSAGECHECK))->SetCheck(nVal);
	if (nVal)
		m_nMask |= FBB_MSGS;
	
	StatusString(IDS_SENDINGOPTIONS);
	
	// Send profile
	char szBuffer[256];
	sprintf(szBuffer, "%d %d %s\n", m_nMask, 0,
		m_RemoteConfig.szCallSign);
	send(g_hSocket, szBuffer, strlen(szBuffer), 0);
}

void CFbbWDlg::SendReply(long nMsg)
{
	char szMsg[80];

	// Load the message nMsg in the editor
	sprintf(szMsg, "MSG %ld", nMsg);
	m_bMessage = true;
	RequestService(8, szMsg);
}

void CFbbWDlg::SendMsg()
{
	FILE *p_Fptr;

	unlink("fbb_message.txt");
	strcpy(m_szFileName, "fbb_message.txt");
	p_Fptr = fopen(m_szFileName, "w");
	fclose(p_Fptr);
	m_bMessage = true;
	m_pApp->RunEditor(m_szFileName);
}

void CFbbWDlg::PactorStatus(char *pStr, int uLength)
{
	int nPort, nPactor;

	sscanf(pStr, "%d %d", &nPort, &nPactor);

	if (m_PactorMenu == 0)
	{
		m_nPactorPort = nPort;
		CMenu * pMenu = GetMenu();
		CMenu *menu = new CMenu;
		VERIFY(menu->LoadMenu(IDR_PACTOR));
		CMenu* pPopup = menu->GetSubMenu(0);
		m_PactorMenu = pPopup->GetSafeHmenu();
		BOOL bRes = pMenu->InsertMenu(5, MF_BYPOSITION|MF_POPUP, (UINT)m_PactorMenu, "&Pactor");
		DrawMenuBar();
	}

	if ((nPactor & 1) ||(nPactor & 4))	// Online !
	{
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORSCAN, true);
		::CheckMenuItem (m_PactorMenu, IDM_PACTORSCAN, MF_UNCHECKED);
		::EnableMenuItem(m_PactorMenu, IDM_PACTORSCAN, MF_GRAYED);
		::EnableMenuItem(m_PactorMenu, IDM_PACTORIRS, MF_ENABLED);
		::EnableMenuItem(m_PactorMenu, IDM_PACTORISS, MF_ENABLED);
		if (nPactor & 4)
		{
			m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORISS,	 false);
			m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORIRS,  true);
			::CheckMenuItem(m_PactorMenu, IDM_PACTORIRS, MF_UNCHECKED);
			::CheckMenuItem(m_PactorMenu, IDM_PACTORISS, MF_CHECKED);
		}
		else
		{
			m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORISS,	 true);
			m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORIRS,  false);
			::CheckMenuItem(m_PactorMenu, IDM_PACTORIRS, MF_CHECKED);
			::CheckMenuItem(m_PactorMenu, IDM_PACTORISS, MF_UNCHECKED);
		}
	}
	else
	{
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORSCAN, false);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORIRS,  true);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORISS,  true);
		::EnableMenuItem(m_PactorMenu, IDM_PACTORSCAN, MF_ENABLED);
		::CheckMenuItem (m_PactorMenu, IDM_PACTORSCAN, (nPactor & 2) ? MF_CHECKED : MF_UNCHECKED);
		::CheckMenuItem (m_PactorMenu, IDM_PACTORIRS, MF_UNCHECKED);
		::CheckMenuItem (m_PactorMenu, IDM_PACTORISS, MF_UNCHECKED);
		::EnableMenuItem(m_PactorMenu, IDM_PACTORIRS, MF_GRAYED);
		::EnableMenuItem(m_PactorMenu, IDM_PACTORISS, MF_GRAYED);
	}
	m_nPactor = nPactor;
}

void CFbbWDlg::Options(char *pStr, int uLength)
{
	if (m_OptionMenu == 0)
			return;

	char Ident;
	char *ptr;
	int nVal;
	int nPos;
	UINT flag;
	char Text[80];
	MENUITEMINFO MenuItem;

	MenuItem.cbSize = sizeof(MENUITEMINFO);
	MenuItem.fMask  = MIIM_DATA;

	ptr = strtok(pStr, "\n");
	ptr = strtok(NULL, "\n");
	while (ptr)
	{
		sscanf(ptr, "%c %d %[^\n]", &Ident, &nVal, Text);
		nPos = Ident - 'A';
		if (GetMenuState(m_OptionMenu, IDM_OPTIONS + nPos, MF_BYCOMMAND) == 0xffffffff)
		{
			AppendMenu(m_OptionMenu, MF_STRING | MF_ENABLED, IDM_OPTIONS + nPos, Text);
			MenuItem.dwItemData = Ident;
			SetMenuItemInfo(m_OptionMenu, IDM_OPTIONS + nPos, false, &MenuItem);
		}
		flag = (nVal) ? MF_CHECKED : MF_UNCHECKED;
		CheckMenuItem(m_OptionMenu, IDM_OPTIONS + nPos, MF_BYCOMMAND | flag);
		ptr = strtok(NULL, "\n");
	}
}

void CFbbWDlg::CreateOptionsMenu()
{
	if (m_OptionMenu)
		return;

	CMenu *pMenu = GetMenu();
	
	m_OptionMenu = pMenu->GetSubMenu(4)->GetSafeHmenu();

	RequestOptions();
}

void CFbbWDlg::DestroyOptionsMenu()
{
	CMenu *pMenu = GetMenu();
	CMenu *pPopup;

	if (m_OptionMenu == 0)
			return;

	pPopup = pMenu->GetSubMenu(4);

	for (int nPos = 0 ; nPos <= 26 ; nPos ++)
	{
		if(GetMenuState(m_OptionMenu, IDM_OPTIONS + nPos, MF_BYCOMMAND) != 0xffffffff)
			DeleteMenu(m_OptionMenu, IDM_OPTIONS + nPos, MF_BYCOMMAND);
	}

	m_OptionMenu = 0;
}

void CFbbWDlg::OnOptions(UINT nID)
{
	// TODO: Add your command handler code here
	UINT state = GetMenuState(m_OptionMenu, nID, MF_BYCOMMAND);

	MENUITEMINFO MenuItem;

	MenuItem.cbSize = sizeof(MENUITEMINFO);
	MenuItem.fMask  = MIIM_DATA;
	GetMenuItemInfo(m_OptionMenu, nID, false, &MenuItem);

	char str[80];
	wsprintf(str, "SET %c %d", (char)MenuItem.dwItemData, (state & MF_CHECKED) ? 0 : 1);
	RequestService(9, str);
}

void CFbbWDlg::ShowStatus(int nCmd)
{
	m_StatusBox.ShowWindow(nCmd);
	::RedrawWindow(::GetDlgItem(m_hWnd, IDC_DISK_FREE), NULL, NULL, RDW_INVALIDATE);
	::RedrawWindow(::GetDlgItem(m_hWnd, IDC_DATA_MEM),  NULL, NULL, RDW_INVALIDATE);
	::RedrawWindow(::GetDlgItem(m_hWnd, IDC_USED_MEM),  NULL, NULL, RDW_INVALIDATE);
	if (nCmd == SW_HIDE)
	{
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORSCAN, true);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORIRS,  true);
		m_wndToolBar.GetToolBarCtrl().HideButton(IDM_PACTORISS,  true);
		if (m_PactorMenu)
		{
			CMenu * pMenu = GetMenu();
			pMenu->DeleteMenu(5, MF_BYPOSITION);
			m_PactorMenu = 0;
			DrawMenuBar();
		}
	}
}

void CFbbWDlg::ShowMessages(int nCmd)
{
	m_MessageBox.ShowWindow(nCmd);
	::RedrawWindow(::GetDlgItem(m_hWnd, IDC_MESSAGES),  NULL, NULL, RDW_INVALIDATE);
	::RedrawWindow(::GetDlgItem(m_hWnd, IDC_PRIV_MSGS), NULL, NULL, RDW_INVALIDATE);
	::RedrawWindow(::GetDlgItem(m_hWnd, IDC_HELD_MSGS), NULL, NULL, RDW_INVALIDATE);
}

void CFbbWDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDI) 
{
	// TODO: Add your message handler code here and/or call default
	switch(nIDCtl)
	{
	case IDC_USED_MEM:
	case IDC_DATA_MEM:
	case IDC_DISK_FREE:
	case IDC_MESSAGES:
	case IDC_PRIV_MSGS:
	case IDC_HELD_MSGS:
		DrawLine(nIDCtl, lpDI);
		break;
	default:
		CDialog::OnDrawItem(nIDCtl, lpDI);
		break;
	}
}

void CFbbWDlg::DrawLine(int nIDCtl, LPDRAWITEMSTRUCT lpDI)
{
	char *token;
	HWND hWnd;
	LINEINFO *pLineInfo;

	hWnd = ::GetDlgItem(m_hWnd, nIDCtl);
	pLineInfo = (LINEINFO *)::GetWindowLong(hWnd, GWL_USERDATA);

	char *string = strdup(pLineInfo->szText);
	if (string == NULL)
		return;

	SetTextColor(lpDI->hDC, pLineInfo->color);
	ExtTextOut(lpDI->hDC,
		0,
		0,
		ETO_OPAQUE,
		&lpDI->rcItem,
		NULL,
		0,
		NULL);

	token = strtok(string, "\t");
	SetTextAlign(lpDI->hDC, TA_RIGHT);
	TextOut(lpDI->hDC,
		lpDI->rcItem.left + 58,
		lpDI->rcItem.top,
		token,
		lstrlen (token));

	lpDI->rcItem.left += 60;
	token = strtok(NULL, "\t");
	SetTextAlign(lpDI->hDC, TA_LEFT);
	TextOut(lpDI->hDC,
		lpDI->rcItem.left,
		lpDI->rcItem.top,
		token,
		lstrlen (token));

	free(string);
}

void CFbbWDlg::ClearStatus()
{
	m_sUsedMem.color = RGB(0,0,0);
	m_sDataMem.color = RGB(0,0,0);
	m_sDiskFree.color = RGB(0,0,0);

	*m_sUsedMem.szText = '\0';
	*m_sDataMem.szText = '\0';
	*m_sDiskFree.szText = '\0';
}

void CFbbWDlg::ClearMessages()
{
	m_sMessages.color = RGB(0,0,0);
	m_sHeldMsgs.color = RGB(0,0,0);
	m_sPrivMsgs.color = RGB(0,0,0);

	*m_sMessages.szText = '\0';
	*m_sHeldMsgs.szText = '\0';
	*m_sPrivMsgs.szText = '\0';
}

void CFbbWDlg::SetAnsi(BOOL bAnsi)
{
	if (m_bAnsi == bAnsi)
		return;

	m_bAnsi = bAnsi;

	char szMode[10];
	wsprintf(szMode, "%d", m_bAnsi);
	m_pApp->WriteIni("Settings", "AnsiChar", szMode);

	if (m_pConsoleDlg->GetSafeHwnd())
		m_pConsoleDlg->SetAnsi(bAnsi);

	if (m_pMonitorDlg->GetSafeHwnd())
		m_pMonitorDlg->SetAnsi(bAnsi);

	if (m_pOneChannelDlg->GetSafeHwnd())
		m_pOneChannelDlg->SetAnsi(bAnsi);

	if (m_pAllChannelsDlg->GetSafeHwnd())
		m_pAllChannelsDlg->SetAnsi(bAnsi);
}

void CFbbWDlg::SetFont()
{
   // get current font description    
	
	LOGFONT lf;    

	m_Font.GetObject(sizeof(LOGFONT), &lf);    

	CFontDialog FontDlg(&lf, CF_SCREENFONTS|CF_INITTOLOGFONTSTRUCT); 
	
	if (FontDlg.DoModal() == IDOK) 
	{ 
		// switch to new font. 
		m_Font.DeleteObject(); 
		if (m_Font.CreateFontIndirect(&lf)) 
		{ 
			CWaitCursor wait; 

			// Save current font information
			char szParams[256];
			wsprintf(szParams, "%ld %ld %ld %ld %ld %d %d %d %d %d %d %d %d",
				lf.lfHeight,
				lf.lfWidth,
				lf.lfEscapement,
				lf.lfOrientation,
				lf.lfWeight,
				lf.lfItalic,
				lf.lfUnderline,
				lf.lfStrikeOut,
				lf.lfCharSet,
				lf.lfOutPrecision,
				lf.lfClipPrecision,
				lf.lfQuality,
				lf.lfPitchAndFamily);
			m_pApp->WriteIni("Settings", "Font_Name", lf.lfFaceName);
			m_pApp->WriteIni("Settings", "Font_Params", szParams);

			// Change fonts in windows
			if (m_pConsoleDlg->GetSafeHwnd())
				m_pConsoleDlg->SetFont(&m_Font);
			if (m_pMonitorDlg->GetSafeHwnd())
				m_pMonitorDlg->SetFont(&m_Font);
			if (m_pAllChannelsDlg->GetSafeHwnd())
				m_pAllChannelsDlg->SetFont(&m_Font);
			if (m_pOneChannelDlg->GetSafeHwnd())
				m_pOneChannelDlg->SetFont(&m_Font);
			m_pApp->SetEditorFont(&m_Font);
		}
	}
}

void CFbbWDlg::SetJustification(BOOL bFlag)
{
	if (m_bJust == bFlag)
		return;

	m_bJust = bFlag;

	char szMode[10];
	wsprintf(szMode, "%d", m_bJust);
	m_pApp->WriteIni("Settings", "Justification", szMode);
}

void CFbbWDlg::SetBreakline(BOOL bFlag) 
{
	if (m_bBreak == bFlag)
		return;

	m_bBreak = bFlag;

	char szMode[10];
	wsprintf(szMode, "%d", m_bBreak);
	m_pApp->WriteIni("Settings", "BreakLine", szMode);
}

void CFbbWDlg::SetPrefix(BOOL bFlag) 
{
	if (m_bPrefix == bFlag)
		return;

	m_bPrefix = bFlag;

	char szMode[10];
	wsprintf(szMode, "%d", m_bPrefix);
	m_pApp->WriteIni("Settings", "Prefix", szMode);
}

void CFbbWDlg::SetSignature(BOOL bFlag, CString cSignature) 
{
	if (m_cSignature.Compare(cSignature) != 0)
	{
		m_cSignature = cSignature;
		cSignature.Replace("\r\n", "\\r");
		m_pApp->WriteIni("Settings", "SignatureText", cSignature.GetBuffer(1024));
	}

	if (m_bSignature == bFlag)
		return;

	m_bSignature = bFlag;

	char szMode[10];
	wsprintf(szMode, "%d", m_bSignature);
	m_pApp->WriteIni("Settings", "Signature", szMode);
}

void CFbbWDlg::OnSettings() 
{
	CSettings Settings(this);
	Settings.DoModal();
	ConsoleFocus();
}

void CFbbWDlg::ConsoleFocus()
{
	if (m_pConsoleDlg->GetSafeHwnd())
		m_pConsoleDlg->m_InputCtrl.SetFocus();
}

void CFbbWDlg::OnPactorirs() 
{
	OnCho();
}

void CFbbWDlg::OnPactoriss() 
{
	OnCho();
}

void CFbbWDlg::OnPactorscan() 
{
	OnScan();
}

void CFbbWDlg::OnUpdatePactorscan(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	if ((m_nPactor & 1) == 0)
	{
//		pCmdUI->Enable(true);
		pCmdUI->SetCheck((m_nPactor & 2) ? true : false);
	}
}

void CFbbWDlg::OnCho()
{
	UINT state = GetMenuState(m_PactorMenu, IDM_PACTORIRS, MF_BYCOMMAND);

	char str[80];
	if (state & MF_CHECKED)
		wsprintf(str, "BRK %d", m_nPactorPort);
	else
		wsprintf(str, "CHO %d", m_nPactorPort);
	RequestService(10, str);
}

void CFbbWDlg::OnScan()
{
	UINT state = GetMenuState(m_PactorMenu, IDM_PACTORSCAN, MF_BYCOMMAND);

	char str[80];
	wsprintf(str, "SCAN %d %d", m_nPactorPort, (state & MF_CHECKED) ? 0 : 1);
	RequestService(10, str);
}

void CFbbWDlg::OnListButton(int nButton, UINT nPos, CPoint point)
{
	switch (nButton)
	{
	case WM_LBUTTONDOWN:
		if (m_pUserInfos && m_pUserInfos->GetSafeHwnd() && m_pUserInfos->IsWindowVisible())
			UserInformation(true);
		break;
	case WM_RBUTTONDOWN:
		{
			int nChan;
			char szCall[80];
			
			if (m_ConnectedList.GetItemInfo(nPos, &nChan, szCall) != LB_ERR)
			{
				// Build the popup menu
				CMenu menu;
				if (menu.CreatePopupMenu())
				{
					int nFlags = 0;
					menu.AppendMenu(MF_STRING, IDM_DISC, "Disconnect");
					menu.AppendMenu(MF_STRING, IDM_IMMEDIATEDISC, "Immediate disconnect");
					if (m_pUserInfos && m_pUserInfos->GetSafeHwnd() && m_pUserInfos->IsWindowVisible())
						nFlags = MF_CHECKED;
					menu.AppendMenu(MF_STRING|nFlags, IDM_USERINFORMATION, "User information");
				
					// Change coordinates to screen
					m_ConnectedList.ClientToScreen(&point);

					// Display the popup menu
					menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
				}
			}
		}
		break;
	}
}
