
/******************************************************
 *                                                    *
 * KCT-T project.                                     *
 *                                                    *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org         *
 *                                                    *
 * Version 0.1 14/03/99 : Initial release             *
 *                                                    *
 ******************************************************/

/******************************************************
 *                                                    *
 * kctlib.h                                           *
 *                                                    *
 * kct library headers and prototypes                 *
 *                                                    *
 ******************************************************/

#include <linux/kct.h>

#define KCT_ICOM 1

typedef int kctdev;

typedef struct
{
	int site_pos;		/* 0 .. 255	*/
	int site_win;		/* 0 .. 25 */
	int site_brksel;	/* 0 .. 25500 ms */
	int site_brkrel;	/* 0 .. 25500 ms */
	int azim_pos;		/* 0 .. 255 */
	int azim_win;		/* 0 .. 25 */
	int azim_brksel;	/* 0 .. 25500 ms */
	int azim_brkrel;	/* 0 .. 25500 ms */
	int control;
} kctstat;

/******************************************************
 *                                                    *
 * prototypes                                         *
 *                                                    *
 ******************************************************/
 
/* tracker.c */
kctdev KctOpen(kctdev board);
void KctClose(kctdev dev);
int KctSetBrake(kctdev dev, int port, int tempo_rel, int tempo_set);
int KctSetWindow(kctdev dev, int port, int val);
int KctSetPosition(kctdev dev, int rotor, int pos);
int KctGetStatus(kctdev dev, kctstat *stat);

/* tuner.c */
int KctSetLine(kctdev dev, int port, int param);
int KctSetFrequency(kctdev dev, int port, int rig, int addr, double freq);

/* icom.c */
int KctSetFrequencyIcom(char *buf, int buflen, int addr, double freq);
