
/******************************************************
 *                                                    *
 * KCT-T project.                                     *
 *                                                    *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org         *
 *                                                    *
 * Version 0.1 14/03/99 : Initial release             *
 *                                                    *
 ******************************************************/

/******************************************************
 *                                                    *
 * kctest.c                                           *
 *                                                    *
 * kct library test program                           *
 *                                                    *
 ******************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <kctlib.h>


int main(int ac, char **av)
{
	int ret;
	kctdev dev;
	kctstat kstat;
	
	dev = KctOpen(0);
	if (dev == -1)
	{
		fprintf(stderr, "Cannot open kct device\n");
		return 1;
	}

	/* Baud rates = 1200 Bds, 8bits, 2 stops, no parity */
	KctSetLine(dev, KCT_TRX1, KCT_2STOPS|KCT_B1200);
	KctSetLine(dev, KCT_TRX2, KCT_2STOPS|KCT_B1200);
	
	/* ic275 */
	KctSetFrequency(dev, KCT_TRX2, KCT_ICOM, 0x10, 144111.1);
	sleep(1);
	KctSetFrequency(dev, KCT_TRX2, KCT_ICOM, 0x10, 144222.2);
	sleep(1);
	KctSetFrequency(dev, KCT_TRX2, KCT_ICOM, 0x10, 144333.3);
	sleep(1);
	KctSetFrequency(dev, KCT_TRX1, KCT_ICOM, 0x14, 430111.1);
	sleep(1);
	KctSetFrequency(dev, KCT_TRX1, KCT_ICOM, 0x14, 430222.2);
	sleep(1);
	KctSetFrequency(dev, KCT_TRX1, KCT_ICOM, 0x14, 430333.3);
	sleep(1);
	
	KctSetBrake(dev, KCT_AZIMUTH, 0, 100);	 
	
	KctSetWindow(dev, KCT_AZIMUTH, 4);	 
	KctSetWindow(dev, KCT_SITE, 3);	 
	
	printf("Ask : Azimuth=64  Site=45\n");
	KctSetPosition(dev, KCT_AZIMUTH, 64);	 
	KctSetPosition(dev, KCT_SITE, 45);
	
	/* Waiting for end of tracking */
	while ((ret = (KctGetStatus(dev, &kstat) & 0x7f)) != 0)
	{
		printf("\rPos : Azimuth=%-3d Site=%-3d Control=%02x", kstat.azim_pos, kstat.site_pos, kstat.control);
		fflush(stdout);
		sleep(1);
	}
	printf("\rPos : Azimuth=%-3d Site=%-3d Control=%02x\n", kstat.azim_pos, kstat.site_pos, kstat.control);

	sleep(1);
	
	printf("Ask : Azimuth=45  Site=10\n");
	KctSetPosition(dev, KCT_AZIMUTH, 45);
	KctSetPosition(dev, KCT_SITE, 10);
	
	/* Waiting for end of tracking */
	while ((ret = (KctGetStatus(dev, &kstat) & 0x7f)) != 0)
	{
		printf("\rPos : Azimuth=%-3d Site=%-3d Control=%02x", kstat.azim_pos, kstat.site_pos, kstat.control);
		fflush(stdout);
		sleep(1);
	}
	printf("\rPos : Azimuth=%-3d Site=%-3d Control=%02x\n", kstat.azim_pos, kstat.site_pos, kstat.control);

	printf("waiting brake ...\n");
	fflush(stdout);
	
	/* Waiting for brake to be set */
	while (KctGetStatus(dev, &kstat))
	{
		printf("\rBrk : Azimuth=%-3d Site=%-3d Control=%02x", kstat.azim_pos, kstat.site_pos, kstat.control);
		fflush(stdout);
		sleep(1);
	}
	
	printf("\nBrake Set OK\n");
	
	KctClose(dev);
	
	return 0;
}
