
/******************************************************
 *                                                    *
 * FPAC project.            Utilities                 *
 *                                                    *
 * Parts of code from different sources of ax25-utils *
 *                                                    *
 * F6FBB 05-1997                                      *
 *                                                    *
 ******************************************************/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/fcntl.h>
#include <sys/file.h>

#include "wp.h"

#include "netax25/axconfig.h"
#include "netax25/nrconfig.h"
#include "netax25/rsconfig.h"
#include "netax25/procutils.h"
#include "fpac.h"


/*
 * Version of nr_config_load_ports() that do not report errors.
 */
void fpac_nr_config_load_ports(void)
{
	int fd = open("/dev/null", O_WRONLY);
	if (dup2(2, fd) != -1)
	{
		nr_config_load_ports();
		close(fd);
	}
}

/*
 *	fpac -> ascii conversion
 */
char *fpac2asc(rose_address *a)
{
	static char buf[12];

	sprintf(buf, "%02X%02X,%02X%02X%02X", 
			a->rose_addr[0] & 0xFF,
			a->rose_addr[1] & 0xFF,
			a->rose_addr[2] & 0xFF,
			a->rose_addr[3] & 0xFF,
			a->rose_addr[4] & 0xFF);

	return buf;
}

/*
 * Version of atoi() that returns zero if s == NULL.
 */
/*static int safe_atoi(const char *s)
{
	return (s == NULL) ? 0 : atoi(s);
}*/

/*
 * Version of atox() that returns zero if s == NULL.
 */
/*static int safe_atox(const char *s)
{
	int val = 0;

	if (s == NULL)
		return(0);
	sscanf(s, "%x", &val);
	return (val);
}*/

/*
 * Version of strncpy() that returns NULL if either src or dest is NULL
 * and also makes sure destination string is always terminated.
 */
/*static char *safe_strncpy(char *dest, char *src, int n)
{
	if (dest == NULL || src == NULL)
		return NULL;
	dest[n] = 0;
	return strncpy(dest, src, n);
}*/

char *rs_get_addr(char *dev)
{
	struct proc_rs *rp, *rlist;
	char *cp = (dev) ? dev : "rose0";
	static char add[11] = "          ";

	if ((rlist = read_proc_rs()) == NULL) {
		if (errno)
			perror("do_links: read_proc_ax25");
		return NULL;
	}

	for (rp = rlist; rp != NULL; rp = rp->next) 
	{
		if (	(strcasecmp(rp->dest_addr, "*") == 0) && 
			(strcasecmp(rp->dest_call, "*") == 0) &&
			(strcasecmp(rp->dev, cp) == 0))
		{
			memcpy(add, rp->src_addr, 10);
			break;
		}
	}
	add[10] = '\0';
	free_proc_rs(rlist);
	return(add);
}

